
//  Bush.inc    05/29/98  (C) Neil Alexander

/*camera {
  location  <90, 50, 90>
  look_at   <0, 30, 0>
  angle 45
  }

light_source {
  <18000000, 6000000, 0>
  color rgb <1,0.95,0.8>
  }
background { color rgb <0,0,1>}*/

// ---------------- Leaves ------------------------

#declare Outline = union {
  intersection {
    cylinder { <-1,0,0>,<8,0,0>,1
      scale <1,3,4>
      translate <0,4,2.5>
      }
    cylinder { <-1,0,0>,<8,0,0>,1
      scale <1,3,4>
      translate <0,4,-2.5>
      }
    }
  box {<-1,0,-0.062>,<2,2,0.062>}
  }  // end Outline

#declare Leaf = merge {
  sphere { <0,0,0>,1
    scale <8,10,5>
    translate <8,0,1.5>
    }
  sphere { <0,0,0>,1
    scale <8,10,5>
    translate <8,0,-1.5>
    }
  clipped_by {
    object { Outline }
    }
  texture {
    pigment { color rgb <0,0.9,0> }
    }
  }  // end Leaf

#declare Leaves = union {
  object { Leaf }
  object { Leaf
    rotate <40,0,0>
    translate <0,-1,0>
    }
  object { Leaf
    rotate <60,20,0>
    translate <0,-3,0>
    }
  object { Leaf
    rotate <-40,0,0>
    translate <0,-1,0>
    }
  object { Leaf
    rotate <-60,-20,0>
    translate <0,-3,0>
    }
  bounded_by {sphere { <0,1,0>,6  }}
  rotate <0,-90,0>
  }  // end Leaves

// --------------------------------------------------------

#declare R2 = seed(0)

// ---------------- Bush Characteristics ------------------

#declare Baseloc = <0,0,0>  // bush location
#declare Startloc = Baseloc  // starting point
#declare Maxrad = 0.5          // diameter of bush at trunk base
#declare Lengthfactor = 25    // factor for section length
#declare Size = Maxrad  // starting size
#declare Sizefactor = 0.75  // reduction factor for branch diameter

// ---------------- Starting Values ------------------------

#declare Dir = y        // starting direction (straight up)
#declare Count = 0      // section counter - 4 sections
#declare N1 = 0         // node place-holders
#declare N2 = 0         // for storing branching info
#declare N3 = 0
#declare N4 = 0

// ---------------- Bush -------------------------------------

#declare Bush = union {  // bush
  sphere { Startloc,Maxrad }

  #while (N1 < 5)  // main loop

    #while (Count < 4)  // sub loop

      #declare Length = ((pow(Size,0.2))*Lengthfactor)*(rand(R2)/2 + 0.5)
      #declare Tilt = 60*rand(R2) // random tilt angle, larger for smaller size
      #declare Rot = 360*rand(R2)       // random tilt direction
      #if ((Dir.x = 0) & (Dir.z = 0))  // find perpendicular vector to Dir for tilt
        #declare Dirx = x
        #else
          #declare Dirx = vcross(Dir, y)
        #end // if
      #declare Dir2 = vaxis_rotate(Dir,Dirx,Tilt) // tilt away from Dir
      #declare Dir2 = vaxis_rotate(Dir2,Dir,Rot)  // in random direction around Dir
      #declare Endloc = Length*Dir2 + Startloc
      #declare Size2 = Size*Sizefactor
      cone { Startloc, Size Endloc, Size2 }
      sphere { Endloc, Size2 }
      #declare Count = Count + 1
      #switch ( Count )
        #case (1)
          #declare E1 = Endloc
          #declare S1 = Size2*Sizefactor
          #declare D1 = Dir2
          #declare N1 = N1 + 1
          #break
        #case (2)
          #declare E2 = Endloc
          #declare S2 = Size2*Sizefactor
          #declare D2 = Dir2
          #declare N2 = N2 + 1
          object { Leaves
            rotate <degrees(acos(Dir2.y)),degrees(atan2(Dir2.x,Dir2.z)),0>
            translate Endloc
            }
          #break
        #case (3)
          #declare E3 = Endloc
          #declare S3 = Size2*Sizefactor
          #declare D3 = Dir2
          #declare N3 = N3 + 1
          #break
        #case (4)
          #declare N4 = N4 + 1
          object { Leaves
            rotate <degrees(acos(Dir2.y)),degrees(atan2(Dir2.x,Dir2.z)),0>
            translate Endloc
            }
          #break
        #end // switch - case
      #declare Size = Size2
      #declare Startloc = Endloc
      #declare Dir = Dir2

      #end // sub loop

     #declare Count = Count - 1
     #if (N4 = 2)
      #declare Count = Count - 1
      #declare N4 = 0
      #if (N3 = 3)
        #declare Count = Count - 1
        #declare N3 = 0
        #if (N2 = 4) // 4-way split
          #declare Count = Count - 1
          #declare N2 = 0
          #if (N1 = 4)  // 4-way split
            #declare N1 = 5  // end bush condition
            #end  // end if N1
          #end  // end if N2
        #end  // end if N3
      #end  // end if N4

    #switch ( Count )
      #case (0)
        #declare Startloc = Baseloc
        #declare Size = Maxrad*Sizefactor
        #declare Dir = y
        #break
      #case (1)
        #declare Startloc = E1
        #declare Size = S1
        #declare Dir = D1
        #break
      #case (2)
        #declare Startloc = E2
        #declare Size = S2
        #declare Dir = D2
        #break
      #case (3)
        #declare Startloc = E3
        #declare Size = S3
        #declare Dir = D3
        #break
      #case (4)
        #declare Startloc = E4
        #declare Size = S4
        #declare Dir = D4
        #break
      #end // end switch - case

    #end  // main loop

  texture {
    pigment { color rgb <0.5,0.3,0.2>}
    }
  }  // end bush

//object { Bush }

