
// Nature.pov   May  1998 (C) Neil Alexander

#include "Tree.inc"
#include "Bush.inc"
#include "Bird.inc"

// uses nature.gif and natcol.gif

// ------------------------------ Texture declarations --------------

#declare Rocktext = pigment {
  granite
  color_map {
    [0.00 rgb <0.2,0.25,0>]
    [0.30 rgb <1,0.85,0.8>]
    [0.7 rgb <1,0.85,0.8>]
    [1.00 rgb <1,1,1>]
    }
  scale 1
  }

#declare Rocktext2 = pigment {
  bozo
  color_map {
    [0.25 rgbt <1,1,1,1>]
    [0.375 rgbt <1,1,1,0.3>]
    [0.5 rgbt <1,1,1,1>]
    [0.625 rgbt <0,0,0,1>]
    [0.75 rgbt <0,0,0,0.7>]
    [1 rgbt <0,0,0,1>]
    }
  scale 50
  }

#declare Rocknorm = normal {
  wrinkles 1 scale 20 turbulence 0.4 }//0.6

#declare Rock1 =
  texture { pigment {Rocktext}
    normal {Rocknorm}
    finish { diffuse 0.3 phong 0.3 phong_size 200 }
    }
  texture { pigment {Rocktext2}
    normal {Rocknorm}
    finish { diffuse 0.3 phong 0.3 phong_size 200 }
    }

#declare Rock2 =
  texture { pigment {Rocktext}
    normal {Rocknorm}
    finish { diffuse 0.7 ambient 0.2 }
    }
  texture { pigment {Rocktext2}
    normal {Rocknorm}
    finish { diffuse 0.7 ambient 0.2 }
    }
    
#declare Rock = 
  texture {
    gradient y
    texture_map {
      [ 0.08 Rock1 scale 0.01]
      [ 0.15 Rock2 scale 0.01]
      }
    turbulence 0.1
    scale 100
    translate <0,-55,0>
    }

// --------------------------------- Camera, Light, Sky -----------------

camera {
  location  <500, 50, 300>
  look_at   <80, 25, -80>
  //location <10,800,10>
  //look_at <0,0,0>
  angle 45
  }

light_source {
  <18000000, 6000000, 0>
  color rgb <1,0.85,0.6>
  }

fog {
    distance 130000
    colour rgbt <1,1,1,0.65>
  }
  
sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.1 color rgb <1,0.8,0.3>]
      [0.6 color rgb <0.4,0.2,0.6>]
      }
    rotate <0,0,20>
    }
  }

// ------------------------------------ Water -----------------------------

plane { y, -50
  texture {
    pigment { color rgb <0.3,0.5,0.4> }
    finish { phong 1 phong_size 150 reflection 0.5 }
    normal{  bumps 0.15 scale 12 }
    }
  }

// ---------------------------- Background Land ----------------------

height_field {
  gif  "nature.gif"
  water_level 0.25
  //smooth
  texture { pigment {Rocktext} scale 0.00001 }// rocks
  texture { pigment {Rocktext2} scale 0.00001 }
  texture { // trees
    pigment {
      image_map {
        gif "Natcol.gif"
        transmit 0,1
        map_type 0
        interpolate 2
        once
        }
      }
    rotate <90,0,0>
    }  // end texture
  rotate <0,200,0>
  translate <0,-0.2525,0>
  scale <100000,20000,100000>
  }

// ---------------------------------- Foreground -----------------------

sphere { <0,0,0>,1  // ground for tree
  scale <300,60,150>
  rotate <0,45,0>
  translate <-150,-60,150>
  texture { pigment { color rgb <0.4,0.3,0.2>}
    }
  }

object { Tree
  translate <-30,-10,30>
  }
// -------------------------------------- Rocks -----------------------

blob { // rock 1
  threshold 0.56
  sphere { <0,0,0>,1,1
    scale <144,60,84>
    }
  sphere { <0,0,0>,1,1
    scale < 36, 20, 60>
    rotate < 20, -50, 0>
    translate < 0, 15, 20>
    }
  sphere { <0,0,0>,1,1
    scale < 50, 10, 30>
    rotate < 20, 0, -10>
    translate < 10, 20, 20>
    }
  sphere { <0,0,0>,1,1
    scale < 150, 20, 40>
    rotate < 0, 0, 0>
    translate < -50, -10, 10>
    }
  sphere { <0,0,0>,1,-0.5
    scale < 40, 30, 90>
    rotate < 0, 0, 0>
    translate < 80, -25, 0>
    }
  sphere { <0,0,0>,1,-0.5
    scale < 60, 20, 30>
    rotate < 0, 0, 0>
    translate < 20, -25, 50>
    }
  sphere { <0,0,0>,1,-0.5
    scale < 60, 20, 80>
    rotate < 0, 10, 10>
    translate < 20, 30, 10>
    }
  rotate <0,-20,0>
  translate <90,-30,-160>
  //texture { pigment { color rgb <1,1,1> }}
  texture { Rock }
  }

blob { // rock 2
  threshold 0.56
  sphere { <0,0,0>,1,1
    scale <180,120,220>
    }
  sphere {<0,0,0>,1,1
    scale <20,40,70>
    translate <70,0,-30>
    }
  sphere {<0,0,0>,1,-1
    scale <200,70,30>
    rotate <-20,30,0>
    translate <0,0,110>
    }
  sphere {<0,0,0>,1,-1
    scale <20,90,240>
    rotate <10,20,40>
    translate <110,0,0>
    }
  sphere {<0,0,0>,1,-1
    scale <90,60,10>
    rotate <-60,45,0>
    translate <60,50,20>
    }
  sphere {<0,0,0>,1,-0.75
    scale <90,15,110>
    translate <0,70,0>
    }
  rotate <0,-30,0>
  translate <110,-60,20>
  //texture { pigment { color rgb <1,1,1> }}
  texture { Rock }
  }

blob { // rock 3
  threshold 0.56
  sphere { <0,0,0>,1,1
    scale <220,160,220>
    }
  sphere {<0,0,0>,1,1
    scale <70,30,30>
    translate <50,0,-80>
    }
  sphere {<0,0,0>,1,-1
    scale <200,70,30>
    rotate <-20,60,0>
    translate <70,0,70>
    }
  sphere {<0,0,0>,1,-0.75
    scale <160,50,30>
    rotate <20,-20,0>
    translate <90,80,-40>
    }
  sphere {<0,0,0>,1,-1
    scale <40,50,10>
    rotate <-45,90,0>
    translate <90,45,-30>
    }
  sturm  // this blob is giving me strange scattered dust on it's outer perimeter
  translate <130,-60,200>
  //texture { pigment { color rgb <1,1,1> }}
  texture { Rock }
  }

blob { // rock 4
  threshold 0.56
  sphere { <0,0,0>,1,1
    scale <220,160,220>
    }
  sphere {<0,0,0>,1,1
    scale <70,30,50>
    rotate <0,20,20>
    translate <0,50,-10>
    }
  sphere {<0,0,0>,1,-1
    scale <500,20,500>
    rotate <20,20,0>
    translate <0,80,0>
    }
  sphere {<0,0,0>,1,-0.75
    scale <80,50,40>
    rotate <120,100,-40>
    translate <70,80,-60>
    }
  sphere {<0,0,0>,1,-1
    scale <60,30,90>
    rotate <0,0,0>
    translate <-30,70,50>
    }
  translate <-80,-60,-110>
  //texture { pigment { color rgb <1,1,1> }}
  texture { Rock }
  }

// -------------------------------------- Bushes -----------------------

object { Bush // far right
  rotate <0,-90,0>
  translate <-40,-30,80>
  }

object { Bush  // left
  rotate <0,60,0>
  translate <40,-40,40>
  }

object { Bush  // front
  rotate <0,30,0>
  translate <20,-50,80>
  }

object { Bush  // back
  //rotate <0,120,0>
  translate <-100,-30,20>
  }

object { Bush  // far left
  translate <90,-40,-90>
  }

// -------------------------------------- Birds -----------------------

object { Bird
  rotate <-30,0,0>
  rotate <0,0,0>
  translate <280,100,80>
   }

object { Bird
  rotate <0,-90,30>
  translate <280,70,-80>
   }

