// Aquamarine
// Martin Bhend 1998
// email: martin.bhend@zurich.com

#version 3.0                     // define syntax version

#declare View_POV_Include_Stack = on

global_settings {
//adc_bailout       FLOAT        // default is ??
//ambient_light     COLOR        // default is ??
  assumed_gamma     2.2          // default is ??
//hf_gray_16        BOOLEAN      // default is ??
//irid_wavelength   COLOR        // default is ??
//max_intersections INTEGER      // default is ??
  max_trace_level   15           // default is 5
//number_of_waves   INTEGER      // default is ??
//radiosity { RADIOSITY_ITEMS... }
}
/*
Ŀ
    Standard include libraries                                  

*/
//#include "debug.inc"     // debug 'including sequence' (always 1st)

//#include "atmos.inc"     // atmospheric effects
//#include "chars.inc"     // character shapes
  #include "colors.inc"    // standard color constants
  #include "consts.inc"    // various contants and alias definitions

//#include "textures.inc"  // basic textures from V2

//#include "finish.inc"    // some basic finishes
//#include "glass.inc"     // glass finishes and textures
//#include "golds.inc"     // gold textures
//#include "metals.inc"    // metallic pigments / finishes / textures
//#include "rad_def.inc"   // common radiosity settings

  #include "shapes.inc"    // standard shapes
//#include "shapes2.inc"   // standard shapes #2
//#include "shapesq.inc"   // quartic standard shapes

//#include "skies.inc"     // sky definitions

  #include "stones1.inc"   // basic stone textures
  #include "stones2.inc"   // extended stone textures

//#include "woodmaps.inc"  // basic wooden colormaps
//#include "woods.inc"     // basic wooden textures
/*
Ŀ
    Scene related constants                                     

*/
#declare S_CAM_H          =  520 // camera height
#declare S_VIEW_H         =  400 // view height
#declare S_FLOOR_H        = -500 // floor height
/*
Ŀ
    *** CAMERA ***                                              

*/
#declare S_CAM1 = camera {
  location  < 0,S_FLOOR_H+S_CAM_H,-1400 >
  look_at   < 0,S_FLOOR_H,0 >
}

#declare S_CAM2 = camera {   // top
  location  < 0,S_FLOOR_H+S_CAM_H+1000,0 >
  look_at   < 0,1,0 >
}
/*
Ŀ
    *** LIGHT SOURCE ***                                        

*/
#declare S_LIGHT1 = object {
  light_source { <200,S_FLOOR_H+300,-2000 >
    color White
  }
}

#declare S_LIGHT2 = object {
  light_source { <0,S_FLOOR_H,2000 >
    color White
  }
}
/*
Ŀ
    aquamarine                                                  

*/
#declare I_AQM_Quick = off
#declare I_AQM_InnerLight = off
#declare I_AQM_SpotLight = on
#declare I_AQM_COL = color rgb < 95, 154, 216 > / 255
//#declare I_AQM_COL = color I_AQM_Aquamarine

#include "aquamar.inc"
/*
Ŀ
    *** scene assembly ***                                      

*/
  camera { S_CAM1 } // front
//camera { S_CAM2 } // top

  object { S_LIGHT1 }
  object { S_LIGHT2 }

  background { color Gray50 }

  object { I_AQM translate <0,S_FLOOR_H-200,0> }

//(EOF)
