/*
  Baby Grass
  Created by Steven L. Reid
  v1.0 23 May 98

  Baby grass for the IRC, Nature Catagory

  v1.0 23 May 98 First rendering.
*/

// Global Settings
#version 3
//global_settings { assumed_gamma 2.2 }

// Include Files
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// Camera & Lightsource
#declare l_highq = false
#declare camera_loc  = <0,1,-20> //20>
#declare camera_look = <0,1.1,-19>  //19>

// Position camera
//camera { location camera_loc }
camera { location camera_loc look_at camera_look }

// Primary light source
#declare light_loc = <-100,150,-200>
light_source {
    light_loc
    color White
#if (l_highq)
    area_light <5, 0, 0>, <0, 0, 5>, 5, 5
    adaptive 1
    jitter
#end
}
// Secondary light sources
light_source { light_loc  color White }
light_source { camera_loc color Gray30 shadowless}

// Environment
#include "Skies.inc"
sky_sphere { S_Cloud2 }
//sky_sphere { pigment {Blue} } //S_Cloud2 }
plane { // Ground
    y, 0
    pigment {DarkBrown}
    normal {wrinkles .4}
}

// Fence board
#declare board = box {
  <-.5,0,0>, <-6,144,1.5>
}

// Cross board
#declare cross = box {
  <-120,12,0>, <120,16,-1>
  pigment {DMFWood2 rotate -92*x scale 8 rotate <7,0,-90>}
//  pigment {Brown} // will be wood texture
}

// Fench
union {
  object {board translate <-24.1,0.12,0>
    pigment {DMFWood2 rotate -92*x scale 8 rotate 9*x}}
  object {board translate <-18.5,0.20,0>
    pigment {DMFWood2 rotate -92*x scale 8 rotate 7*x}}
  object {board translate <-12.3,0.35,0>
    pigment {DMFWood2 rotate -92*x scale 8 rotate -4*x}}
  object {board translate <- 6.1,0.13,0>
    pigment {DMFWood2 rotate -92*x scale 8 rotate -6*x}}
  object {board rotate -8*x translate <10,0,6>
    pigment {DMFWood2 rotate -92*x scale 8 }}
  object {board translate < 12.2,0.24,0>
    pigment {DMFWood2 rotate -92*x scale 8 rotate -7.7*x}}
  object {board translate < 18.1,0.09,0>
    pigment {DMFWood2 rotate -92*x scale 8 rotate 6.2*x}}
  object {cross}
  translate <6,0,8>
}

// Automatic Sprinkler
union {
  cylinder {-1*y,8.5*y,.5}
  cylinder {8.5*y,8.55*y, .7}
  cone {8.55*y,.5, 9.5*y, .25}
  cylinder {9.5*y,9.6*y, .24 pigment {Gray85}}
  pigment {Gray15}
  finish { specular 0.2 }
  rotate <-4,0,-4>
  translate <-8,0,-2>
}

// Blade of grass
#declare blade = intersection {
    cylinder {0, y, .5}
    sphere   {0,1 translate <0, .0000,.5>}
    sphere   {0,1 translate <0,-.0005,.5> inverse}
    scale <.2,1.5,1>
    translate <-.25,-.2,-.25>
    rotate -25*x
    pigment {DarkGreen}
}

// Patch of grass
//object {blade}
#include "newgrass.pov"
