#include "consts.inc"
#declare Foot = 12

#ifndef(Seed)
  #declare Seed = seed(43235)
#end


#declare Sky =

union {

/////////////////////////////////////////
// sun
//

#declare Sun_Theta = 4 * 0.265  // http://www.geocities.com/CapeCanaveral/Lab/2683/solsyshm.htm
                                // reports 1.392 Gm diameter of sun, mean distance from Earth
                                // 150 Gm, yielding theta = 0.265 degrees
#declare Sun_Distance  = 1e5
#declare Sun_Elevation = 2

disc {
  <0, 0, 0>,
  z,
  1
  texture {
    pigment {
	onion
	color_map {
	  [0     rgbt <1, 0.7,  0,   0>]
	  [0.5   rgbt <1, 0.6,  0,   0>]
	  [0.75  rgbt <1, 0.6,  0, 0.7>]
	  [1     rgbt <1, 0.5,  0,   1>]
        }
    }
    finish {
      diffuse 0
      ambient 2
    }
  }
  scale radians( Sun_Theta ) * Sun_Distance
  translate <0, 0, Sun_Distance>
  rotate -Sun_Elevation * x
  no_shadow
}

light_source {
	<0, 0, Sun_Distance>,
	color rgb <1, 0.8, 0.7>
    rotate -(Sun_Elevation + Sun_Theta) * x
}


/////////////////////////////////////////
// sky
//

#declare Clouds_Low =
texture {
  pigment {
    wrinkles
    turbulence 0.8
    octaves 6
    omega 0.6
    lambda 1
    color_map {
        [0.15 color rgbt <0.7, 0.6, 0.5, 1>]
        [0.3  color rgbt  <0.5, 0.5, 0.5, 0.7>]
        [0.45 color rgbt <0.7, 0.6, 0.5, 1>]
    }
    rotate 60 * x;
    scale <4, 0.3, 1>
    rotate 2 * <rand(Seed), rand(Seed), rand(Seed)>
  }
  finish { diffuse 0 ambient 1 }
}

#declare Clouds_Med =
texture {
  pigment {
    wrinkles
    turbulence 0.8
    octaves 6
    omega 0.8
    lambda 1.5
    color_map {
        [0  color rgb 0.2]
        [0.5  color rgbt <0.7, 0.7, 0.5, 1>]
    }
   rotate 180 * x
   scale <-2, 0.3, 2>
  }
  finish { diffuse 0 ambient 1 }
}


#declare Clouds_High =
texture {
  pigment {
    wrinkles
    turbulence 0.8
    octaves 6
    omega 0.5
    lambda 1
    color_map {
        [0  color rgb 0.2]
        [0.5  color rgbt <0.6, 0.55, 0.5, 0.85>]
        [0.85  color rgbt <0.6, 0.45, 0.3, 1>]
    }
   rotate 300 * x
   scale <1, -0.15, 1>
   }
   finish { diffuse 0 ambient 0.9 }
}



// clouds : in front of Sun
#declare Cloud_Distance = Sun_Distance / 2
union {
  sphere {
     <0, 0, 0>
     1
     texture { Clouds_Low }
  }
  sphere {
     <0, 0, 0>
     1.05
     texture { Clouds_Med }
  }
  sphere {
     <0, 0, 0>
     1.1
     texture { Clouds_High }
  }
  hollow
  scale Cloud_Distance
  no_shadow
}

// sky : behind sun
#declare Sky_Distance = 2 * Sun_Distance
sphere {
  <0, 0, 0>
  1
  pigment {
    gradient z
    color_map {
      [ 0     color rgb <0.2, 0.1, 0.3> ]
      [ 0.85  color rgb <0.2, 0.1, 0.5> ]
      [ 0.90  color rgb <0.5, 0.1, 0.5> ]
      [ 0.95  color rgb <0.8, 0.3, 0.5> ]
      [ 1     color rgb <1,   0.6, 0.3> ]
    }
  }
  scale <3, 1, 1> * Sky_Distance
  hollow
  no_shadow
}


}       // end of sky union

/////////////////////////////////////////
// atmospherics
//

#declare Fog_Flag = 1
#ifdef (Fog_Flag)
  fog {
    fog_type Ground_Fog
    distance 250 * Foot
    fog_alt  70 * Foot
    color rgbt<0.1, 0.0, 0.0, 0.7>
    turbulence 0.4
    turb_depth 0.6
  }
#end

