/*
=============================================================================
 POV PERSISTENCE OF VISION
   Cheers! / CHEER_UP.POV
   SOCRATES RIZQUEZ 10/30-May-1998
=============================================================================*/

camera { location <-.5,5.5,-10> look_at <6,0,0> }

fog {  fog_type 1 distance 40 color rgb <0,0,0>  }

light_source { <-40,40,-20> color rgb <1,0.9,0.8>*1.2 spotlight
  area_light
  <3,0,0>,<0,0,2> 4,4 adaptive 2 jitter point_at <15,-3,6> radius 4 tightness 50 falloff 12 }
light_source { <90,40,-60> color rgb <0.7,0.7,0.7> shadowless}
light_source { <25,10,70> color rgb <0.75,0.5,0.3>*1.3 shadowless}

                                                
#declare ojos = union {
sphere { <3.5,0,0.25>,0.25 }
sphere { <3.5,0,-0.25>,0.25 }
sphere { <0,0,0>,0.1 scale <1.5,0.3,0.8> rotate y*20 rotate z*35 translate <3.4,-0.25,0.2> }
sphere { <0,0,0>,0.1 scale <1.5,0.3,0.8> rotate -y*20 rotate z*35 translate <3.4,-0.25,-0.2> }
texture { pigment { color rgb <0.2,0.2,0.1> } finish { phong 0.9 ambient 0.5 }}}
#declare cab = union {
sphere { <0,0,0>,0.4 scale <1.3,1,0.9> translate <4.15,0.6,0>}
sphere { <3.5,0,0>,0.22 }
cylinder { <3.5,0,0>,<4,0.5,0>,0.15 }
union {
cylinder { <3.5,0,0>,<4,-0.5,0>,0.05 }
sphere { <4,-0.5,0>,0.05 }
cone { <4,-0.5,0,>,0.06,<2.2,-2.1,0>,0.02 }
pigment { color rgb <0.8,0.7,0.6> }}
cone { <2.1,-2.1,0>,0,<3.5,0,0>,0.05 pigment { color rgb <0.6,0.4,0.4> }
     finish { phong 0.9 ambient 0.6 }}
texture { pigment { wood  color_map {
  [  0.0  color rgb <0.6,0.5,0.45> ]
  [  0.2  color rgb <0.6,0.5,0.45> ]
  [  0.3  color rgb <0.5,0.4,0.3>]
  [  0.5  color rgb <0.4,0.3,0.2>]
  [  0.7  color rgb <0.5,0.4,0.3>]
  [  0.8  color rgb <0.6,0.5,0.45> ]
  [  1  color rgb <0.6,0.5,0.45> ]}
  turbulence 0.1 scale <6,3,0.2> }
 finish { crand 0.3 specular 0.4 ambient 0.3 } normal { bumps 0.2 scale 0.085 }}}

#declare cue1 = union {
sphere { <0,0,0>,1 scale <0.9,0.32,0.8> rotate z*30 translate <4.55,1.25,0> }
sphere { <0,0,0>,1 scale <0.9,0.4,0.6> rotate z*15 translate <5.2,0.96,0> }
sphere { <0,0,0>,1 scale <0.8,0.3,0.5> rotate z*1 translate <5.1,0.6,0> }
sphere { <0,0,0>,0.11 scale <1,1,1.75> translate <4.8,0.45,-0.35> }
sphere { <0,0,0>,0.11 scale <1,1,1.75> translate <5.4,0.53,-0.35> }
sphere { <0,0,0>,0.11 scale <1,1,1.75> translate <5.5,1.3,-0.6> }
texture { pigment { wood  color_map {
  [  0.0  color rgb <0.6,0.5,0.45> ]
  [  0.2  color rgb <0.6,0.5,0.45> ]
  [  0.3  color rgb <0.5,0.4,0.3>]
  [  0.5  color rgb <0.45,0.35,0.25>]
  [  0.7  color rgb <0.5,0.4,0.3>]
  [  0.8  color rgb <0.6,0.5,0.45> ]
  [  1  color rgb <0.6,0.5,0.45> ]}
  turbulence 0.1 scale <6,3,0.3> }
 finish { crand 0.3 specular 0.4 ambient 0.65 } normal { bumps 0.25 scale 0.085 }}}

#declare cue2 = sphere { <0,0,0>,1 scale <2,0.65,0.75> translate <7,1.1,0>
texture { pigment { gradient x  color_map {
  [  0.0  color rgb <0.7,0.7,0.7> ]
  [  0.1  color rgb <0.7,0.7,0.7> ]
  [  0.2  color rgb <0.5,0.4,0.4>]
  [  0.5  color rgb <0.55,0.3,0.3>]
  [  0.8  color rgb <0.5,0.4,0.4>]
  [  0.9  color rgb <0.7,0.7,0.7> ]
  [  1  color rgb <0.7,0.7,0.7> ]}
  turbulence 0.1 scale 5 }
 finish { phong 1 ambient 0.3 } normal { bumps 0.4 scale <0.5,0.085,0.085> } translate <-1,0,0> }}
#declare cue3 = intersection {
sphere { <0,0,0>,1 scale <5,5,0.75> }
sphere { <0,0,0>,1 scale <8,8,1> translate <0,-4,0> inverse} scale <0.6,0.3,1.1>
texture {
pigment { gradient x  color_map {
  [  0.0  color rgb <0.65,0.63,0.6> ]
  [  0.1  color rgb <0.65,0.63,0.6> ]
  [  0.3  color rgb <0.6,0.5,0.4>]
  [  0.5  color rgb <0.6,0.5,0.4>]
  [  0.7  color rgb <0.6,0.5,0.4>]
  [  0.9  color rgb <0.65,0.63,0.6> ]
  [  1  color rgb <0.65,0.63,0.6> ]}
  turbulence 0.2 scale 0.6 }
 finish { phong 0.7 ambient 0.3 } normal { bumps 0.4 scale <0.3,0.085,0.085> }}
scale <1,0.55,1> rotate z*2 translate <7.2,1.05,0>}
#declare PATA1 = union {
cylinder { <4.8,0.45,-0.41>,<4,2.5,-2>,0.06 }
cylinder { <4,2.5,-2>,<2,-1,-3>,0.04 }
cylinder { <2,-1,-3>,<1,-1.8,-3.5>,0.025 }
cylinder { <1,-1.8,-3.5>,<0,-2,-4>,0.025 }}
#declare PATA2 = union {
cylinder { <5.4,0.53,-0.41>,<6.5,2.5,-1.5>,0.06 }
cylinder { <6.5,2.5,-1.5>,<7,-0.7,-3>,0.04 }
cylinder { <7,-0.7,-3>,<8.5,-1.6,-4>,0.025 }
cylinder { <8.5,-1.6,-4>,<9.5,-2,-4.5>,0.025 }}
#declare PATA3 = union {
cylinder { <5.5,1.3,-0.7>,<7.5,3,-1.5>,0.06 }
cylinder { <7.5,3,-1.5>,<8,-0.5,-2.5>,0.04 }
cylinder { <8,-0.5,-2.5>,<9.5,-1.3,-3.5>,0.025 }
cylinder { <9.5,-1.3,-3.5>,<12,-2,-4.5>,0.025 }}
#declare PATA4 = union {
cylinder { <4.8,0.45,0.41>,<4,2.5,2>,0.06 }
cylinder { <4,2.5,2>,<2,-1,3>,0.04 }
cylinder { <2,-1,3>,<1,-1.8,3.5>,0.025 }
cylinder { <1,-1.8,3.5>,<0,-2,4>,0.025 }}
#declare PATA5 = union {
cylinder { <5.4,0.53,0.41>,<5.4,2.5,1.8>,0.06 }
cylinder { <5.4,2.5,1.8>,<5,-0.7,3>,0.04 }
cylinder { <5,-0.7,3>,<4,-1.6,4.5>,0.025 }
cylinder { <4,-1.6,4.5>,<3.5,-2,6>,0.025 }}
#declare PATA6 = union {
cylinder { <5.5,1.3,0.7>,<7.5,3,1.5>,0.06 }
cylinder { <7.5,3,1.5>,<8,-0.5,2.5>,0.04 }
cylinder { <8,-0.5,2.5>,<9.5,-1.3,3.5>,0.025 }
cylinder { <9.5,-1.3,3.5>,<12,-2,4.5>,0.025 }}

#declare PATAS = union {
         object { PATA1 }
         object { PATA2 }
         object { PATA3 }
         object { PATA4 }
         object { PATA5 }
         object { PATA6 }
texture { pigment { wood  color_map {
  [  0.0  color rgb <0.6,0.5,0.45> ]
  [  0.2  color rgb <0.6,0.5,0.45> ]
  [  0.3  color rgb <0.5,0.4,0.3>]
  [  0.5  color rgb <0.45,0.35,0.25>]
  [  0.7  color rgb <0.5,0.4,0.3>]
  [  0.8  color rgb <0.6,0.5,0.45> ]
  [  1  color rgb <0.6,0.5,0.45> ]}
  turbulence 0.1 scale <6,3,0.3> }
 finish { crand 0.3 specular 0.5 ambient 0.45 } normal { bumps 0.25 scale 0.085 }}
}

#declare ant1 = union {
         cone { <0,0,0>,0.01,<-0.5,0,-0.15>,0.03 }
         cone { <-0.5,0,-0.15>,0.01,<-1,0,-0.27>,0.03 }
         cone { <-1,0,-0.27>,0.01,<-1.45,0,-0.45>,0.03 }
         cone { <-1.45,0,-0.45>,0.01,<-2,0,-0.6>,0.03 }
         cone { <-2,0,-0.6>,0.01,<-2.45,0,-0.8>,0.03 }
         cone { <-2.45,0,-0.8>,0.01,<-2.9,0,-1.1>,0.03 }
         cone { <-2.9,0,-1.1>,0.01,<-3.4,0,-1.35>,0.03 }
         cone { <-3.4,0,-1.35>,0.01,<-3.85,0,-1.75>,0.03 }
         cone { <-3.85,0,-1.75>,0.01,<-4.2,0,-2.15>,0.03 }
         scale <0.3,1,1>  }
#declare anten = union {
         object { ant1 rotate z*20 translate <3.4,-0.2,-0.1> }
         object { ant1 rotate z*20 rotate x*180 translate <3.4,-0.2,0.1> }
texture { pigment { color rgb <0.2,0.2,0.2> } finish { phong 0.7 ambient 0.4 }}
        }

#declare ALAS = union {
merge {
cylinder { <0,0,0>,<4.5,0,0>,0.5 }
sphere { <0,0,0>,1 scale <1.8,0.5,0.5> translate <4.5,0,0>}
scale <1.3,0.1,1.4> texture { pigment { color rgbf <0.9,0.9,0.9,0.8> } finish { phong 1 ior 1.5 ambient 0.6 }
normal { bumps 8 scale <2,4,0.3> }}
rotate -x*2 rotate z*5 rotate y*5 translate <5.3,1.7,0> }
merge {
cylinder { <0,0,0>,<4.5,0,0>,0.5 }
sphere { <0,0,0>,1 scale <1.8,0.5,0.5> translate <4.5,0,0>}
scale <1.3,0.1,1.4> texture { pigment { color rgbf <0.9,0.9,0.9,0.8> } finish { phong 1 ior 1.5 ambient 0.6 }
normal { bumps 8 scale <2,4,0.3> }}
rotate x*2 rotate z*5 rotate -y*5 translate <5.3,1.7,0> }
}

union {
object { ojos }
object { cab }
object { cue1 }
object { cue2 }
object { cue3 }
object { PATAS }
object { ALAS }
object { anten }
}

//------------ La piel

height_field { tga "piel1.tga" smooth
translate <-0.5,0,-0.5> scale <40,0.6,40> translate <9.3,-2.5,9.8>
texture { pigment { color rgb <1,0.8,0.76> }
finish { phong 1 brilliance 1 ambient 0.35 diffuse 0.75 }
normal { bumps 0.6 scale 0.5 }
scale <1.3,0.3,0.8> } rotate y*20 scale <1.5,1,1>}

#declare pelo = intersection {
         torus { 1,0.018 } box { <0,-1,-2>,<2,1,2> inverse }
         texture { pigment { color rgb <0.2,0.2,0.15> }
         finish { phong 1 ambient 0.5 }}rotate x*85}

//------------ El vello
object { pelo rotate y*2 scale 3 translate <0.8,-3.5,-3> }
object { pelo rotate y*-2 scale 1.75 translate <5,-3.35,-6> }
object { pelo rotate y*1 scale 3 translate <6,-3,3.5> }
object { pelo rotate y*1.5 scale 3.2 translate <17,-3.15,-3> }
object { pelo rotate y*-2 scale 3 translate <10.5,-3,-4.5> }
object { pelo rotate y*-3 scale 2.7 translate <13,-2.9,-2> }
object { pelo rotate y*3.5 scale 2.2 translate <10,-3.2,4> }
object { pelo rotate y*4 scale 3 translate <4,-3.5,3> }
object { pelo rotate y*21 scale 3 translate <20,-3.5,8> }
object { pelo rotate y*-7 scale 1.75 translate <7,-3.35,12> }
object { pelo rotate y*5 scale 3 translate <9,-3,3.5> }
object { pelo rotate y*8.5 scale 3.2 translate <1.8,-3.15,-6.5> }
object { pelo rotate y*-3 scale 3 translate <4.5,-3,8.5> }
object { pelo rotate y*-9 scale 2.7 translate <19,-2.9,-2> }
object { pelo rotate y*18.5 scale 2.2 translate <14,-3.2,14> }
object { pelo rotate y*2 scale 3 translate <11,-3.5,17> }
object { pelo rotate y*-25 scale 2.7 translate <5,-2.9,-4.3> }
object { pelo rotate y*3.5 scale 2.2 translate <12,-3.2,5> }
object { pelo rotate y*4 scale 3 translate <8,-3.5,-3.2> }
object { pelo rotate y*5 scale 3 translate <2,-3.5,-6.5> }
object { pelo rotate y*-7 scale 1.75 translate <3,-3.35,-8.5> }
object { pelo rotate y*15 scale 3 translate <9,-3,8> }
object { pelo rotate y*8.5 scale 3.2 translate <2.5,-3.15,-8.5> }
object { pelo rotate y*-25 scale 2.7 translate <-1,-2.9,4.3> }
object { pelo rotate y*3.5 scale 2.2 translate <1,-3.2,6> }
object { pelo rotate y*4 scale 3 translate <-1.5,-3.5,-3.2> }

