// various flowers / shrubs etc

#declare FMNGreen = color rgb <0.31, 0.573, 0.255>


#declare Blue_Flower =
union {
#declare Count = 0
#while (Count < 5)

cylinder {<0, 0, 0>, <0, 0.05, 0>, 0.05
          scale <1.5, 1, 1>
          translate <0.075, 0, 0>
          rotate <5, 0, 10>
          rotate <0, 72*Count, 0>
}
#declare Count = Count + 1
#end

sphere {<0, 0.03, 0>, 0.05
        pigment {color White}
}
cylinder { <0, 0, 0>, <0, -0.2, 0>, 0.01
           pigment {color FMNGreen}
}

pigment {color SkyBlue}
} // end blue flower union

#declare Pink_Flower = object {Blue_Flower pigment {color Maroon} }


#declare FMNBud =
union {
cylinder {<0, 0, 0>, <0.2, 0.2, 0>, 0.01}
sphere { <0, 0, 0>, 0.04
         scale <1.5, 1, 1>
         rotate <0, 0, 45>
         translate <0.1, 0.1, 0>
}
pigment {color FMNGreen}

} // end FMNBud union

#declare FMNStalk = union {

object {Blue_Flower}
#declare Count = 0
#while (Count < 4)
object {Blue_Flower
       translate <0, 0, -0.3>
       rotate <-55, Count *90, 0>
       translate <0, 0.2, 0>
}
#declare Count = Count + 1
#end

cylinder {<0, 0, 0>, <0, -3, 0>, 0.02
          pigment {color FMNGreen}
}

#declare Count = 0
#while (Count < 7)

object {FMNBud
        translate <0, -Count * 0.3, 0>
}
object {FMNBud
        rotate <0, 180, 0>
        translate <0, -Count * 0.3 -0.15, 0>
}

#declare Count = Count + 1
#end

} // end stalk union

#declare ForgetMeNot = union {
object {FMNStalk
        translate <0, 3, 0>
        rotate <25, 0, 0>
}
object {FMNStalk
        translate <0, 3, 0>
        rotate <30, 120, 0>
}
object {FMNStalk
        translate <0, 3, 0>
        rotate <35, 240, 0>
        translate <0, -1, 0>
}
cylinder {<0, 0, 0>, <0, -3, 0>, 0.05 pigment {color FMNGreen} }

cylinder {<0, 0, 0>, <0, 0.05, 0>, 1
          scale <1, 1, 0.4>
          rotate <23, 0, 20>
          translate <1, -2, 0>
          pigment {color FMNGreen}
          normal {marble
                  turbulence 0.4
                  scale 0.3}
}
cylinder {<0, 0, 0>, <0, 0.05, 0>, 1
          scale <1, 1, 0.37>
          rotate <-35, 0, 25>
          translate <-1, -1.5, 0>
          pigment {color FMNGreen}
          normal {marble
                  turbulence 0.4
                  scale 0.3}

}

} // end Forgetme not union

// -----------------------------------------------------------
// hanging plant
#declare HPleaf =
cylinder {<0, 0, 0>, <0, 0.01, 0>, 0.15
          scale <2, 1, 0.75>
          translate <0.3, 0, 0>
pigment {color Green}
}

#declare HPleaf1 =
union {
object {HPleaf}
object {HPleaf
        rotate <10, 118, 0>
}
object {HPleaf
       rotate <-5, 244, 0>
}
#declare Count = 0
#while (Count < 16)
object {Pink_Flower
       translate <-0.4+rand(R1)*0.8, 0, -0.4+rand(R1)*0.8>
}
#declare Count = Count + 1
#end
} // end hpleaf union


#declare Wort =
union {
#declare Count = 0
#while (Count < 14)

union {
object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       translate <rand(R1)*0.8, 0, rand(R1)*0.8>
}
object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       translate <rand(R1)*0.8, 0, rand(R1)*0.8>
}
object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       translate <rand(R1)*0.8, 0.3, rand(R1)*0.8>
}
object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       rotate <-30, 0, 0>
       translate <-1+rand(R1)*2, -0.1, -0.5-rand(R1)*2>
}
object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       rotate <-20, 0, 0>
       translate <-1+rand(R1)*2, -0.2, -0.5-rand(R1)*2>
}
object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       rotate <-30, 0, 0>
       translate <-1+rand(R1)*2, -0.4, -1-rand(R1)*2>
}
object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       rotate <-40, 0, 0>
       translate <-1+rand(R1)*2, -1, -1-rand(R1)*2>
}
object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       rotate <-60, 0, 0>
       translate <-1+rand(R1)*2, -1.5, -1-rand(R1)*2>
}
#declare Count1 = -2
#while (Count1 > -9)
object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       rotate <-90, 0, 0>
       translate <-1+rand(R1)*2, Count1, -1-rand(R1)*2>
}

#declare Count1=Count1-0.5
#end

#if (rand(R1) < 0.5)
    object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       rotate <-60, 0, 0>
       translate <-1+rand(R1)*2, -9.5, -1-rand(R1)*2>
    }
    #if (rand(R1) < 0.5)
    object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       rotate <-30, 0, 0>
       translate <-1+rand(R1)*2, -9.6, -1.2-rand(R1)*2>
    }
    #if (rand(R1) < 0.5)
    object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       translate <-1+rand(R1)*2, -9.6, -1.7-rand(R1)*2>
    }
    #if (rand(R1) < 0.5)
    object {HPleaf1
       rotate <0, rand(R1)*360, 0>
       translate <-1+rand(R1)*2, -9.6, -2.3-rand(R1)*2>
    }
    #end

    #end

  #end

#end

translate <Count, 0, 0>

} // end section union

#declare Count = Count + 1
#end

} // end wort union


// ------------------------------------------------------
// fern

#declare Fern_Leaf = union {

#declare Count = 1
#while (Count < 15)

cylinder {<0, 0, 0>, <0.5, 0, 0>, 0.02
          pigment {gradient x
                   color_map {
                   [0.0 color DarkGreen]
                   [1 color Yellow]}
                   scale 0.5
                   }
          rotate <0, Count * (5+rand(R1)), rand(R1)*20 - 10>
          translate <3 - Count/5, 0, 0>
}
cylinder {<0, 0, 0>, <0.5, 0, 0>, 0.02
          pigment {gradient x
                   color_map {
                   [0.0 color DarkGreen]
                   [1 color Yellow]}
                   scale 0.5
                   }
          rotate <0, -Count * (5+rand(R1)), rand(R1)*20 - 10>
          translate <3 - Count/5, 0, 0>
}

#declare Count = Count + 0.7
#end

cone {<3.5, 0, 0>, 0
      <0, 0, 0>, 0.05
      pigment {color DarkGreen}
}

} // end Fern_Leaf union

#declare Fern = union {
#declare Count = 0
#while (Count < 14)

object {Fern_Leaf
       rotate <rand(R1)*40 -20, rand(R1)*360, rand(R1)*20-10>
       translate <0, rand(R1)*2, 0>
}

#declare Count = Count +1
#end

} // end fern union

// --------------------------------------------------------
// shrubery

#declare Bush_text =
texture {
        pigment {bozo
                turbulence 1
                color_map {
                [0.0 color DarkGreen]
                [0.1 color DarkGreen]
                [0.1 color Clear]
                [0.4 color Clear]
                [0.4 color DarkGreen]
                [0.5 color DarkGreen]
                [0.5 color Clear]
                [0.8 color Clear]
                [0.8 color DarkBrown]
                [0.82 color Brown]
                [0.82 color Clear]
                [1.0 color Clear] }
                }
}
#declare Bush = union {
#declare Count = 0
#while (Count < 100)

sphere {<rand(R1) * 10, rand(R1) * 5 + 3, rand (R1)*10>, rand(R1)+0.5
       texture {Bush_text}
}
sphere {<rand(R1) * 7 + 1.25, rand(R1) * 5 + 6, rand (R1)*7>, rand(R1)+0.5
       texture {Bush_text}
}
sphere {<rand(R1) * 7 + 1.25, rand(R1) * 5 , rand (R1)*7>, rand(R1)+0.5
       texture {Bush_text}
}

#declare Count = Count + 1
#end
}

// -----------------------------------------
// White daisies

#declare Daisy_Head =
union {
#declare Count = 0
#while (Count < 15)

cylinder {<0, 0, 0>, <0, 0.01, 0>, 0.4
          scale <2, 1, 0.3>
          translate <0.8, 0, 0>
          rotate <rand(R1)*20-10, 0, rand(R1)*10-5>
          rotate <0, Count * (22+rand(R1)*4), 0>
          pigment {color White}
          finish {ambient 0.5}
}

#declare Count = Count + 1
#end
sphere {<0, 0, 0>, 0.4
        scale <1, 0.25, 1>
        pigment {color rgb <0.6, 0.55, 0>}
        normal {dents 0.3 scale 0.1}
        finish {ambient 0.3}
}
cylinder {<0, 0, 0>, <0, -4, 0>, 0.1}
cylinder {<0, -4, 0>, <0, -4.1, 0>, 0.5
         scale <2.5, 1, 0.5>
         rotate <0, rand(R1)*360, rand(R1)*20>
}
cylinder {<0, -3, 0>, <0, -3.1, 0>, 0.5
         scale <2.5, 1, 0.5>
         rotate <0, rand(R1)*360, rand(R1)*20>
}
cylinder {<0, -2, 0>, <0, -2.1, 0>, 0.5
         scale <3, 1, 0.5>
         rotate <0, rand(R1)*360, rand(R1)*20>
}

pigment {DarkGreen}
finish {Shiny}

} // end daisy Head

// ---------------------------------------------
// Delphiniums


#declare Delphi_Green = color rgb <0.3, 0.5, 0.4>
#declare Delphi_Blue = color rgb <0.6, 0.5, 0.9>

#declare Delphi_Flower = union {
#declare Count = 0
#while (Count < 5)
cylinder {<0, 0, 0>, <0, 0, 0.01>, 0.25
          scale <0.9, 1, 1>
          rotate <35, 0, 0>
          translate <0, -0.3, 0>
          rotate <0, 0, 72 * Count>
}

#declare Count=Count + 1
#end

sphere {<0, 0, 0>, 0.2
        scale <1, 1, 0.25>
        pigment {color rgb <0.3, 0.1, 0.4>}
}
cylinder {<0, 0, 0>, <0, 0, 0.4>, 0.2 pigment {color Delphi_Green} }

} // end flower union

#declare Delphi_Leaf = union {
box {<0, 0, 0>, <1, 1, 0.01>
       pigment {
               image_map {
               gif "d_leaf.gif"
               transmit 0, 1.0
               }
       }
       scale 2
       finish {ambient 0.4}
}
box {<0, 0, 0>, <1, 1, 0.01>
       pigment {
               image_map {
               gif "d_leaf.gif"
               transmit 0, 1.0
               }
       }
       scale 2
       rotate <20, 0, -90>
       translate <2, 1, 0>
       finish {ambient 0.4}
}
box {<0, 0, 0>, <1, 1, 0.01>
       pigment {
               image_map {
               gif "d_leaf.gif"
               transmit 0, 1.0
               }
       }
       scale 2
       rotate <-15, 0, 180>
       translate <2, 0, 0>
       finish {ambient 0.4}
}
cylinder {<-1, 0, 0>, <1, 0, 0>, 0.02 pigment {color Delphi_Green} }
rotate <90, 0, 40>
} // end leaf union

#declare Delphi_Bud = union {
sphere {<0, 0, 0>, 0.3
        scale <1.2, 0.8, 0.8>
}
cone {<0, 0, 0>, 0.2
      <0.5, 0, 0>, 0.1
      pigment {color Delphi_Green}
      }
}      


#declare Delphinium = union {


#declare Count = 0
#while (Count < 8)
object {Delphi_Flower
        rotate <0, 0, rand(R1)*360>
        translate <0, Count + rand(R1), -0.7-rand(R1)/5>
        rotate <0, rand(R1)*20-5, 0>
}
object {Delphi_Flower
        rotate <0, 0, rand(R1)*360>
        translate <0, Count + rand(R1), -0.7-rand(R1)/5>
        rotate <0, 55+rand(R1)*20, 0>
}
object {Delphi_Flower
        rotate <0, 0, rand(R1)*360>
        translate <0, Count + rand(R1), -0.7-rand(R1)/5>
        rotate <0, 115+rand(R1)*20, 0>
}
object {Delphi_Flower
        rotate <0, 0, rand(R1)*360>
        translate <0, Count + rand(R1), -0.7-rand(R1)/5>
        rotate <0, 175+rand(R1)*20, 0>
}
object {Delphi_Flower
        rotate <0, 0, rand(R1)*360>
        translate <0, Count + rand(R1), -0.7-rand(R1)/5>
        rotate <0, 235+rand(R1)*20, 0>
}
object {Delphi_Flower
        rotate <0, 0, rand(R1)*360>
        translate <0, Count + rand(R1), -0.7-rand(R1)/5>
        rotate <0, 295+rand(R1)*20, 0>
}

#declare Count=Count + 1
#end

// needed here to allow petal colours to be change by main prog
union {
cylinder {<0, 7, 0>, <0, -10, 0>, 0.15}
cone {<0, 7, 0>, 0.15
      <-0.5, 9, 0>, 0.12}
cone {<-0.5, 9, 0>, 0.12
      <-1.5, 11, 0>, 0.05}
cone {<-1.5, 11, 0>, 0.05
      <-2, 11.5, 0>, 0}      
pigment {color Delphi_Green}
}      

object {Delphi_Flower
        scale 0.8
        rotate <0,-30, 0>
        translate <0.2, 8.5, 0>
}         
object {Delphi_Flower
        scale 0.6
        rotate <0, 30, 0>
        translate <-0.2, 9.5, 0>
}         
object {Delphi_Bud
        translate <-0.9, 8.1, 0>
}
object {Delphi_Bud
        scale 0.7
        rotate <0, -120, 0>
        translate <-0.7, 9.8, -0.4>
}
object {Delphi_Bud
        scale 0.8
        rotate <0, -120, 0>
        translate <-0.5, 9.3, -0.5>
}
object {Delphi_Bud
        scale 0.9
        rotate <0, -80, 0>
        translate <-0.3, 8.5, -0.6>
}
object {Delphi_Bud
        scale 0.9
        rotate <0, 80, 0>
        translate <-0.3, 8.5, 0.6>
}

object {Delphi_Bud
        rotate <0, 120, 0>
        translate <0, 8.8, 0>
}
object {Delphi_Bud
        scale 0.8
        translate <-1, 9.2, 0>
}
object {Delphi_Bud
        scale 0.7
        rotate <0, 120, 0>
        translate <-0.85, 10, 0.3>
}
object {Delphi_Bud
        scale 0.7
        translate <-1.3, 9.9, 0>
}
object {Delphi_Bud
        scale 0.5
        rotate <0, 120, 0>
        translate <-1.2, 10.5, 0.2>
}
object {Delphi_Bud
        scale 0.5
        translate <-1.5, 10.4, 0>
}
object {Delphi_Bud
        scale 0.3
        rotate <0, 120, 0>
        translate <-1.5, 11, 0.2>
}
object {Delphi_Bud
        scale 0.3
        translate <-1.8, 11, 0>
}



#declare Count = 3
#while (Count < 10)
object {Delphi_Leaf
        translate <1, -Count+rand(R1), 0>
        rotate <0, 30 + rand(R1)*20, 0>
}
object {Delphi_Leaf
        translate <1, -Count+rand(R1), 0>
        rotate <0, 150 + rand(R1)*20, 0>
}
object {Delphi_Leaf
        translate <1, -Count+rand(R1), 0>
        rotate <0, 270 + rand(R1)*20, 0>
}

#declare Count=Count + 2
#end


} // end delphinum union
