
// Glenn's Environment POV-Ray Object File
// This file does not render.  #include "Environ.inc" in another .pov file
// created 19-May-98  updated 23-May-98
// copyright 1998 Glenn McCarter

// Some distant mountains

// Intended scale is English system (inches), ground is +Z
// Origin in the middle of the ground plane


//===============================================
//             Textures
//===============================================

#declare JungleTex =
	texture {
		pigment {
			bozo
			color_map
			{
       [ 0.0     rgbft <0.137255, 0.313725, 0.105882, 0.0, 0.0> ]
       [ 0.234875  rgbft <0.239216, 0.407843, 0.176471, 0.0, 0.0> ]
       [ 1.0     rgbft <0.368627, 0.686275, 0.196078, 0.0, 0.0> ]
			} // color_map
			scale 50
			turbulence .02
		}
		normal { bumps .13 scale 400 }
		finish { ambient .15 diffuse .7 specular .2 roughness .05 }
	}
#declare MountainTex =
	texture {
		pigment {
			bozo
			color_map
			{
       [ 0.0     rgbft <0.347255, 0.313725, 0.245882, 0.0, 0.0> ]
       [ 0.234875  rgbft <0.339216, 0.437843, 0.326471, 0.0, 0.0> ]
       [ 1.0     rgbft <0.568627, 0.486275, 0.46078, 0.0, 0.0> ]
			} // color_map
			scale 50
			turbulence .02
		}
		normal { bumps .13 scale 400 }
		finish { ambient .15 diffuse .7 specular .2 roughness .05 }
	}
/*
#declare EarthTex = // gradient test
	texture {
		pigment {
			gradient x
			color_map
			{
			[ 0.0 color rgb<1,1,1> ]
			[ 1.0 color rgb<0,0,0> ]
			} // color_map
			scale 1.4*Miles
		}
		normal { bumps .13 scale 400 }
		finish { ambient .15 diffuse .7 specular .2 roughness .05 }
	}
*/

#declare DirtTex =
	texture {
		pigment { color rgb<.60,.48,.22>*.6 } // dirty tan
		finish { ambient .1 specular .05 roughness .08 }
	}

#declare CloudTex =
	texture {
		pigment {
			bozo
			color_map
			{
				[ 0.1  color rgbt<.4,.4,.4,1.0> ]
				[ 0.4  color rgbt<.5,.5,.5,1.0> ]
				[ 0.7  color rgbt<.96,.96,.96,.6> ]
				[ 1.0  color rgbt<.8,.8,.8,.3> ]
			} // color_map
			scale 10000
			turbulence .5
		}
		normal { bumps .13 scale 400 }
		finish { ambient .15 diffuse .7 specular .2 roughness .05 }
	}


//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <-4*Feet,-18*Feet,14*Feet> }
//object {StdBulb60Watt translate <-40*Feet,12*Feet,14*Feet> }


//===============================================
//             Objects
//===============================================

#declare DistantMountains =
	height_field {
		png "Mount1HF.png"
		smooth
		rotate <90,0,0> // set up for RH coordinate system
		translate <-.5,.5,-0.005> //center on origin // sink it below local area
//		translate <-.5,.5,0> //center on origin
		rotate <0,0,90> // top of image is +X
		scale <1,-1,1> // LH side of image is +Y
		scale <2.5*Miles,2.5*Miles,1600*Feet> // finally, scale it up
//		texture { GreenGrass } // test
//		texture { EarthTex }
// NOTE: because of scaling, center region is about 8 below zero
	}
#declare DistantJungle =
	height_field {
		png "Jungle1HF.png"
		smooth
		rotate <90,0,0> // set up for RH coordinate system
		translate <-.5,.5,-0.005> //center on origin // sink it below local area
//		translate <-.5,.5,0> //center on origin
		rotate <0,0,90> // top of image is +X
		scale <1,-1,1> // LH side of image is +Y
		scale <2.5*Miles,2.5*Miles,1600*Feet> // finally, scale it up
//		texture { GreenGrass } // test
//		texture { EarthTex }
// NOTE: because of scaling, center region is about 8 below zero
	}

#declare NearbyDirt =
	height_field {
		png "Dirt1HF.png"
		rotate <90,0,0> // set up for RH coordinate system
		translate <-.5,.5,-0.005> //center on origin // sink base below local zero
		rotate <0,0,90> // top of image is +X
		scale <1,-1,1> // LH side of image is +Y
		water_level .05
//		translate <-.5,.5,0> //center on origin
		scale <4*Feet,4*Feet,4> // finally, scale it up
//		texture { GreenGrass } // test
//		texture { EarthTex }
	}



#declare Clouds =
	plane {
		-z,0
		texture { CloudTex }
	}

#ifndef (NoFog) #declare NoFog=0 #end
#if (NoFog=0)
/*
fog {
	fog_type 1 // general fog adds distance
//		distance 12000*Feet
		distance 22000*Feet
		color rgbt<.980,.980,.998,.06> // transmittance (lower trans dulls out sky)
		turbulence .001
	}
*/
fog {
	fog_type 2 // ground fog fills valleys with mist
		distance 200*Feet
//		distance 22000*Feet
		fog_offset 200*Feet
		fog_alt 40*Feet
		up z
		color rgbt<.980,.980,.998,.46> // transmittance (lower trans dulls out sky)
		turbulence .001
	}
#end

