
// Glenn's POV-Ray Object File - Dirt Ground
// This file does not render.  #include "Ground.inc" in another .pov file
// created 19-May-98  updated 7-Jun-98
// copyright 1998 Glenn McCarter

// A 2-meter patch of dirt

// Intended scale is English system (inches), ground is +Z
// Origin in the middle of the ground plane


//===============================================
//             Textures
//===============================================


#declare DirtTex =
	texture {
		pigment { color rgb<.60,.48,.22>*.6 } // dirty tan
		finish { ambient .1 specular .05 roughness .08 }
	}


//===============================================
//             Lighting
//===============================================



//===============================================
//             Objects
//===============================================


#declare NearbyDirt =
	height_field {
		png "Dirt1HF.png"
		rotate <90,0,0> // set up for RH coordinate system
		translate <-.5,.5,-0.005> //center on origin // sink base below local zero
		rotate <0,0,90> // top of image is +X
		scale <1,-1,1> // LH side of image is +Y
		water_level .05
//		translate <-.5,.5,0> //center on origin
		scale <4*Feet,4*Feet,4> // finally, scale it up
//		texture { GreenGrass } // test
//		texture { EarthTex }
	}



