
// Glenn's POV-Ray Scene File - Leaf Height Field Gradient
// created 22-May-98
// last update 22-May-98
// copyright 1998 Glenn McCarter

// This file produces a .png output file which can be used
// as a height field representing the surface of a leaf.
// Uses a gradient texture to achieve this: the higher the
// point on the surface, the brighter the ambient texture.
// No light sources are necessary.
// Note the orthographic camera is used.

#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//===============================================
//             Variables
//===============================================

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
	orthographic // note: image size defined by length of right and up vectors
  direction <0.0,     1.0,  0.0>
  sky       <1.0,     0.0,  0.0>  // Use right handed-system!
  up        <0.0,     0.0,  16.0>  // Where Z is up
  right     <16*1.33333, 0.0,  0.0>
  /* // Focal Blur section: uncomment to enable focal blur
  blur_samples 6
  aperture .5    //lower value = wider range in focus
  focal_point <0,0,0>
  */ // end focal blur
//	angle 45
  location  <0.001,0.001,20>
  look_at   <0.001, 0.001, 0.000>
}


camera { // special cameras declared in GCamerasRH.inc
    Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare HFGradientTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.0 color rgb<0,0,0> ]
				[ 1.0 color rgb<1,1,1> ]
			}
		}
		finish { ambient .8 }
	}

//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
//object {StdBulb60Watt translate <-10*Feet,2*Feet,8*Feet> }

//===============================================
//             Environment
//===============================================

background { color rgb <0.2, 0.4, 0.8> } // light blue
//background { color rgb <0.0, 0.0, 0.0> } // black
//#include "skies.inc"
//sky_sphere { S_Cloud5 rotate <90,0,0> }
//object { O_Cloud1 rotate <90,0,0> }
object {GroundPlaneWhite translate z*-0}

//===============================================
//             Objects
//===============================================

#declare LeafHalf =
	cylinder {
		<0,0,0>,<0,0,10>,8
	}
#declare LeafSurf =
	union {
		object { LeafHalf rotate x*75 }
		object { LeafHalf rotate x*-75 }
	}


//===============================================
//             Object Placement
//===============================================

//object { TestSphere scale 4 translate <0,-6,3> }
object { LeafSurf translate z*-6 texture { HFGradientTex scale 5 } }

