
// Glenn's POV-Ray Scene File - Leaves
// created 23-May-98
// last update 23-Nov-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Leaves.inc" in another .pov file
//
// Leaf1LH, Leaf1RH - a very ordinary small leaf
// ThickLeaf1 - suitable for a small weed plant
// ThickLeaf2 - more wavy and wider than 1
//
// All leaves have stems beginning at the origin.
// Leaves mostly extend into +X
// Leaves are ready to attach onto a branch which
// extends into +X
//
// Three types of leaf constructions are used:
//  - height field leaves
//  - primitive leaves
//  - patch leaves
// (See below for descriptions)


//================================================================
//      Remove this section -- only used for test renders!
//================================================================
/*
#include "GIncludeRH.inc"
#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  /* // Focal Blur section: uncomment to enable focal blur
  blur_samples 6
  aperture .5    //lower value = wider range in focus
  focal_point <0,0,0>
  */ // end focal blur
  location  <-1.6*Feet, -2.2*Feet, .9*Feet>
  look_at   <0.000, 0.000, 0.000>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//    angle 40
//    direction z*50
  location <-1, -1, 11> // top view
//  location <1, -11, 0> // side view
//  location <-11, -1, 0> // rear view
  look_at <0, 0, 0>
  }

camera { // special cameras declared in GCamerasRH.inc
//    Special_Cam
//    Render_Cam
    Back4Inch_Cam // use values 1,2,4,8,12,16,32,64,or 128
//    location <6*Feet, 6*Feet, 5*Feet> // "Reverse Angle"
//    location <-42, -24, 10> // Standard Position
    angle 40
    look_at <0, 0, 0>
  }
object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
object {StdBulb60Watt translate <-10*Feet,2*Feet,8*Feet> }
background { color rgb <0.2, 0.4, 0.8> } // light blue
//object {GroundPlaneWhite translate z*-0}
*/


//===============================================
//             Textures
//===============================================

#declare Leaf1Tex =
	texture {
		pigment { color rgb<.35,.93,.18> }
	}
#declare ThickLeaf1Tex =
	texture {
		pigment { color rgb<.32,.81,.21> }
	}
#declare ThickLeaf2Tex =
	texture {
		pigment { color rgb<.30,.78,.18> }
	}


//===============================================
//             Height Field Leaves
//===============================================

// Main surface of these leaves is formed by a height field,
// outline is formed with a primitive.
// Makes leaves with complex surfaces.

#include "LeafStem1.pov"
#declare LeafStem1 =
	object { LeafStemShape1
		texture { Leaf1Tex }
	}
#declare Leaf1HF =
	height_field {
		png "Leaf1HF.png"
		rotate x*90 // set up for RH coordinate system
		translate <-.5,.5,-0.005> //center on origin // sink it below local area
		scale <8,8,3> // finally, scale it up
//		texture { Leaf1Tex } // test
// NOTE: because of scaling, center region is below zero
	}
#declare Leaf1Main =
	intersection {
		object { Leaf1HF } // top surface
		object { Leaf1HF translate <0,0,-.04> inverse } // bottom surface
		cylinder { // outline
			<0,.5,0>,<0,.5,2>,2
			scale <.6,1,1>
		}
		rotate <10,0,90> // flatten leaf, extends along +x
		translate <2.4,0,-1.0> // center base at origin
		texture { Leaf1Tex }
	} // end intersection
#declare Leaf1RH =
	union {
		object { LeafStem1 rotate <-90,0,0> }
		object { Leaf1Main
			rotate <7,24,-40> // rotate leaf
			translate <.9,-0.5,0.05> // attach to stem
		}
	} // end union

#declare Leaf1LH = object { Leaf1RH scale <1,-1,1> }


//===============================================
//             Primitive Leaves
//===============================================

// Main surface of these leaves is formed by a primitive,
// outline is formed with a height field.
// Makes leaves with complex outlines.


//===============================================
//             Patch Leaves
//===============================================

// Main surface and perimeter of these leaves is formed by a
// bezier patch.

#include "ThickLeaf1.pov"
#declare ThickLeaf1 = // 3 inches long
	object { ThickLeafShape1
		rotate <90,0,90> // horizontal, extends into +x
		translate <1.25,-0.15,0.5> // origin at base of stem
		texture { ThickLeaf1Tex }
	}
#include "ThickLeaf2.pov"
#declare ThickLeaf2 = // 3 inches long
	object { ThickLeafShape2
		rotate <90,0,90> // horizontal, extends into +x
		translate <1.25,-0.15,0.5> // origin at base of stem
		texture { ThickLeaf2Tex }
	}


//===============================================
//             Object Placement
//===============================================

//object { TestSphere scale 4 translate <0,-6,3> }
//object { Leaf1RH  }
//object { Leaf1LH  }
//object { ThickLeaf1 scale 1 }
