
// Glenn's POV-Ray Scene File - Shadow Trees
// created 27-Jun-98
// last update 28-Jun-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "ShadowTrees.inc" in another .pov file

// This file creates the trees that cast
// shadows over most of the objects in the scene.

//===============================================
//             Textures
//===============================================

#declare DistantTreeTex =
	texture {
		pigment {
			granite
			color_map {
				[ 0.0 color rgbt<1,1,1,1> ]
				[ 0.4 color rgbt<1,1,1,1> ]
				[ 0.6 color rgbt<0.3,1.0,0.4,0.4> ]
				[ 1.0 color rgbt<0.3,1.0,0.4,0.2> ]
			}
		}
	}

//===============================================
//             Objects
//===============================================

// These files must be included first:
//#include "Trees.inc"
//#include "Weeds.inc"

#declare SimpleTree1 = // windswept, spheroid leaf sets
	union {
//		object { BareTree1 scale <8,7.6,5> rotate <0,0,0> } // main trunk, along z-axis
		sphere {
			<0,0,0>,15*Feet
			scale <1,1.1,1.6>
			rotate <33,4,6>
			texture { DistantTreeTex scale 88 }
			translate <0,-10*Feet,48*Feet> // set on top of trunk
		}
		sphere {
			<0,0,0>,7*Feet
			scale <1,1.1,1.6>
			rotate <-16,-8,41>
			texture { DistantTreeTex scale 125 }
			translate <-5*Feet,8*Feet,33*Feet> // set on top of trunk
		}
	}
#declare SimpleCanopyTree1 = // tall, spheroid leaf sets
	union {
//		object { BranchStem1 scale <25,27,25> rotate <0,0,0> } // main trunk, along z-axis
//		object { BranchStem1 scale <5,7,5> rotate <0,34,8> translate <44,-48,46*Feet>} // upper branch
//		object { BranchStem1 scale <5,7,5> rotate <2,40,100> translate <44,-48,45*Feet>} // upper branch
//		object { BranchStem1 scale <5,7,5> rotate <5,40,220> translate <44,-48,44*Feet>} // upper branch
		sphere {
			<0,0,0>,15*Feet
			scale <1,1.1,1>
			rotate <3,4,6>
			texture { DistantTreeTex scale 148 }
			clipped_by{box{<-22*Feet,-22*Feet,20>,<22*Feet,22*Feet,22*Feet>}} // keep top half
			translate <0,-1*Feet,48*Feet> // set on top of trunk
		}
//		box { <0,0,0>,<22,22,40*Feet> texture { BrightWhite} translate <0,20*Feet,0>} // size reference test
	}

//===============================================
//             Object Placement
//===============================================

#declare ShadowTrees =
union {

object { SimpleTree1 scale .6 translate <0,0,0> }
object { SimpleTree1 scale .75 rotate z*117 translate <92,14*Feet,0> }
object { SimpleTree1 scale .5 rotate z*32 translate <0,35*Feet,0> } // far left
object { SimpleTree1 scale .7 rotate z*237 translate <0,-28*Feet,0> } // far right

object { SimpleCanopyTree1 scale <1,1,1.23> translate <-8*Feet,-4*Feet,28*Feet> } // right
object { SimpleCanopyTree1 scale <1,1,1.12> rotate <0,0,60> translate <-8.6*Feet,-12*Feet,21*Feet> } // right

object { SimpleCanopyTree1 scale <1,1,1.12> rotate <8,0,60> translate <-8.6*Feet,-13*Feet,0> } // right
object { SimpleCanopyTree1 scale <1,1,1.03> rotate <0,0,120> translate <-9.6*Feet,23.6*Feet,0> } // left
object { SimpleCanopyTree1 scale <1,1,1.20> rotate <-14,0,12> translate <-9.6*Feet,25.1*Feet,0> } // left
object { Weeds1 scale 40 translate <0,8*Feet,0> }
object { Weeds1 scale 37 rotate z*36 translate <0,-18*Feet,0> }
} // end union



