
// Glenn's POV-Ray Scene File - Branches and Trees
// created 22-May-98
// last update 23-Jun-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Trees.inc" in another .pov file
//
// Branch1Main - a 24-inch stem, no branching
// StraightBranch1 - horizontal, 24-inch long, 20 leaves
// StraightBranch2 - horizontal, 12-inch long, 10 leaves
// BareTree1 - very simple, no leaves
// SimpleTree1 - A sphere with loose texture
//
// All branches have stems beginning at the origin.
// Branches mostly extend into +X


//================================================================
//      Remove this section -- only used for test renders!
//================================================================
/*
#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//    angle 40
//    direction z*50
  location <-1, -1, 21> // top view
//  location <1, -21, 0> // side view
//  location <-11, -1, 0> // rear view
//  location <-11*Feet, -11*Feet, 21*Feet> // tree normal view
//  location <-2*Feet, -1, 32*Feet> // tree top view
//  location <1, -21*Feet, 8*Feet> // tree side view
//  location <-161*Feet, -1, 6*Feet> // tree rear view
  look_at <0, 0, 4>
//  look_at <0, 0, 18*Feet>
  }

camera { // special cameras declared in GCamerasRH.inc
    Special_Cam
//    Back16Inch_Cam // use values 1,2,4,8,12,16,32,64,or 128
//    location <6*Feet, 6*Feet, 5*Feet> // "Reverse Angle"
//    location <-42, -24, 10> // Standard Position
    angle 40
//    look_at <0, 0, 0>
  }
object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
object {StdBulb60Watt translate <-10*Feet,2*Feet,8*Feet> }
background { color rgb <0.2, 0.4, 0.8> } // light blue
//object {GroundPlaneWhite translate z*-0}
*/

//===============================================
//             Textures
//===============================================

#declare Branch1Tex = // stem texture
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0 rgb<.334,.453,.008> ] // green
				[ 0.5 rgb<.134,.554,.002> ] // green
				[ 1.0 rgb<.024,.263,.012> ]
			}
			scale <.12,.15,1.6>
		}
		normal { bumps .6 scale .2 }
	}
#declare DistantTreeTex =
	texture {
		pigment {
			granite
			color_map {
				[ 0.0 color rgbt<1,1,1,1> ]
				[ 0.4 color rgbt<1,1,1,1> ]
				[ 0.6 color rgbt<0.3,1.0,0.4,0.4> ]
				[ 1.0 color rgbt<0.3,1.0,0.4,0.2> ]
			}
		}
	}

//===============================================
//             Objects
//===============================================

#include "Leaves.inc"
#include "BranchStem.pov"
#declare Branch1Main =
	object { BranchStem1 }
#declare RS = seed(73538)
#declare BaseX = 4.0
#declare Split = .2
/*
#declare StraightBranch1 = // 24-inches long, 20 leaves
	union {
		object { BranchStem1 rotate <0,90,0> } // along x-axis

		object { Leaf1RH scale 1.2 rotate <0,0,0> translate <BaseX*1,-Split,0.0> }
		object { Leaf1LH scale 1.2 rotate <0,0,0> translate <BaseX*1, Split,0.0> }

		object { Leaf1RH scale 1.18 rotate <0,10,-12> translate <BaseX*2,-Split-.2,-0.3> }
		object { Leaf1LH scale 1.18 rotate <0,10,12> translate <BaseX*2, Split-.2,-0.3> }

		object { Leaf1RH scale 1.12 rotate <4,0,-20> translate <BaseX*3*1,-Split-.5-.8,-1.8> }
		object { Leaf1LH scale 1.12 rotate <-4,0,20> translate <BaseX*3*1, Split-.5-.8,-1.8> }

		object { Leaf1RH scale 1.11 rotate <5,0,-15> translate <BaseX*4*.95,-Split-1.2,-1.8> }
		object { Leaf1LH scale 1.11 rotate <-6,0,15> translate <BaseX*4*.95, Split-1.2,-1.8> }

		object { Leaf1RH scale 1.10 rotate <8,8,-16> translate <BaseX*5*.90,-Split-1.0,-1.8> }
		object { Leaf1LH scale 1.10 rotate <-8,8,11> translate <BaseX*5*.90, Split-1.0,-1.8> }

		object { Leaf1RH scale 0.90 rotate <0,5,-12> translate <BaseX*6*.88,-Split-1,-1.7> }
		object { Leaf1LH scale 0.90 rotate <0,2,12> translate <BaseX*6*.88, Split-1,-1.7> }

		object { Leaf1RH scale 0.78 rotate <0,8,-10> translate <BaseX*7*.84,-Split*.8-1,-1.1> }
		object { Leaf1LH scale 0.78 rotate <0,4,10> translate <BaseX*7*.84, Split*.8-1,-1.1> }

		object { Leaf1RH scale 0.68 rotate <2,10,-18> translate <BaseX*8*.81,-Split*.5-1,-0.5> }
		object { Leaf1LH scale 0.68 rotate <-5,7,18> translate <BaseX*8*.81, Split*.5-1,-0.5> }

		object { Leaf1RH scale 0.48 rotate <5,4,-16> translate <BaseX*9*.77,-Split*.3-.5,-0.2> }
		object { Leaf1LH scale 0.48 rotate <-2,0,16> translate <BaseX*9*.77, Split*.3-.5,-0.2> }

		object { Leaf1RH scale 0.29 rotate <4,0,-16> translate <BaseX*10*.72,-Split*.1,-0.0> }
		object { Leaf1LH scale 0.29 rotate <-4,-2,16> translate <BaseX*10*.72, Split*.1,-0.0> }

		object { Leaf1RH scale 0.11 rotate <4,0,-76> translate <BaseX*10*.72+.7,0,-0.0> }
		object { Leaf1LH scale 0.11 rotate <-4,-2,76> translate <BaseX*10*.72+.7, 0,-0.0> }

	} // end union
*/
#declare BaseX = 3.0
#declare Split = .1
#declare StraightBranch2 = // 12-inches long, 10 leaves
	union {
		object { BranchStem1 scale 0.5 rotate <0,90,0> } // along x-axis

		object { Leaf1RH scale 1.0 rotate <0,0,-12> translate <BaseX*1,-Split-.1,-0.2> }
		object { Leaf1LH scale 1.0 rotate <0,0, 12> translate <BaseX*1, Split-.1,-0.2> }

		object { Leaf1RH scale 0.88 rotate <0,10,-12> translate <BaseX*2,-Split-.7,-0.4> }
		object { Leaf1LH scale 0.88 rotate <0,10,12> translate <BaseX*2, Split-.7,-0.4> }

		object { Leaf1RH scale 0.80 rotate <4,0,-20> translate <BaseX*3*1,-Split-.7,-0.7> }
		object { Leaf1LH scale 0.80 rotate <-4,0,20> translate <BaseX*3*1, Split-.7,-0.7> }

		object { Leaf1RH scale 0.67 rotate <5,0,-15> translate <BaseX*4*.95,-Split/2-.6,-0.3> }
		object { Leaf1LH scale 0.67 rotate <-6,0,15> translate <BaseX*4*.95, Split/2-.6,-0.3> }

		object { Leaf1RH scale 0.54 rotate <8,8,-16> translate <BaseX*5*.90,-Split/2-.2,0.2> }
		object { Leaf1LH scale 0.54 rotate <-8,8,11> translate <BaseX*5*.90, Split/2-.2, 0.2> }

		object { Leaf1RH scale 0.16 rotate <4,0,16> translate <BaseX*5*.92+1,0,-0.0> }
		object { Leaf1LH scale 0.16 rotate <-4,-2,-16> translate <BaseX*5*.92+1, 0,-0.0> }

	} // end union

#declare BareTree1 = // no leaves
	union {
		object { BranchStem1 scale <8,7.6,5> rotate <0,0,0> } // main trunk, along z-axis
		object { BranchStem1 scale <4,4,3> rotate <0,8,90> translate <12,-5,4*Feet> } // limb1
		object { BranchStem1 scale <3.5,3.8,1.5> rotate <0,46,180> translate <13,-11,6*Feet> } // limb2
		object { BranchStem1 scale 1.7 rotate <0,52,250> translate <12,-10,8*Feet> } // limb3
	}

#declare SimpleTree1 = // windswept, spheroid leaf sets
	union {
		object { BareTree1 scale <8,7.6,5> rotate <0,0,0> } // main trunk, along z-axis
		sphere {
			<0,0,0>,15*Feet
			scale <1,1.1,1.6>
			rotate <33,4,6>
			texture { DistantTreeTex scale 88 }
			translate <0,-10*Feet,48*Feet> // set on top of trunk
		}
		sphere {
			<0,0,0>,7*Feet
			scale <1,1.1,1.6>
			rotate <-16,-8,41>
			texture { DistantTreeTex scale 125 }
			translate <-5*Feet,8*Feet,33*Feet> // set on top of trunk
		}
	}
#declare SimpleCanopyTree1 = // tall, spheroid leaf sets
	union {
		object { BranchStem1 scale <25,27,25> rotate <0,0,0> } // main trunk, along z-axis
		object { BranchStem1 scale <5,7,5> rotate <0,34,8> translate <44,-48,46*Feet>} // upper branch
		object { BranchStem1 scale <5,7,5> rotate <2,40,100> translate <44,-48,45*Feet>} // upper branch
		object { BranchStem1 scale <5,7,5> rotate <5,40,220> translate <44,-48,44*Feet>} // upper branch
		sphere {
			<0,0,0>,15*Feet
			scale <1,1.1,1>
			rotate <3,4,6>
			texture { DistantTreeTex scale 148 }
			clipped_by{box{<-22*Feet,-22*Feet,20>,<22*Feet,22*Feet,22*Feet>}} // keep top half
			translate <0,-1*Feet,48*Feet> // set on top of trunk
		}
//		box { <0,0,0>,<22,22,40*Feet> texture { BrightWhite} translate <0,20*Feet,0>} // size reference test
	}



//===============================================
//             Object Placement
//===============================================

//object { TestSphere scale 4 translate <0,-6,3> }
object { StraightBranch2 translate <-8,-1,0> }
//object { BareTree1 }
//object { SimpleCanopyTree1 rotate <0,0,90> }
