// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

plane{
  <0, 1, 0>, 0
  texture{
    pigment{ color rgb<0.0, 0.2, 0.4>}
    finish{ phong 1.0 ambient 0 reflection 0.3}
  }
}

// "Teeth" used for biting the apple
#declare Teeth =
height_field{
  tga "bite2.tga"
  smooth

  texture {
    pigment{ color rgb<1, 1, 0.8>}
    finish{ specular 0.3 roughness 0.001 ambient 0.3}
    normal{ bumps bump_size 0.3 scale 0.01}
  }

  scale <1, 0.25, 1>
  rotate <90, 0, 0>
  translate <-0.5, 0.5, 0>
  scale 2
  scale <0.7, 1, 0.7>
}

// Apple guts
#declare AppleGuts =
torus {
  0.6, 1
  texture {
    pigment{ color rgb<1, 1, 0.8>}
    finish{ specular 0.1 roughness 0.001 ambient 0.3}
    normal{ bumps bump_size 0.3 scale 0.01}
  }
  scale <0.65, 1, 0.65>
  scale 0.95
  rotate <0, 0, -10>
  translate <0, 1, 0>
}



// Apple exterior
#declare AppleExterior =
difference {
  torus {
    0.6, 1
    texture {
      pigment{
        image_map{
          tga "apple2.tga"
          map_type 1
        }
      }
      finish{ specular 0.1 roughness 0.1}
    }
    texture {
      pigment{
        image_map{
          tga "apple2.tga"
          map_type 1
          filter all 0.5
        }
      }
      finish{ phong 0.5 reflection 0.05}
      normal{ bumps bump_size 0.1 scale 0.1 scale <1, 2.5, 1>}
    }
    texture {
      pigment{
        image_map{
          tga "apple2.tga"
          map_type 1
          filter all 0.5
        }
      }
      finish{ phong 0.5 reflection 0.1}
      normal{ bumps bump_size 0.5 scale 0.005}
    }
  }
  torus {
    0.6, 1
    scale 0.95
  }
  scale <0.65, 1, 0.65>
  rotate <0, 0, -10>
  translate <0, 1, 0>
}



#declare WaterTexture =
texture{
  pigment{ color White*0.7 transmit 0.9}
  finish{ ambient 0 specular 1 reflection 0.3 refraction on ior 1.333 roughness 0.0005}
}
#declare AppleDroplets =
union{
  #include "Drops.pov"
  scale <0.65, 1, 0.65>
  rotate <0, 0, -10>
  translate <0, 1, 0>
}

#declare Apple =
union {
  difference{ AppleExterior}
  torus{ AppleGuts}
  union{ AppleDroplets}
}

// Apple
difference{
  union{ Apple}
  height_field{
    Teeth
    translate <0, 0, -1.1>
    rotate <20, 61, -10>
    translate <0, 1, 0>
  }
}


#declare CameraLocation = <2, 5, -5>

light_source
{
  <0, 0, 0>
  color White
  area_light <2, 0, 0>, <0, 0, 2>, 5, 5 rotate <0, 0, 45>
  adaptive 2
  jitter

  translate <-8, 10, -1>

  spotlight               // this kind of light source
  point_at <0, 0, 0>      // direction of spotlight
  radius 8                // hotspot (inner, in degrees)
  tightness 20            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 12               // intensity falloff radius (outer, in degrees)

  looks_like {
    sphere{ <0, 0, 0>, 3.5 texture{ pigment{ color White} finish{ ambient 1}}}
  }
}

light_source
{
  CameraLocation
  color White*0.4
}


camera
{
  location  CameraLocation
  up        <0, 1, 0>
  right     <1, 0, 0>
  direction <0, 0, 1.5>
  look_at   <0, 1, 0.0>
  aperture  0.5
  focal_point <0, 1, -1.6*0.63>
  blur_samples 40
}
