#ifndef ( __JGB_TREES__ )
#declare __JGB_TREES__ = true

  /* begin with defining a single tree */
  #declare triangles_per_tree = 6
  #declare tree_height        = MountainScale.y*0.025
  #declare tree_radius        = tree_height*0.3

  #declare tree = array[ triangles_per_tree ]

  /* build a standard tree */
  #declare i = 0
  #declare rotate_inc = 360/triangles_per_tree
  #while( i < triangles_per_tree )
    #declare tree[i] = array[3]
    #declare tree[i][0] = <0,tree_height,0>
    #declare tree[i][1] = vrotate(<tree_radius,0,0>,y*i*rotate_inc)
    #declare tree[i][2] = vrotate(<tree_radius,0,0>,y*(i+1)*rotate_inc)
    #declare i = i + 1
  #end

  /* build the mesh */
  #declare max_altitude = 0.4
  #declare min_altitude = 0.3
  #declare lower_jitter = 0.05
  #declare upper_jitter = 0.1
  #declare mesh_seed    = seed(2143)
  #declare granularity  = 0.003
  #declare tree_odds    = 1.0
  #declare max_slope    = 70 /* angle */

  #debug "Constructing a forest...\n"

  #declare Forests =
    mesh
    {
      #declare i = 0
      #while ( i < 1.0 )

        /* get the x parameters for the slope */
        #if( i > granularity ) #declare a = i - granularity
        #else #declare a = 0.0 #end
        #if( i < 1 - granularity ) #declare b = i + granularity
        #else #declare b = 1.0 #end

        #declare j = 0
        #while ( j < 1.0 )
          #declare hi = hf_height_at( i, j, Mountains )
          /* make sure the height is in allowable bounds */
          #if ( ( hi < max_altitude + rand(mesh_seed)*upper_jitter ) &
                ( hi > min_altitude - rand(mesh_seed)*lower_jitter ) )

            /* make sure the slope is not too steep */

            #declare lft = hf_height_at( a, j, Mountains )*MountainScale.y
            #declare rt  = hf_height_at( b, j, Mountains )*MountainScale.y

            /* get the z parameters for the slope */
            #if( j > granularity ) #declare c = j - granularity
            #else #declare c = 0.0 #end
            #if( j < 1 - granularity ) #declare d = j + granularity
            #else #declare d = 1.0 #end

            #declare fore = hf_height_at( i, c, Mountains )*MountainScale.y
            #declare aft  = hf_height_at( i, d, Mountains )*MountainScale.y

            #declare hi_tilt_z = rt - lft
            #declare hi_tilt_x = aft - fore

            #declare zrot = abs(degrees(atan2( hi_tilt_z, (rt-lft)*MountainScale.x )))
            #declare xrot = abs(degrees(atan2( hi_tilt_x, (aft-fore)*MountainScale.z )))

            #if ( ( xrot < max_slope ) & ( zrot < max_slope ) )

              /* if everything else says "a tree may be here", we just need
                 to ask our trusty random number generator next. */

              #declare tree_here = ( rand(mesh_seed) < tree_odds )
              #if ( tree_here )

                #declare _x = i * MountainScale.x
                #declare _y = hi * MountainScale.y
                #declare _z = j * MountainScale.z

                #declare _x = _x + ( rand(mesh_seed)*(granularity*MountainScale.x*2) - granularity*MountainScale.x ) * 0.5
                #declare _z = _z + ( rand(mesh_seed)*(granularity*MountainScale.z*2) - granularity*MountainScale.z ) * 0.5

                /* mutate the tree a bit */
                #declare _yvar = 1 + rand(mesh_seed)*0.6-0.3
                #declare _wvar = 1 + rand(mesh_seed)*0.5-0.25

                #declare tri = 0
                #while ( tri < triangles_per_tree )
                  triangle { tree[tri][0]*_yvar + <_x,_y,_z>,
                             tree[tri][1]*_wvar + <_x,_y,_z>,
                             tree[tri][2]*_wvar + <_x,_y,_z>  }
                  #declare tri = tri + 1
                #end
              #end

            #end

          #end
          #declare j = j + granularity
        #end
        #declare i = i + granularity
      #end
    }

#end
