// Les rayons exterieurs
#ifndef (flotchRay) #declare flotchRay=1 #end
#ifndef (flotchRBase) #declare flotchRBase=flotchRay #end
#ifndef (flotchRMid) #declare flotchRMid=flotchRay/2 #end
#ifndef (flotchRHt) #declare flotchRHt=flotchRay #end

// Les Hauteurs
#ifndef (flotchHt) #declare flotchHt=1 #end
#ifndef (flotchMid) #declare flotchMid=0.25 #end

// Les Variations
#ifndef (flotchVar) #declare flotchVar=flotchHt/20 #end
#ifndef (flotchRayVar) #declare flotchRayVar=flotchVar #end
#ifndef (flotchHtVar) #declare flotchHtVar=flotchVar #end
#ifndef (flotchAngVar) #declare flotchAngVar=20 #end

// Les epaisseurs
#ifndef (flotchBaseEp) #declare flotchBaseEp=flotchRBase/3 #end
#ifndef (flotchMidEp) #declare flotchMidEp=flotchBaseEp/2 #end
#ifndef (flotchHtEp) #declare flotchHtEp=0 #end

// Les variations possibles d'epaisseurs
#ifndef (flotchBsVEp) #declare flotchBsVEp=flotchBaseEp*0.75 #end
#ifndef (flotchMidVEp) #declare flotchMidVEp=flotchMidEp*0.75 #end
#ifndef (flotchHVEp) #declare flotchHtVEp=flotchMidEp*0.5 #end

// Divers
#ifndef (flotchSeed) #declare flotchSeed=seed(0) #end
#ifndef (flotchBlob) #declare flotchBlob=true #end

#ifndef (flotchTex)
#declare flotchTex=texture {
   pigment { rgb <0.8, 0.9, 1> }
   finish {
      reflection 0.8
      refraction 0.6
      ior 1.33
      diffuse 0.5
      ambient 0.2
      phong 0.2
      specular 0.8
      metallic 0.4
   }
}
#end

#declare flotch=
  #if (flotchBlob=true) 
	blob
  #else
	union
  #end
{
   #declare a=0
   #while ( a < 360 )
	#declare aRad=a*pi/180
	
	// Partie du dessous...
	#declare beta=0
	#while (beta < 90)
		#declare betaR=beta*pi/180

		// Centre du floch...
		#declare Cent=<flotchRBase, flotchMid, 0>
   
		// Epaisseur du Blob
		#declare rayB=(beta/90)*(flotchMidEp-flotchBaseEp)+flotchBaseEp
		#declare rayVarB=(beta/90)*(flotchMidVEp-flotchBsVEp)+flotchBsVEp
		// #declare rayVarB=0
		#declare rayB=rayB+rayVarB*(rand(flotchSeed)*2-1)
		#if (rayB < 0) #declare rayB=0 #end
   
		// Rayon du flotch...
		#declare Ray=<flotchRBase-flotchRMid, flotchMid, 0>
   			+<flotchRayVar*(rand(flotchSeed)*2-1),flotchHtVar*(rand(flotchSeed)*2-1),0>

		// Position du blob
		#declare blobPos=Cent-<(Ray.x+rayB/2)*sin(betaR), (Ray.y+rayB/2)*cos(betaR), 0>
		#declare blobPos=vrotate(blobPos, a*y)

		sphere { blobPos, rayB
		   #if (flotchBlob=true)
		   , 1 
		   #end
		}
		#declare beta=beta+5
	#end
   
// 	#render "--------------------------------\n"
   
	// dessus
	#declare beta=0
	#while (beta < 135)
   		#declare betaR=beta*pi/180
	
		// Centre...
		#declare Cent=<flotchRBase, flotchMid, 0>
   
		// Rayon du blob
		#declare rayB=(beta/135)*(flotchHtEp-flotchMidEp)+flotchMidEp
		#declare rayVarB=(beta/135)*(flotchHtVEp-flotchMidVEp)+flotchMidVEp
		// #declare rayVarB=0
		#declare rayB=rayB+rayVarB*(rand(flotchSeed)*2-1)
   		#if (rayB < 0) #declare rayB=0 #end

		// #render concat("Beta = ", str(beta,3,0), " - rayB = ", str(rayB, 3,3), "\n")
   
		// Rayon
		#declare Ray=<flotchRMid-flotchRHt, flotchHt-flotchMid, 0>
		#declare blobPos=Cent+<(Ray.x-rayB/2)*cos(betaR), (Ray.y-rayB/2)*sin(betaR), 0>
			+<flotchRayVar*(rand(flotchSeed)*2-1),flotchHtVar*(rand(flotchSeed)*2-1),0>

		#declare blobPos=vrotate(blobPos, (a+(rand(flotchSeed)-0.5)*2*flotchAngVar)*y)
   
		#if (rayB>0)
		   sphere { blobPos, rayB
		      #if (flotchBlob=true)
		      , 1 
		      #end
		   }
		#end
		#declare beta=beta+5
	#end
   
	#declare a=a+flotchAngVar
   #end
   
   
   texture { flotchTex }
}