global_settings {
  adc_bailout 0.003922
  ambient_light <1,1,1>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 128//64
  max_trace_level 40
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            200
    distance_maximum 0.0
    error_bound      0.2
    gray_threshold   0.2
    low_error_factor 0.8
    minimum_reuse    0.007
    nearest_count    8
    recursion_limit  1
  }
}

//background { color <0.5,0.5,1> }

/*camera {  //  Camera StdCam
  location  <-6.078, -5.958, 3.323>
//  aperture 0.025
//  blur_samples 40
  direction <0.0,     0.0,  0.7843>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
//  look_at   <0.284, 0.504, 4.443>
look_at <0,0,4.443>
} */

camera {  //  Camera StdCam
  location  <-5.939, -6.091, 1.437>
  direction <0.0,     0.0,  0.7237>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.021, 0.198, 3.955>
}

fog {
  fog_type 2    // Ground Fog
  distance     200.0
  color <0.4,0.4,0.4,0.0,0.498039>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      4.0
}

fog {
  fog_type 2    // Ground Fog
  distance     960.0
  color <0.34902,0.34902,0.74902,0.0,0.498039>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      75.0
}


//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.000, -2000.000, 1100.000>
  color rgb <1.000, 1.000, 1.000>
}




//
// ********  TEXTURES  *******
//

#declare Texture1 =
   texture  // Texture1
   {
      pigment
      {
         color rgb <0.25, 1.0, 0.25>
      }
      finish
      {
         ambient 0.0
         diffuse 1.0
      }
   }


//  $MRY$: 'Wood'


#declare Wood =
   texture  // Wood
   {
    pigment
      {
         crackle
         color_map
         {
             [ 0.0 rgbft <0.4, 0.35, 0.22, 0.0, 0.0> ]
             [ 0.103203  rgbft <0.475, 0.275, 0.2, 0.0, 0.0> ]
            [ 1.0     rgbft <0.475, 0.275, 0.2, 0.0, 0.0> ]
         }
         turbulence 0.3
      }
      normal
      {
         crackle , 0.5
         turbulence 0.3
      }
      finish
      {
         ambient 0.1
         diffuse 1.0
      }
      scale  <0.125, 0.125, 0.025>
   }


//  $MRY$: 'Branch'


#declare Branch =
   texture  // Branch
   {
      pigment
      {
         color rgb <0.135278, 0.527045, 0.306388>
      }
    finish
    {
    ambient 0
    diffuse 1.0
    specular 0.4
   }

#declare Bark =
   texture  // Trunk
   {
      pigment
      {
         crackle
         color_map
         {
            [ 0.0     rgbft <0.475, 0.275, 0.2, 0.0, 0.0> ]
            [ 0.103203  rgbft <0.4, 0.35, 0.22, 0.0, 0.0> ]
            [ 1.0     rgbft <0.4, 0.35, 0.22, 0.0, 0.0> ]
         }
         turbulence 0.3
      }
      normal
      {
         crackle , 0.5
         turbulence 0.3
      }
      finish
      {
         ambient 0.1
         diffuse 1.0
      }
      scale  <0.125, 0.125, 0.025>
   }



//  $MRY$: 'Needle'


#declare Needle =
   texture  // Needle
   {
      pigment
      {
         color rgb <0.1, 0.4, 0.20>
      }
      finish
      {
         ambient 0
         diffuse 1.0
         specular 0.4
      }
   }

#declare Ground =
   texture  // Ground
   {
      pigment
      {
         onion
         color_map
         {
            [ 0.0     rgbft <0.51, 0.323, 0.15, 0.0, 0.0> ]
            [ 0.199288  rgbft <0.115, 0.5, 0.208, 0.0, 0.0> ]
            [ 0.498221  rgbft <0.115, 0.5, 0.208, 0.0, 0.0> ]
            [ 0.797153  rgbft <0.115, 0.5, 0.208, 0.0, 0.0> ]
            [ 1.0     rgbft <0.51, 0.323, 0.15, 0.0, 0.0> ]
         }
         scale  150.0
      }
      normal
      {
         granite , 0.5

      }
      finish
      {
         ambient 0.1
         diffuse 1.0
      }
   }

   #declare Mountain =
   texture  // Mountain
   {
      pigment
      {
         gradient z
         color_map
         {
            [ 0.0     rgbft <0.114567, 0.5, 0.208333, 0.0, 0.0> ]
            [ 0.263345  rgbft <0.51, 0.323, 0.15, 0.0, 0.0> ]
            [ 0.348754  rgbft <0.51, 0.323, 0.15, 0.0, 0.0> ]
            [ 0.637011  rgbft <0.5, 0.5, 0.5, 0.0, 0.0> ]
            [ 0.88879  rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
         }
         scale  <1.0, 1.0, 1.85>
         translate -1.0 * z
      }
      normal
      {
         granite , 0.5
         scale  <0.0033, 0.0033, 0.011>
      }
   }


//  $MRY$: 'Sky'


#declare Sky =
   texture  // Sky
   {
      pigment
      {
         gradient z
         color_map
         {
            [ 0.0     rgbft <0.8, 0.9, 1, 0.0, 0.0> ]
            [ 1.0     rgbft <0.2, 0.2, 1.5, 0.0, 0.0> ]
         }
      }
      finish
      {
         ambient 1.0
         diffuse 0.0
      }
   scale 40000
   }


//  $MRY$: 'Cloud'


#declare Cloud =
   texture  // Cloud
   {
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <1.0, 1.0, 1.0, 0.0, 1.0> ]
            [ 0.565836  rgbft <1.1, 1.1, 1.1, 0.0, 1.0> ]
            [ 1.0     rgbft <1, 1, 1, 0.0, 0.0> ]
         }
         scale  200.0
         translate <100,0,0>
      }
      finish
      {
         ambient 1.0
         diffuse 0.0
      }
   }


//  $MRY$: 'TreeTrunk'


#declare TreeTrunk =
   texture  // TreeTrunk
   {
      pigment
      {
         color rgb <0.614567, 0.531233, 0.4479>
      }
      normal
      {
         wood , 0.5
         turbulence 0.05
         scale  0.1
      }
   }

#declare KiteCyl =
   texture  // KiteCyl
   {
      pigment
      {
         color rgb <0.25, 0.25, 0.25>
      }
      finish
      {
         ambient 0.1
         diffuse 1.0
         specular 0.4
      }
   }

   //  $MRY$: 'Kite2'


#declare Kite2 =
   texture  // Kite2
   {
      pigment
      {
         color rgb <1.0, 1.0, 1.0>
      }
      finish
      {
         ambient 0.5
         diffuse 1.0
         phong 1.0
         phong_size 100.0
         specular 0.007167
      }
   }


//  $MRY$: 'Kite2_1'


#declare Kite2_1 =
   texture  // Kite2_1
   {
      pigment
      {
         color rgb <1.0, 0.15, 0.15>
      }
      finish
      {
         ambient 0.5
         diffuse 1.0
         phong 1.0
         phong_size 100.0
         specular 0.007167
      }
   }


//  $MRY$: 'String'


#declare String =
   texture  // String
   {
      pigment
      {
         color rgb <1.0, 1.0, 1.0>
      }
      finish
      {
         ambient 0.1
         diffuse 1.0
      }
   }


//  $MRY$: 'Cardboard'


#declare Cardboard =
   texture  // Cardboard
   {
      pigment
      {
         color rgb <0.595682, 0.468724, 0.341785>
      }
      finish
      {
         ambient 0.1
         diffuse 1.0
         specular 0.3
      }
   }


//  $MRY$: 'PineTree'


#declare PineTree =
   texture  // PineTree
   {
      pigment
      {
         spiral1 5
         color_map
         {
            [ 0.0     rgbft <0.0, 0.7708, 0.256933, 0.0, 1.0> ]
            [ 0.615658  rgbft <0.0, 0.7708, 0.256933, 0.0, 0.5> ]
            [ 1.0     rgbft <0.0, 0.7708, 0.256933, 0.0, 0.8> ]
         }
         turbulence 0.3
         scale  0.1
      }
      normal
      {
         granite , 0.5
      }
      finish
      {
         ambient 0.1
         diffuse 1.0
      }
   }
   }

//  $MRY$: 'Hair'


#declare Hair =
   texture  // Hair
   {
      pigment
      {
         spiral1 50
         color_map
         {
            [ 0.0     rgbft <0.502, 0.0, 0.0, 0.0, 0.0> ]
            [ 0.5     rgbft <0.864567, 0.354167, 0.2, 0.0, 0.791667> ]
            [ 0.75    rgbft <0.502, 0.0, 0.0, 0.0, 0.0> ]
            [ 1.0     rgbft <0.864567, 0.354167, 0.2, 0.0, 0.791667> ]
         }
         turbulence 0.2
         scale  <-0.05, 0.05, 0.05>
      }
      normal
      {
         spiral1 50 , 0.1
         turbulence 0.2
         scale  <-0.05, 0.05, 0.05>
      }
      finish
      {
         ambient 0.1
         diffuse 1.0
         phong 0.8
         phong_size 68.21
         specular 0.4
      }
   }


//  $MRY$: 'Flesh'


#declare Flesh =
   texture  // Flesh
   {
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <0.962, 0.75, 0.72, 0.0, 0.0> ]
            [ 1.0     rgbft <0.962237, 0.80521, 0.787763, 0.0, 0.0> ]
         }
         scale  0.5
      }
      normal
      {
         crackle , 0.05
         scale  0.05
      }
      finish
      {
         ambient rgb <0.25, 0.1, 0.1>
         diffuse 0.75
      }
   }


//  $MRY$: 'shirt'


#declare shirt =
   texture  // shirt
   {
      pigment
      {
         color rgb <0.292145, 0.292145, 0.728655>
      }
      normal
      {
         quilted , 0.5
         control0 0.0
         control1 1.0
         scale  0.03
      }
      finish
      {
         ambient 0.25
         diffuse 1.0
         brilliance 0.7
      }
   }


//  $MRY$: 'Skirt'


#declare Skirt =
   texture  // Skirt
   {
      pigment
      {
         color rgb <1.0, 0.502, 0.753>
      }
      normal
      {
         quilted , 0.5
         control0 0.0
         control1 1.0
         scale  0.03
      }
      finish
      {
         ambient 0.25
         diffuse 1.0
      }
   }


//  $MRY$: 'socks'


#declare socks =
   texture  // socks
   {
      pigment
      {
         color rgb <1.0, 1.0, 1.0>
      }
      normal
      {
         quilted , 0.5
         control0 0.0
         control1 1.0
         scale  0.05
         rotate    <-45.0, -45.0, -360.0>
      }
      finish
      {
         ambient 0.1
         diffuse 0.75
         brilliance 0.75
      }
   }

   //  $MRY$: 'soles'


#declare soles =
   texture  // soles
   {
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.697706, 0.385838, 0.09396, 0.0, 0.0> ]
            [ 1.0     rgbft <0.928289, 0.690271, 0.467511, 0.0, 0.0> ]
         }
         scale  0.1
      }
   }



//  $MRY$: 'Shoes'


#declare Shoes =
   texture  // Shoes
   {
      pigment
      {
         color rgb <0.25, 0.25, 0.25>
      }
      finish
      {
         ambient 0.1
         diffuse 1.0
         phong 1.0
         phong_size 100.0
         specular 0.4
      }
   }


// Kite String

sphere_sweep
{
    b_spline_sphere_sweep, 16,
    <-2.522459,10.471535, 12.895696>, 0.01
    <-2.198926, 9.908809, 12.19185>, 0.01
    <-1.724224, 8.825441, 11.321334>, 0.01
    <-0.674832, 6.93162, 10.14233>, 0.01
    <0.292288, 4.81124, 9.09471>,0.01
    <1.849818,2.873502,8.240502>,0.01
    <3.748017, 1.285661, 7.607372>,0.01
    <6.265195,-0.001692, 7.35356>,0.01
    <6.211176, -1 /*-0.26545*/, 7.282199>,0.01
    <6.023287, -0.62929, 12 /*7.134056*/>,0.01

    <-0.29787, -0.77397, 7.16712>, 0.01
    <-3.752843, -1.021797, 7.084675>,0.01
    <-2.765626, -1.485174, 7.305809>, 0.01
    <-3.068628, -1.049871, 8.305809>, 0.01
    <-3.32753, -0.376726, 8.305809>,0.01
    <-3.8, -1.0485174, 7.305809>,0.01
    sphere_sweep_depth_tolerance 1.0e-3
    texture {String}
}

// Kite

#declare sPatchObj = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.011364, -0.090909>, <0.000000, -0.614773, -0.094318>, <0.000000, -1.419318, -0.098864>, <0.000000, -2.022727, -0.102273>,
      <0.000000, -0.011364, -0.090909>, <0.000000, -0.757626, -0.155024>, <0.000000, -0.958762, -0.156161>, <0.000000, -1.562171, -0.159570>,
      <0.000000, -0.011364, -0.090909>, <0.000000, -0.757626, -0.155024>, <0.000000, -0.803993, -0.178292>, <0.000000, -0.948097, -0.235966>,
      <0.000000, -0.011364, -0.090909>, <0.000000, -0.154217, -0.151615>, <0.000000, -0.343437, -0.235589>, <0.000000, -0.487541, -0.293263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.991785, -0.483297>, <0.000000, -0.840512, -0.426287>, <0.000000, -0.637626, -0.353331>, <0.000000, -0.487541, -0.293263>,
      <0.000000, -0.991785, -0.483297>, <0.000000, -1.149794, -0.311980>, <0.000000, -1.098182, -0.296034>, <0.000000, -0.948097, -0.235966>,
      <0.000000, -0.991785, -0.483297>, <0.000000, -1.149794, -0.311980>, <0.000000, -1.252889, -0.273877>, <0.000000, -1.562171, -0.159570>,
      <0.000000, -0.991785, -0.483297>, <0.000000, -1.301068, -0.368990>, <0.000000, -1.713444, -0.216580>, <0.000000, -2.022727, -0.102273>
    }
  }
  texture {
    Kite2_1
  }
}
#declare sPatchObj1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.659091, 0.000000, 0.420455>, <-0.915419, 0.000000, 0.426863>, <-1.144318, 0.000000, 0.070455>, <-1.352273, 0.000000, -0.079545>,
      <-0.659091, 0.000000, 0.420455>, <-0.717692, -0.613637, 0.270045>, <-0.738637, -0.613637, 0.063637>, <-0.946591, -0.613637, -0.086363>,
      <-0.659091, 0.000000, 0.420455>, <-0.717692, -0.613637, 0.270045>, <-0.603409, -0.818182, 0.061364>, <-0.405682, -1.431819, -0.095455>,
      <-0.659091, 0.000000, 0.420455>, <-0.461364, -0.613637, 0.263637>, <-0.197727, -1.431819, 0.054545>, <0.000000, -2.045455, -0.102273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.431818, 0.000000, -0.068182>, <1.213636, 0.000000, 0.075000>, <0.965380, 0.000000, 0.417438>, <0.704545, 0.000000, 0.409091>,
      <1.431818, 0.000000, -0.068182>, <0.784091, -0.613637, 0.064773>, <0.754016, -0.613637, 0.264028>, <0.493182, -0.613637, 0.255682>,
      <1.431818, 0.000000, -0.068182>, <0.784091, -0.613637, 0.064773>, <0.640909, -0.818182, 0.061364>, <0.211364, -1.431819, 0.051136>,
      <1.431818, 0.000000, -0.068182>, <1.002273, -0.613637, -0.078409>, <0.429546, -1.431819, -0.092046>, <0.000000, -2.045455, -0.102273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.011364, 0.000000, -0.113636>, <0.219318, 0.000000, 0.043182>, <0.444223, 0.000000, 0.400761>, <0.704545, 0.000000, 0.409091>,
      <0.011364, 0.000000, -0.113636>, <0.215909, -0.613637, 0.046591>, <0.232860, -0.613637, 0.247352>, <0.493182, -0.613637, 0.255682>,
      <0.011364, 0.000000, -0.113636>, <0.215909, -0.613637, 0.046591>, <0.214773, -0.818182, 0.047727>, <0.211364, -1.431819, 0.051136>,
      <0.011364, 0.000000, -0.113636>, <0.007955, -0.613637, -0.110227>, <0.003409, -1.431819, -0.105682>, <0.000000, -2.045455, -0.102273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.011364, 0.000000, -0.113636>, <0.007955, -0.613637, -0.110227>, <0.003409, -1.431819, -0.105682>, <0.000000, -2.045455, -0.102273>,
      <0.011364, 0.000000, -0.113636>, <-0.193182, -0.613637, 0.050000>, <-0.194318, -0.818182, 0.051137>, <-0.197727, -1.431819, 0.054545>,
      <0.011364, 0.000000, -0.113636>, <-0.193182, -0.613637, 0.050000>, <-0.204289, -0.613637, 0.257210>, <-0.461364, -0.613637, 0.263637>,
      <0.011364, 0.000000, -0.113636>, <-0.189773, 0.000000, 0.046591>, <-0.402016, 0.000000, 0.414028>, <-0.659091, 0.000000, 0.420455>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.011364, 0.000000, -0.113636>, <-0.189773, 0.000000, 0.046591>, <-0.402016, 0.000000, 0.414028>, <-0.659091, 0.000000, 0.420455>,
      <0.219318, 0.000000, 0.043182>, <0.018182, 0.000000, 0.203409>, <-0.204289, -0.613637, 0.257210>, <-0.461364, -0.613637, 0.263637>,
      <0.444223, 0.000000, 0.400761>, <0.232860, -0.613637, 0.247352>, <0.013636, -0.818182, 0.207955>, <-0.197727, -1.431819, 0.054545>,
      <0.704545, 0.000000, 0.409091>, <0.493182, -0.613637, 0.255682>, <0.211364, -1.431819, 0.051136>, <0.000000, -2.045455, -0.102273>
    }
  }
  texture {
    Kite2
  }
}
union { // sPatchGroup
  object { sPatchObj }
  object { sPatchObj1 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      KiteCyl
    }
    scale <0.02, 0.02, 2.45>
    rotate <90.0, 0.0, -35.0>
    translate  <1.4, 0.0, -0.1>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      KiteCyl
    }
    scale <0.02, 0.02, 2.45>
    rotate <90.0, -0.0, 35.0>
    translate  <-1.4, 0.0, -0.1>
  }
  rotate <-40.0, -16.499084, 29.911797>
  translate  <-2.673037, 10.911187, 11.912724>
}

/*// Mannequin

union { // Group001
  sphere { // Sphere003
    <0,0,0>,1
    texture {
      String
    }
    scale 0.33
    translate  <-4.436956, -1.077099, 3.513683>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    texture {
      String
    }
    scale <0.5, 0.3, 1.5>
    rotate -20.433134*z
    translate  <-4.412187, -1.095379, 1.5>
  }
  sphere { // Sphere10
    <0,0,0>,1
    texture {
      String
    }
    scale <0.1, 0.1, 0.2>
    rotate 5.430286*y
    translate  <-3.514156, -1.322286, 4.656198>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    texture {
      String
    }
    scale <0.15, 0.15, 1.5>
    rotate <170.780243, -10.803424, -161.603821>
    translate  <-4.971386, -0.877434, 2.944389>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    texture {
      String
    }
    scale <0.15, 0.15, 1.5>
    rotate <-3.41807, 9.092133, -20.704987>
    translate  <-3.828781, -1.258837, 2.944389>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    texture {
      String
    }
    scale <0.2, 0.2, 1.5>
    rotate -20.433134*z
    translate  <-4.679382, -0.986406, 0.0>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    texture {
      String
    }
    scale <0.2, 0.2, 1.5>
    rotate -20.433134*z
    translate  <-4.172234, -1.258837, 0.032715>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 0.15
    texture {
      String
    }
    scale <1.0, 1.0, 0.8>
    rotate <16.76013, 18.035601, -70.138519>
    translate  <-3.978347, -0.974844, -0.703385>
  }
  cone { // Cone3
    <0,0,0>, 0.0, <0,0,1>, 0.15
    texture {
      String
    }
    scale <1.0, 1.0, 0.8>
    rotate <16.76013, 18.035601, -70.138519>
    translate  <-4.523209, -0.647927, -0.703385>
  }
  sphere { // Sphere12
    <0,0,0>,1
    texture {
      String
    }
    scale <0.1, 0.1, 0.2>
    rotate 5.430286*y
    translate  <-5.282606, -0.722939, 1.393059>
  }
  translate  <0.903875, -0.179274, 0.581107>
}
*/

#declare Tree_Height = 14
#declare Tree_Wiggle = 20
#declare Trunk_Thickness = 0.5
#declare Branch_Thickness = 0.1
#declare Mid_Branch_Thickness = 0.05
#declare Branch_Length = 3.5
#declare Branch_Bend = 10
#declare Branch_Spacing =   0.5 //0.6
#declare Number_Branches = 9
#declare Branch_Rotate_X = 60 // 60
#declare Bottom_Branch = 4
#declare Number_Needles_Rot = 5 // 5
#declare Needle_Wiggle = seed(3)
#declare Branch_Wiggle = seed(4)
#declare Branch_Bend_Wiggle = seed(0)
#declare Branch_Rot_Wiggle = seed(4)
#declare Number_Needles_Translate = 8
#declare Needle_Spacing = 0.15
#declare Spiral_Rotation = 0.30

// DON'T CHANGE THE FOLLOWING THREE VALUES!!!

#declare Spacing = 0
#declare Shrink = 1
#declare Spir_Rot = Spiral_Rotation


#declare Pine_Tree =
union{
cone { // Cone001
  <0,0,0>, Trunk_Thickness, <0,0,1>, 0.0
texture
{
Bark
}
  scale <0.5, 0.5, Tree_Height>
}
#declare D = 0 #while (D < Tree_Height-Bottom_Branch)
#declare A = 1 #while (A < Number_Branches+1)
cone {
<0,0,0>,Branch_Thickness,<0,0,Branch_Length/2>,Mid_Branch_Thickness
texture {
Wood
}
#declare Random=rand(Branch_Wiggle)
#declare RandomTwo=rand(Branch_Bend_Wiggle)
#declare RandomThree=rand(Branch_Bend_Wiggle)
#declare RandomFour=rand(Branch_Bend_Wiggle)
#declare RandomFive=rand(Branch_Rot_Wiggle)
scale <Shrink,Shrink,Shrink>
rotate <Branch_Rotate_X+(Random*Tree_Wiggle),0,0>
translate <0,0,Bottom_Branch+D>
rotate <0,0, ((360/Number_Branches)*A)+(RandomFive*Tree_Wiggle)>
}
sphere {
<0,0,0>,Mid_Branch_Thickness
texture {
Wood
}
translate <0,0,Branch_Length/2>
scale <Shrink,Shrink,Shrink>
rotate <Branch_Rotate_X+(Random*Tree_Wiggle),0,0>
translate <0,0,Bottom_Branch+D>
rotate <0,0,((360/Number_Branches)*A)+(RandomFive*Tree_Wiggle)>
}
cone
{
<0,0,0>,Mid_Branch_Thickness,<0,0,Branch_Length/2>,0.0
texture {
Wood
}
rotate <Branch_Bend+(RandomTwo*Tree_Wiggle),0,0>
translate <0,0,Branch_Length/2>
scale <Shrink,Shrink,Shrink>
rotate <Branch_Rotate_X+(Random*Tree_Wiggle),0,0>
translate <0,0,Bottom_Branch+D>
rotate <0,0,((360/Number_Branches))*A+(RandomFive*Tree_Wiggle)>
}
#declare C = 0 #while (C < Number_Needles_Translate)
#declare B = 1 #while (B < Number_Needles_Rot+1)
sphere {
<0,0,0>,1
    texture {
      Needle
    }
    scale <0.02, 0.02, 0.08>
    rotate <0.0, 45.0+(rand(Needle_Wiggle)*Tree_Wiggle), 0>
    translate <0.1,0,0>
    rotate <0,0,((360/Number_Needles_Rot)*B)+(rand(Needle_Wiggle)*Tree_Wiggle)>
    translate  <0, 0, Branch_Length/2>
    translate <0,0,-Spacing>
    rotate <Branch_Bend+(RandomTwo*Tree_Wiggle),0,0>
    translate <0, 0, Branch_Length/2>
    rotate <Branch_Rotate_X+(Random*Tree_Wiggle),0,0>
    scale <Shrink,Shrink,Shrink>
    translate <0,0,Bottom_Branch+D>
    rotate <0,0,((360/Number_Branches)*A)+(RandomFive*Tree_Wiggle)>
  }
#declare B = B + 1 #end
#declare Spacing = Spacing + Needle_Spacing
#declare C = C + 1 #end
#declare Spacing = 0
cone
{
<0,0,0>,Mid_Branch_Thickness,<0,0,Branch_Length/2>,0.0
texture {
Wood
}
rotate <Branch_Bend+(RandomThree*Tree_Wiggle),30,0>
translate <0,0,Branch_Length/2>
scale <Shrink,Shrink,Shrink>
rotate <Branch_Rotate_X+(Random*Tree_Wiggle),0,0>
translate <0,0,Bottom_Branch+D>
rotate <0,0,((360/Number_Branches)*A)+(RandomFive*Tree_Wiggle)>
}
#declare F = 0 #while (F < Number_Needles_Translate)
#declare G = 1 #while (G < Number_Needles_Rot+1)
sphere {
<0,0,0>,1
    texture {
      Needle
    }
    scale <0.02, 0.02, 0.08>
    rotate <0.0, 45.0+(rand(Needle_Wiggle)*Tree_Wiggle), 0>
    translate <0.1,0,0>
    rotate <0,0,((360/Number_Needles_Rot)*G)+(rand(Needle_Wiggle)*Tree_Wiggle)>
    translate  <0, 0, Branch_Length/2>
    translate <0,0,-Spacing>
    rotate <Branch_Bend+(RandomThree*Tree_Wiggle),30,0>
    translate <0, 0, Branch_Length/2>
    rotate <Branch_Rotate_X+(Random*Tree_Wiggle),0,0>
    scale <Shrink,Shrink,Shrink>
    translate <0,0,Bottom_Branch+D>
    rotate <0,0,((360/Number_Branches)*A)+(RandomFive*Tree_Wiggle)>
  }
#declare G = G + 1 #end
#declare Spacing = Spacing + Needle_Spacing
#declare F = F + 1 #end
#declare Spacing = 0
cone
{
<0,0,0>,Mid_Branch_Thickness,<0,0,Branch_Length/2>,0.0
texture {
Wood
}
rotate <Branch_Bend+(RandomFour*Tree_Wiggle),-30,0>
translate <0,0,Branch_Length/2>
scale <Shrink,Shrink,Shrink>
rotate <Branch_Rotate_X+(Random*Tree_Wiggle),0,0>
translate <0,0,Bottom_Branch+D>
rotate <0,0,((360/Number_Branches)*A)+(RandomFive*Tree_Wiggle)>
}
#declare H = 0 #while (H < Number_Needles_Translate)
#declare I = 1 #while (I < Number_Needles_Rot+1)
sphere {
<0,0,0>,1
    texture {
      Needle
    }
    scale <0.02, 0.02, 0.08>
    rotate <0.0, 45.0+(rand(Needle_Wiggle)*Tree_Wiggle), 0>
    translate <0.1,0,0>
    rotate <0,0,((360/Number_Needles_Rot)*I)+(rand(Needle_Wiggle)*Tree_Wiggle)>
    translate  <0, 0, Branch_Length/2>
    translate <0,0,-Spacing>
    rotate <Branch_Bend+(RandomFour*Tree_Wiggle),-30,0>
    translate <0, 0, Branch_Length/2>
    rotate <Branch_Rotate_X+(Random*Tree_Wiggle),0,0>
    scale <Shrink,Shrink,Shrink>
    translate <0,0,Bottom_Branch+D>
    rotate <0,0,((360/Number_Branches)*A)+(RandomFive*Tree_Wiggle)>
  }
#declare I = I + 1 #end
#declare Spacing = Spacing + Needle_Spacing
#declare H = H + 1 #end
#declare Spacing = 0
#declare A=A + 1 #end
#declare Shrink = Shrink-(Branch_Spacing/(Tree_Height-Bottom_Branch))
#declare D = D + Branch_Spacing #end
}
//}


#declare Grass_Rand_X = seed(7362)
#declare Grass_Rand_Y = seed(2637)
#declare Grass_Rand_Rot = seed(1998)
#declare Grass_Rand_Green = seed(2001)
#declare Grass_Rand_Red = seed(2010)

#declare Grass_Blade =
sphere {
<0,0,0>,0.5
scale <1,1,0.5>
}


/*#declare Grass_Blade =
sphere_sweep
{
    b_spline_sphere_sweep, 5,
    <0.5,0, -1>, 0.02
    <0.5,0,0>,0.017
    <0.25,0,0.125>,0.014
    <0,0,0.25>,0.0011
    <-0.5,0,0.25>,0.0008
    sphere_sweep_depth_tolerance 1.0e-3
}*/


sphere {
<0,0,0>,40000
   texture
   {
   Sky
   }
hollow
}


object
{
Pine_Tree
translate <5.96605,-0.26516,0>
}


// Original grass texture
    /*  pigment
      {
         radial
         color_map
         {
            [ 0.0   rgbft <0.1+(Grass_Red/10), 0.5+(Grass_Green/5), 0.20, 0.0, 1.0> ]
            [ 0.49  rgbft <0.1+(Grass_Red/10), 0.5+(Grass_Green/5), 0.20, 0.0, 1.0> ]
            [ 0.5   rgbft <0.1+(Grass_Red/10), 0.5+(Grass_Green/5), 0.20, 0.0, 0.0> ]
            [ 0.51  rgbft <0.1+(Grass_Red/10), 0.5+(Grass_Green/5), 0.20, 0.0, 1.0> ]
            [ 1.0   rgbft <0.1+(Grass_Red/10), 0.5+(Grass_Green/5), 0.20, 0.0, 1.0> ]
         }
         rotate -90*x
*/


#declare Grass_X = -6 #while (Grass_X < 20)
#declare Grass_Y = -5 #while (Grass_Y < 20)
#declare Grass_Green = rand(Grass_Rand_Green)
#declare Grass_Red = rand(Grass_Rand_Red)
object
{
Grass_Blade
   texture  // Texture1
   {
pigment
{
   radial
         color_map
         {
            [ 0.0   rgbft <0.115+(Grass_Red/10), 0.5+(Grass_Green/10), 0.208, 0.0, 1.0> ]
            [ 0.49  rgbft <0.115+(Grass_Red/10), 0.5+(Grass_Green/10), 0.208, 0.0, 1.0> ]
            [ 0.5   rgbft <0.115+(Grass_Red/10), 0.5+(Grass_Green/10), 0.208, 0.0, 0.0> ]
            [ 0.51  rgbft <0.115+(Grass_Red/10), 0.5+(Grass_Green/10), 0.208, 0.0, 1.0> ]
            [ 1.0   rgbft <0.115+(Grass_Red/10), 0.5+(Grass_Green/10), 0.208, 0.0, 1.0> ]
         }
         rotate -90*x
/*color rgb <0.1+(Grass_Red/10),0.5+(Grass_Green/5),0.20>*/
      }
      finish
      {
         ambient 0.1
         diffuse 1.0
         /*specular 0.4*/
      }
   rotate <0,0,75>
   }
rotate <0,0,rand(Grass_Rand_Rot)*30>
translate <Grass_X+((rand(Grass_Rand_X))/2), Grass_Y+((rand(Grass_Rand_Y))/2), 0>
}
#declare Grass_Y = Grass_Y + 0.5 #end
#declare Grass_X = Grass_X + 0.5 #end


plane { // Plane002
  z,0
  texture {
    Cloud
  }
  hollow
  rotate -180.0*x
  translate  <0,0,150>
}



plane { // Plane001
  z,0
  texture {
    Ground
  }
  hollow
}


object {   // HgtFld001
  height_field {
    tga "c:\povray3\mt.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Mountain
  }
  scale <299.999969, 299.999969, 110.0>
  rotate -10.0*z
  translate  <558.166572, 307.142176, 110.0>
}

object {   // HgtFld2
  height_field {
    tga "c:\povray3\mt.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Mountain
  }
  scale <299.999969, 299.999969, 110.0>
  rotate -3.508924*z
  translate  <-30.287567, 757.466891, 110.0>
}


object {   // HgtFld3
  height_field {
    tga "c:\povray3\mt.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Mountain
  }
  scale <299.999969, 299.999969, 110.0>
  rotate 116.410027*z
  translate  <585.243589, 1281.82756, 110.0>
}

#include "C:\Rhino\Templates\shoes.inc"

#declare Object29_Ref = object {
  Object1
}
#declare Object30_Ref = object {
  Object2
}
#declare ShoesGirl = union {
  object { Object29_Ref }
  object { Object30_Ref }
  texture {
    Shoes
  }
}
#include "C:\Rhino\Templates\socks.inc"

#declare Object27_Ref = object {
  Object1
}
#declare Object28_Ref = object {
  Object2
}
#declare SocksGirl = union {
  object { Object27_Ref }
  object { Object28_Ref }
  texture {
    socks
  }
}
#include "C:\Rhino\Templates\pink.inc"

#declare Object21_Ref = object {
  Object1
}
#declare Object22_Ref = object {
  Object2
}
#declare Object23_Ref = object {
  Object3
}
#declare Object24_Ref = object {
  Object4
}
#declare Object25_Ref = object {
  Object5
}
#declare Object26_Ref = object {
  Object6
}
#declare SkirtHBand = union {
  object { Object21_Ref }
  object { Object22_Ref }
  object { Object23_Ref }
  object { Object24_Ref }
  object { Object25_Ref }
  object { Object26_Ref }
  texture {
    Skirt
  }
}
#include "C:\Rhino\Templates\flesh.inc"

#declare Object16_Ref = object {
  Object1
}
#declare Object17_Ref = object {
  Object2
}
#declare Object18_Ref = object {
  Object3
}
#declare Object19_Ref = object {
  Object4
}
#declare Object20_Ref = object {
  Object5
}
#declare BodyGirl = union {
  object { Object16_Ref }
  object { Object17_Ref }
  object { Object18_Ref }
  object { Object19_Ref }
  object { Object20_Ref }
  texture {
    Flesh
  }
}
#include "C:\Rhino\Templates\hair.inc"

#declare Object1_Ref = object {
  Object1
}
#declare Object2_Ref = object {
  Object2
}
#declare Object3_Ref = object {
  Object3
}
#declare Object4_Ref = object {
  Object4
}
#declare Object5_Ref = object {
  Object5
}
#declare Object6_Ref = object {
  Object6
}
#declare Object7_Ref = object {
  Object7
}
#declare Object8_Ref = object {
  Object8
}
#declare Object9_Ref = object {
  Object9
}
#declare Object10_Ref = object {
  Object10
}
#declare Object11_Ref = object {
  Object11
}
#declare Object12_Ref = object {
  Object12
}
#declare Object13_Ref = object {
  Object13
}
#declare Object14_Ref = object {
  Object14
}
#declare Object15_Ref = object {
  Object15
}
#declare Hairgirl = union {
  object { Object1_Ref }
  object { Object2_Ref }
  object { Object3_Ref }
  object { Object4_Ref }
  object { Object5_Ref }
  object { Object6_Ref }
  object { Object7_Ref }
  object { Object8_Ref }
  object { Object9_Ref }
  object { Object10_Ref }
  object { Object11_Ref }
  object { Object12_Ref }
  object { Object13_Ref }
  object { Object14_Ref }
  object { Object15_Ref }
  texture {
    Hair
  }
}
#include "C:\Rhino\Templates\shirt.inc"

#declare Blouse_Ref = object {
  Object1
  texture {
    shirt
  }
}
#include "C:\Rhino\Templates\soles.inc"

#declare Object31_Ref = object {
  Object1
}
#declare Object32_Ref = object {
  Object2
}
#declare UserDefGroup1 = union {
  object { Object31_Ref }
  object { Object32_Ref }
  texture {
    soles
  }
  rotate -0.008469*z
  translate  <-0.000004, 0.000004, 0.0>
}
union { // Girl
  object { ShoesGirl }
  object { SocksGirl }
  object { SkirtHBand }
  object { BodyGirl }
  object { Hairgirl }
  object { Blouse_Ref }
  object { UserDefGroup1 }
  rotate 161.568466*z
  translate  <-3.581222, -1.177045, 0.0>
}

// TOOOOOB

cylinder { // Cylndr003
  <0,0,1>, <0,0,0>, 1 open
  texture {
    Cardboard
  }
  scale <0.05, 0.05, 0.5>
  rotate <-90.0, -0.0, -23.040638>
  translate  <-4.440176, -1.161695, 1.820156>
}

torus { // Torus001
  0.06, 0.01  rotate -x*90
  texture {
    String
  }
  rotate <-90.0, 0.0, -20.340502>
  translate  <-4.399572, -1.069425, 1.807905>
}

// broken piece of string coming from tube

sphere_sweep
{
    b_spline_sphere_sweep, 8,
    <-4.426526, -1.060408, 1.854277>,0.01
    <-4.426526, -1.060408, 1.9>,0.01
    <-4.567401, -1.057646, 1.701077>,0.01
     <-4.726929, -1.007702, 1.91396>,0.01
     <-4.880761, -1.007702, 1.70962>,0.01
     <-4.963173, -0.960059, 1.846102>,0.01
   <-5.077338, -0.960059, 1.91054>,0.01
   <-5.1,-0.960059,1.75>,0.01
    sphere_sweep_depth_tolerance 1.0e-3
    texture {String}
}


#declare Bark2 =
   texture  // Bark2
   {
      pigment
      {
         color rgb <0.531233, 0.489567, 0.406233>
      }
      normal
      {
         crackle , 0.5
         turbulence 0.1
         scale  0.25
      }
      finish
      {
         ambient 0.1
         diffuse 1.0
      }
   }


#declare Leaves =
texture
{
pigment
{
color rgb <0.115,0.5,0.208>
}
finish
{
ambient 0.25
diffuse 1.0
phong 1.0
phong_size 50.0
specular 0.4
}
}

#declare Trunk_Height_B = 10
#declare Trunk_Width = 1.5
#declare Branch_Length_1 = 5
#declare Branch_Length_2 = 5
#declare Branch_Length_3 = 4
#declare Num_Branches_1 = 5
#declare Num_Branches_2 = 5
#declare Num_Branches_3 = 5
#declare Branch_Bend_1 = 30
#declare Branch_Bend_2 = 30
#declare Branch_Bend_3 = 30
#declare Branch_Rand_1 = seed(4096)
#declare Branch_Rand_2 = seed(9654)
#declare Branch_Rand_3 = seed(9)
#declare Leaf_Rand = seed(10)
#declare Num_Leaves = 3

#declare Blob_Tree =
blob {
threshold 0.4
cylinder {<0,0,0>,<0,0,Trunk_Height_B>,Trunk_Width,0.9
texture {Bark2}
}
#declare A = 0 #while (A < Num_Branches_1)
#declare Branch_Rand_A = rand(Branch_Rand_1)*30
cylinder {<0,0,0.75>,<Branch_Length_1,0,-0.5>,1,0.9
texture {Bark2}
rotate <0,0,(360/Num_Branches_1)*A>
}
cylinder {<Trunk_Width,0,0>,<0,0,Trunk_Height_B/1.5>,Trunk_Width/2,0.9
texture {Bark2}
rotate <0,0,(360/Num_Branches_1)*A>
}
cylinder {<0,0,0>,<0,0,Branch_Length_1>,0.6,0.9
texture {Bark2}
rotate <0,Branch_Bend_1+(Branch_Rand_A),0>
rotate <0,0,(360/Num_Branches_1)*A>
translate <0,0,Trunk_Height_B>
}
#declare B = 0 #while (B < Num_Branches_2)
#declare Branch_Rand_B = rand(Branch_Rand_2)*30
cylinder {<0,0,0>,<0,0,Branch_Length_2>,0.6,0.9
texture {Bark2}
rotate <0,Branch_Bend_2+(Branch_Rand_B),0>
rotate <0,0,(360/Num_Branches_2)*B>
translate <0,0,Branch_Length_2>
rotate <0,Branch_Bend_1+(Branch_Rand_A),0>
rotate <0,0,(360/Num_Branches_1)*A>
translate <0,0,Trunk_Height_B>
}
#declare C = 0 #while (C < Num_Branches_3)
#declare Branch_Rand_C = rand(Branch_Rand_3)*30
cylinder {<0,0,0>,<0,0,Branch_Length_3>,0.4,0.9
texture {Bark2}
rotate <0,Branch_Bend_3+(Branch_Rand_C),0>
rotate <0,0,(360/Num_Branches_3)*C>
translate <0,0,Branch_Length_2>
rotate <0,Branch_Bend_2+(Branch_Rand_B),0>
rotate <0,0,(360/Num_Branches_2)*B>
translate <0,0,Branch_Length_1>
rotate <0,Branch_Bend_1+(Branch_Rand_A),0>
rotate <0,0,(360/Num_Branches_1)*A>
translate <0,0,Trunk_Height_B>
}
#declare D = 0 #while (D < Num_Leaves)
#declare Leaf_Rand_D = rand(Leaf_Rand)
sphere {<0,0,0>,1,0.9
scale <0.968,0.363,0.15125>
texture {Leaves}
translate <0.825,0,0>
rotate <0,Leaf_Rand_D*(-30),0>
rotate <0,0,(360/Num_Leaves)*D>
translate <0,0,Branch_Length_3+0.05>
rotate <0,Branch_Bend_3+(Branch_Rand_C),0>
rotate <0,0*C,(360/Num_Branches_3)*C>
translate <0,0,Branch_Length_2>
rotate <0,Branch_Bend_2+(Branch_Rand_B),0>
rotate <0,0,(360/Num_Branches_2)*B>
translate <0,0,Branch_Length_1>
rotate <0,Branch_Bend_1+(Branch_Rand_A),0>
rotate <0,0,(360/Num_Branches_1)*A>
translate <0,0,Trunk_Height_B>
}
sphere {<0,0,0>,1,0.9
scale <0.9075,0.363,0.15125>
scale <0.8,0.8,0.8>
texture {Leaves}
translate <0.6875,0,0>
rotate <0,Leaf_Rand_D*(-30),0>
rotate <0,0,(360/Num_Leaves)*D>
rotate <0,0,30>
translate <0,0,Branch_Length_3+0.05>
rotate <0,Branch_Bend_3+(Branch_Rand_C),0>
rotate <0,0,(360/Num_Branches_3)*C>
translate <0,0,Branch_Length_2>
rotate <0,Branch_Bend_2+(Branch_Rand_B),0>
rotate <0,0,(360/Num_Branches_2)*B>
translate <0,0,Branch_Length_1>
rotate <0,Branch_Bend_1+(Branch_Rand_A),0>
rotate <0,0,(360/Num_Branches_1)*A>
translate <0,0,Trunk_Height_B>
}
sphere {<0,0,0>,1,0.9
scale <0.9075,0.363,0.15125>
scale <0.8,0.8,0.8>
texture {Leaves}
translate <0.6875,0,0>
rotate <0,Leaf_Rand_D*(-30),0>
rotate <0,0,(360/Num_Leaves)*D>
rotate <0,0,-30>
translate <0,0,Branch_Length_3+0.05>
rotate <0,Branch_Bend_3+(Branch_Rand_C),0>
rotate <0,0,(360/Num_Branches_3)*C>
translate <0,0,Branch_Length_2>
rotate <0,Branch_Bend_2+(Branch_Rand_B),0>
rotate <0,0,(360/Num_Branches_2)*B>
translate <0,0,Branch_Length_1>
rotate <0,Branch_Bend_1+(Branch_Rand_A),0>
rotate <0,0,(360/Num_Branches_1)*A>
translate <0,0,Trunk_Height_B>
}
#declare D = D + 1 #end
#declare C = C + 1 #end
#declare B = B + 1 #end
#declare A = A + 1 #end
}

object {
Blob_Tree
scale <0.8, 0.8, 0.8>
rotate <0,0,20>
 translate  <62.716526, 13.542401, 0.0>
}


object {
Blob_Tree
scale <0.8, 0.8, 0.8>
rotate <0,0,-20>
  translate  <7.459969, 101.682586, 0.0>
}

object {
Blob_Tree
  scale <0.8, 0.8, 0.8>
  translate  <111.801047, 109.201022, 0.0>
}

object {
Blob_Tree
  scale <0.8, 0.8, 0.8>
   translate  <254.801108, 186.201055, 0.0>
}




