// fish.inc
// by Robert Fremin 1998
//
// objects:  fish


#ifndef (FISH_INC)
#declare FISH_INC = true

#declare fintex =
pigment { gradient x color_map { [0 Yellow][.5 Gray20][1 Yellow] } scale .5 }
//pigment { Yellow }

#end	// ifndef


// White tailed damsel - type of fish.
#declare fish =
union
{
	sphere { 0 5 scale <1.7,.9,.3> }									// body
//	sphere { 0 1 scale <2,.9,.9> rotate z*-15 translate <-6.7,-1,0> }	// lip

	union
	{
		triangle { <3,0,0> <14,3,0> <14,-3,0> pigment { fintex rotate z*90 } }		// tail
		triangle { <0,4,0> <10,6,0> <7,0,0> pigment { fintex rotate z*-30 } }		// back
		triangle { <0,-4,0> <8,-5,0> <7,0,0> pigment { fintex rotate z*20 } }		// belly
		triangle { <-3,-3,0> <5,-8,-5> <3,-3,0> pigment { fintex rotate z*30 } }	// left
		triangle { <-3,-3,0> <5,-8, 5> <3,-3,0> pigment { fintex rotate z*30 } }	// right
	}

	union
	{
		sphere { 0 1 scale <1,1,.5> translate <-4,1,-1.1> pigment { White } finish { ambient .1 } }
		sphere { 0 1 scale <.5,.5,.3> translate <-4.2,1,-1.4> pigment { Black } }

		sphere { 0 1 scale <1,1,.5> translate <-4,1, 1.1> pigment { White } finish { ambient .1 } }
		sphere { 0 1 scale <.5,.5,.3> translate <-4.2,1, 1.4> pigment { Black } }
	}

	scale .5

	pigment { checker Yellow,Black translate <0,-.5,-.5> scale <2.6,20,100> turbulence .56 }
	normal { bump_map { tga "stones1.tga" interpolate 2 bump_size 2 } scale 2 }
	finish { specular .3 phong .4 }
}
