// ===========================================================================
//
//  --=  O  C  T  O  P  U  S  =--
//
//    by Robert Fremin  (c)1998
//
// Made for the IRTC "Nature" round, May-June 1998
//
// ===========================================================================

#include "colors.inc"
#include "textures.inc"
#include "chars.inc"
#include "consts.inc"
#include "metals.inc"

// ---------------------------------------------------------------------------

#declare where_from    = -210
#declare NumberOfGrass =  5000

camera
{
  location  <0, 9, where_from>
  look_at   <0, 1, 0>
}

// fill light
light_source
{
  <-100, 2000, -2000>
  color White
  atmosphere off
  shadowless
}

// main light
light_source
{
  <300, 1000, 1000-1000>
  color <.05,.08,.13>*.3
  spotlight
  radius 3
  falloff 2
  point_at <0,0,-170>

  atmosphere on
//	atmospheric_attenuation on
}

#declare deep_water_fast =
atmosphere
{
  type 1
  samples 5
  distance 45-8
  scattering 0.2
  aa_level 4
  aa_threshold 0.1
  jitter 0.2
}

#declare deep_water_fine =
atmosphere
{
  type 1
  samples 40
  distance 45-7
  scattering 0.2
  aa_level 4
  aa_threshold 0.1
  jitter 0.2
}

// ---------------------------------------------------------------------------

#declare the_bottom =
height_field
{
  png "moon.png"
  pigment { color <.8,.5,.3> }
  finish { ambient .1 }
  translate <-.5,0,-.5>
  scale <250,1,250>
  rotate y*30
  translate z*-100

    clipped_by { plane { -z,-where_from-14 } }  // remove behind camera
}

#declare plant1 =
union
{
  #debug "Plant type 1"

  #declare i = 0
  #declare Ni = 100
  #declare Rg = seed(453176)
  #while (i < Ni)
    #declare ws1 = sin(radians(i*720/Ni))*7
    #declare ws2 = sin(radians(i*537/Ni))*4
    box { <-1,-1,-1> <1,1,1> pigment { crackle color_map { [0 rgb <0,.2,0>][.5 rgb <.4,1,.4>] } rotate <rand(Rg)*360,rand(Rg)*360,rand(Rg)*360> turbulence .2 scale 1 } rotate <rand(Rg)*90,rand(Rg)*90,rand(Rg)*90> translate <ws1,i*1.5,ws2/2> }
    box { <-1,-1,-1> <1,1,1> pigment { crackle color_map { [0 rgb <0,.2,0>][.5 rgb <.4,1,.4>] } rotate <rand(Rg)*360,rand(Rg)*360,rand(Rg)*360> turbulence .2 scale 1 } rotate <rand(Rg)*90,rand(Rg)*90,rand(Rg)*90> translate <ws1/2,i*1.3,ws2> }
    #declare i = i + 1
  #end

  finish { specular .5 phong .4 reflection .1 ambient .2 }
  normal { ripples bump_size 2 }
}

#declare plants1 =
union
{
  object { plant1 scale <-1,1,-.5> translate <-25,0,-150> }
  object { plant1 translate <0,0,-120> }
  object { plant1 translate <20,0,-155> }
}

#include "fish.inc"

#declare fish_school =
union
{
  #debug "School of fish"

  #declare Fw = 130-30
  #declare Fh = 40
  #declare Fd = 110
  #declare Rf = seed(8546895+34)

  #declare i = 0
  #while (i < 50)
    object
      {
	fish
	  rotate <(rand(Rf)-.5),(rand(Rf)-.5)*30,(rand(Rf)-.5)*20>
	  translate <rand(Rf)*Fw-Fw/2,rand(Rf)*Fh,rand(Rf)*Fd-Fd/2>
      }
    #declare i = i + 1
  #end
}

#declare plants2 =
union
{
  #debug "Plants type 2"

  #declare Fw = 900
  #declare Fd = 700
  #declare Rf = seed(8546198)
  #declare Rp = seed(3456845)

  #declare i = 0
  #while (i < NumberOfGrass)
    #include "plant2.inc"
    #declare i = i + 1
  #end

  pigment { ForestGreen }
  finish { specular .3 phong .5 metallic }

  scale .1

  translate z*-160
}

#declare helmet =
union
{
  // helmet
  difference
    {
      cylinder { z*0 z*1.5 50 }
      cylinder { z*-10 z*10 10 }

      pigment { Gray30 }
    }

  // ring
  difference
    {
      cylinder { z*0 z*2 10 }
      cylinder { z*-10 z*10 9 }
      cylinder { z*.8 z*1.2 9.5 }  // the glass goes here

      texture { T_Chrome_3C }
      normal { bumps }
    }

  // bolts
  #declare c = 0
  #while (c < 24)
    sphere
      {
	vrotate(<9.5,0,0>,z*(360/10)*c) .35
	texture { T_Chrome_2B }
	normal { bumps scale .1 }
      }
    #declare c = c + 1
  #end

  // glass
  cylinder
    {
      z*.7 z*.8 9.5
      pigment { White filter .99 }
      //      pigment { Red }
      finish { refraction on ior 1.2 phong .3 specular .1 reflection .15 }
      normal { waves frequency 2 translate <3,2,3> bump_size .03 turbulence .1 }
    }

  scale <1,.8,1>

  translate <0,8.6,where_from+12>
}

#declare alien_reflection =
box
{
  <0,0,0> <1,1,.1>
  pigment { image_map { png "/root/alien2.png" interpolate 2 } }
  finish { ambient 2 }
  translate <-.5,-.5,0>
  rotate y*180
  scale 30
  translate <3, 5, where_from-.001>
}

// ---------------------------------------------------------------------------

background { SkyBlue }
//atmosphere { deep_water_fast }
atmosphere { deep_water_fine }
object { helmet }
object { alien_reflection }
object { the_bottom }
//plane { y,0 pigment { checker Red,White } scale 20 }
object { plants1 }
object { plants2 }
object { fish_school translate <20,10-5,-110> }
//#declare no_arms = true
#include "octo.inc"
object { octopus rotate y*-30 scale .1 translate <-7, 5.5, -186.5> }
