 pdmnatur.povձ4pdmnatur.pov   66pL     TEXTPOV3         D  uձ4                       >  // POV-Ray file
// Standard pre-defined colors
#include "colors.inc"
#include "textures.inc"

/* 320x240 (Centris 650) early version:
Time For Parse:    0 hours  3 minutes   4.0 seconds (184 seconds)
Time For Trace:    0 hours 14 minutes  20.0 seconds (860 seconds)
    Total Time:    0 hours 17 minutes  24.0 seconds (1044 seconds)
*/
/* 832x624 (PowerMac G3):
Graphic Converter to convert the results to gif
Time For Parse:    0 hours  1 minutes  19.0 seconds (79 seconds)
Time For Trace:    0 hours  7 minutes  52.0 seconds (472 seconds)
    Total Time:    0 hours  9 minutes  11.0 seconds (551 seconds)
with anti-aliasing (which made the foliage look worse):
Time For Parse:    0 hours  1 minutes  13.0 seconds (73 seconds)
Time For Trace:    1 hours 15 minutes  32.0 seconds (4532 seconds)
    Total Time:    1 hours 16 minutes  45.0 seconds (4605 seconds)
*/

global_settings{
  assumed_gamma 1.0
  //displaygamma 1.2
  /*radiosity {
    brightness 0.5
    count 100
    distance_maximum 6
    error_bound 0.33
    gray_threshold 0.5
    low_error_factor 0.1
    minimum_reuse 0.1
    nearest_count 1
    recursion_limit 20
  }*/
}

// Units
#declare in  =  1  // There's probably still some implied inches without *in
#declare ft  = 12
#declare yd  = 36
#declare mi  = 1760*yd

#declare VPoverview = <0,1000*yd,-.9*mi>// z was -1.25*mi
#declare LAoverview = <0,7*in,0>

#declare VPunderview = <0,10*yd,-.9*mi>
#declare LAunderview = <0,5*ft+4*in,0>

#declare VPcloseup = <-.25*mi-29*yd,5*ft+4*in,-.5*mi-20*yd>
#declare LAcloseup = <-.25*mi,2*ft,-.5*mi>

#declare VPtree = <0*yd,5*ft+4*in,-5*yd>-<-5*yd,0,200*yd>
#declare LAtree = <0*yd,2*ft,0*yd>-<0,0,190*yd>

#declare ViewPoint = VPtree
#declare LookAt    = LAtree

#declare Detailed = 1

camera {
  location  ViewPoint // position of camera <X Y Z>
  look_at   LookAt // point center of view at this point <X Y Z>
}

light_source {
  ViewPoint
  colour rgb <1,1,1>
}

light_source {
  <3*mi,3*mi,.5*mi>
  colour rgb <2,2,2>
}

fog{
  distance .6*mi
  colour rgbf<0.5, 0.5, 0.7, 0.2>
}

sky_sphere {
  pigment {
    gradient y
    colour_map {
      [0.000 0.002 colour rgb <0.0, 0.2, 1.0>
                   colour rgb <0.0, 0.2, 1.0>]
      [0.002 0.200 colour rgb <0.2, 0.2, 0.8>
                   colour rgb <0.2, 0.2, 0.6>]
    }
    scale 2
    translate -1
  }
  pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    colour_map {
      [0.0 0.1 colour rgb <0.85, 0.85, 0.85>
               colour rgb <0.75, 0.75, 0.75>]
      [0.1 0.5 colour rgb <0.75, 0.75, 0.75>
               colour rgbt <1, 1, 1, 1>]
      [0.5 1.0 colour rgbt <1, 1, 1, 1>
               colour rgbt <1, 1, 1, 1>]
    }
    scale <0.2, 0.5, 0.2>
  }
  rotate -135*x
}

#declare HeightField = "lakescene5.gif"

#declare Trunk=
texture{
  pigment{
    radial
    colour_map{
      [0.0 colour rgb<.5,.25,.2>]
      [1.0 colour rgb<.25,.125,.1>]
    }
    turbulence .2 omega 2 lambda 1.2 octaves 3
    frequency 36  rotate <-5,15,-10>
  }
}

#declare Trunk2=
texture{
  pigment{
    radial
    colour_map{
      [0.0 colour rgb<.4,.3,.15>]
      [1.0 colour rgb<.3,.22,.11>]
    }
    turbulence .2 omega 2 lambda 1.2 octaves 3
    frequency 48  rotate <7,-21,14>
  }
}

#declare Trunk3=
texture{
  pigment{
    radial
    colour_map{
      [0.0 colour rgb<.4,.3,.15>]
      [1.0 colour rgb<.3,.22,.11>]
    }
    turbulence .2 omega 2 lambda 1.2 octaves 3
    frequency 16  rotate <2,6,4>
  }
}

#declare Foliage2=
texture{
  pigment{
    agate colour_map{
	  [0.0 colour rgbf<1  ,1  ,1  ,1 >]
	  [0.6 colour rgbf<1  ,1  ,1  ,1 >]
	  [0.7 colour rgbf<.17,.44,.11, 0>]
	  [1.0 colour rgbf<.1,.3,.05, 0>]
	}
	agate_turb 1.0 // octaves 2.0 omega 2.0
  }
}

#declare Tree1=
cylinder{
  <0,-12,0>,<0,50*ft,0>,2*ft
}

#declare Tree2=
union{
  union{
    //roots
    cone{
      <0,-1*ft,0>,2*ft,<0,6*in,0>,1*ft
    }
    cone{
      <-1.25*ft,-1*ft,0>,1*ft,<0,4*in,0>,9*in
    }
    cone{
      <18*in,-1*ft,9*in>,1*ft,<0,6*in,0>,9*in
    }
    cone{
      <18*in,-1*ft,-16*in>,1*ft,<0,6*in,0>,9*in
    }
    //trunk
    cone{
      <0,-12,0>,1*ft+2*in,<0,6*ft,0>,1*ft
    }
    cone{
      <0,5*ft,0>,1*ft,<0,7*ft,0>,1*ft
    }
    cylinder{
      <0,6*ft,0>,<4*in,10*ft,0>,11*in
    }
    //major branches
    cone{//1
      <5*in,10*ft,0>,6*in,<1*ft+6*in,20*ft,5*in>,4*in
    }
    cone{//2
      <2*in,10*ft,-2*in>,8*in,<-2*ft,15*ft,-1*ft>,6*in
    }
    cone{
      <-2*ft,15*ft,-1*ft>,6*in,<-3*ft+6*in,23*ft,-2*ft>,4*in
    }
    cone{
      <-2*ft,15*ft,-1*ft>,5.5*in,<-8*ft+6*in,17*ft,-3*ft+6*in>,4*in
    }
    cone{//3
      <6*in,9*ft+11*in,3*in>,7*in,<5*ft,16*ft,4*ft>,6*in
    }
    cone{
      <5*ft,16*ft,4*ft>,6*in,<8*ft,19*ft,6*ft>,4*in
    }
    cone{
      <5*ft,16*ft,4*ft>,6*in,<6*ft,24*ft,5*ft+6*in>,3*in
    }
    cone{
      <4*ft+8*in,15*ft+6*in,3*ft+9*in>,6*in,<6*ft+6*in,21*ft,9*ft>,4*in
    }
    cone{//4
      <0,9*ft+6*in,3*in>,7*in,<0,14*ft,-7*ft>,5*in
    }
    cone{
      <0,14*ft,-7*ft>,5*in,<1.75*ft,18*ft,-9*ft>,3*in
    }
    cone{
      <0,13*ft+5*in,-6*ft>,5.4*in,<-3*ft,15*ft,-8*ft>,3*in
    }
    texture{Trunk}
  }
  merge{//Now foliage
    cone{//1
      <5*in,10*ft,0>,7*in,<1*ft+6*in,20*ft,5*in>,2*ft
    }
    sphere{
      <1*ft+6*in,20*ft,5*in>,2*ft
    }
    cone{//2
      <2*in,10*ft,-2*in>,10*in,<-2*ft,15*ft,-1*ft>,2*ft
    }
    cone{
      <-2*ft,15*ft,-1*ft>,2*ft,<-3*ft+6*in,23*ft,-2*ft>,4*ft
    }
    sphere{
      <-3*ft+6*in,23*ft,-2*ft>,4*ft
    }
    cone{
      <-2*ft,15*ft,-1*ft>,2*ft,<-8*ft+6*in,17*ft,-3*ft+6*in>,4*ft
    }
    sphere{
      <-8*ft+6*in,17*ft,-3*ft+6*in>,4*ft
    }
    cone{
      <-2*ft,15*ft,-1*ft>,2*ft,<3*ft,17*ft,-6*ft>,3*ft
    }
    sphere{
      <3*ft,17*ft,-6*ft>,3*ft
    }
    cone{
      <-2*ft,15*ft,-1*ft>,2*ft,<5*ft,19*ft,3*ft>,3*ft
    }
    sphere{
      <5*ft,19*ft,3*ft>,3*ft
    }
    cone{//3
      <6*in,9*ft+11*in,3*in>,10*in,<5*ft,16*ft,4*ft>,18*in
    }
    cone{
      <5*ft,16*ft,4*ft>,18*in,<8*ft,19*ft,6*ft>,2*ft
    }
    sphere{
      <8*ft,19*ft,6*ft>,2*ft
    }
    cone{
      <5*ft,16*ft,4*ft>,18*in,<6*ft,24*ft,5*ft+6*in>,3.5*ft
    }
    sphere{
      <6*ft,24*ft,5*ft+6*in>,3.5*ft
    }
    cone{
      <4*ft+8*in,15*ft+6*in,3*ft+9*in>,18*in,<6*ft+6*in,21*ft,9*ft>,4*ft
    }
    sphere{
      <6*ft+6*in,21*ft,9*ft>,4*ft
    }
    cone{//4
      <0,9*ft+6*in,3*in>,14*in,<0,14*ft,-7*ft>,1.5*ft
    }
    cone{
      <0,14*ft,-7*ft>,1.5*ft,<1.75*ft,18*ft,-9*ft>,2.5*ft
    }
    sphere{
      <1.75*ft,18*ft,-9*ft>,2.5*ft
    }
    cone{
      <0,13*ft+5*in,-6*ft>,1.5*ft,<-3*ft,15*ft,-8*ft>,2.5*ft
    }
    sphere{
      <-3*ft,15*ft,-8*ft>,2.5*ft
    }
    texture{Foliage2}
  }
}

#declare Tree3=
union{
  union{
    //roots
    cone{
      <0,-1*ft,0>,1.75*ft,<6*in,1.75*ft,0>,1.5*ft
    }
    cone{
      <0,-1*ft,-1*ft+10*in>,8*in,<0,1.25*ft,-1*ft>,6*in
    }
    //trunk
    cone{
      <6*in,1*ft+2*in,0>,1.4*ft,<8*in,1*ft+10*in,0>,1.4*ft
    }
    cone{
      <6*in,1.5*ft,0>,1.5*ft,<5*in,8*ft,0>,1*ft+4*in
    }
    //major branches
    cone{//1
      <1*in,7*ft,-8*in>,10*in,<-1*ft,15*ft,-2*ft>,8*in
    }
    cone{
      <-1*ft,15*ft,-2*ft>,8*in,<-4*ft,22*ft,-3*ft>,7.8*in
    }
    cone{//1.1
      <-4*ft,22*ft,-3*ft>,7*in,<-5*ft,27*ft,-4*ft>,5*in
    }
    cone{
      <-5*ft,27*ft,-4*ft>,5*in,<-6*ft,32*ft,-4.5*ft>,3*in
    }
    cone{//1.2
      <-3.75*ft,21.75*ft,-3*ft>,7*in,<-3*ft,24*ft,-3.5*ft>,6*in
    }
    cone{//1.2.1
      <-3*ft,24*ft,-3.5*ft>,6*in,<0,27*ft,-4.5*ft>,5*in
    }
    cone{
      <0,27*ft,-4.5*ft>,5*in,<2*ft,28*ft,-5*ft>,4*in
    }
    cone{
      <2*ft,28*ft,-5*ft>,4*in,<6*ft,28.5*ft,-7*ft>,3*in
    }
    cone{
      <6*ft,28.5*ft,-7*ft>,3*in,<9*ft,27*ft,-8*ft>,1.5*in
    }
    cone{//1.2.2
      <-3*ft,24*ft,-3.5*ft>,6*in,<-2.5*ft,26*ft,-2.5*ft>,5*in
    }
    cone{
      <-2.5*ft,26*ft,-2.5*ft>,5*in,<-1.5*ft,29*ft,-1*ft>,4*in
    }
    cone{
      <-1.5*ft,29*ft,-1*ft>,4*in,<-1*ft,30.5*ft,2*ft>,3*in
    }
    cone{
      <-1*ft,30.5*ft,2*ft>,3*in,<-2.5*ft,30*ft,4*ft>,1.5*in
    }
    cone{//2
      <10*in,7*ft,8*in>,11*in,<13*in,14*ft,1.5*ft>,9*in
    }
    sphere{//2.1
      <13*in,14*ft,1.5*ft>,9*in
    }
    cone{
      <13*in,14*ft,1.5*ft>,9*in,<5*in,19*ft,3*ft>,8*in
    }
    cone{
      <5*in,19*ft,3*ft>,8*in,<1*ft,23*ft,4*ft>,7*in
    }
    cone{
      <1*ft,23*ft,4*ft>,7*in,<5*ft,25*ft,3*ft>,6*in
    }
    cone{
      <5*ft,25*ft,3*ft>,6*in,<7*ft,25*ft,2*ft>,5*in
    }
    cone{//2.3.1
      <7*ft,25*ft,2*ft>,5*in,<11*ft,22*ft,1*ft>,4*in
    }
    cone{
      <11*ft,22*ft,1*ft>,4*in,<15*ft,21*ft,1*ft>,3*in
    }
    cone{//2.3.2
      <9*ft,23.5*ft,1.5*ft>,4.5*in,<10*ft,21*ft,2.5*ft>,3.5*in
    }
    cone{
      <10*ft,21*ft,2.5*ft>,3.5*in,<12*ft,19*ft,4*ft>,2.5*in
    }
    cone{//2.1.1
      <7.3*in,20*ft+4*in,3*ft+4*in>,7.5*in,<7*in,25.5*ft,3.75*ft>,7*in
    }
    cone{
      <7*in,25.5*ft,3.75*ft>,7*in,<1*ft,29*ft,7*ft>,6*in
    }
    cone{
      <1*ft,29*ft,7*ft>,6*in,<5*ft,32*ft,10*ft>,5*in
    }
    cone{
      <5*ft,32*ft,10*ft>,5*in,<7*ft,32*ft,12*ft>,4*in
    }
    cone{
      <7*ft,32*ft,12*ft>,4*in,<10*ft,30*ft,14*ft>,2.5*in
    }
    cone{//2.2
      <9*in,16.5*ft,2.25*ft>,8*in,<1.75*ft,17*ft,2.5*ft>,7*in
    }
    texture{Trunk2}
  }
  merge{//Now foliage
    //major branches
    cone{//1
      <1*in,7*ft,-8*in>,10*in,<-4*ft,22*ft,-3*ft>,3*ft
    }
    cone{//1.1
      <-4*ft,22*ft,-3*ft>,12*in,<-5*ft,27*ft,-4*ft>,6*ft
    }
    cone{
      <-5*ft,27*ft,-4*ft>,6*ft,<-6.5*ft,34.5*ft,-4.75*ft>,12*in
    }
    cone{//1.2
      <-3.75*ft,21.75*ft,-3*ft>,12*in,<-3*ft,24*ft,-3.5*ft>,2*ft
    }
    cone{//1.2.1
      <-3*ft,24*ft,-3.5*ft>,2*ft,<0,27*ft,-4.5*ft>,4*ft
    }
    cone{
      <0,25*ft,-4.5*ft>,6*ft,<10*ft,29*ft,-9*ft>,1*ft
    }
    cone{//1.2.2
      <-3*ft,24*ft,-3.5*ft>,1*ft,<-1.5*ft,29*ft,-1*ft>,3*ft
    }
    cone{
      <-1.5*ft,29*ft,-1*ft>,3*in,<-2.5*ft,30*ft,4*ft>,1.5*ft
    }
    sphere{
      <0,0,0>,1*ft
      scale <14,5,14>
      translate <0,30*ft,0>
    }
    cone{
      <13*in,14*ft,1.5*ft>,1*ft,<1*ft,23*ft,4*ft>,4*ft
    }
    cone{
      <1*ft,23*ft,4*ft>,4*ft,<7*ft,25*ft,2*ft>,5*ft
    }
    cone{//2
      <10*in,7*ft,8*in>,11*in,<13*in,14*ft,1.5*ft>,3*ft
    }
    cone{//2.3.1
      <7*ft,25*ft,2*ft>,1*ft,<15*ft,21*ft,1*ft>,3*ft
    }
    cone{//2.3.2
      <9*ft,23.5*ft,1.5*ft>,3*ft,<12*ft,19*ft,4*ft>,4*ft
    }
    cone{//2.1.1
      <7.3*in,20*ft+4*in,3*ft+4*in>,1*ft,<1*ft,29*ft,7*ft>,3*ft
    }
    cone{
      <1*ft,29*ft,7*ft>,3*in,<10*ft,30*ft,14*ft>,4*ft
    }
    cone{//2.2
      <9*in,16.5*ft,2.25*ft>,2*ft,<1.75*ft,17*ft,2.5*ft>,4*ft
    }
    texture{Foliage2}
  }
}

#declare Tree4=
union{
  union{
    //roots
    cone{
      <0,-12*in,-10*in>,8*in,<0,8*in,0>,1*ft
    }
    cone{
      <-6*in,-12*in,8*in>,10*in,<0,8*in,0>,1*ft
    }
    cone{
      <6*in,-12*in,8*in>,10*in,<0,8*in,0>,1*ft
    }
    //trunk
    cone{
      <0,8*in,0>,1*ft,<0,12*ft,0>,11*in
    }
    //major branches
    cone{
      <0,12*ft,0>,11*in,<0,18*ft,0>,10*in
    }
    cone{
      <0,12*ft,0>,11*in,<-12*ft,15*ft,0>,4*in
    }
    cone{
      <0,12*ft,0>,11*in,<9.6*ft,14.5*ft,7.5*ft>,4*in
    }
    cone{
      <0,12*ft,0>,11*in,<7.5*ft,15.5*ft,-9.6*ft>,4*in
    }
    cone{
      <0,18*ft,0>,10*in,<8*ft,23*ft,0>,2*in
    }
    cone{
      <0,18*ft,0>,10*in,<-6.4*ft,22.5*ft,-5.2*ft>,2*in
    }
    cone{
      <0,18*ft,0>,10*in,<-5.2*ft,23.5*ft,6.4*ft>,2*in
    }
    texture{Trunk3}
  }
  difference{
    merge{//Now foliage
      sphere{
        <0,0,0>,9*ft
        scale <1,.5,1>
        translate <0,22*ft,0>
      }
      sphere{
        <0,0,0>,14*ft
        scale <1,.6,1>
        translate <0,15*ft,0>
      }
    }
    sphere{
      <0,0,0>,8*ft
      scale <1,.5,1>
      translate <0,6.6*ft,0>
    }
    texture{Foliage2}
  }
}

#declare TeddHeadR = <0,0,0>
#declare TeddRarmR = <0,0,0>
#declare TeddLarmR = <0,0,0>
#declare TeddRlegR = <0,0,0>
#declare TeddLlegR = <0,0,0>
#include "teddbear.inc"

#declare Wicker=
texture{
  pigment{
    marble
    colour_map{
      [0.0  colour rgb <.5,.4,.2>]
      [1.0  colour rgb <.25,.2,.1>]
    }
  }
  scale .25
  rotate z*90
  finish{
    roughness 0.4
  }
}

#declare Wicker2=
texture{
  pigment{
    onion
    colour_map{
      [0.0  colour rgb <.5,.4,.2>]
      [1.0  colour rgb <.25,.2,.1>]
    }
  }
  scale .25
  rotate z*90
  finish{
    roughness 0.4
  }
}

#declare PicnicBasket=
union{
  //container
  difference{
    cylinder{
      <0,0,0>,<0,8*in,0>,1*in
      scale <10*in,1,6.5*in>
    }
    cylinder{
      <0,.5*in,0>,<0,9*in,0>,1*in
      scale <9*in,1,5.5*in>
      texture{pigment{colour rgb<.5,.5,1>}}
    }
    box{
      <1,3*in,7*in>,<-11*in,0,-7*in>
      rotate z*10
      translate <0,8*in,0>
    }
    box{
      <11*in,3*in,7*in>,<-1,0,-7*in>
      rotate z*-10
      translate <0,8*in,0>
    }
  }
  //handle
  cylinder{
    <0,8*in,-6*in>,<0,8*in,6*in>,.125*in
    scale <5,1,1>
  }
  difference{
    torus{
      6*in,.5*in
      rotate z*90
      scale <1,10/6,1>
      translate <0,8*in,0>
    }
    box{
      <-1*in,-3*in,-7*in>,<1*in,7.5*in,7*in>
    }
  }
  //right lid
  difference{
    cylinder{
      <0,0,0>,<0,.75*in,0>,.5*in
      scale <17,1,12.5>
      translate <0*in,8.0*in,0>
      //texture{Wicker2}
    }
    box{
      <-18*in,8*in,7*in>,<-.5*in,9.5*in,-7*in>
    }
    rotate z*-10
  }
  //left lid
  difference{
    cylinder{
      <0,0,0>,<0,.75*in,0>,.5*in
      scale <17,1,12.5>
      translate <0*in,8.0*in,0>
      //texture{Wicker2}
    }
    box{
      <18*in,8*in,7*in>,<.5*in,9.5*in,-7*in>
    }
    rotate z*0
  }
  object{teddy
    rotate y*200
    translate <-6.5*in,4*in,-4*in>
  }
  texture{Wicker}
}

// Landscape: Extremes
height_field{
  gif HeightField
  smooth
  translate <-.5,-.25,-.5>
  scale <1*mi,.4*mi,1*mi>
  texture{
    pigment{
      image_map{
        gif "lakeimage.gif" once interpolate 2
      }
      rotate x*90
      translate <-.5,-.25,-.5>
      scale <1*mi,.4*mi,1*mi>
    }
    normal{
      bumps 1 turbulence 0.75 octaves 5 omega 0.6 lambda 1.5
      scale <100 10 100>
    }
  }
  translate <0,00*yd,0>
}

// Landscape: Basic 0 level
height_field{
  gif HeightField
  water_level 1/16
  smooth
  translate <-.5,-.25,-.5>
  texture{
    pigment{
      gradient y
      colour_map{
        [0.00 colour rgb<0.3 ,0.7 ,0. >]
        [0.12 colour rgb<0.2 ,0.6 ,0.2 >]
        [0.13 colour rgb<0.1 ,0.7 ,0.2 >]
        [0.95 colour rgb<0.1 ,0.85,0.2 >]
        [0.96 colour rgb<0.2 ,0.9 ,0.2 >]
        [1.00 colour rgb<0.2 ,0.9 ,0.2 >]
      }
    }
  }
  scale <1*mi,1*ft,1*mi>
}

box{
  <-.4*mi,-6*in,-.4*mi>,<.4*mi,-.5*mi,.4*mi>
  /*
  texture{
    pigment{colour rgbf<.3,.4,.8,.8>}
    normal{
      ripples 1 turbulence 0.7 octaves 4 omega 0.2 lambda 1
      scale <12,1,12>
    }
  }
  */
  texture{pigment{colour rgb<.3,.4,.8>}}
}


#declare TX=seed(4945)
#declare TZ=seed(5817)
#declare TR=seed(312)
#declare TT=seed(1057)
#declare TS=seed(930)

// One bunch of trees is on a nominal 50 yard grid.
#declare TreeZ=-850
#while (TreeZ<700)
  #declare TreeX=-800+(rand(TX)*10)-(rand(TX)*20)
  #while (TreeX<850)
    #declare TreeR=rand(TR)*360
    #if ((TreeX>-570) & (TreeX<350) & (TreeZ>-160) & (TreeZ<330))
    #else
      object{
	    #switch(int(rand(TT)*10))
		#case (1)
          Tree2
        #break
		#case (2)
          Tree3
        #break
		#case (3)
          Tree2
        #break
		#case (4)
          Tree4
        #break
		#case (5)
          Tree2    //
        #break
		#case (6)
          Tree4
        #break
		#case (7)
          Tree3    //
        #break
		#case (8)
          Tree2    //
        #break
		#case (9)
          Tree4    //
        #break
		#else
          Tree4
		#end
        scale <1,(rand(TS)*20+90)/100,1>
        rotate y*TreeR
        translate <TreeX*yd,0,(TreeZ-5+10*rand(TZ))*yd>
      }
    #end
  #declare TreeX=TreeX+45+rand(TX)*10
  #end
  #declare TreeZ=TreeZ+50
#end

// another bunch is offset 25 yards in the Y and Z directions.
#declare TreeZ=-775
#while (TreeZ<700)
  #declare TreeX=-825+(rand(TX)*10)-(rand(TX)*20)
  #while (TreeX<850)
    #declare TreeR=rand(TR)*360
    #if ((TreeX>-610) & (TreeX<390) & (TreeZ>-160) & (TreeZ<360))
    #else
      object{
	    #switch(int(rand(TT)*10))
		#case (1)
          Tree2
        #break
		#case (2)
          Tree3
        #break
		#case (3)
          Tree2
        #break
		#case (4)
          Tree4
        #break
		#case (5)
          Tree2    //
        #break
		#case (6)
          Tree4
        #break
		#case (7)
          Tree3    //
        #break
		#case (8)
          Tree2    //
        #break
		#case (9)
          Tree4    //
        #break
		#else
          Tree2
		#end
        scale <1,(rand(TS)*20+90)/100,1>
        rotate y*TreeR
        translate <TreeX*yd,0,(TreeZ-5+10*rand(TZ))*yd>
      }
    #end
  #declare TreeX=TreeX+45+rand(TX)*10
  #end
  #declare TreeZ=TreeZ+50
#end

// Some placed trees for the scene.

object{
  Tree2
  rotate y*rand(TR)*360
  translate <-20*yd,0,-190*yd>
}

object{
  Tree2
  rotate y*rand(TR)*360
  translate <10*yd,0,-180*yd>
}

object{
  Tree4
  rotate y*rand(TR)*360
  translate <-10*yd,0,-190*yd>
}

object{
  Tree4
  rotate y*rand(TR)*360
  translate <-40*yd,0,-170*yd>
}

object{
  PicnicBasket
  translate <6*ft,-1*in,-199*yd-6*in>
}

// Cardboard cut-out of man
box{
  <0,0,0>,<9.75*ft,6.75*ft,.1>
  texture{
    pigment{
      image_map{
        gif "musing.gif" once
        filter all 1.0
      }
      scale <9.75*ft,6.75*ft,1>
    }
  }
  no_shadow
  translate <0*yd,0,-199*yd>
}                                                                                                                                     e  #Icallahans03.pictp  PICTttpdmnatur.povies.bumpemptctttt- TEXTPOV3                     ձ  D  u                #Icallahans04.pictp  PICTttxt        #           
n                         F G
     G      H 	Monaco ? QP R>?     d = d =  Ce  Ce  B     d = d =  B               <    4 -M     X      X JVWR8BIM   	                           >                                ?  f$` 9  FhR            eB    R MPSR  FPRF   *           L    ,     n    POV-Ray File Prefs           