//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 2 textures and 3 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.0 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 03/28/1998    (28.03.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.541,0.153,0.129> }

/* */
#declare camx = -174.326
#declare camy = -137.670
//#declare camz = 2.0
#declare camz = .5
#declare lx = -118
#declare ly = 10
#declare lz = 1.2
/**/
/*
#declare camx = -17
#declare camy = -13
#declare camz = 0.1
#declare lx = 0
#declare ly = 0
#declare lz = 0
*/

camera {  //  Camera StdCam
  location  <camx, camy, camz>
  direction <0.0,     0.0,  2.5833>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <lx,ly,lz>
}

  sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.000 0.00001 color rgb <1.0, 0.4, 0.2>
                     color rgb <1.0, 0.4, 0.2>]
        [0.00001 0.01000 color rgb <0.8, 0.15, 0.0>
                     color rgb <0.2, 0.2, 0.3>]
      }
      scale 2
      translate -1

      rotate -174*x
      rotate -29.5*z
    }

    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          /*
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
          */
          [0.0 0.1 color rgb <.85, 0.5, 0.5>
                   color rgb <0.75, 0.5, 0.5>]
          [0.1 0.5 color rgb <0.75, 0.5, 0.5>
                   color rgbt <1, .5, .5, 1>]
          [0.5 1.0 color rgbt <1, .5, .5, 1>
                   color rgbt <1, .5, .5, 1>]
      }
      scale <0.2, 0.5, 0.2>
      rotate -175*x
      rotate -29.5*z


    }
  }

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <426.797, 929.940, 130.383>
  color rgb <1.000, 0.355, 0.129>
}

   #declare camera_location = <camx, camy, camz>
   #declare camera_look_at = <lx,ly,lz>
   #declare camera_direction = <0.0,     0.0,  2.5833>
   #declare camera_sky = <0.0,     0.0,  1.0>  // Use right handed-system!
   #declare effect_location = <426.797, 929.940, 130.383>
   #declare effect_type = "Sun"
   #declare source_colour = <2.5, 1, .5>
   #include "Lens.inc"

   #declare camera_location = <camx, camy, camz>
   #declare camera_look_at = <lx,ly,lz>
   #declare camera_direction = <0.0,     0.0,  2.5833>
   #declare camera_sky = <0.0,     0.0,  1.0>  // Use right handed-system!
   #declare effect_location = <426.797, 929.940, -125.383>
   #declare effect_type = "Sparkle"
   #declare source_colour = <2.0, 0.8, 0.4>
   //#include "Lens.inc"


//
// ********  TEXTURES  *******
//

#include "mount1.inc"


//
// ********  REFERENCED OBJECTS  *******
//

//#include "raft.inc"

//
// ********  OBJECTS  *******
//
plane { // Plane001
  z,0
  texture {
    Pacific
  }
}



object {   // HgtFld001
  height_field {
    tga "mnt_hfld.tga"
    water_level 0.3669
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Mount1
  }
  scale <500.0, 500.0, 50.0>
  translate  <0.0, -7.371637, 12.92685>
}

//
// ********  TEXTURES  *******
//

#include "raft.in1"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

union { // raft
  torus { // Torus11
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <1.227338, -0.635843, 0.0>
  }
  torus { // Torus10
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <0.707338, -0.654959, 0.0>
  }
  torus { // Torus12
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <-1.375614, -0.665276, 0.0>
  }
  torus { // Torus9
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <0.187338, -0.63648, 0.0>
  }
  torus { // Torus8
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <-0.332662, -0.664199, 0.0>
  }
  torus { // Torus7
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <-0.852662, -0.64572, 0.0>
  }
  torus { // Torus6
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <1.227338, -0.599902, 0.0>
  }
  torus { // Torus5
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <0.707338, -0.616847, 0.0>
  }
  torus { // Torus4
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <0.187338, -0.599132, 0.0>
  }
  torus { // Torus3
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <-0.331121, -0.623009, 0.0>
  }
  torus { // Torus2
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <-0.854506, -0.610615, 0.0>
  }
  torus { // Torus001
    0.26, 0.01  rotate -x*90
    texture {
      rope
    }
    rotate -90.0*x
    translate  <-1.372662, -0.629551, 0.0>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    texture {
      bark
    }
    scale <0.25, 0.25, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <1.224946, -5.28948, 0.0>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    texture {
      bark
    }
    scale <0.25, 0.25, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <0.704946, -4.969086, 0.0>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    texture {
      bark
    }
    scale <0.25, 0.25, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <0.184946, -5.142489, 0.0>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    texture {
      bark
    }
    scale <0.25, 0.25, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <-0.335054, -5.404529, 0.0>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      bark
    }
    scale <0.25, 0.25, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <-0.855054, -4.998954, 0.0>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      bark
    }
    scale <0.25, 0.25, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <-1.375054, -5.196418, 0.0>
  }
  translate <camx+.25 , camy+3.5, 0>
}



