
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: 13STORM - Fighting the Elements
// Date: Jul 98
// Auth: Nathan O'Brien
// Email : no13@no13.net
// Web : www.no13.net
                             
#include "colors.inc"
#include "T_Storm.inc"


#declare Water_effect = on;
#declare Sky_effect1 = on;
#declare Sky_effect2 = on;
#declare Ship_effect = on;
#declare Radiosity_effects = on;
#declare Effects_high = on;
#declare Final_switch = on; 
#declare Flash_switch = on;

camera {
	location <0.01,3,-3>
	look_at  <0,3,0>

	translate <1,0.5,0>
}

light_source {<5,5,-5> color <1,1,1>
#if (Final_switch = on)
	area_light <3,0,0> <0,3,0> 10 10
#end
}


#if (Radiosity_effects = on)
// Constants used by 'rad_def.inc' are set in 'const.inc'
#include "consts.inc"
#if (Effects_high = off)
	#declare Rad_Quality = Radiosity_Debug;
	#else
	#declare Rad_Quality = Radiosity_Normal;
#end

#include "rad_def.inc"
#end


#if (Sky_effect1 = on)
fog {distance 20 color <0.2,0.21,0.2>}
#end

#if (Water_effect = on)
	#include "ocean.inc"
	#else
	plane {y,0 pigment{White}}
#end

#macro Clouds (P1,Rad1,Ran1,E1)

		#local Banana = seed(Ran1);
		#local R1 = (rand(Banana) * 360);
		#local R2 = (rand(Banana) * 360);
		#local R3 = (rand(Banana) * 360);
		sphere {<0,0,0>,3 pigment{color<1,1,1,1>}
			interior {
  	  		media {
    	  		emission E1
      			intervals 10
      			samples 1, 10
	      		confidence 0.9999
    	  		variance 1/1000
      			density {
        			spherical
        			poly_wave 0.5
	        		turbulence 1
    	    		color_map {
        	  		[0.0 color rgb <0,0,0>]
          			[0.1 color rgb <0.1,0.11,0.1>]
					[0.2 color rgb <0.2,0.21,0.1>]
					[0.4 color rgb <0.1,0.11,0.1>]
					[0.6 color rgb <0.3,0.2,0.1>]
          			[0.9 color rgb <0.2,0.25,0.21>]
					[1.0 color rgb <0.52,0.51,0.5>]
    	    		}
					rotate <R1,R2,R3>
	      		}
    			}
  			}
			scale Rad1
			translate P1
			hollow
		}
#end

#if (Sky_effect2 = on)

	Clouds (<0,20,40>,20,13,1)
	Clouds (<10,20,30>,20,31,1)
	Clouds (<-10,15,30>,15,11,0.5)

	Clouds (<-2,5,7>,10,101,0.5)

#end

#if (Ship_effect = on)
	#include "endevour.inc"
	object {Endevour scale .035 rotate <0,0,-15> rotate <10,-45,0> translate <-2,-1,7>}
#end

#if (Flash_switch = on)

#include "flash.inc"    

Flash (<15,15,15>,<-15,5,20>,<1.1,1.1,1>,0.02,2.0,0.05) 

Flash (<20,20,20>,<0,0,17>,<1.1,1.1,1>,0.02,2.0,0.05)  

Flash (<15,15,15>,<-15,5,20>,<1.1,1.1,1>,0.02,2.0,0.05)

#end
