// lightening macro

#declare Monica = seed(69); 	// rand value 213
#declare Flag2 = 0.005;       	// radius terminator  
#declare Adjust = 0.5;     
#declare Slength = 0.5;														// default unit length    
#declare Flag3 = 0.1;  
#declare Mini_Length = 7;


// Vector function
#macro F_Vector ()
	#local S1 = rand(Monica);
	#if (S1 < 0.5) #local S1 = -1; #else #local S1 = 1; #end
	#local S2 = rand(Monica);
	#if (S2 < 0.5) #local S2 = -1; #else #local S2 = 1; #end
	#local S3 = rand(Monica);
	#if (S3 < 0.5) #local S3 = -1; #else #local S3 = 1; #end
	#local M_Vector_A = <(rand(Monica) * S1),(rand(Monica) * S2),(rand(Monica) * S3)>;
	#declare M_Vector = vnormalize(M_Vector_A);
#end

// branch function
#macro L_Branch (Bp1,Bp2,R1,A1,C1) 
	#local L_Bfin = texture {
		pigment {
			rgb C1
		}
		finish {ambient A1}
	}
	sphere {Bp1 , R1 texture {L_Bfin} no_shadow}
	cylinder {Bp1 , Bp2 , R1 texture {L_Bfin} no_shadow}
#end

// new loop check and initiate function
#macro New_Loop (Np1,Np2,Nc1,Nr1,Nf1,Nq1,Nl1)
	#local Test_Value = rand(Monica); 
	#if (Test_Value < Nq1)  
		F_Vector()
		#local New_Length = (Adjust * Nl1); 
		#local New_Vector = vnormalize(Np2-Np1);   
		#local New_Spoint = Np1;
		#local New_Epoint = (Np1 + (New_Length * New_Vector));
		#local New_Fcolour = Nc1;
		#local New_Frad = (Adjust * Nr1);
		#local New_Ffin = Nf1;
		#local New_Bfreq = (Adjust * Nq1);
		#if (Flag2 < New_Frad)
			Flash (New_Spoint,New_Epoint,New_Fcolour,New_Frad,New_Ffin,New_Bfreq)
		#end
	#else
		#local Test_Value2 = rand(Monica); 
		#if (Test_Value2 < Flag3) 
			Mini_Branch (Np1)
		#end
	#end
#end

// mini terminating branch function
#macro Mini_Branch (Sp1) 
	#local Count1 = 0;
	#local Msp1 = Sp1;
	#local Mrad = 0.005;
	#local Mfin = 1;
	#local Mcol = <1.1,1.1,1>;  
	F_Vector ()
	#local Mtarget = ((M_Vector * Slength * Mini_Length) + Msp1);
	#while (Count1 < Mini_Length) 
		F_Vector ()
		#local Msp2 = ((vnormalize(M_Vector + Mtarget) * Slength) + Msp1);
		L_Branch (Msp1,Msp2,Mrad,Mfin,Mcol) 
		#local Msp1 = Msp2;
		#local Count1 = (Count1 + 1);
	#end		
#end

// main function
#macro Flash (Spoint,Epoint,Fcolour,Frad,Ffin,Bfreq)        


#local S_Vector = vnormalize(Epoint-Spoint);	// start vector 
#local Flag_01 = 0;														// termination flag   
#local S_Point = Spoint;
#local F_Rad = Frad;
#local F_Fin = Ffin;   
#local T_Dist = vlength(Spoint-Epoint);

#local Flag1 = 0;

#while (Flag1 = 0)    

		F_Vector()
		#local P_Vector_A = vnormalize(M_Vector + S_Vector);
		#local E_Point = ((P_Vector_A * Slength) + S_Point);
		L_Branch (S_Point,E_Point,F_Rad,F_Fin,Fcolour)
		#local S_Point = E_Point;
		#local S_Vector = vnormalize(Epoint-S_Point);

		New_Loop(S_Point,Epoint,Fcolour,Frad,Ffin,Bfreq,T_Dist)
	                 
		#local S_Dist = vlength(S_Point-Epoint);          	// terminating test
		#if (S_Dist < Slength) #local Flag1 = 1; #end                
	
#end
	
#end
