
// Persistence of Vision Ray Tracer Scene Description File
// File: Land.pov
// Vers: 3
// Desc: Main Scene for Elements
// Date: 20/07/98
// Auth: Mick Hazelgrove
//

#version 3

#include "colors.inc"
#include "textures.inc"
#include "megarch.inc"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES2.inc"
#include "STONES.inc"
#include "Glass.inc"
#include "juggler.inc"

//Radiosity-------------------------------------

   global_settings {
   max_trace_level 15
     radiosity {
       brightness 6.3
       count 250
       distance_maximum 201
       error_bound 0.2 //was 0.4
       gray_threshold 0.1
       low_error_factor 0.2 //was 0.8
       minimum_reuse 0.15 //was 0.015
       nearest_count 8
       recursion_limit 1
     }
   }

// ----------------------------------------
#declare Turn_Fog_on = 1
#declare Turn_GFog_on = 1
// ----------------------------------------
camera
{
  location  <0.0, 5, -80.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>

    focal_point < 0, 0, 0>

    aperture 0.05    // almost everything is in focus

    blur_samples 4       // fewer samples, faster to render
    blur_samples 20      // more samples, higher quality image

}

   sky_sphere {
    pigment {
      gradient y
      color_map {
        [0 color Red]
        [1 color Yellow]
      }
    }
  }


light_source{<0, 200, 100>
    color rgb <1,0.4,0.25>  // light's color
    area_light
    <8, 0, 0> <0, 0, 8> 4, 4
    adaptive 0
    jitter
}


light_source{<-100, 75, 1000> color rgb<1,0.5,0.25> }

light_source{<-100, 75, 100> color rgb<1,0.65,0.25> }

light_source{<100, 75, -100> color rgb<1,0.65,0.25> }



light_source{0*x
  color rgb <1,1,0.25>
  spotlight
  translate <0, 25, 40>
  point_at <0, 5, -150>
  radius 5
  tightness 50
  falloff 8
}


light_source{0*x
  color rgb <1,1,0.25>
  spotlight
  translate <-30, 25, -20>
  point_at <1, 5, -60>
  radius 15
  tightness 20
  falloff 8
}

// ----------------------------------------

#if (Turn_Fog_on = 1)
  fog {
    distance 50
    colour rgbt<1, 0.5, 0, 0.2>
    turbulence 0.75
    turb_depth 0.9
  }
#end

#if (Turn_GFog_on = 1)
   fog {
    distance 25 //was 35
    colour rgbf<0.5, 0.3, 0.5, 1.0>
    fog_type 2
    fog_offset 10
    fog_alt 1
    turbulence 5
    turb_depth 0.9
  }
#end


// ----------------------------------------
#declare Lake_Water = texture {
  pigment {
    color rgb <0.0, 0.25,0.25>
  }
  normal { bumps 5.75 }
  finish {
    reflection 0.9
    refraction 1.25
    ior 1.33
    phong 1.0
    phong_size 200
    metallic
  }
  scale <0.2,0.2,0.2>
}


#declare Grass_Tex =
texture {
  pigment {
    granite
    turbulence 3
    color_map {
      [0.00 0.05 color rgb <0.5, 0.35, 0.55>
      color rgb <0.25, 0.35, 0.2 >]
      [0.05 0.15 color rgb <0.25, 0.35, 0.2 >
      color rgb <0.35, 0.55, 0.27 >]
      [0.15 0.299 color rgb <0.35, 0.55, 0.27>
      color rgb <0.5, 0.5, 0.35 >]
      [0.299 0.3 color rgb <0.5, 0.5, 0.35>
      color rgb <0.25, 0.5, 0.45 >]
      [0.3 0.4 color rgb <0.25, 0.5, 0.35 >
      color rgb <0.25, 0.5, 0.35>]
      [0.4 0.6 color rgb <0.25, 0.5, 0.35 >
      color rgb <0.35, 0.4, 0.5 >]
      [0.6 1.00 color rgb <0.35, 0.4, 0.5>
      color rgb <0.3, 0.5, 0.45>]
    }
    scale 0.35
  }
}

// ----------------------------------------
height_field {gif "LSHF2.gif" texture {Grass_Tex finish{ crand 0.15 specular 0.3}}
inverse
     smooth
      water_level 0.25
       translate <-0.5,-0.525,-0.5>
         rotate y*1
           scale <150,10,150>
           hollow
normal{bump_map{ gif "LSBMbubbles2.gif"
  interpolate 2
  bump_size 5

} // end of bump_map
      rotate x*90
      scale 2.5 //was 7.5
}//end of normal dec

}

height_field {gif "LSHF3.gif" texture {Grass_Tex scale 2 finish{specular 0.25}}
     smooth
      water_level 0.1
       translate <-0.45,-0.525,-0.5>
         rotate y*1
           scale <28,5,30>
           hollow
}




disc{<0, -9, 0> y,100, texture{Lake_Water}}

// ------------------------------------------

  #declare Sun = object{
      sphere { <0,20,199.5>,30
      texture {
        pigment {color rgb <5, 5, 0>}
      }
    }
  }

  light_source {
    <0, 20, 200>
    color rgb<2.5,2.5,0>
    area_light <1, 0, 0>, <0, 1, 0>, 2, 2
    adaptive 1
    jitter
    looks_like{ Sun }
  }

// ------------------------------------------

#declare megaring = union{
#declare Angle = 0
#declare Rad = 3.5

#while (Angle <360)

object{ megarch
    scale 0.1
    translate<0,2.35,Rad>
    rotate y*Angle
    }

    #declare Angle = Angle + 45
    #end
}

object{megaring
      texture{T_Stone44}
      translate x*0.25
      rotate y*15
}

// -------------------------------------------


#declare menhir = object{
  julia_fractal {
      <-0.1,0.5,-0.85,-0.25>
      quaternion
         cube
       max_iteration 5
       precision 20
  }
}

object{ menhir
     texture {T_Stone34}finish{specular 1}
       rotate y*45
       //rotate x*25
         scale<.4,3,.4>
           scale 1.85
  translate <-4,2,-67>
}

object{ menhir
     texture {T_Stone33}
       rotate y*180
       rotate z*-2
         scale<.5,3.2,.75>
           scale 2.65
   translate <7.5,-5.00,-47>

}

object{ menhir
     texture {T_Stone33}
       rotate y*-25
       rotate z*2
         scale<.275,3.225,.275>
           scale 2.75
   translate <10,-5.00,-47>
}

object{Figure
      texture{pigment{White }
          finish{specular 0.25}}
          normal{bumps 0.5 scale 0.01}
          scale 0.4
          rotate y*160
          translate <-2.75,3.4,-67>

}

#declare Ball = difference{
         sphere{0,1}
         sphere{0,0.975}
         }

#declare White_Glass =
texture {
    pigment { color rgbf <1.98, 1.98, 1.98, 0.9> }
    finish { F_Glass3 }
    finish{specular 5}
}

object {Ball
       scale 0.1
       translate <-2,4.00,-67>
       texture{White_Glass}
       //normal{bumps 0.25 scale 0.1}
       }


#declare Green_Glass =
texture {
    pigment { color rgbf <0.8, 1.75, 0.95, 0.9> }
    finish { F_Glass3 }
    finish{specular 5}
}
object {Ball
       scale 0.1
       translate <-2,5,-66>
       texture{Green_Glass}
       //normal{bumps 0.25 scale 0.1}
       }

#declare Blue_Glass =
texture {
    pigment { color rgbf <0.0, 1.25, 1.7, 0.9> }
    finish { F_Glass3 }
    finish{specular 10}
}

object {Ball
       scale 0.1
       translate <-2.5,4.5,-66>
       texture{Blue_Glass}
       //normal{bumps 0.25 scale 0.1}
       }


#declare Red_Glass =
texture {
    pigment { color rgbf <1.25, 0.98, 0.98 0.9> }
    finish { F_Glass3 }
    finish{specular 5}
}
object {Ball
       scale 0.1
       translate <-2.25,5.5,-66>
       texture{Red_Glass}
       //normal{bumps 0.25 scale 0.1}
       }



