/* Persistence Of Vision raytracer beta version 3.1 file.
File by A. BUCK

BUCHMANN Alexandre
Quartier Novellini
B.P. 222
04000 DIGNE LES BAINS
FRANCE
EMAIL ABUCHM7158@AOL.COM
*/

#version 3.1;

#macro rotation (X,Y,Z,Angle)

#local Alpha=radians(Angle);

#local KX=X/sqrt(X*X+Y*Y+Z*Z);
#local KY=Y/sqrt(X*X+Y*Y+Z*Z);
#local KZ=Z/sqrt(X*X+Y*Y+Z*Z);

matrix <

(1-cos(Alpha))*KX*KX+cos(Alpha),
(1-cos(Alpha))*KX*KY+KZ*sin(Alpha),
(1-cos(Alpha))*KX*KZ-KY*sin(Alpha),

(1-cos(Alpha))*KX*KY-KZ*sin(Alpha),
(1-cos(Alpha))*KY*KY+cos(Alpha),
(1-cos(Alpha))*KY*KZ+KX*sin(Alpha),

(1-cos(Alpha))*KX*KZ+KY*sin(Alpha),
(1-cos(Alpha))*KY*KZ-KX*sin(Alpha),
(1-cos(Alpha))*KZ*KZ+cos(Alpha),

0, 0, 0 >

#end

global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "col_rdr.inc"
#include "glass.inc"
#include "polyreg.inc"
#include "skies.inc"
#include "woods.inc"

#declare C1 = .06;
#declare C2 = .8*C1;
#declare C3 = 1.1*C1;
#declare Angle = degrees(asin(sqrt(2/3)));
#declare Angle1 = degrees(atan2((sqrt(5)-1)/2, 1));

#declare cube1 =
difference { box { -C1, C1 }
             box { <-C3, -C2, -C2>, <C3, C2, C2> }
             box { <-C2, -C3, -C2>, <C2, C3, C2> }
             box { <-C2, -C2, -C3>, <C2, C2, C3> }
           }
camera {
   location  <-.45, .4, -1.3>
   up        <0.0,  .6,  0>
   right     <.8,  0.0,  0>
   look_at   <-.08, .1, 0>}

light_source { <.15, .64, -.45> rgb <.65, .65, .65> }
light_source { <-.4, .64, -.3> rgb <.7, .7, .7> }
light_source { <-.5, .24, -.3> rgb <.6, .6, .6> }

sky_sphere { S_Cloud2 }

// Compound of five dodecahedra
union {
object { Dodecaedre1 rotate <Angle1, 0, 0> pigment { Blanc } }
object { Dodecaedre1 rotate <Angle1, 72, 0> pigment { Jaune } }
object { Dodecaedre1 rotate <Angle1, 144, 0> pigment { Bleu } }
object { Dodecaedre1 rotate <Angle1, 216, 0> pigment { Vert_Fonce } }
object { Dodecaedre1 rotate <Angle1, 288, 0> pigment { Rouge } }
scale C1
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 }
translate <.25, C1/sin(36*pi/180), .12>
}

// Compound of three octahedra
union {
object { Octaedre rotate <Angle, 0, 0> pigment { Blanc } }
object { Octaedre rotate <Angle, 120, 0> pigment { Orange } }
object { Octaedre rotate <Angle, 240, 0> pigment { Vert } }
finish { reflection 0.2 diffuse .52 phong .75 phong_size 15 metallic }
scale 1.5*C1
translate <.04, 1.5*C1*sqrt(2/3), .18>
}

// Compound of four tetrahedra
union {
object { Tetraedre1 rotation (1, 1, 1, 180) pigment { Jaune } }
object { Tetraedre1 rotation (1, 1, -1, 180) pigment { Rouge } }
object { Tetraedre1 rotation (1, -1, -1, 180) pigment { Bleu } }
object { Tetraedre1 rotation (1, -1, 1, 180) pigment { Vert_Fonce } }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 }
rotate <45, 48, 0>
scale C1
translate <-.2, sqrt(2)*C1, .12>
}

// Compound of five cubes
union {
object { cube1 rotate <Angle1, 0, 0> pigment { Blanc } }
object { cube1 rotate <Angle1, 72, 0> pigment { Noir } }
object { cube1 rotate <Angle1, 144, 0> pigment { Jaune } }
object { cube1 rotate <Angle1, 216, 0> pigment { Rouge } }
object { cube1 rotate <Angle1, 288, 0> pigment { Vert_Fonce } }
rotate <0, 24, 0>
translate <-.4, sqrt(2)*C1*cos(radians(45-Angle1)), .18>
}

// Le meuble en acajou verni, de chez
// BADEL ET CIE (anciennement AZUR*INOX)
// 249, av. R. POINCARE - 83700 SAINT-RAPHAEL
// Tl. : 04 94 95 18 35 - Fax : 04 94 95 26 36

#declare coin =
difference { box { < -.025, -.015, -.025 >, < .025, .001, .025 > }
             cylinder { < -.025, -.016, -.025 >, < -.025, .005, -.025 >, .04 }
             pigment { Or }
             finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic }
           }

#declare ferrure =
box { < -.025, -.015, -.025 >, < .025, 0, .025 >
      pigment { Or }
      finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic }
     }

#declare poignee =
union {
difference { box { <-.045, -.0225, 0> <.045, .0225, .02> }
             box { <-.031, -.0145, -.005> <.031, .0175, .008> }
             cylinder { < -.045, -.0225, -.005>, < -.045, -.0225, .03>, .01 }
             cylinder { < -.045, .0225, -.005>, < -.045, .0225, .03>, .01 }
             cylinder { < .045, -.0225, -.005>, < .045, -.0225, .03>, .01 }
             cylinder { < .045, .0225, -.005>, < .045, .0225, .03>, .01 }
             }
             box { <-.021, .0176, 0> <.021, .0075, .01> }
             box { <-.03, .0075, 0> <-.022, .0165, .006> }
             box { <.022, .0075, 0> <.03, .0175, .006> }

difference { box { <-.0285, -.012, .002> <.0285, .008, .006> }
             box { <-.0235, -.007, 0> <.0235, .01, .008> }
           }
             pigment { Or }
             finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic }
}

// Le dessus du meuble reprsente le niveau 0.
union {
// Le plateau
box { <-.55, -.025, 0> <.55, 0, .55> }
// La paroi verticale de gauche
box { <-.55, -1, 0> <-.525, -.02, .55> }
// La paroi verticale de droite
box { <.525, -1, 0> <.55, -.02, .55> }
texture { T_Wood14 rotate 90*y finish { reflection 0.05 } scale .075 }
}

// Les coins du meuble
object { coin translate <.526, 0, .526> }
object { coin rotate <0, 90, 0> translate <.526, 0, .024> }
object { coin rotate <0, 180, 0> translate <-.526, 0, .024> }
object { coin rotate <0, 270, 0> translate <-.526, 0, .526> }

// Les tiroirs
#declare tiroir =
union {
difference { box { <-.524, -.124, 0> <.524, -.027, .02> }
             box { <-.357, -.09, -.01> <-.293, -.057, .01> }
             box { <.357, -.09, -.01> <.293, -.057, .01> }
texture { T_Wood14 rotate 90*y finish { reflection 0.05 } scale .075 }
           }
// La planche infrieure
box { <-.55, -.15, 0> <.55, -.125, .55>
texture { T_Wood14 rotate 90*y finish { reflection 0.05 } scale .075 }
 }
// La poigne de gauche
object { poignee translate <-.325, -.075, -.001> }
// La poigne de droite
object { poignee translate <.325, -.075, -.001> }
// Les ferrures
object { ferrure translate <.526, -.13, .024> }
object { ferrure translate <-.526, -.13, .024> }
}

object { tiroir }
object { tiroir translate <0, -.125, 0> }
object { tiroir translate <0, -.25, 0> }
object { tiroir translate <0, -.375, 0> }
object { tiroir translate <0, -.5, 0> }
object { tiroir translate <0, -.625, 0> }
object { tiroir translate <0, -.75, 0> }

// L'encadrement de fentre
difference {
union {
box { <-2, -2, .62> <2, 2, 1.05> pigment { Orchidee_Moyen2 } }
box { <-.5, -.08, .6> <.5, 1.35, .63> pigment { Vert_Printemps } }
}
union {
box { <-.41, .02, .55> <.41, 1.25, 1.10> pigment { Vert_Printemps } }
box { <-.45, .025, .8> <.45, 1.25, .9> pigment { Gris } }
}
finish { reflection 0.1 diffuse .52 phong .75 phong_size 15 }
}

// La tablette de fentre
box { <-.52, .005, .58> <.52, .025, .9>
texture { T_Wood7 scale 5 rotate 90*y }  }

#declare fenetre =
union {
// la vitre
box { <-.4, .05, .82> <.40, .63, .83> texture {T_Glass4} }
// Montant verticaux du cadre
// gauche
difference {
box { <-.45, .02, .8> <-.39, .66, .845> }
cylinder { < -.39, .01, .8 >, < -.39, .67, .8 >, .005 }
}
// droit
difference {
box { <.39, .02, .8> <.45, .66, .845> }
cylinder { < .39, .01, .8 >, < .39, .67, .8 >, .005 }
}
// Partie basse du cadre
difference {
box { <-.45, .02, .8> <.45, .06, .845> }
cylinder { < -.46, .06, .8 >, < .46, .06, .8 >, .005 }
}
// Partie haute du cadre
difference {
box { <-.45, .62, .8> <.45, .66, .845> }
cylinder { < -.46, .62, .8 >, < .46, .62, .8 >, .005 }
}
// Sparateur vertical de gauche
difference {
box { <-.21, .02, .8> <-.19, .66, .845> }
cylinder { < -.21, .01, .8 >, < -.21, .67, .8 >, .005 }
cylinder { < -.19, .01, .8 >, < -.19, .67, .8 >, .005 }
}
// Sparateur vertical du milieu
difference {
box { <-.01, .02, .8> <.01, .66, .845> }
cylinder { < -.01, .01, .8 >, < -.01, .67, .8 >, .005 }
cylinder { < .01, .01, .8 >, < .01, .67, .8 >, .005 }
}
// Sparateur vertical de droite
difference {
box { <.19, .02, .8> <.21, .66, .845> }
cylinder { < .19, .01, .8 >, < .19, .67, .8 >, .005 }
cylinder { < .21, .01, .8 >, < .21, .67, .8 >, .005 }
}
// sparateur horizontal
difference {
box { <-.45, .33, .8> <.45, .35, .845> }
cylinder { < -.46, .33, .8 >, < .46, .33, .8 >, .005 }
cylinder { < -.46, .35, .8 >, < .46, .35, .8 >, .005 }
}
pigment { Blanc }
finish { reflection 0 diffuse .52 phong .75 phong_size 15 }
}

// Service fixe
// object { fenetre translate <0, .59, .055> }
// Service coulissant
object { fenetre translate <0, .2, 0> }

// La mer
plane { y, -8.5 pigment { Bleu }
finish { reflection 0.1 diffuse .52 phong .75 phong_size 15 } }
