// Persistence of Vision Raytracer Version 3.0
//
// file: 5lmnts.pov     autor: -- jd --     version: 290798
// The 5 classical elements represented by the Platonic bodies

#version 3

#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "textures.inc"
#include "stones1.inc"

// the eye
camera {
    location  <20, 15, 0>
    direction <0, 0, 1>
    up        <0, 1, 0>
    right     <4/3, 0, 0>
    look_at   <100, 0, 0>
}

// the sun
light_source {
    <110, 5, 0> color <0.9, 0.75, 0.45>
    spotlight point_at <1000, -70, 0>
    radius 10 falloff 20 tightness 200
}
light_source {
    <600, 100, 0> color White
}
object {
    Sphere hollow
    texture {
        pigment {color Clear}
        halo {
            linear
            max_value 1.0
            spherical_mapping
            emitting
            turbulence 0
            color_map
            { [0 color rgbt <1,1,0.8,0.78>] [1 color rgbt <1,0.8,0.5,0>] }
            samples 10
        }
    }
    scale 60 translate <600,100,0>
}


// the fire
object {
    Tetrahedron
    pigment { color rgbt<0.9, 0, 0, 0.4 > }
    finish { specular 1 reflection 0.8 caustics 1.5 }
    rotate y*20
    scale 0.66
    translate <35,7,-1>
}

// the earth
object {
    Cube
    pigment { color rgbt<0, 0.8, 0, 0.4 > }
    finish { specular 1 reflection 0.8 caustics 1.5 }
    scale 0.88
    rotate y*45
    rotate x*20
    translate <45,8,1>
}

// the air
object {
    Octahedron
    pigment { color rgbt<1.0, 1.0, 0, 0.5 > }
    finish { specular 1 reflection 0.8 caustics 1.5 }
    scale 0.82
    rotate y*33
    translate <41,8,-5>
}

// the water
object {
    Icosahedron
    pigment { color rgbt<0, 0, 0.8, 0.4 > }
    finish { specular 1 reflection 0.8  caustics 1.5 }
    translate <39,8,5>
}

// the universe
object {
    Dodecahedron
    pigment { color rgbt<0.4, 0, 0.5, 0.25 > }
    finish { specular 1 reflection 0.5 caustics 5 }
    translate <40,8,0>
}

// the sky
object {
    Sphere hollow
    scale 2000
    pigment {
        bozo
        turbulence 0.66
        color_map {
            [0.0, 0.4 color rgb <0.6, 0.6, 1.0>
                      color rgb <0.8, 0.6, 1.0>]
            [0.4, 0.6 color rgb <0.8, 0.6, 1.0>
                      color rgb <1.0, 0.95, 0.9>]
            [0.7, 1.0 color rgb <1.0, 0.95, 0.9>
                      color rgb <0.9, 0.7, 0.8>]
        }
        scale 900
    }
}

// the island
height_field {
    png "5elements-island.png"
    water_level 0.001
    smooth
    pigment { color Gray10 }
    texture { T_Stone7 }
    finish { ambient 0.1 }
    scale <180, 9, 180>
    translate <-80, -6.5, -80>
    rotate y*110
    translate <15, 0, 0>
}
object {
    Sphere hollow
    texture {
        pigment {color Clear}
        halo {
            cubic
            max_value 1.0
            spherical_mapping
            dust
            turbulence 2
            color_map { [0 color rgbt <1,1,1,1>] [1 color rgbt <1,1,1,0.1>] }
        }
    }
    scale <120, 10, 120> translate <25,-5,15>
}


// the sea
plane { y, -6
    pigment { color SlateBlue }
    normal {
        waves 1.0
        frequency 7.0
        scale 7.0
     }
     finish{ ambient 0.05 diffuse 0.5 reflection 0.7 }
}

// the fog
fog {
    color White
    distance 2000
}
fog {
    distance 5200
    color rgbt <1.0, 0.80, 0.65, 0.1>
    fog_type 2
    fog_offset 1
    fog_alt 25
}
