
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//
#version 3



#include "colors.inc"
#include "finish.inc"
#include "metals.inc"
#include "textures.inc"
#include "golds.inc"
#include "bolts.inc"
#include "clamps.inc"

// ----------------------------------------



#declare  silver=
texture {
  pigment { rgb <.90, .91, .95> }
  finish { F_MetalB  }
}

#declare  myCopper=
texture {
  pigment { Brass*2  }
  finish { F_MetalA  }
}

#declare Bronze_Metal = texture {
  pigment { color rgb <0.55, 0.47, 0.14>*1.35}
  finish {
    metallic
    ambient 0.2
    diffuse 0.7
    brilliance 6
    reflection 0.25
    phong 0.75
    phong_size 80
  }
}

#declare shinyBlack=
texture{
  pigment{White*.2}
  #ifndef (TestMode)
    finish {
      ambient 0.35
      brilliance 2
      diffuse 0.3
      metallic
      specular 0.80
      roughness 1/10
      reflection 0.17
      crand 0.05
    }
  #end
}

#declare Brick_Texture = texture {
    pigment {
        brick Gray40, Gray50
    }
    finish {
        crand 0.003
        diffuse 0.6 ambient 0.20
    }
}



#declare yRotate=-45
#declare fadeDistance=15
#declare Brightness=0.10

#declare lightFixture=
union{
  cylinder{<0,1.25,0>,<0,75,0> 1/12 pigment{Silver}}
  object{
    sphere{<0,0,0> , 1
    texture{myCopper}
    scale<1,1.5,1>}
    clipped_by{plane{y,0 inverse}}
    no_shadow
  }
  object{
    sphere{<0,0,0> , 1 texture{Polished_Chrome}  scale<1,1.5,1>*.97}
    clipped_by{plane{y,0 inverse}}
    no_shadow
  }

  light_source{<0,0,0>
    color White*Brightness
    #ifdef (UseAreaLights)
      area_light
      <0.65, 0, 0> <0, 0, 0.65> // lights spread out across this distance (x * z)
      3, 3                // total number of lights in grid (4x*4z = 16 lights)
      adaptive 1          // 0,1,2,3...
      jitter              // adds random softening of light
   #end

    fade_distance fadeDistance
    fade_power(1)
    looks_like { sphere{<0,0.4,0> .65 pigment{color rgb <1.000, 1.000, 0.784>*10}}}
  }
}

#declare core=
difference{
  cylinder { <0,0,0>, <0,50,0>, 4.0  }
  #declare deg=0
  #while (deg< 360)
    cylinder { <4,-1,0>, <4,55,0>, .5  rotate<0,deg,0>}
    #declare deg= deg+30
  #end
  texture {
    pigment { color SteelBlue }
    #ifndef (TestMode)
      finish {
        metallic
        ambient 0.2
        diffuse 0.7
        brilliance 6
        reflection 0.25
        phong 0.75
        phong_size 80
      }
    #end
  }
}



#declare upperCore=
difference{
  cylinder { <-196,0,0>, <-145,0,0>, 1.5  }
  #declare deg=0
  #while (deg< 360)
    cylinder { <-200,0,-1.5>, <-140,0,-1.5>, .18  rotate<deg,0,0>}
    #declare deg= deg+30
  #end
  texture {
    pigment { color SteelBlue*1.25 }
    #ifndef (TestMode)
      finish {
        metallic
        ambient 0.2
        diffuse 0.7
        brilliance 6
        reflection 0.25
        phong 0.75
        phong_size 80
      }
    #end
  }
}

#declare smallCoil=
  torus{  1.75,  0.875
    texture{
      pigment{
        image_map{
          tga "s2.tga"   // the file to read (iff/gif/tga/png/sys)
          map_type 5          // 0=planar, 1=spherical, 2=cylindrical, 5=torus
          interpolate 0       // 0=none, 1=linear, 2=bilinear, 4=normalized distance
        }                     // image_map
      }
      #ifndef (TestMode)
        finish { F_MetalB  }
      #end
      scale 3
    }
    rotate<0,0,90>
  }


#declare upperCoil=
union{
  object{upperCore }
  object{smallCoil translate<-188,0,0>}
  object{smallCoil translate<-180.5,0,0>}
  object{smallCoil translate<-173,0,0>}
  object{smallCoil translate<-165.5,0,0>}
  object{smallCoil translate<-158,0,0>}
}

#declare upperCoilArray=
union{
  object{upperCoil translate<0,48,0>}
  object{upperCoil translate<0,48,0> rotate<0,15,0>}
  object{upperCoil translate<0,48,0> rotate<0,30,0>}
  object{upperCoil translate<0,48,0> rotate<0,45,0>}
  object{upperCoil translate<0,48,0> rotate<0,-15,0>}
  object{upperCoil translate<0,48,0> rotate<0,-30,0>}
}

#declare Glass =
texture {
  pigment { color rgbf<1.0, 1.0, 1.0, 0.9> }
  finish  { Glass_Finish }
}


#declare glassShield1=
difference{
  cylinder { <0,10,0>, <0,40.25,0>, 10.25}
  cylinder { <0,5,0>, <0,45,0>, 10.1667}
  texture{Glass}
}



#declare Density=
  density {
    spherical
    ramp_wave
    color_map {
      [0.0 color rgb <0.0, 0.0, .1>]
      [0.5 color rgb <0.1, 0.1, .3>]
      [1.0 color rgb <0.8, 0.8, 1>]
    }
  }

#declare blueGlow=
cylinder { <0,10,0>, <0,40,0>, 6
  pigment { color rgbf<1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }
  interior {
    media {
      emission .5
      intervals 5
      samples 1, 5
      confidence 0.9999
      variance 1/1000
      density {Density}
    }
  }
  hollow
}


// F_MetalA  :  Very soft and dull.
// F_MetalB  :  Fairly soft and dull.
// F_MetalC  :  Medium reflectivity. Holds color well.
// F_MetalD  :  Highly hard and polished. High reflectivity
// F_MetalE  :  Very highly polished & reflective.


#declare bigCoil=
torus{  7.5,  2.5
  #ifndef (TestMode)
    texture{
      pigment{
        image_map{
          tga "s2.tga"   // the file to read (iff/gif/tga/png/sys)
          map_type 5          // 0=planar, 1=spherical, 2=cylindrical, 5=torus
          interpolate 0       // 0=none, 1=linear, 2=bilinear, 4=normalized distance
        }                     // image_map
      }
      finish { F_MetalB  }
      scale 10
    }
  #else
    texture{
      pigment{
        image_map{
          tga "s2.tga"   // the file to read (iff/gif/tga/png/sys)
          map_type 5          // 0=planar, 1=spherical, 2=cylindrical, 5=torus
          interpolate 0       // 0=none, 1=linear, 2=bilinear, 4=normalized distance
        }                     // image_map
      }
      scale 10
    }
  #end
}


//========================<<< start big coil >>>========================
#declare coil=
union{
  torus{  11.375,  .1875 pigment{OrangeRed*1.5} translate<0,5,0>}
  torus{  11.375,  .1875 pigment{OrangeRed*1.5} translate<0,2.5,0>}
  cylinder { <11.375,0,0>, <11.375,5.0,0>, .1875 pigment{OrangeRed} rotate<0,15,0>}
  cylinder { <11.375,0,0>, <11.375,5.0,0>, .1875 pigment{OrangeRed} rotate<0,45+15,0>}
  cylinder { <11.375,0,0>, <11.375,5.0,0>, .1875 pigment{OrangeRed} rotate<0,90+15,0>}
  cylinder { <11.375,0,0>, <11.375,5.0,0>, .1875 pigment{OrangeRed} rotate<0,135+15,0>}
  cylinder { <11.375,0,0>, <11.375,5.0,0>, .1875 pigment{OrangeRed} rotate<0,180+15,0>}
  cylinder { <11.375,0,0>, <11.375,5.0,0>, .1875 pigment{OrangeRed} rotate<0,225+15,0>}
  cylinder { <11.375,0,0>, <11.375,5.0,0>, .1875 pigment{OrangeRed} rotate<0,270+15,0>}
  cylinder { <11.375,0,0>, <11.375,5.0,0>, .1875 pigment{OrangeRed} rotate<0,315+15,0>}

  object{bigCoil translate<0,10,0> rotate<0,rand(R2)*360,0>}
  object{bigCoil translate<0,25,0> rotate<0,rand(R2)*360,0>}
  object{bigCoil  translate<0,40,0> rotate<0,rand(R2)*360,0>}

  box{<-8,0,-8>,<8,.5,8>
    texture{pigment{color Wheat*1.5 }}
    finish{Dull}
    normal {bumps .2
          scale<.1,.01,.1>
    }
  }

  #ifndef (TestMode)
    object{boltHead scale .125 translate<6.5,.5,-6.5> }
    object{boltHead scale .125 translate<6.5,.5,6.5> }
    object{boltHead scale .125 translate<-6.5,.5,-6.5> }
    object{boltHead scale .125 translate<-6.5,.5,6.5> }
    object{blueGlow}
  #end

  object{core}


  #ifndef (TestMode)
    light_source{<0,17.5,-8.25>  color Blue*.05 shadowless fade_distance 5 fade_power(1) }
    light_source{<0,17.5,-8.25>  color Blue*.05 shadowless fade_distance 5 fade_power(1) rotate<0,-90,0>}
    light_source{<0,17.5,-8.25>  color Blue*.05 shadowless fade_distance 5 fade_power(1) rotate<0,90,0>}
    light_source{<0,32.5,-8.25>  color Blue*.05 shadowless fade_distance 5 fade_power(1)}
    light_source{<0,32.5,-8.25>  color Blue*.05 shadowless fade_distance 5 fade_power(1) rotate<0,-90,0>}
    light_source{<0,32.5,-8.25>  color Blue*.05 shadowless fade_distance 5 fade_power(1) rotate<0,90,0>}

    light_source{< 0,7,-5>  color White*.2 fade_distance 10 fade_power(1)}
    light_source{<-5,7, 0>  color White*.2 fade_distance 10 fade_power(1)}
    light_source{< 5,7, 0>  color White*.2 fade_distance 10 fade_power(1)}
  #end
} //======================<<< end big coil >>>=========================

#declare bigCoilArray=
union{
  object{coil rotate<0,rand(R2)*360,0> translate<-200,0,0>}
  object{coil rotate<0,rand(R2)*360,0> translate<-200,0,0> rotate<0,15,0>}
  object{coil rotate<0,rand(R2)*360,0> translate<-200,0,0> rotate<0,30,0>}
  object{coil rotate<0,rand(R2)*360,0> translate<-200,0,0> rotate<0,45,0>}
  object{coil rotate<0,rand(R2)*360,0> translate<-200,0,0> rotate<0,-45,0>}
  object{coil rotate<0,rand(R2)*360,0> translate<-200,0,0> rotate<0,-30,0>}
  object{coil rotate<0,rand(R2)*360,0> translate<-200,0,0> rotate<0,-15,0>}
}



#declare mainConduit=
union{
  torus{150.17,0.16667 translate<0,30,0>}
  torus{150.17,0.16667 translate<0,30.4,0> }
  torus{150.17,0.16667 translate<0,30.8,0> }
  torus{150.17,0.16667 translate<0,31.2,0> }
  torus{150.17,0.16667 translate<0,31.6,0> }
  torus{150.17,0.16667 translate<0,32.0,0> }
  torus{150.17,0.16667 translate<0,32.4,0> }
  torus{150.17,0.16667 translate<0,32.8,0> }
  torus{150.17,0.16667 translate<0,33.2,0> }
  torus{150.17,0.16667 translate<0,33.6,0> }
  torus{150.17,0.16667 translate<0,34.0,0> }
  cylinder{ <-150.17,48,0>, <-150.17,34.4,0>, 0.1667 rotate<0,-15,0>}
  cylinder{ <-150.17,48,0>, <-150.17,38.4,0>, 0.1667 rotate<0,-30,0>}
  object{
    torus{150.17,0.16667 }
    clipped_by{plane{z,0 rotate<0,-15,0>}}
    clipped_by{plane{z,0 rotate<0,-28.5,0> inverse}}
    translate<0,34.4,0>
  }
  object{
    torus{4,0.16667 }
    clipped_by{plane{z,0 }}
    clipped_by{plane{x,0 inverse}}
    rotate<-90,90,-.25>
    translate<-150.17,38.4,0>
    rotate<0,-28.49,0>
  }
  #ifndef (TestMode)
    texture{silver}
  #else
    pigment{Silver }
  #end
}


#declare chamberCutOut=
difference{
  torus{  148,  22}
  box{<-200,-25,0>,<200,25,200>}
  box{<-200,-25,0>,<200,25,-200> rotate<0,-15,0>}
  translate<3,0,0>
  rotate<0,-15,0>
}

#declare taperTorus=
union{
  #declare yrot=-19.5
  #declare xradius=2.5

  difference{
    torus{  140,  2.5   }
    box{<-200,-25,0>,<200,25,200>rotate<0,-19.5,0>}
    box{<-200,-25,0>,<200,25,-200> rotate<0,-20,0>}
  }

  #while (yrot < -10)
    difference{
      torus{  140,  xradius}
      box{<-200,-25,0>,<200,25,200>rotate<0,yrot+.25,0>}
      box{<-200,-25,0>,<200,25,-200> rotate<0,yrot,0>}
    }
    #declare yrot=yrot+.25
    #declare xradius=xradius*1.02951
  #end
  difference{
    torus{  140,  2.5   }
    cylinder { <-7.5, 0, 0>, <7.5, 0, 0>, 6.5 rotate<0,90,0> translate<-140,0,0> rotate<0,-27,0> }
  }
  #ifndef (TestMode)
    texture{T_Silver_3B}
  #else
    pigment{Silver}
  #end
}

#declare cyclotron=
union{
  difference{
    cylinder {  <0,0,0>, <0,55,0>, 150}
    object{chamberCutOut}

    torus{  140,  8 translate<0,10,0>}
    pigment{color rgb <1.000, 0.9, 0.65>*1.5}
    normal{
      wrinkles 0.2
      scale 0.4
    }
  }

  object{taperTorus translate<0,10,0> rotate<0,5,0>}

  union{
    difference{
      cylinder {  <-140,10,0>, <-140,10,-1/12>, 9.5}
      cylinder {  <-140,10,-1>, <-140,10,1>, 8}
      #ifndef (TestMode)
        texture{T_Gold_2B}
      #else
        pigment{BrightGold}
      #end
    }

    #declare zrot=0
    #while (zrot < 360)
      object{
       boltHead scale .08 rotate<-90,0,0>
       translate<-8.75,0,0> rotate<0,0,zrot>
       translate<-140,10,-1/12>
      }
      #declare zrot = zrot + 20
    #end
    rotate<0,-15,0>
  }
  light_source {<-147,10,0> color Red*.25
    #ifdef (UseAreaLights)
      area_light
     <0.16, 0, 0> <0, 0, 0.16> // lights spread out across this distance (x * z)
     3, 3                // total number of lights in grid (4x*4z = 16 lights)
     adaptive 1          // 0,1,2,3...
     jitter              // adds random softening of light
   #end
    fade_distance 8 fade_power(1) rotate<0,-10,0>
  }
  light_source {<-140,17,0> color Red*.25
    #ifdef (UseAreaLights)
      area_light
      <0.16, 0, 0> <0, 0, 0.16> // lights spread out across this distance (x * z)
      3, 3                // total number of lights in grid (4x*4z = 16 lights)
      adaptive 1          // 0,1,2,3...
      jitter              // adds random softening of light
    #end
    fade_distance 8 fade_power(1) rotate<0,-10,0>
    fade_distance 8 fade_power(1) rotate<0,-10,0>
  }
  light_source {<-140,3,0> color Red*.25
    #ifdef (UseAreaLights)
      area_light
      <0.16, 0, 0> <0, 0, 0.16> // lights spread out across this distance (x * z)
      3, 3                // total number of lights in grid (4x*4z = 16 lights)
      adaptive 1          // 0,1,2,3...
      jitter              // adds random softening of light
    #end

    fade_distance 8 fade_power(1) rotate<0,-10,0>
    fade_distance 8 fade_power(1) rotate<0,-10,0>
  }
  light_source {<-133,10,0> color Red*.25
    #ifdef (UseAreaLights)
      area_light
      <0.16, 0, 0> <0, 0, 0.16> // lights spread out across this distance (x * z)
      3, 3                // total number of lights in grid (4x*4z = 16 lights)
      adaptive 1          // 0,1,2,3...
      jitter              // adds random softening of light
    #end

    fade_distance 8 fade_power(1) rotate<0,-10,0>
    fade_distance 8fade_power(1)rotate<0,-10,0>
  }
}


//=====================<<< end upper floor >>>=======================

//============<<< start roof >>>=======================
#declare roof=
union{
  object{
      sphere{<0,-1448.6,0>, 1573.6}
    clipped_by{plane{y,75 inverse}}
    pigment{White}
  //texture{silver}
    hollow
  }

  #declare truss=
  object{
    union{
      difference{
         cylinder{<0,-1448.6,-1>,<0,-1448.6,1> 1573.6 }
         cylinder{<0,-1448.6,-5>,<0,-1448.6,5> 1573.0 }
      }
      difference{
         cylinder{<0,-1448.6,-1>,<0,-1448.6,1> 1568.6 }
         cylinder{<0,-1448.6,-5>,<0,-1448.6,5> 1568.0 }
      }
      difference{
         cylinder{<0,-1448.6,-0.08>,<0,-1448.6,0.08> 1573.6 }
         cylinder{<0,-1448.6,-5>,<0,-1448.6,5> 1568.0 }
      }
    }
    clipped_by{plane{y,70 inverse}}
    clipped_by{plane{x,0 }}
    pigment{OrangeRed}
    hollow
  }
  object{truss rotate<0,60,0>}
  object{truss rotate<0,50,0>}
  object{truss rotate<0,40,0>}
  object{truss rotate<0,30,0>}
  object{truss rotate<0,20,0>}
}



#declare glassCylinder=
union{
  difference{
    merge{
      cylinder{<0,0,0>,<0,1.5,0> 1.35}
      torus{1.27, 0.08  translate<0,1.5,0>}
      cylinder{<0,1.5,0>,<0,1.58,0> 1.27}
    }
    union{
      cylinder{<0,0,0>,<0,1.5,0> 1.35 }
      torus{1.27, 0.08  translate<0,1.5,0>}
      cylinder{<0,1.5,0>,<0,1.58,0> 1.27 }
      scale <.99,.98,.99>
    }
    #ifndef (TestMode)
      texture{Glass3}
    #else
      pigment{Red}
    #end
  }
  difference{
    cylinder{<0,0,0>,<0,.15> 1.4}
    cylinder{<0,-1,0>,<0,2,0> 1.28}
    texture{shinyBlack}
  }
}

#declare junctionBox=
union{
  box{<-145,28,-3>,<-151.5,36,3>
    rotate<0,-15,0>
    texture{
      pigment{color rgb <0.353, 0.353, 0.467>}
      #ifndef (TestMode)
        finish {
          ambient 0.35
          brilliance 2
          diffuse 0.3
          metallic
          specular 0.80
          roughness 1/10
          reflection 0.17
          crand 0.05
        }
      #end
    }
  }
  object{glassCylinder rotate<0,0,90> translate<-151.5,34,0> rotate<0,-15,0>}
  object{glassCylinder rotate<0,0,90> translate<-151.5,30,0> rotate<0,-15,0>}

  union{
    cylinder {<-150.5,0,0>, <-150.5,28,0>, 5/12 rotate<0,-15,0>}
    cylinder {<-150.5,6,0>, <-150.5,6.5,0>, .5 rotate<0,-15,0>}
    cylinder {<-150.5,12,0>, <-150.5,12.5,0>, .5 rotate<0,-15,0>}
    cylinder {<-150.5,18,0>, <-150.5,18.5,0>, .5 rotate<0,-15,0>}
    cylinder {<-150.5,24,0>, <-150.5,24.5,0>, .5 rotate<0,-15,0>}
    texture{shinyBlack}
  }
}



//=====================<<< start upper floor >>>=======================
#declare upperFloor=
difference{
  cylinder {<0,0,0>, <0,55,0>, 280}
  cylinder {<0,-10,0>, <0,120,0>, 250}
  #ifndef (TestMode)
    texture{Brick_Texture}
  #else
    pigment{White*.7}
  #end

}

torus{  250.5,  .1875 pigment{Yellow*1.5} translate<0,60,0>}
torus{  250.5,  .1875 pigment{Yellow*1.5} translate<0,57.5,0>}

#declare onePost=
  cylinder { <-250.5,55,0>, <-250.5,60.0,0>, .1875 pigment{Yellow}}
#declare yrotate=-15
#while(yrotate < 60)
  object{onePost rotate<0,yrotate,0>}
  #declare yrotate=yrotate + 3
#end
//=====================<<< end upper floor >>>=======================


#declare outerWall=
difference{
  cylinder {<0,0,0>, <0,75,0>, 280}
  cylinder {<0,-10,0>, <0,120,0>, 275}
  pigment{White*.8}
  normal{
    wrinkles 0.2
    scale 0.1
  }
}

#declare mainFloor=
plane{  y,  0.0
  texture{
    pigment{color rgb <0.882, 0.882, 0.784>}
    #ifndef (TestMode)
      normal{
        wrinkles 0.1
        scale<1,.2,1>
      }
      finish{Shiny}
    #end
  }
}
