
#version 3

#ifndef (UseAsIncludeFile)

  #include "colors.inc"
  #include "finish.inc"
  #include "metals.inc"
  #include "textures.inc"

  #declare not_TestMode=1
  global_settings{
    assumed_gamma 2.2
  }

// ----------------------------------------
  camera{
    location  <0.0,20, -30>
    direction 1.5*z
    right     4/3*x
    look_at   <0.0, 10.0,  0.0>
  }

  sky_sphere{
    pigment{
      gradient y
      color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
    }
  }

  light_source{
    0*x // light's position (translated below)
    color White*1.5
    translate <30, 100, -100>
  }

// ----------------------------------------

#declare  silver=
texture {
  pigment { rgb <.90, .91, .95> }
  finish { F_MetalB  }
}

#declare Bronze_Metal = texture {
  pigment { color rgb <0.55, 0.47, 0.14>*.75 }
  finish {
    metallic
    ambient 0.2
    diffuse 0.7
    brilliance 6
    reflection 0.25
    phong 0.75
    phong_size 80
  }
}



#declare boltHead=
union{
  intersection{
    prism {
      linear_sweep
      linear_spline
      0, 5.3,
      7,
      <3.55,6.15>,<7.1,0>,<3.55,-6.15>,<-3.55,-6.15>,
      <-7.01,0>,<-3.55,6.15>,<3.55,6.15>
    }
    cone { <0,4.61+4.0,0>, 0.0001, <0,0+4.0,0>, 8.0}
  }

  prism {
    linear_sweep
    linear_spline
    0, 4.35,
    7,
    <3.55,6.15>,<7.1,0>,<3.55,-6.15>,<-3.55,-6.15>,
    <-7.01,0>,<-3.55,6.15>,<3.55,6.15>
  }

  #if (not_TestMode)
    texture{silver}
  #else
    pigment{Green}
  #end
}



#declare bolt=
union{
  object{boltHead}
  cylinder { <0,0,0>, <0,-35,0>, 3.85
    #if (not_TestMode)
      texture{silver}
    #else
      pigment{Green}
    #end
  }
}

#end


#declare XmainChamber =
union{
  cylinder { <-8, 0, 0>, <8, 0, 0>, 6}
  difference{
    sphere{<0,0,0>, 6}
    box{<0,-10,-10>,<10,10,10>}
    scale<.5,1,1>
    translate<-8,0,0>
  }
  difference{
    sphere{<0,0,0>, 6}
    box{<0,-10,-10>,<-10,10,10>}
    scale<.5,1,1>
    translate<8,0,0>
  }
}

#declare mainChamber =
union{
  difference{
    object{XmainChamber}
    object{XmainChamber scale .98}
    cylinder { <0,0,0>, <0,10,0>, 2.5  rotate<-45,0,0>}
    texture{Bronze_Metal }
  }
  difference{
   cylinder { <0,5.4,0>, <0,6.25,0> 2.52}
   cylinder { <0, 5, 0>, <0, 10, 0>, 2.25 }
   rotate<-45,0,0>
   texture{Bronze_Metal}
  }

   union{
    object{bolt  scale .0125 translate<0,6.42,-2.385>}
    #declare yrot=20
    #while (yrot < 360)
      object{bolt  scale .0125 translate<0,6.42,-2.385> rotate<0,yrot,0>}
      #declare yrot=yrot+20
    #end
    rotate<-45,0,0>
  }
  cylinder { <0,6.25,0>, <0,6.42,0> 2.52 texture{NBoldglass} rotate<-45,0,0>}
  light_source{ <0,0,0> color White*4 fade_distance 10 fade_power(1)}
}


#declare collisionChamber=
union{
  #declare xrot=-70
  #while (xrot < 90)
    object{boltHead scale .04 rotate<-90,0,0>
      translate<-4.5,0,-6.1667>
      rotate<xrot,0,0> translate<0,10,0>
    }
    object{boltHead scale .04 rotate<-90,0,0>
      translate<4.5,0,-6.1667>
      rotate<xrot,0,0> translate<0,10,0>
    }
    #declare xrot=xrot+20
  #end

  difference{
   cylinder { <-5, 10, 0>, <-4, 10, 0>, 6.1667}
   cylinder { <-10, 10, 0>, <0, 10, 0>, 6  }
   texture{Bronze_Metal}
  }
  difference{
   cylinder { <5, 10, 0>, <4, 10, 0>, 6.1667}
   cylinder { <0, 10, 0>, <10, 10, 0>, 6  }
   texture{Bronze_Metal}
  }
  object{mainChamber translate<0,10,0>}
}

#ifndef (UseAsIncludeFile)
  object{collisionChamber rotate<0,-30,0>}
#end

