#version 3


#include "colors.inc"
#include "textures.inc"



#ifndef (UseAsIncludeFile)
global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------

camera
{
  location  <0.0, 1,-1>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
#end

#declare blackBoltHead=
union{
  intersection{
    prism {
      linear_sweep
      linear_spline
      0, 5.3,
      7,
      <3.55,6.15>,<7.1,0>,<3.55,-6.15>,<-3.55,-6.15>,
      <-7.01,0>,<-3.55,6.15>,<3.55,6.15>
    }
    cone { <0,4.61+4.0,0>, 0.0001, <0,0+4.0,0>, 8.0}
  }

  prism {
    linear_sweep
    linear_spline
    0, 4.35,
    7,
    <3.55,6.15>,<7.1,0>,<3.55,-6.15>,<-3.55,-6.15>,
    <-7.01,0>,<-3.55,6.15>,<3.55,6.15>
  }
  #ifndef (TestMode)
    texture{
      pigment{White*.25}
      finish {
        ambient 0.35
        brilliance 2
        diffuse 0.3
        metallic
        specular 0.80
        roughness 1/10
        reflection 0.17
        crand 0.05
      }
    }
  #else
    pigment{Green}
  #end
}


#declare clamp=
union{
  union{
    difference{
      cylinder{<0,-.75/12,0>, <0,.75/12,0> 2.25/12}
      cylinder{<0,-1,0>, <0,1,0> 2.0/12}
      box{<-1,1,0>,<1,-1,1>}
    }
    box{<2/12,-.75/12,0>,<3/12,.75/12,-.25/12>}
    box{<-2/12,-.75/12,0>,<-3/12,.75/12,-.25/12>}
    cylinder{<3/12,0,0>, <3/12,0,-.25/12> .75/12}
    cylinder{<-3/12,0,0>, <-3/12,0,-.25/12> .75/12}
    texture{Soft_Silver}
  }
  object{blackBoltHead scale .005 rotate<-90,0,0> translate<-3/12,0,-.25/12>}
  object{blackBoltHead scale .005 rotate<-90,0,0> translate<3/12,0,-.25/12>}
}

#ifndef (UseAsIncludeFile)
  clamp
#end
