 #version 3

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "finish.inc"


global_settings
{
  assumed_gamma 2.2
}


#ifndef (UseAsIncludeFile)

// ----------------------------------------

camera
{
  location  <50, 75,-250>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 20,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color White*2
  translate <75,200, -500>
}

plane { y, 0 pigment {color rgb <0.7,0.5,0.3>}}

#end
// ----------------------------------------



#declare forkLiftOrange =
texture {
  pigment { color rgb <1.000, 0.310, 0.031>}
  #ifndef (TestMode)
    finish {
      ambient 0.25
      diffuse 0.35
      phong 0.5
      phong_size 20.0
    }
  #end
}


#declare blackTexture=
texture{
  pigment{White*.2}
  #ifndef (TestMode)
    finish {
      ambient 0.35
      brilliance 2
      diffuse 0.3
      metallic
      specular 0.80
      roughness 1/10
      reflection 0.17
      crand 0.05
    }
  #end
}

#declare tiller=
union{
  cylinder { <30,45,0>, <30,50,0>, 1.5 texture{Aluminum}}
  box{<28,50,-3>,<32,55,3> texture{blackTexture}}
  cylinder { <30,52.5,-4>, <30,52.5,4>, .375 texture{Aluminum}}

  union{
    box{<29.25,52.5,-3.125>,<30.75,63.5,-3.75>}
    cylinder { <30,52.5,-3.125>, <30,52.5,-3.75>,0.75}
    box{<29.25,51.5,3.125>,<30.75,63.5,3.75>}
    cylinder { <30,52.5,3.125>, <30,52.5,3.75>,0.75}

    box{<29.25,66,-9>,<30.75,69,-9.625> }
    cylinder { <30,69,-9>, <30,69,-9.625>,.75}
    box{<29.25,66,9>,<30.75,69,9.625>}
    cylinder { <30,69,9>, <30,69,9.625>,.75}
    box{<-.75,0,0>,<.75,.625,-7>  rotate<20,0,0> translate<30,63.25,-3.125>}
    box{<-.75,0,0>,<.75,.625,7>  rotate<-20,0,0> translate<30,63.25,3.125>}
    box{<28.5,60,-3.125>,<31.5,70.5,3.125> }
    texture{blackTexture}
  }


  union{
    cylinder { <30,69,-9>, <30,69,9>,.75 }
    box{<28.25,70.5,-3.375>,<31.75,71,3.375> }
    texture{forkLiftOrange }
  }
}

#declare wheel=
union{
  difference{
    cylinder {<0,3.5,-0.625>, <0,3.5,0.625>, 3.5}
    cylinder {<0,3.5,-1>, <0,3.5,1>, 3.25}
    pigment{color rgb <1.000, 0.310, 0.031>}
  }

  cylinder {<0,3.5,-0.25>, <0,3.5,0.25>, 3.5
    pigment{color rgb <1.000, 0.310, 0.031>}
  }

  union{
    box{<-1,2.5,-.75>,<2,8.0,-.875>}
    box{<-1,2.5,.75>,<2,8.0,.875>}
    box{<-1,8,-.875>,<2,7.875,.875>}
    #ifndef (TestMode)
      texture{Aluminum}
    #else
      pigment{White*.8}
    #end
  }
   cylinder{<0,3.5,-1>, <0,3.5,1> .25 pigment{Black}}
}


#declare frontSupport=
union{
  box{<-50,3,-3>,<0,5,3> }
  box{<-50,3,-5>,<-40,5,5> }
  texture{forkLiftOrange }
}

#declare forks=
union{
  difference{
    box{<-8,24,-18>,<-9,48,18>}
    box{<-10,24,0>,<-6,-24,-50>  rotate<30,0,0> translate<0,46,-10>}
    box{<-10,24,0>,<-6,-24,50>  rotate<-30,0,0> translate<0,46,10>}
    box{<-10,32,-8>,<-6,44,8>}
  }
  difference{
    box{<-50,24,-17>,<-8,26,-11> }
    box{<-20,0,50>, <20,20,-50>  rotate<0,0,15> translate<-50,24.5,0>}
  }

  difference{
    box{<-50,24,17>,<-8,26,11> }
    box{<-20,0,50>, <20,20,-50>  rotate<0,0,15> translate<-50,24.5,0>}
  }
  #ifndef (TestMode)
    texture{T_Silver_1A}
  #else
    pigment{White}
  #end
}

#declare forkLift=
union{
  difference{
    box{<0,8,-20>,<45,45,20> }
    box{<0,-10,-8>,<15,75,8>  rotate<0,45,0> translate<42,0,-17>}
    box{<0,-10,-8>,<15,75,8>  rotate<0,-45,0> translate<42,0,17>}
    box{<-10,3,16>,<0,5,-16>  }
    texture{forkLiftOrange }
  }

  difference{
    box{<0,16,-20.0>,<45.005,18,20.0> }
    box{<0,-10,-8>,<15,75,8>  rotate<0,45,0> translate<42,0,-17>}
    box{<0,-10,-8>,<15,75,8>  rotate<0,-45,0> translate<42,0,17>}
    scale<1.001,1,1.001>
    pigment{Yellow}
  }

  difference{
    box{<0,19,-20.0>,<45.005,20,20.0> }
    box{<0,-10,-8>,<15,75,8>  rotate<0,45,0> translate<42,0,-17>}
    box{<0,-10,-8>,<15,75,8>  rotate<0,-45,0> translate<42,0,17>}
    scale<1.002,1,1.001>
    pigment{Yellow}
  }

  union{
    box{<-10,3,16>,<0,5,-16>}
    box{<-1,3,17>,<1,15,-17>}
    box{<0,3,-16>,<-7,27,-17>}
    box{<-7.50,3,-12>,<-7,27,-17>}

    box{<0,3,16>,<-7,27,17>}
    box{<-7.50,3,12>,<-7,27,17>}
    texture{forkLiftOrange }
  }

  union{
    box{<0,3,1>,<-7,123,-1>}

    box{<-1,3,-14>,<-6,100,-16>}
    box{<-1,3,14>,<-6,100,16>}
    box{<0,27,-16>,<-7,110,-17>}
    box{<0,27,16>,<-7,110,17>}

    box{<0,3,13.5>,<-7,123,14>}
    box{<-7,3,12>,<-6.5,123,14>}
    box{<0,3,12>,<-0.5,123,14>}

    box{<0,3,-13>,<-7,123,-14>}
    box{<-7,3,-12>,<-6.5,123,-14>}
    box{<0,3,-12>,<-0.5,123,-14>}

    box{<0,122.5,-14>,<-7,123,14>}

    box{<0,113,-14>,<-0.5,123,14>}
    texture{blackTexture}
  }

  union{
    box{<0,109,14>,<-7,110,16>}
    box{<0,109,-14>,<-7,110,-16>}
    cylinder { <-4.25, 117, -6.5>, <-2.75, 117, -6.5>, 4}
    cylinder { <-4.25, 117, 6.5>, <-2.75, 117, 6.5>, 4}
    #ifndef (TestMode)
      texture{Aluminum}
    #else
      pigment{White*.8}
    #end
  }

  object{frontSupport translate<0,0,-14>}
  object{frontSupport translate<0,0,14>}
  object{forks}
  object{wheel rotate<0,-25,0> translate<33,0,-17>}
  object{wheel translate<33,0,17>}
  object{tiller}


  text { ttf "arialbd.ttf" "EZ-Lift" 1, 0
  #ifndef (TestMode)
    texture{T_Silver_1B}
  #else
    pigment{White}
  #end
    scale 5
    translate <18,38,-20.5>
  }
}


#ifndef (UseAsIncludeFile)
  object{forkLift rotate<0,-45,0>}
#end
