
#version 3

#include "colors.inc"
#include "finish.inc"
#include "textures.inc"

#ifndef (UseAsIncludeFile)
global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera{
  location  <-148-20, 100, -130>
  direction 10*z
  right     4/3*x
  look_at   <-159, 0,  -25>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color White*2
  translate <-150, 50, -100>
}

// ----------------------------------------
plane { y, 0 pigment {color rgb <0.7,0.5,0.3>*2}}
#end
//=====================================================================

#declare redBook=
union{
  union{
    box{<-2,0,0>,<2,11.5,0.2>}
    box{<-0.2,0,0>,<0,11.5,11.25> rotate<0,-5,0> translate<2,0,0>}
    box{<0.2,0,0>,<0,11.5,11.25> rotate<0,5,0> translate<-2,0,0>}
    pigment{Red}
  }
  box{<-.95,0.25,2.25>,<0.95,11.25,10.75> pigment{White}}
  box{<-1,6,0>,<1,10,-.01> pigment{White}}
  torus{1.5,0.09 texture{Soft_Silver} translate<0,9.75,1.75>}
}
#declare blackBook=
union{
  union{
    box{<-2,0,0>,<2,11.5,0.2>}
    box{<-0.2,0,0>,<0,11.5,11.25> rotate<0,-5,0> translate<2,0,0>}
    box{<0.2,0,0>,<0,11.5,11.25> rotate<0,5,0> translate<-2,0,0>}
    pigment{Black}
  }
  box{<-.95,0.25,2.25>,<0.95,11.25,10.75> pigment{White}}
  box{<-1,6,0>,<1,10,-.01> pigment{White}}
  torus{1.5,0.09 texture{Soft_Silver} translate<0,9.75,1.75>}
}
#declare blueBook=
union{
  union{
    box{<-2,0,0>,<2,11.5,0.2>}
    box{<-0.2,0,0>,<0,11.5,11.25> rotate<0,-5,0> translate<2,0,0>}
    box{<0.2,0,0>,<0,11.5,11.25> rotate<0,5,0> translate<-2,0,0>}
    pigment{Blue}
  }
  box{<-.95,0.25,2.25>,<0.95,11.25,10.75> pigment{White}}
  box{<-1,6,0>,<1,10,-.01> pigment{White}}
  torus{1.5,0.09 texture{Soft_Silver} translate<0,9.75,1.75>}
}


#declare oakMult= 2.5
#declare DMFLightOak2 =
pigment {
    wood
    turbulence 0.05            // For best results,  keep this low!
    scale <0.2, 0.2, 1>        // Scaled for a unit object
    color_map {
        [0.0, 0.1 color rgb <0.42, 0.26, 0.15>*oakMult
                  color rgb <0.42, 0.26, 0.15>*oakMult]
        [0.1, 0.9 color rgb <0.42, 0.26, 0.15>*oakMult
                  color rgb <0.52, 0.37, 0.26>*oakMult]
        [0.9, 1.0 color rgb <0.52, 0.37, 0.26>*oakMult
                  color rgb <0.52, 0.37, 0.26>*oakMult]
    }
}


#declare computerScreen=
union{
  difference{
    box{<-8,0,0>,<8,14,2>}
    box{<-6.5,3,-10>,<6.5,12.5,10>}
    box{<0,3,-3>,<5,12.5,10>  rotate<0,45,0> translate<-6.5,0,1>}
    box{<0,3,-3>,<-5,12.5,10>  rotate<0,-45,0> translate<6.5,0,1>}
    pigment{NewTan*1.5}
  }

  cylinder{<-6,1.5,0>,<-6,1.5,-.25> .75  pigment{NewTan*1.5}}
  cylinder{<-3.5,1.5,0>,<-3.5,1.5,-.25> .75  pigment{NewTan*1.5}}
  box{<0,0,0>, <1,1,.125>

    pigment{
      image_map{
        gif "screen2.gif" // the file to read (iff/gif/tga/png/sys)
        interpolate 0     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
        once
      }
    }
    scale<13,9.5,1>
    translate<-6.5,3,1.126>
  }
}

#declare keyboard=
  box{<0,0,0>,<19/12,1/12,8/12> rotate<-5,0,0> pigment{NewTan*1.5}}

#declare workStation=
union{
  union{
    box{<-7.5,28/12,1>,<7.5,26/12,-1>}
    box{<-7.5,0,0>,<7.5,2,-.1> rotate<20,0,0> translate<0,27/12,1> }
    box{<-7.5,0,0>,<7.5,2/12,1.25> translate<0,4,1.62>}
    difference{
      box{<-7.35,0,1>,<-7.5,4.16,2.87> }
      box{<-10,0,0>,<7.5,2,-2> rotate<20,0,0> translate<0,27/12,1>}
    }
    texture{pigment{LightWood } finish{Shiny}}
  }


  object{computerScreen scale 1/10 rotate<20,0,0> translate<-5,32/12,.75>}
  object{computerScreen scale 1/10 rotate<20,0,0> translate<0,32/12,.75>}
  object{computerScreen scale 1/10 rotate<20,0,0> translate<5,32/12,.75>}

  object{keyboard translate<-5.75,28.5/12,-.5>}
  object{keyboard rotate<0,-10,0> translate<-.75,28.5/12,-.5>}
  object{keyboard rotate<0,5,0> translate<4.5,28.5/12,-.5>}



object{redBook scale 1/12 translate<-3,28.5/12,0>}
object{blueBook scale 1/12 translate<-3-(3.65/12),28.5/12,0>}
object{blackBook scale 1/12 translate<-3+(3.65/12),28.5/12,0>}
object{blackBook scale 1/12 translate<-3+(3.65/12*2),28.5/12,0>}
object{blueBook scale 1/12 rotate<0,0,15> translate<-2.75+(3.65/12*3),28.5/12,0>}
object{blueBook scale 1/12 rotate<0,0,90> rotate<5,60,0> translate<-7,30.5/12,-.75>}
object{redBook scale 1/12 rotate<0,0,90> rotate<5,-45,0> translate<4,30.5/12,-.5>}

}

#ifndef (UseAsIncludeFile)
  object{workStation translate<-157,0,0> rotate<0,-9.5,0>}
#end

