
// Balloon.pov  July 1998  Neil Alexander

// uses heightfields generated from Watermap.pov and Hills.pov
// and image map generated from Hillstxt.pov
// Hillstxt.pov uses Hillcolr.inc

#include "splash.inc"
#include "rope.inc"
#include "balloon.inc"

// ------------------------- Lights, Camera --------------------------

camera {
  location  <100, 10, 100>
  angle 65
  look_at   <0, 60, 0>
  }

#declare Sunrot = <130,90,0>  // Sun rotation from -z axis

light_source {  // Sun shining through clouds
  <0, 0, -10000000000000>
  color rgb 1
  rotate Sunrot
  }

light_source {  // scene illumination
  <0, 0, -10000000000000>
  color rgb 1
  rotate Sunrot
  shadowless
  atmosphere off
  }

// ------------------------------ Sky ---------------------------------

sky_sphere {
  pigment { gradient z
    color_map {
      [0.002 color rgb 1]
      [0.002 color rgb <0.25,0.5,1>]
      [0.8 color rgb <1, 1, 1>]
      }
    scale 2
    translate -1
    }
  rotate Sunrot
  }

atmosphere {
  type 1
  samples 15
  distance 20000
  scattering 0.0001
  color rgbt<1,1,1,0.8>
  }

sphere {0,1  // clouds
  scale <120000,12000,120000>
  texture { // layer 1
    pigment {
      bozo
      color_map {
        [0.1 color rgbt 1]
        [0.3 color rgbt <0.8,0.78,0.85, 0.1>]
        [1.0 color rgbt <0.60,0.55,0.65,0>]
        }
      translate -1
      scale 18000
      turbulence 0.7
      omega 0.7
      }
    finish {ambient 1 diffuse 0}
    }
  texture { // layer 2
    pigment {
      bozo
      color_map {
        [0.4 color rgbt 1]
        [0.7 color rgbt <0.8,0.78,0.85, 0.4>]
        [1.0 color rgbt <0.70,0.65,0.75,0.1>]
        }
      translate 10
      scale 14000
      turbulence 0.7
      omega 0.7
      }
    finish {ambient 1 diffuse 0}
    }
  hollow
  }

sphere {0,1 // inverse sphere to eliminate atmosphere outside cloud sphere
  scale <120001,12001,120001>
  texture { pigment { color rgbt <0,0,0,1>}}
  inverse
  }

// -------------------------- Landscape ----------------------------

height_field { // water
  tga
  "watermap.tga"
  translate <-1,0,-1>
  scale <800,3,800>
  texture {
    pigment { gradient y
      color_map {
        [0 color rgb <0.15,0.18,0.2>]
        [1 color rgb <0.55, 0.6, 0.65>]
        }
      turbulence 0.1
      scale 3
      }
    finish { phong 0.9 phong_size 25 reflection 0.15 }
    normal { wrinkles 0.1 scale 3 }
    }
  translate <110,6.5,110>
  }


height_field { // background hills
  tga
  "hills.tga"
  smooth
  texture {
    pigment {
      image_map {
        tga "hillstxt.tga"
        map_type 0
        interpolate 0
        } // image_map
      }
    rotate <90,0,0>
    }
  translate <-0.5,0,-0.5>
  rotate <0,0,0>
  translate <-0.5,0,-0.5>
  scale <60000,5000,60000>
  translate <-4000,-700,-8000>
  }

object { Balloon
  rotate <-30,30,0>
  translate <-150,100,-50>
  }

object { Splash
  translate <0,3,50>
  }
object { Rope // rope of splashing sandbag
  rotate y*90
  translate <0,6.5,50>
  }
object { Bag  // suspended sandbag
  translate <0,-44,-47>    // to position to x-rotated balloon
  rotate y*30              // to position to y-rotated balloon
  translate <-150,100,-50> // to position with balloon
  }
object {Balloon2
  translate 12000*-z
  rotate <20,25,0>
  }

