//the fishbowl car from a far side cartoon

#include "colors.inc"
#include "skies.inc"
#include "textures.inc"
//camera



//textures

#declare Glass1 =
   texture  // Glass
   {
      pigment
      {
         color rgbt <1,1,1, 0.8>
      }
      finish
      {
         ambient 0.1
         phong 1.0
         reflection 0.1
         refraction on  ior 1.2
      }
   }
#declare Glass2 =
   texture  // Glass
   {
      pigment
      {
         color rgbt <0.4,0.8,1, 0.4>
      }
      finish
      {
         ambient 0.1
         phong 1.0
         reflection 0.1
         refraction on  ior 1.2
      }
   }

#declare Water =
   texture  // Water
   {
      pigment
      {
         color rgbf <0.427451, 0.823529, 0.878431, 0.5>
      }
      normal
      {
         ripples , 0.5 phase -clock scale 0.15
      }
      finish
      {
         ambient 0.2
         phong 1.0
         phong_size 5.0
         //roughness 0.2
         //metallic 1.0
         reflection 0.2
         refraction on  ior 1.5
      }
   }

#declare Silver3 =
   texture  // Silver3
   {
      pigment
      {
         color rgb <0.94, 0.93, 0.9>
      }
      finish
      {
         ambient 0.25
         diffuse 0.65
         brilliance 6.0
         phong 1.0
         phong_size 100.0
         reflection 0.45
      }
   }

#declare Fishtex =
   texture  // Fishtex
   {
      pigment
      {
         crackle
         color_map
         {
            [ 0.0     rgbft <0.227451, 0.619608, 0.552941, 0.0, 0.0> ]
            [ 1.0     rgbft <0.207843, 0.290196, 0.168627, 0.0, 0.0> ]
         }
      }
      normal
      {
         crackle , 0.05
      }
      finish
      {
         ambient 0.1
         diffuse 1
         phong 0.3
         phong_size 20.0
      }
      scale  0.01
   }

#declare Sky =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.00 SkyBlue ] // horizon
            [0.05 SkyBlue ]                   // horizon
            [0.20 P_Cloud4 ]
        }
    }
}

#declare Stonetex =
   texture  // Stonetex
   {
      pigment
      {
         color rgb <0.682353, 0.682353, 0.682353>
      }
      normal
      {
         granite , 1
      }
      finish
      {
         ambient 0.1
         crand 0.08
      }
      scale 3
   }

#declare Tornadotex =
   texture  // Tornadotex
   {
      pigment
      {
         gradient z
         color_map
         {
            [ 0.0     rgbft <0.0, 0.0, 0.0, 0.0, 1.0> ]
            [ 0.86121  rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 1.0     rgbft <0.780392, 0.780392, 0.780392, 0.0, 0.0> ]
         }
         turbulence 2.0
         scale  <1.0, 1.0, 0.05>
      }
      finish
      {
         ambient 0.4
      }
   }

//element car
//sky

sky_sphere {Stars scale 2}


//road

box {<-6,0,-10000>,<20,-1,10000> pigment {image_map {gif "road.gif"} rotate x*90 scale 24 translate x*-5} normal {granite 1 scale 10}}

#declare Arch =
union {
      cylinder {<-6,-50,0>,<-6,2,0>,0.5}
      cylinder {<20,-50,0>,<20,2,0>,0.5}
      intersection {
                   torus {13,0.5 rotate x*90 translate <7,2,0>}
                   plane {-y,-2}
                   }
      texture {Silver3}
      }
object {Arch translate z*20*-20}
object {Arch translate z*20*-19}
object {Arch translate z*20*-18}
object {Arch translate z*20*-17}
object {Arch translate z*20*-16}
object {Arch translate z*20*-15}
object {Arch translate z*20*-14}
object {Arch translate z*20*-13}
object {Arch translate z*20*-12}
object {Arch translate z*20*-11}
object {Arch translate z*20*-10}
object {Arch translate z*20*-9}
object {Arch translate z*20*-8}
object {Arch translate z*20*-7}
object {Arch translate z*20*-6}
object {Arch translate z*20*-5}
object {Arch translate z*20*-4}
object {Arch translate z*20*-3}
object {Arch translate z*20*-2}
object {Arch translate z*20*-1}
object {Arch translate z*20*0}
object {Arch translate z*20*1}
object {Arch translate z*20*2}
object {Arch translate z*20*3}
object {Arch translate z*20*4}
object {Arch translate z*20*5}
object {Arch translate z*20*6}
object {Arch translate z*20*7}
object {Arch translate z*20*8}
object {Arch translate z*20*9}
object {Arch translate z*20*10}
object {Arch translate z*20*11}
object {Arch translate z*20*12}
object {Arch translate z*20*13}
object {Arch translate z*20*14}
object {Arch translate z*20*15}
object {Arch translate z*20*16}
object {Arch translate z*20*17}
object {Arch translate z*20*18}
object {Arch translate z*20*19}
object {Arch translate z*20*20}

union {
      cylinder {<-6,2,-10000>,<-6,2,10000>,0.4}
      cylinder {<20,2,-10000>,<20,2,10000>,0.4}
      texture {Silver3}
      }

//fishbowl
#declare Elementcar = union {

merge {
      difference {
           sphere {<0,6,0>,4}
           sphere {<0,6,0>,3.9}
           plane {-y,-9}
           plane {y,8}
           }
      torus {2.8,0.25 translate y*9}
      texture {Glass1}
      }
difference {
           sphere {<0,6,0>,4}
           plane {-y,-8}
           texture {Glass2}
           }
disc {<0,8.001,0>, y, 3.4 texture {Water}}

//steering wheel

#declare SteerWheel =
blob {
     threshold 0.75
     component 1.000000, 0.4, <0,7,-1>
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*1,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*2,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*3,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*4,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*5,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*6,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*7,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*8,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*9,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*10,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*11,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*12,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*13,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*14,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*15,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*16,0>)
     component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*17,0>)
     //component 1.000000, 0.4, vrotate(<0,7,-1>,<0,20*18,0>)

     pigment {Red}
     }

intersection {
             sphere {<0,6,0>,4}
             union {
                   cylinder {<0,0,0>,<0,7,0>,0.25 pigment {Black}}
                   sphere {<0,7,0>,0.25 pigment {Black}}
                   cylinder {<0,7,0>,<0,7,-1>,0.1 texture {Silver3}}
                   cylinder {<0,7,0>,<0,7,1>,0.1 texture {Silver3}}
                   cylinder {<0,7,0>,<-1,7,0>,0.1 texture {Silver3}}
                   cylinder {<0,7,0>,<1,7,0>,0.1 texture {Silver3}}
                   object {SteerWheel}
                   rotate x*60
                   translate <0,1.7,-7>
                   }
             }

//car

//main body
superellipsoid {<0.2,0.2> texture {Stonetex} scale <4,0.5,5> translate y*1.5 }
difference {
           sphere {<0,0,0>,3 scale <1,0.6,1.5> translate y*1.8}
           sphere {<0,6,0>,4}
           texture {Stonetex}
           }

//hydraulic supports
difference {
           union {
                 cylinder {<3.2,1.5,-4.7>,<3.2,3,-3>,0.3 pigment {Black}}
                 cylinder {<3.2,1.5,-4.7>,<3.2,4.5,-1.3>,0.2 texture {Silver3}}
                 cylinder {<-3.2,1.5,-4.7>,<-3.2,3,-3>,0.3 pigment {Black}}
                 cylinder {<-3.2,1.5,-4.7>,<-3.2,4.5,-1.3>,0.2 texture {Silver3}}
                 cylinder {<2.2,1.5,4.7>,<2.2,3,3>,0.3 pigment {Black}}
                 cylinder {<2.2,1.5,4.7>,<2.2,4.5,1.3>,0.2 texture {Silver3}}
                 cylinder {<-2.2,1.5,4.7>,<-2.2,3,3>,0.3 pigment {Black}}
                 cylinder {<-2.2,1.5,4.7>,<-2.2,4.5,1.3>,0.2 texture {Silver3}}
                 }
           sphere {<0,6,0>,4}
           }

//tail fins
sphere {<0,0,0>,2 texture {Stonetex} scale <0.2,0.5,1> translate <3.2,1.8,3>}
sphere {<0,0,0>,2 texture {Stonetex} scale <0.2,0.5,1> translate <-3.2,1.8,3>}

//wheels and axles
union {
      union {
            cylinder {<-4.5,1.5,-4>,<4.5,1.5,-4>,0.15 }
            sphere {<-4.5,1.5,-4>,0.15 }
            sphere {<4.5,1.5,-4>,0.15 }
            cylinder {<4.5,1.5,-4>,<4.5,2.8,-4>,0.1 }
            cylinder {<4.5,1.5,-4>,<4.5,0.2,-4>,0.1 }
            cylinder {<4.5,1.5,-4>,<4.5,1.5,-5.3>,0.1 }
            cylinder {<4.5,1.5,-4>,<4.5,1.5,-2.7>,0.1 }
            cylinder {<-4.5,1.5,-4>,<-4.5,2.8,-4>,0.1 }
            cylinder {<-4.5,1.5,-4>,<-4.5,0.2,-4>,0.1 }
            cylinder {<-4.5,1.5,-4>,<-4.5,1.5,-5.3>,0.1 }
            cylinder {<-4.5,1.5,-4>,<-4.5,1.5,-2.7>,0.1 }
            texture {Silver3}
            }
      torus {1.3,0.2 pigment {Black} rotate z*90 translate <4.5,1.5,-4>}
      torus {1.3,0.2 pigment {Black} rotate z*90 translate <-4.5,1.5,-4>}
      }

union {
      union {
            cylinder {<-4.5,1.5,4>,<4.5,1.5,4>,0.15 }
            sphere {<-4.5,1.5,4>,0.15 }
            sphere {<4.5,1.5,4>,0.15 }
            cylinder {<4.5,1.5,4>,<4.5,2.8,4>,0.1 }
            cylinder {<4.5,1.5,4>,<4.5,0.2,4>,0.1 }
            cylinder {<4.5,1.5,4>,<4.5,1.5,5.3>,0.1 }
            cylinder {<4.5,1.5,4>,<4.5,1.5,2.7>,0.1 }
            cylinder {<-4.5,1.5,4>,<-4.5,2.8,4>,0.1 }
            cylinder {<-4.5,1.5,4>,<-4.5,0.2,4>,0.1 }
            cylinder {<-4.5,1.5,4>,<-4.5,1.5,5.3>,0.1 }
            cylinder {<-4.5,1.5,4>,<-4.5,1.5,2.7>,0.1 }
            texture {Silver3}
            }
      torus {1.3,0.2 pigment {Black} rotate z*90 translate <4.5,1.5,4>}
      torus {1.3,0.2 pigment {Black} rotate z*90 translate <-4.5,1.5,4>}
      }

//exhaust pipe
difference {
           cylinder {<3,1.5,0>,<3,1.5,6>,0.2}
           cylinder {<3,1.5,0>,<3,1.5,7
           >,0.19}
           texture {Silver3}
           }
}
//fish

#declare Fish =
union {
blob {
   threshold 0.6
   component 1.000000, 0.711875, <-0.008439, 0.767932, -0.042194>
   component -1.00000, 0.100000, <0.0000000, 0.586666, -0.340000>
   component 1.000000, 0.562084, <0.000000, 0.649789, 0.075949>
   component 1.000000, 0.463507, <0.000000, 0.413502, 0.244726>
   component 1.000000, 0.319944, <0.000000, 0.160338, 0.160338>
   component 1.000000, 0.227627, <0.000000, 0.042194, -0.025316>
   component 1.000000, 0.207286, <0.000000, 0.042194, -0.177215>
   component 1.000000, 0.238472, <0.092827, -0.008439, -0.278481> //tail
   component 1.000000, 0.248845, <-0.092827, -0.008439, -0.295359> //tail
   component 1.000000, 0.284395, <0.295359, 0.379747, 0.143460>
   component 1.000000, 0.177747, <0.312236, 0.345992, 0.000000>
   component 1.000000, 0.177747, <-0.312236, 0.345992, 0.000000>
   component 1.000000, 0.284395, <-0.295359, 0.379747, 0.143460>
   cylinder {<-0.312236, 0.345992, 0.000000>,<-0.312236, 0.345992, -0.450000>,0.17,1}
   cylinder {<0.312236, 0.345992, 0.000000>,<0.312236, 0.345992, -0.450000>,0.17,1}

   texture {Fishtex}
}
sphere {<-0.18,0.82,-0.32>,0.08 pigment {White} finish {diffuse 2}}
sphere {<-0.18,0.82,-0.345>,0.06 pigment {Black} }
sphere {<0.18,0.82,-0.32>,0.08 pigment {White} finish {diffuse 2}}
sphere {<0.18,0.82,-0.345>,0.06 pigment {Black} }

#declare Fin =
object { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.765995, -1.461764, 0.000000>, <-0.619296, -0.450930, 0.000000>, <-0.301937, -0.621590, 0.000000>, <-0.194622, -1.488019, 0.000000>,
      <-1.172954, -0.579913, 0.000000>, <-0.540530, -0.343614, 0.000000>, <-0.354448, -0.304231, 0.000000>, <0.146699, -0.448636, 0.000000>,
      <-0.739740, -0.577619, 0.000000>, <-0.474892, 0.013128, 0.000000>, <-0.354448, 0.026255, 0.000000>, <-0.299643, -0.301937, 0.000000>,
      <-1.330487, -1.468010, 0.000000>, <-0.750573, 2.572044, 0.000000>, <-0.170660, 2.614709, 0.000000>, <0.343614, -1.271094, 0.000000>
    }
  }
  texture {
    Fishtex
  }
  scale 0.25
  translate  <0.090815, -0.079097, 0.0>
  rotate x*90
  scale <1.3,1,1>
  translate <0.04,0,-0.55>
}
#declare Fin2 =
object { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.765995, -1.461764, 0.000000>, <-0.619296, -0.450930, 0.000000>, <-0.301937, -0.621590, 0.000000>, <-0.194622, -1.488019, 0.000000>,
      <-1.172954, -0.579913, 0.000000>, <-0.540530, -0.343614, 0.000000>, <-0.354448, -0.304231, 0.000000>, <0.146699, -0.448636, 0.000000>,
      <-0.739740, -0.577619, 0.000000>, <-0.474892, 0.013128, 0.000000>, <-0.354448, 0.026255, 0.000000>, <-0.299643, -0.301937, 0.000000>,
      <-1.330487, -1.468010, 0.000000>, <-0.750573, 2.572044, 0.000000>, <-0.170660, 2.614709, 0.000000>, <0.343614, -1.271094, 0.000000>
    }
  }
  texture {
    Fishtex
  }
  scale 0.165
  rotate y*90
  translate  <0.090815, -0.079097, 0.0>
  rotate x*90
  scale <1.3,1,1>
  translate <0.04,0,-0.55>
}

object {Fin}
object {Fin2 translate <-0.512236, 0.455992, -0.050000> }
object {Fin2 translate <0.212236, 0.455992, -0.050000> }

//headlights
#declare Bulb =
union {
      difference {
                 sphere { <0,0,-0.4>,1.5}
                 plane { z, 0 }
                 }
      difference {
                 sphere { <0,0,-0.4>,1.5 scale <1,1,0.1>}
                 plane { -z, 0 }
                 }
      pigment {White}
      finish {ambient 1}
      }


#declare Headlight =
union {
      difference {
                 union {
                       difference {
                                  sphere { <0,0,0>,2 scale <1,1,2>}
                                  plane { z, 0 }
                                  }
                       difference {
                                  sphere { <0,0,0>,2 scale <1,1,0.2>}
                                  plane { -z, 0 }
                                  }
                       }
                 sphere { <0,0,-0.4>,1.5 }
                 texture {Stonetex}
                 }
     light_source { <0,0,0> color White*3 spotlight radius 40 falloff 48 tightness 1 point_at <0,-10,-100>  looks_like {Bulb} fade_distance 20 fade_power 3}
     }

object {Headlight scale 0.1 translate <0.5,-0.5,-1.7>}
object {Headlight scale 0.1 translate <-0.5,-0.5,-1.7>}

#declare Firejet =
cone { <0,0,0>,0.8,<0,-1000>, 2
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    cylindrical_mapping
    linear
    turbulence 1.5
    color_map {
      [ 0.0 color rgbt <1, 0, 0,  1.0> ]
      [ 0.5 color rgbt <1, 1, 0,  0.0> ]
      [ 1.0 color rgbt <1, 0, 0,  1.0> ]
    }
    frequency 1
    samples 20
    scale 0.5
  }
  hollow
  scale 2.5
  rotate x*90
}


#declare Thruster =
union {
      difference {
                 union {
                       difference {
                                  sphere { <0,0,0>,2 scale <1,1,2>}
                                  plane { z, 0 }
                                  }
                       difference {
                                  sphere { <0,0,0>,2 scale <1,1,0.2>}
                                  plane { -z, 0 }
                                  }
                       }
                 sphere { <0,0,-0.4>,1.5 }
                 texture {Stonetex}
                 }
     object {Firejet}
     }

object {Thruster rotate y*180 scale 0.1 translate <0.5,-0.5,1.0>}
object {Thruster rotate y*180 scale 0.1 translate <-0.5,-0.5,1.0>}

//tornado weapons

#declare Tornado =
cone {<0,0,-0.5>,0.25,<0,0,1>,0.1 open texture {Tornadotex}}

object {Tornado translate <-1.2,0.25,-0.5>}
object {Tornado translate <1.2,0.25,-0.5>}

cylinder {<-0.5,0,-0.25>,<-1.025,0.25,-0.25>,0.1 texture {Silver3}}
torus { 0.175 , 0.1 rotate x*90 translate <-1.2,0.25,-0.25> texture {Silver3}}

cylinder {<0.5,0,-0.25>,<1.025,0.25,-0.25>,0.1 texture {Silver3}}
torus { 0.175 , 0.1 rotate x*90 translate <1.2,0.25,-0.25> texture {Silver3}}

}

//SCENE (objects and camera and stuff)

union {
object {Elementcar }
object {Fish scale 4 translate <0,3.7,1.7> }
}

camera {location <13,6,-15> look_at <0,5,0> rotate y*90}
//camera {location <-13,6,-15> look_at <0,5,0> rotate y*90}

light_source {<0,200,-200> color White}

plane { y, -40
  texture {
    pigment { color rgb <0.3,0.5,0.4> }
    finish { phong 1 phong_size 150 reflection 0.2 ambient 0.2 }
    normal{  bumps 0.15 scale 12 }
    }
}


