//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 20 textures and 48 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 08/26/1998    (26.08.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray V3.01 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera The_Camera
  location  <1.000, -8.000, 6.000>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.500>
}

//
// *******  L I G H T S *******
//

light_source {   // HelperLight
  <1.000, -8.000, 6.000>
  color rgb <0.600, 0.600, 0.600>
  shadowless
}

light_source { // Lights
  <0.000, 0.000, 2.000>
  color  rgb<1.000, 1.000, 1.000>
  area_light <10.000, 0.000, 0.000>, <0.000, 6.000, 0.000>, 5, 5
  adaptive 1
  fade_distance  2.5
  fade_power 1.0
}



//
// ********  TEXTURES  *******
//

#include "cake.inc"


//
// ********  REFERENCED OBJECTS  *******
//

// Include contains 'Chocolate'
#include "cake.in1"

#declare Chocolate = object {
  Chocolate_Raw
  texture {
    ChocolateTex
  }
  scale <0.1, 0.1, 0.2>
  rotate 40.0*z
  translate  <-0.8, 0.3, 0.06>
}
#declare Egg = union { // Egg
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 3,
      <0.015606, -0.000001, 3.301232>, <0.015606, 0.020830, 3.301232>, <-0.015606, 0.020830, 3.301232>, <-0.015606, -0.000001, 3.301232>,
      <-1.200000, -0.000002, 3.092627>, <-1.200000, -1.600000, 3.092627>, <1.200000, -1.600000, 3.092627>, <1.200000, 0.000000, 3.092627>,
      <-1.710155, -0.000002, 0.141607>, <-1.710155, -2.280206, 0.141607>, <1.710155, -2.280206, 0.141607>, <1.710155, 0.000000, 0.141607>,
      <0.000000, -0.000001, 0.071506>, <0.000000, -0.000001, 0.071506>, <-0.000000, -0.000001, 0.071506>, <-0.000000, -0.000001, 0.071506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 3,
      <-0.015606, -0.000001, 3.301232>, <-0.015606, -0.020832, 3.301232>, <0.015606, -0.020832, 3.301232>, <0.015606, -0.000001, 3.301232>,
      <1.200000, 0.000000, 3.092627>, <1.200000, 1.600000, 3.092627>, <-1.200000, 1.599996, 3.092627>, <-1.200000, -0.000002, 3.092627>,
      <1.710155, 0.000000, 0.141607>, <1.710155, 2.280207, 0.141607>, <-1.710155, 2.280202, 0.141607>, <-1.710155, -0.000002, 0.141607>,
      <-0.000000, -0.000001, 0.071506>, <-0.000000, -0.000001, 0.071506>, <0.000000, -0.000001, 0.071506>, <0.000000, -0.000001, 0.071506>
    }
  }
  texture {
    Eggshell
  }
  scale 0.15
  rotate <41.0, 90.0, 0.0>
  translate  <-2.0, 0.0, 0.26>
}




#declare Tine = union {
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 3,
      <-0.018259, -0.144375, 0.000000>, <-0.018259, -0.236093, 0.000000>, <0.162633, -0.236093, 0.000000>, <0.162633, -0.144374, 0.000000>,
      <1.829724, -0.144375, 1.307006>, <1.829724, -0.236093, 1.307006>, <2.010616, -0.236093, 1.307006>, <2.010616, -0.144374, 1.307006>,
      <0.876858, -0.144375, 4.115499>, <0.876858, -0.236093, 4.115499>, <1.057749, -0.236093, 4.115499>, <1.057749, -0.144374, 4.115499>,
      <-0.018259, -0.144375, 6.000000>, <-0.018259, -0.236093, 6.000000>, <0.162633, -0.236093, 6.000000>, <0.162633, -0.144374, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 3,
      <0.162633, -0.144374, 0.000000>, <0.162633, -0.052654, 0.000000>, <-0.018259, -0.052657, 0.000000>, <-0.018259, -0.144375, 0.000000>,
      <2.010616, -0.144374, 1.307006>, <2.010616, -0.052654, 1.307006>, <1.829724, -0.052657, 1.307006>, <1.829724, -0.144375, 1.307006>,
      <1.057749, -0.144374, 4.115499>, <1.057749, -0.052654, 4.115499>, <0.876858, -0.052657, 4.115499>, <0.876858, -0.144375, 4.115499>,
      <0.162633, -0.144374, 6.000000>, <0.162633, -0.052654, 6.000000>, <-0.018259, -0.052657, 6.000000>, <-0.018259, -0.144375, 6.000000>
    }
  }
}




//
// ********  OBJECTS  *******
//

#declare FaucetSpout = merge {
  cylinder { // FaucetOut
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.92>
    rotate 90.0*x
    translate  1.4*z
  }
  cylinder { // FaucetDwn
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.3>
    translate  <0.0, -1.92, 1.1>
  }
  cylinder { // WaterFall
    <0,0,1>, <0,0,0>, 1
    texture {
      Water
    }
    scale <0.07, 0.07, 2.5>
    translate  <0.0, -1.92, -1.4>
  }
  sphere { // FaucetJoint
    <0,0,0>,1
    scale 0.1
    translate  <0.0, -1.92, 1.4>
  }
  rotate -20.0*z
}
union { // Faucet
  superellipsoid { // FaucetBase
    <0.1, 0.1>
    scale <0.5, 0.15, 0.1>
  }
  cylinder { // FaucetUp
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.4>
  }
  object { FaucetSpout }
  texture {
    Aluminum
  }
  translate  <3.0, 2.75, 0.2>
}


plane { // Sky
  z,0
  texture {
    Shadow_Clouds
  }
  hollow
  rotate -90.0*x
  translate  5.0*y
}


object { // Chocolate1->Chocolate
  Chocolate
  rotate <-0.0, -0.0, -10.0>
  translate  <0.2, 0.04, 0.0>
}


object { // Egg1->Egg
  Egg
  rotate <-68.0, -0.0, 0.0>
  translate  <0.2, 0.1, 0.0>
}


#declare SpoonFront = difference {
  sphere { // SpoonFrontYes
    <0,0,0>,1
    scale <0.2, 0.1, 0.1>
    translate  <0.2, 0.0, 0.125>
  }
  sphere { // SpoonFrontNo
    <0,0,0>,1
    scale <0.18, 0.1, 0.1>
    translate  <0.2, 0.0, 0.17>
  }
}
merge { // Spoon
  object { SpoonFront }
  cylinder { // SpoonHandle
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 1.0>
    rotate -90.0*y
    translate  0.13*z
  }
  sphere { // Sugar
    <0,0,0>,1
    texture {
      SugarTex
    }
    scale <0.178, 0.098, 0.05>
    translate  <0.2, 0.0, 0.17>
  }
  texture {
    Aluminum
  }
  scale 0.5
  rotate <0.0, -2.644971, -50.0>
  translate  <-0.117905, -0.471621, 0.077164>
}


box { // Butter
  <-1, -1, -1>, <1, 1, 1>
  texture {
    ButterTex
    rotate -90.0*y
  }
  scale <0.4, 0.1, 0.1>
  rotate -30.0*z
  translate  <0.75, 1.0, 0.2>
}


#declare MilkTopTriPart = difference {
  box { // MilkTop
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2499, 0.176777, 0.176777>
  }
  rotate -45.0*x
  translate  <1.3, 1.3, 1.1>
}
merge { // MilkCarton
  box { // MilkBody
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.25, 0.5>
    translate  <1.3, 1.3, 0.6>
  }
  box { // MilkVeryTop
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2498, 0.01, 0.06>
    translate  <1.3, 1.3, 1.34>
  }
  object { MilkTopTriPart }
  texture {
    MilkTex
    scale <1.0, 1.0, 1.3>
    rotate -45.0*z
    translate <1.300000, 1.300000, 0.100000>
  }
  rotate 60.0*z
  translate  <0.82, 0.58, 0.0>
}




//
// Include file contains 'Cup'
//
#include "cake.in2"
#declare Cup = object {
  Cup_Raw
}
// Include contains 'FlourHandle'
#include "cake.in3"

#declare FlourHandle = object {
  FlourHandle_Raw
  scale 0.5
  rotate <90.0, 0.0, -0.0>
  translate  <1.35, 0.25, 0.3>
}
union { // FlourCup
  object { Cup }
  sphere { // Flour
    <0,0,0>,1
    texture {
      FlourTex
    }
    scale <0.97, 0.97, 0.3>
    translate  0.8*z
  }
  object { FlourHandle }
  texture {
    Chrome1
  }
  scale 0.2
  rotate 147.0*z
  translate  <0.95, -0.3, 0.35>
}


object { Egg }


object { Chocolate }




union { // Bowl
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 3,
      <-0.178499, -0.000000, 0.000000>, <-0.178499, -0.237999, 0.000000>, <0.178499, -0.237999, 0.000000>, <0.178499, -0.000000, 0.000000>,
      <-0.894766, -0.000001, 0.626906>, <-0.894766, -1.193022, 0.626906>, <0.894766, -1.193022, 0.626906>, <0.894766, -0.000000, 0.626906>,
      <-1.000000, -0.000002, 1.025902>, <-1.000000, -1.333333, 1.025902>, <1.000000, -1.333333, 1.025902>, <1.000000, -0.000000, 1.025902>,
      <-1.000000, -0.000002, 6.000000>, <-1.000000, -1.333333, 6.000000>, <1.000000, -1.333333, 6.000000>, <1.000000, -0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 5 v_steps 3,
      <0.178499, -0.000000, 0.000000>, <0.178499, 0.237999, 0.000000>, <-0.178499, 0.237998, 0.000000>, <-0.178499, -0.000000, 0.000000>,
      <0.894766, -0.000000, 0.626906>, <0.894766, 1.193022, 0.626906>, <-0.894766, 1.193019, 0.626906>, <-0.894766, -0.000001, 0.626906>,
      <1.000000, -0.000000, 1.025902>, <1.000000, 1.333333, 1.025902>, <-1.000000, 1.333330, 1.025902>, <-1.000000, -0.000002, 1.025902>,
      <1.000000, -0.000000, 6.000000>, <1.000000, 1.333333, 6.000000>, <-1.000000, 1.333330, 6.000000>, <-1.000000, -0.000002, 6.000000>
    }
  }
  texture {
    BowlTex
  }
  scale <0.5, 0.5, 0.125>
  translate  <-2.0, 1.0, 0.1>
}


#declare BackWallYes = union {
  box { // Wall
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.1, 1.0>
    translate  <0.0, 3.0, 1.0>
  }
  superellipsoid { // Paneling
    <0.23, 0.1>
    texture {
      TrimTex
    }
    scale <1.2, 0.85, 0.4>
    rotate -90.0*x
    translate  <0.0, 3.2, 1.0>
  }
}
#declare BackWall = difference {
  object { BackWallYes }
  box { // WindowHole
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TrimTex
    }
    scale <1.0, 1.0, 0.7>
    translate  <0.0, 2.1, 1.0>
  }
  box { // BackPanelingKiller
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TrimTex
    }
    translate  <0.0, 4.1, 1.0>
  }
  texture {
    Rosewood
  }
}
#declare SinkYes = union {
  box { // TableTop
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Formica
    }
    scale <5.0, 2.25, 0.1>
    translate  1.0*y
  }
  box { // DummyObject
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Rosewood
    }
    scale <1.7, 1.8, 1.0>
    translate  <3.0, 1.0, -1.1>
  }
}
#declare Surface = difference {
  object { SinkYes }
  superellipsoid { // Sink
    <0.2, 0.2>
    texture {
      Chrome1
    }
    scale <1.65, 1.8, 1.0>
    translate  <3.0, 0.95, 0.0>
  }
  cone { // Drain
    <0,0,0>, 0.5, <0,0,1>, 1.0
    texture {
      DrainTex
    }
    scale 0.2
    translate  <2.333333, 0.95, -1.199>
  }
}
union { // Furniture
  box { // Cabinets
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.1, 2.0>
    translate  <0.0, -1.0, -2.0>
    texture {
      Rosewood
    }
  }
  box { // Trim
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TrimTex
    }
    scale <5.0, 0.01, 0.1>
    translate  -1.25*y
  }
  object { BackWall }
  box { // WindowPane
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WindowGlass
    }
    scale <1.0, 0.08, 0.7>
    translate  <0.0, 3.0, 1.0>
  }
  object { Surface }
}


union { // Recipe
  box { // HolderFront
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Plexiglas
    }
    scale <1.0, 0.05, 0.6>
    rotate -12.5*x
  }
  box { // HolderBack
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Plexiglas
    }
    scale <1.0, 0.35, 0.05>
    translate  <0.0, 0.17, -0.55>
  }
  box { // IndexCard
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ChocolateCakeRecipie
      scale <2.0, 2.0, 1.0>
      rotate 90.0*x
      translate <-1.000000, 0.000000, -1.000000>
    }
    scale <0.9, 0.001, 0.54>
    rotate -12.5*x
  }
  scale 0.6
  rotate -12.0*z
  translate  <-0.6, 1.7, 0.46>
}


merge { // Whisk
  cylinder { // Handle
    <0,0,1>, <0,0,0>, 1
    scale <0.09, 0.09, 5.0>
    translate  5.0*z
  }
  object { Tine }
  object { // Tine1->Tine
    Tine
    rotate -45.0*z
  }
  object { // Tine2->Tine
    Tine
    rotate -90.0*z
  }
  object { // Tine3->Tine
    Tine
    rotate -135.0*z
  }
  object { // Tine4->Tine
    Tine
    rotate 180.0*z
  }
  object { // Tine5->Tine
    Tine
    rotate 135.0*z
  }
  object { // Tine6->Tine
    Tine
    rotate 90.0*z
  }
  object { // Tine7->Tine
    Tine
    rotate 45.0*z
  }
  texture {
    Aluminum
  }
  scale <0.15, 0.15, 0.1>
  rotate <101.0, 0.0, -150.0>
  translate  <-1.1, 1.1, 0.3>
}


