
//#include "Pistol.inc"

// Glenn's BlobHand POV-Ray Scene File
// first concept 12-Jun-97 last update 12-Aug-98
// copyright Glenn McCarter 1997-1998
// This file does not render.  #include "BlobHand.inc" in another .pov file
//
// A hand
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system


//================================================================
//      Remove this entire section -- only used for test renders!
//================================================================
/*
//#include "GRuler.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "GIncludeRH.inc"
#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//  location  <-28, -0, 0> // front view
//  look_at   <0, 0, 0>
//  location  <-28, -0, 10> // upper front view
//  look_at   <0, 0, 0>
//  location  <-0, -18, 0> // side view
//  look_at   <0, 0, 0>
//  location  <-6, -4, 18> // top view
//  look_at   <0.000, 0.000, 4.000>
//  location  <-11, -11, 11> // thumb view
//  look_at   <0.000, 0.000, 2.000>
  location  <-15, -12, 6> // 3/4 view
  look_at   <0.000, 0.000, 1.000>
	angle 40
}
camera { Render_Cam }
object {StdBulb60Watt translate <-40,80,70> }
object {StdBulb100Watt translate <-100,-60,80> }
//object {StdBulb50Watt translate <-40,80,-70> }
// this pose is for testing only
#declare HandPose = 1
#declare FFat = 1.23 // finger fatness ratio ( 1 = normal, 1.4 = too fat )
#declare TA  = 30 // thumb, outer joint
#declare TB  = 40 // thumb, middle joint
#declare TRot  = 30 // thumb rotation angle
#declare TExt  = 0 // thumb extension from hand
#declare F1A  = 15 // index finger, outer joint
#declare F1B  = 12 // index finger, middle joint
#declare F1C  = 10 // index finger angle
#declare F1Rot  = 5 // index finger rotation
#declare F2A  = 7 // middle finger, outer joint
#declare F2B  = 8 // middle finger, middle joint
#declare F2C  = 12 // middle finger angle
#declare F2Rot  = 0 // middle finger rotation
#declare F3A  = 5 // ring finger, outer joint
#declare F3B  = 6 // ring finger, middle joint
#declare F3C  = 12 // ring finger angle
#declare F3Rot  = -4 // ring finger rotation
#declare F4A  = 4 // pinky finger, outer joint
#declare F4B  = 6 // pinky finger, middle joint
#declare F4C  = 13 // pinky finger angle
#declare F4Rot  = -3 // pinky finger rotation
#declare WRot = -12 // wrist rotation angle
#declare WCock = -25 // wrist cock side-to-side
*/
//===============================================
//             end test section.
//===============================================


//===============================================
//             Variable Declarations
//===============================================

// Pose Angles ( in order )

#ifndef ( HandPose )
#declare FFat = 1.23; // finger fatness ratio ( 1 = normal, 1.4 = too fat )
#declare TA  = 32; // thumb, outer joint
#declare TB  = 45; // thumb, middle joint
#declare TRot  = 30; // thumb rotation angle
#declare TExt  = 0; // thumb extension from hand
#declare F1A  = 24; // index finger, outer joint
#declare F1B  = 32; // index finger, middle joint
#declare F1C  = 0; // index finger angle
#declare F1Rot  = 10; // index finger rotation
#declare F2A  = 70; // middle finger, outer joint
#declare F2B  = 80; // middle finger, middle joint
#declare F2C  = 20; // middle finger angle
#declare F2Rot  = 0; // middle finger rotation
#declare F3A  = 55; // ring finger, outer joint
#declare F3B  = 68; // ring finger, middle joint
#declare F3C  = 26; // ring finger angle
#declare F3Rot  = -4; // ring finger rotation
#declare F4A  = 42; // pinky finger, outer joint
#declare F4B  = 66; // pinky finger, middle joint
#declare F4C  = 32; // pinky finger angle
#declare F4Rot  = -10; // pinky finger rotation
#declare WRot = -12; // wrist angle
#declare WCock = -25; // wrist cock side-to-side
#end



#declare InverseY = // forms a mirror image
	transform {
  	matrix < 1, 0, 0,
             0, -1, 0,
             0, 0, 1,
             0, 0, 0 >
	}

//===============================================
//             Textures
//===============================================

#declare SkinTex =
	texture {
//		pigment { color rgb<.94,.92,.74> } // yellowish
		pigment { color rgb<1.14,1.08,.74> } // yellowish test
//		pigment { color rgb<.90,.80,.68> } // really pasty whitish
//		pigment { color rgb<.90,.80,.50> } // more whitish
//		pigment { color rgb<.93,.62,.35> } // more reddish
		finish { ambient .12 specular .1 roughness .1 }
	}
#declare FingernailTex =
	texture {
		pigment { color rgbt<1.06,1.02,.76,.3> }
		finish { ambient .17 specular .5 roughness .03 }
	}

//===============================================
//       Objects
//===============================================


#declare BlobThreshold = .65;
#declare BT = BlobThreshold;
   // this controls the raw size of the components.
   // the larger the number, the smaller the raw component,
   // although the "joins" remain big.
#declare BlobRadiusFactor = 1.6;
#declare BHRF = BlobRadiusFactor;
   // this controls the size of the "join"
   // between components.  The bigger,
   // the thicker the "connecting tissue"
   // (but also the bigger the component).
#declare BlobStrengthFactor = .96;
#declare BSF = BlobStrengthFactor;
   // This is the strength of the blob components.
   // Also controls the size of the "join".
   // but also the bigger the factor, the bigger the blob itself.
   //
   // HINTS
   // A perpendicular, negative cylinder at a join will depress it
   // along the cyl axis.
   // Always make BT bigger and BRF smaller, or vice-versa
   // interesting combinations of crossed cylinders:
   // BT=1 BRF=1 BSF=1: tiny overall, slightly pointed, no cyls
   // BT=.01 BRF=1 BSF=1: sharp corners at joins
   // BT=0.5 BRF=1 BSF=1: nice overall
   //
   // Blob NEGATIVE depressions:
   //		BRF*3.6, -BSF/NSF*4, scale 1 = VERY gentle overall push
   //   BRF*1.0, -BSF/NSF*8, scale 1 = almost sharp edged
   //   BRF*1.0, -BSF/NSF*4, scale 1 = small and deep
   //   BRF*1.0, -BSF/NSF*2, scale 1 = like a poke in a balloon
   //   BRF*1.0, -BSF/NSF*2, scale 1.5 = soft rubber
   //
   // Blob POSITIVE push outs:
   //		BRF*1, BSF*1, scale 1 = too much like a big wart
   //		BRF*1, BSF*3, scale 1 = even sharper join on wart
   //		BRF*1, BSF*.3, scale 1 = gentler radius on wart
   //		BRF*1, BSF*.03, scale 1 = VERY gentle pull out
   //		BRF*3, BSF*.5, scale 1 = huge elephant head


#declare BT  = 0.75; // Blob Threshold
#declare BRF = 1.0;  // Blob Radius Factor
#declare BSF = 1.0;  // Blob Strength Factor
#declare NSF = 24.0; // Negative Strength Factor ( divisor )

#declare TestBlob =
	blob {
		threshold BT
			sphere { // START: main hand
				<0,0,0>,BRF*7.2,BSF
				scale <1,.75,1>
				translate <0,0,0>
			}
/*
			sphere { // TEST: flatten hand
				<0,0,0>,
//				BRF*3.6, -BSF/NSF*4 // VERY gentle
//				scale <1.0,1.0,1.0>
//				translate <-3.0,0,0>
				BRF*3.0, -BSF/NSF*4
				scale <1.0,1.0,1.0>
				translate <-3.0,0,0>
			}
*/
			sphere { // add feature
				<0,0,0>,
				BRF*1.0, BSF*.03
				scale <1.0,1.0,1.0>
				translate <-4.0,0,0>
			}

		texture { SkinTex }
		translate <0,0,2>
	}

//------------ Fingernail ----------------
#declare Fingernail =
	intersection {
		cylinder { // outer surf
			<-1,0,0>,<1,0,0>,FFat*.26
		}
		cylinder { // inner surf
			<-1,0,0>,<1,0,0>,FFat*.25
			inverse
		}
		cylinder { // trim edge
			<.2,0,-1>,<.2,0,1>,FFat*.4
			scale <1,1,1>
		}
		cylinder { // quick edge
			<-.1,0,-1>,<-.1,0,1>,FFat*.4
			scale <1,1,1>
		}
		box { // only keep upper half
			<-.9,-.9,0>,<.9,.9,.9>
		}
		texture { FingernailTex }
	}

//------------ Index Finger ----------------
#declare F1Tip =
	union {
		object { Fingernail translate <0,0,.02> }
		sphere { // fingertip
			<0,0,0>,FFat*.25
		}
		cone { // first digit
			<0,0,0>,FFat*.25,<.7,0,0>,FFat*.33
		}
		texture { SkinTex }
		translate <-.7,0,0> // origin at first joint
		rotate <0,-F1A,-2>
	}
#declare F1Outer =
	union {
		object { F1Tip }
		sphere { // joint
			<0,0,0>,FFat*.33
		}
		cone { // second digit
			<0,0,0>,FFat*.33,<1.2,0,0>,FFat*.38
		}
		texture { SkinTex }
		translate <-1.2,0,0> // origin at second joint
		rotate <0,-F1B,-3>
	}
#declare IndexFinger =
	union {
		object { F1Outer }
		sphere { // joint
			<0,0,0>,FFat*.38
		}
		cone { // second digit
			<0,0,0>,FFat*.38,<1.9,0,0>,FFat*.44
		}
		sphere { // knuckle
			<1.9,0,0>,FFat*.44
		}
		texture { SkinTex }
		scale <1,1.2,1>
		translate <-1.9,0,0> // origin at hand joint
		rotate <0,-F1C,F1Rot>
	}

//------------ Middle Finger ----------------
#declare F2Tip =
	union {
		object { Fingernail scale 1.06 translate <0,0,.02> }
		sphere { // fingertip
			<0,0,0>,FFat*.25
		}
		cone { // first digit
			<0,0,0>,FFat*.25,<.8,0,0>,FFat*.33
		}
		texture { SkinTex }
		translate <-.8,0,0> // origin at first joint
		rotate <0,-F2A,0>
	}
#declare F2Outer =
	union {
		object { F2Tip }
		sphere { // joint
			<0,0,0>,FFat*.33
		}
		cone { // second digit
			<0,0,0>,FFat*.33,<1.4,0,0>,FFat*.38
		}
		texture { SkinTex }
		translate <-1.4,0,0> // origin at second joint
		rotate <0,-F2B,0>
	}
#declare MiddleFinger =
	union {
		object { F2Outer }
		sphere { // joint
			<0,0,0>,FFat*.38
		}
		cone { // second digit
			<0,0,0>,FFat*.38,<2.2,0,0>,FFat*.44
		}
		sphere { // knuckle
			<2.2,0,0>,FFat*.44
		}
		texture { SkinTex }
		scale <1,1.2,1>
		translate <-2.2,0,0> // origin at hand joint
		rotate <0,-F2C,F2Rot>
	}

//------------ Ring Finger ----------------
#declare F3Tip =
	union {
		object { Fingernail scale 1 translate <.05,0,.02> }
		sphere { // fingertip
			<0,0,0>,FFat*.25
		}
		cone { // first digit
			<0,0,0>,FFat*.25,<.7,0,0>,FFat*.33
		}
		texture { SkinTex }
		translate <-.7,0,0> // origin at first joint
		rotate <0,-F3A,1>
	}
#declare F3Outer =
	union {
		object { F3Tip }
		sphere { // joint
			<0,0,0>,FFat*.33
		}
		cone { // second digit
			<0,0,0>,FFat*.33,<1.3,0,0>,FFat*.38
		}
		texture { SkinTex }
		translate <-1.3,0,0> // origin at second joint
		rotate <0,-F3B,3>
	}
#declare RingFinger =
	union {
		object { F3Outer }
		sphere { // joint
			<0,0,0>,FFat*.38
		}
		cone { // second digit
			<0,0,0>,FFat*.38,<1.9,0,0>,FFat*.44
		}
		sphere { // knuckle
			<1.9,0,0>,FFat*.44
		}
		texture { SkinTex }
		scale <1,1.2,1>
		translate <-1.9,0,0> // origin at hand joint
		rotate <0,-F3C,F3Rot>
	}

//------------ Pinky Finger ----------------
#declare F4Tip =
	union {
		object { Fingernail scale .8 translate <.04,0,.02> }
		sphere { // fingertip
			<0,0,0>,FFat*.20
		}
		cone { // first digit
			<0,0,0>,FFat*.20,<.6,0,0>,FFat*.30
		}
		texture { SkinTex }
		translate <-.6,0,0> // origin at first joint
		rotate <0,-F4A,2>
	}
#declare F4Outer =
	union {
		object { F4Tip }
		sphere { // joint
			<0,0,0>,FFat*.30
		}
		cone { // second digit
			<0,0,0>,FFat*.30,<0.8,0,0>,FFat*.36
		}
		texture { SkinTex }
		translate <-0.8,0,0> // origin at second joint
		rotate <0,-F4B,2>
	}
#declare PinkyFinger =
	union {
		object { F4Outer }
		sphere { // joint
			<0,0,0>,FFat*.36
		}
		cone { // second digit
			<0,0,0>,FFat*.36,<1.5,0,0>,FFat*.40
		}
		sphere { // knuckle
			<1.5,0,0>,FFat*.40
		}
		texture { SkinTex }
		scale <1,1.2,1>
		translate <-1.5,0,0> // origin at hand joint
		rotate <0,-F4C,F4Rot>
	}

//------------ Thumb ----------------
#declare TTip =
	union {
		object { Fingernail scale 1.2 rotate <0,-8,0> translate <0,0,.04> }
		sphere { // fingertip
			<0,0,0>,FFat*.33
		}
		cone { // first digit
			<0,0,0>,FFat*.33,<1.0,0,0>,FFat*.40
		}
		texture { SkinTex }
		translate <-1.0,0,0> // origin at first joint
		rotate <0,-TA,0>
	}
#declare TOuter =
	union {
		object { TTip }
		sphere { // joint
			<0,0,0>,FFat*.40
		}
		cone { // second digit
			<0,0,0>,FFat*.40,<1.4,0,0>,FFat*.50
		}
		texture { SkinTex }
		translate <-1.4,0,0> // origin at second joint
		rotate <0,-TB,0>
		rotate <60,0,0>
	}
#declare Thumb =
	union {
		object { TOuter }
		sphere { // joint
			<0,0,0>,FFat*.50
		}
		cone { // second digit
			<0,0,0>,FFat*.50,<2.3,0,0>,FFat*.50
		}
		sphere { // knuckle
			<2.3,0,0>,FFat*.50
		}
		texture { SkinTex }
		scale <1,1.2,1>
		translate <-2.3,0,0> // origin at hand joint
		rotate <0,-TRot,TExt+20>
	}

//------------ Hand Blob ----------------
#declare HandBlob = // origin at center of palm
	blob {
		threshold BT
		cylinder { // first finger
			<0,0,0>,<3.7,0,0>,
			BRF*0.8,BSF*1.7
			scale <1,1.2,1>
			rotate <0,0,0>
			translate <0,0,0>
		}
		cylinder { // middle finger
			<0,0,0>,<3.5,0,0>,
			BRF*0.8,BSF*1.7
			scale <1,1.2,1>
			rotate <0,0,-4>
			translate <0.15,1,.2>
		}
		cylinder { // ring finger
			<0,0,0>,<3.2,0,0>,
			BRF*0.8,BSF*1.7
			scale <1,1.2,1>
			rotate <0,0,-8>
			translate <0.30,1.7,.1>
		}
		cylinder { // pinky
			<0,0,0>,<3.0,0,0>,
			BRF*0.8,BSF*1.7
			scale <1,1.2,1>
			rotate <0,0,-12>
			translate <0.45,2.6,-.2>
		}
		cylinder { // thumb flesh1
			<0,0,0>,<2.4,0,0>,
			BRF*1.0,BSF*1.7
			scale <1,1.4,1>
			rotate <0,0,8>
			translate <1.4,-0.5,-.4>
		}
		cylinder { // thumb flesh2
			<-1.6,0,0>,<.2,0,0>,
			BRF*0.8,BSF*1.7
			scale <1,1.4,1>
			rotate <0,-TRot,20>
			translate <2.6,-1.0,-.6>
		}
		cylinder { // wrist index
			<0,0,0>,<4,0,0>,
			BRF*1.2,BSF*1.7
			scale <1,1.2,1>
			rotate <0,WRot,WCock>
			translate <4,0,-.4>
		}
		cylinder { // wrist middle
			<0,0,0>,<4,0,0>,
			BRF*1.2,BSF*1.7
			scale <1,1.2,1>
			rotate <0,WRot,WCock>
			translate <4,.7,-.2>
		}
		cylinder { // wrist outer
			<0,0,0>,<4,0,0>,
			BRF*1.2,BSF*1.7
			scale <1,1.2,1>
			rotate <0,WRot,WCock>
			translate <4,1.4,-.4>
		}
		translate <-0,0,0>
		texture { SkinTex }
	}


#declare RightHand = // palm down on XY, origin at base of index finger
	union {
		object { HandBlob }
		object { IndexFinger translate <0,0,0> }
		object { MiddleFinger translate <.15,1,.2> }
		object { RingFinger translate <.30,1.7,.1> }
		object { PinkyFinger translate <.45,2.6,-.2> }
		object { Thumb translate <3.2,-.8,-.4> }
		translate <-3.5,-.7,.8> // origin at wrist
		rotate <0,-WRot,-WCock>
	}
#declare LeftHand =
	object { RightHand transform InverseY }
/*
#declare LeftHandWithGun =
	union {
		object { LeftHand }
//		object { Revolver38 scale 1.4 rotate <-90,0,-25> rotate <12,0,0> translate <-6,6.8,1> }
	}
#declare LeftHandWithGunFiring =
	union {
		object { LeftHand }
//		object { Revolver38Flash scale 1.4 rotate <-90,0,-25> rotate <12,0,0> translate <-6,6.8,1> }
	}
*/
//object { TestBlob }
//object { RightHand rotate <-30,0,0> translate <2,0,0> }
//object { LeftHand rotate <80,0,-30> translate <0,0,0> }
//object { LeftHandWithGun rotate <90,0,-60> translate <0,0,-1> }

