
// Glenn's POV-Ray Object File - Cafe Objects
// created 17-Aug-98
// last update 27-Aug-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "CafeObjects.inc" in another .pov file
//
//
// This file uses "Chairs.inc" and "Tables.inc", which must be #included first
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare BarTex =
	texture {
		pigment { color rgb<.62,.67,.75> }
		normal { bumps .4 scale <6,1,1> }
		finish { phong .6 phong_size 240 }
	}

#declare LetteringTex =
	texture {
		pigment { color rgb<.37,.37,.15> }
		finish { specular .6 roughness .05 }
	}


//===============================================
//             Objects
//===============================================

#declare SBar = // simple version
	union {
		box { <0,0,0>,<14*Feet,18,40> } // base
		box { <0,-6,0>,<14*Feet,20,6> translate <0,0,40> } // top
		cylinder { <0,0,0>,<14*Feet,0,0>,3.6 scale <1,.7,1> translate <0,-6,43> } // edge
		texture { BarTex }
	}

#declare WindowLettering =
	union {
		text {
			ttf "TIMESBD.TTF",
			"CAFE",
			.05,     // THICKNESS_FLOAT, extruded into +Z
			0       //OFFSET_VECTOR
			scale <8,8,1>
			rotate <90,0,180>
		}
		#local UArray = array[7]
		#local UArray[0] = "P"
		#local UArray[1] = "O"
		#local UArray[2] = "V"
		#local UArray[3] = "-"
		#local UArray[4] = "R"
		#local UArray[5] = "a"
		#local UArray[6] = "y"
		#local UCount = 0;
		#while ( UCount < 7 )
			text {
				ttf "TIMESBD.TTF",
				UArray[UCount],
				.05,     // THICKNESS_FLOAT, extruded into +Z
				0       //OFFSET_VECTOR
				scale <4,3,1>
				rotate <90,0,180>
				translate <0,0,18>
				rotate <0,30-UCount*(60/7),0>
				translate <-11,0,-8>
			}
			#local UCount = UCount + 1;
		#end

		#local LArray = array[7]
		#local LArray[0] = "S"
		#local LArray[1] = "p"
		#local LArray[2] = "e"
		#local LArray[3] = "c"
		#local LArray[4] = "i"
		#local LArray[5] = "a"
		#local LArray[6] = "l"
		#local LCount = 0;
		#while ( LCount < 7 )
			text {
				ttf "TIMESBD.TTF",
				LArray[LCount],
				.05,     // THICKNESS_FLOAT, extruded into +Z
				0       //OFFSET_VECTOR
				scale <4.4,4,1>
				rotate <90,0,180>
				translate <0,0,-18>
				rotate <0,-30+LCount*(60/7),0>
				translate <-11,0,12>
			}
			#local LCount = LCount + 1;
		#end
		texture { LetteringTex }
	}



#declare RoomObjects = // most of these are not directly seen, only in reflections
	union {
		object { SChair rotate z*178 translate <-6.4*Feet,6,-36> }
		object { CarbonFiberTable(24,30,0) translate <-5*Feet,0,0> }
		object { SChair rotate z*5 translate <-3.8*Feet,3,-36> }

		object { MChair rotate z*178 translate <4.1*Feet,6,-36> } // visible in scene
		object { CarbonFiberTable(24,30,0) translate <5*Feet,0,0> }
		object { SChair rotate z*1 translate <6*Feet,2,-36> }

		object { SChair rotate z*182 translate <9*Feet,2,-36> }
		object { CarbonFiberTable(24,30,0) translate <10*Feet,0,0> }
		object { SChair rotate z*3 translate <9*Feet,2,-36> }

		object { SChair rotate z*185 translate <14.3*Feet,4,-36> }
		object { CarbonFiberTable(24,30,0) translate <15*Feet,0,0> }
		object { SChair rotate z*-4 translate <16*Feet,2,-36> }

		object { SBar rotate z*180 translate <14*Feet,-9*Feet,-36> }
		object { SDinerStool rotate z*80 translate <-3*Feet,-8*Feet,-36> }
		object { SDinerStool rotate z*80 translate <0,-8*Feet,-36> }
		object { SDinerStool rotate z*47 translate <3*Feet,-8*Feet,-36> }
		object { SDinerStool rotate z*92 translate <6*Feet,-8*Feet,-36> }
		object { SDinerStool rotate z*102 translate <9*Feet,-8*Feet,-36> }

	}
