
// Glenn's POV-Ray Object File - Coffee
// created 27-Jul-98
// last update 30-Aug-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Coffee.inc" in another .pov file
//
// Objects:
// Saucer
// CoffeeCup
// CoffeeCupSpilling
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare ChinaWhite =
	texture {
		pigment { color rgb<1,1,1.08> }
//		finish { ambient .65 specular .9 roughness .005 } // test
		finish { ambient .35 specular .9 roughness .005 reflection .3 } // render
	}
#declare CoffeeTex =
	texture {
//		pigment { color rgb <.68,.58,.38    > } // test
//		pigment { color rgbf<.68,.58,.38,.64> } // too brown
//		pigment { color rgbf<.59,.49,.32,.68> } // too thin
		pigment { color rgbf<.42,.36,.23,.35> } // nice dark roast
		normal { bumps .8 scale .65 }
//		finish { ambient .10 specular .96 roughness .005               } // test
		finish { ambient .10 specular .96 roughness .003 reflection .19 } // render
	}
#declare CoffeeInt =
	interior {
		ior 1.33
	}

//===============================================
//             Objects
//===============================================

#declare Saucer =
	lathe { // around Y-axis
		cubic_spline
		11, // # of points
		<-1,0> // slope point not on curve
		<0,0>, <1,0>, <1.8,.4>, <2.5,.5>, // lower side
		<2.5,.6>, <2.4,.55>, // rim
		<1.8,.5>, <1,.2>, <0,.2>, // top side
		<-1,.2> // slope point not on curve
		// [open]
		rotate x*90 // set it upright
		texture { ChinaWhite }
	}

#declare CoffeeCupShape =
	union {
		lathe { // around Y-axis
			cubic_spline
			16, // # of points
			<-1,0> // slope point not on curve
			<0,0>, <1,0>, <1.4,.5>, <1.45,.9>, <1.5,1.7>, // sidewall
			<1.6,1.9>, <1.6,1.95>, <1.55,1.95>, <1.5,1.925>, // lip
			<1.4,1.75>, <1.32,.9>, <1.2,.5>, <1,.2>, <0,.2>,
			<-1,.2> // slope point not on curve
			// [open]
			rotate x*90 // set it upright
		}
		difference { // handle
			torus {
				0.6,.05
			}
			box {
				<.2,-1,-2>,<2,1,2>
			}
			scale <.7,2,1>
			rotate y*-10
			translate <-1.5,0,1.0>
		} // end difference
} // end union

#declare CoffeeCup =
	object { CoffeeCupShape texture { ChinaWhite } }



#local BlobRadiusFactor = 1.0;
#local BRF = BlobRadiusFactor;
#local BlobStrengthFactor = 1.0;
#local BSF = BlobStrengthFactor;

#declare SpillingCoffee =
	difference {
	blob {
		threshold .55
		cylinder { <0,0,0>,<0,0,.1>,BRF*3.4,BSF*1 scale <1,1,.3> rotate <12,0,0> } // main surface
		cylinder { <0,0,0>,<0,0,.5>,BRF*.57,BSF*.7 rotate <-5,11,0> translate <0.4,1.2,0> }
		cylinder { <0,0,0>,<0,0,.8>,BRF*.51,BSF*.7 rotate <-8,-14,0> translate <-0.4,1.2,0> }
		sphere { <0,0,0>,BRF*.48,BSF*.7 scale <.32,.63,1> rotate <3,12,5> translate <-0.1,0.9,1.0> } // far
		sphere { <0,0,0>,BRF*0.88,BSF*.7 scale <.62,.71,1> rotate <-8,-8,14> translate <-0.6,1.55,1.47> } // near
		sphere { <0,0,0>,BRF*0.58,BSF*.7 scale <.87,.84,1> rotate <-42,-8,14> translate <-1.06,1.61,1.02> } // near, over the edge
//		texture { WhitePaint }
		texture { CoffeeTex }
		interior { CoffeeInt }
		translate <0,0,1.2>
	} // end blob
		difference { // simulated cup shape
			cylinder { <0,0,0>,<0,0,1.9>,4 } // outer
			cylinder { <0,0,0.5>,<0,0,2>,1.5 } // inner
			texture { CoffeeTex }
		} // end difference
	} // end difference

#declare CoffeeCupSpilling =
	union {
		object { CoffeeCup rotate <0,0,-20> }
		object { SpillingCoffee scale <.92,.92,.85> translate <0,0,.25> }
	}

