
//#include "BlobHand31.inc" (see below)

// Glenn's POV-Ray Scene File - Dummy
// first concept 18-Aug-98 last update 18-Aug-98
// Based upon Glenn's "BlobMan.inc"
// copyright Glenn McCarter 1998 (gmccarter@hotmail.com)
// This file does not render.  #include "Dummy.inc" in another .pov file
//
// Objects:
// "SDummy" a sitting person, little detail, renders quickly
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system
// Origin at base of neck
// +X is towards the back of the person.

//================================================================
//      Remove this section -- only used for test renders!
//================================================================

/*
#include "GRuler.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "GIncludeRH.inc"
#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//  location  <-13, -10, 7> // origin closeup
//  look_at   <0.000, 0.000, 0.000>
//  location  <-33, -0, 7> // head front view
//  look_at   <0.000, 0.000, 4.000>
//  location  <2, -30, 4> // head side view
//  look_at   <2, 0, 4>
//  location  <-1, -1, 28> // top view
//  look_at   <0.000, 0.000, 4.000>
//  location  <-9, -4, 2.2> // eye closeup
//  look_at   <0.000, 0.000, 2.200>
//  location  <-25, -22, 7> // 3/4 head view
//  look_at   <0.000, 0.000, 4.000>
//  location  <0, -66, 0> // overall side view
//  look_at   <0, 0, -6>
//  location  <-60, 0, 4> // overall front view
//  look_at   <0, 0, -4>
//  location  <-52, -48, 8> // 3/4 overall view
//  look_at   <0.000, 0.000, -8.000>
  location  <-28, -95, 8> // render view
  look_at   <-8, 0, -12>
	angle 40
}
camera { Render_Cam }
//object {StdBulb60Watt translate <-40,80,70> }
object {StdBulb60Watt translate <40,-80,70> }
object {StdBulb100Watt translate <-100,-40,80> }
*/

//===============================================
//             Variable Declarations
//===============================================

#ifndef ( Pose )
// Pose Angles ( in order )
#declare HPan     = 2;   // head, positive = towards his left
#declare HTiltFwd = 15;   // head forward tilt
#declare HCock    = 20;    // head right/left tilt, positive = to the left
#declare TTwist   = 0;    // torso twist, positive = right hip fwd
#declare HipTude  = 0;    // hip attitude, positive = right hip up
#declare RWCock   = 0;    // wrist side-to-side (golf)
#declare RWAng    = 0;    // wrist angle
#declare RETwist  = 20;   // twists the hand, positive = palms up
#declare REAng    = 70;  // elbow
#declare RAFwd    = 4;   // total arm
#declare RARot    = 12;   // claps hands
#declare RAOut    = 2;   // opens underarm
#declare RAFwd2   = 0;    // total arm
#declare RARot2   = 0;    // claps hands
#declare RKnee    = 90;
#declare RLTwist  = 0;    // leg twist
#declare RLAng    = 90;    // leg angle fwd
#declare RLOut    = 5;    // spread eagle
#declare LWCock   = 25;   // wrist side-to-side (golf)
#declare LWAng    = 15;    // wrist angle
#declare LETwist  = 35;  // twists the hand, positive = palms up
#declare LEAng    = 99;   // elbow
#declare LAFwd    = 10;   // total arm
#declare LARot    = 0;   // claps hands
#declare LAOut    = 0;    // opens underarm
#declare LAFwd2   = 0;    // total arm
#declare LARot2   = 0;  // claps hands
#declare LKnee    = 90;
#declare LLTwist  = 0;    // leg twist
#declare LLAng    = 90;    // leg angle fwd
#declare LLOut    = 5;    // spread eagle

// RightHand Pose Angles ( in order )
#declare HandPose = 1;
#declare FFat = 1.23; // finger fatness ratio ( 1 = normal, 1.4 = too fat )
#declare TA  = 36; // thumb, outer joint
#declare TB  = 25; // thumb, middle joint
#declare TRot  = 30; // thumb rotation angle
#declare TExt  = -6; // thumb extension from hand
#declare F1A  = 44; // index finger, outer joint
#declare F1B  = 52; // index finger, middle joint
#declare F1C  = 15; // index finger angle
#declare F1Rot  = 10; // index finger rotation
#declare F2A  = 70; // middle finger, outer joint
#declare F2B  = 80; // middle finger, middle joint
#declare F2C  = 20; // middle finger angle
#declare F2Rot  = 0; // middle finger rotation
#declare F3A  = 55; // ring finger, outer joint
#declare F3B  = 68; // ring finger, middle joint
#declare F3C  = 26; // ring finger angle
#declare F3Rot  = -4; // ring finger rotation
#declare F4A  = 42; // pinky finger, outer joint
#declare F4B  = 66; // pinky finger, middle joint
#declare F4C  = 32; // pinky finger angle
#declare F4Rot  = -10; // pinky finger rotation
#declare WRot = -12; // wrist angle
#declare WCock = -25; // wrist cock side-to-side

#include "BlobHand31.inc"
#end

//===============================================
//             Textures
//===============================================

#declare ClothTex =
	texture {
		pigment {color rgb<.65,.25,.16> }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .08 specular .3 roughness .03 }
	}

/*
#declare SkinTex =
	texture {
//		pigment { color rgb<.9,.8,.5> } // more whitish
		pigment { color rgb<.93,.62,.35> } // more reddish
		finish { ambient .12 specular .1 roughness .1 }
	}
*/

//===============================================
//       Objects
//===============================================


#declare TorsoHalf =
	union {
		sphere { // upper shoulders
			<0,0,0>,9
			scale <.4,1,.4>
			texture { ClothTex }
		}
		cylinder { //torso
			<0,0,0>,<0,0,-14>,9
			scale <.4,1,1>
			texture { ClothTex }
		}
		sphere { // lower end
			<0,0,0>,9
			scale <.4,1,.3>
			translate <0,0,-14>
			texture { ClothTex }
		}
		rotate <10,0,0>
		clipped_by { box {<-6,0,6>,<6,-12,-30>}}
	}

#declare Torso = //center where neck/shoulder join each other
	union {
		object { TorsoHalf }
		object { TorsoHalf transform InverseY }
	}
#declare LHand = // points straight down
	object { LeftHand
			rotate <0,-90,0> // point downwards
			rotate <0,LWCock,LWAng> // wrist angles
			translate <-0.0,0.6,-1.6> // drop down, move to touch sleeve
		}
#declare LLowerArm =
	union {
		object { LHand scale .5 }
			cone { //lower sleeve except cuff
				<0,0,2>,1.82,<0,0,11>,2.2
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		difference {
			cylinder { //lower sleeve outer
				<0,0,0>,<0,0,2.1>,1.9
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.85
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare LeftArm = //origin at shoulder
	union {
		object { LLowerArm rotate <0,0,LETwist> rotate <0,LEAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { ClothTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { ClothTex }
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare RHand = // points straight down
	object { RightHand
		rotate <0,-90,0> // point downwards
		translate <0.0,-0.6,-1.0> // drop down, move to touch sleeve
	}
#declare RLowerArm =
	union {
		object { RHand scale .5 }
		difference {
			cone { //lower sleeve outer
				<0,0,0>,1.9,<0,0,11>,2.2
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.8
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare RightArm = //origin at shoulder
	union {
		object { RLowerArm rotate <0,0,-RETwist> rotate <0,REAng,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { ClothTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { ClothTex }
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare RLowerLeg =
	union {
		sphere { // knee end
			<0,0,17>,2.5
			texture { ClothTex }
		}
		cone { // lower leg
			<0,0,0>,2.0,<0,0,17>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at knee
	}

#declare LLowerLeg =
	union {
		sphere { // knee end
			<0,0,17>,2.5
			texture { ClothTex }
		}
		cone { // lower leg
			<0,0,0>,2.0,<0,0,17>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at knee
	}

#declare RightLeg = // origin at pelvis joint
	union {
		object { RLowerLeg rotate <0,0,-RLTwist> rotate <0,-RKnee,0> }
		sphere { // knee end
			<0,0,0>,2.5
			texture { ClothTex }
		}
		cone { // upper leg
			<0,0,0>,2.5,<0,0,18>,3.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { // pelvis end
			<0,0,18>,3.5
			texture { ClothTex }
		}
		translate <0,0,-18> // origin at pelvis joint
	}

#declare LeftLeg = // origin at pelvis joint
	union {
		object { LLowerLeg rotate <0,0,-LLTwist> rotate <0,-LKnee,0> }
		sphere { // knee end
			<0,0,0>,2.5
			texture { ClothTex }
		}
		cone { // upper leg
			<0,0,0>,2.5,<0,0,18>,3.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { // pelvis end
			<0,0,18>,3.5
			texture { ClothTex }
		}
		translate <0,0,-18> // origin at pelvis joint
	}


#declare LowerTorso =
	union {
		object { LeftLeg
			rotate <-LLOut,LLAng,0>
			translate <0,-3,0>
		}
		object { RightLeg
			rotate <RLOut,RLAng,0>
			translate <0,3,0>
		}
	} // end union

#declare DHead =
	union {
		sphere {
			<0,0,0>,4.5
			scale <.9,.7,1>
		}
		cylinder {
			<0,0,-8>,<0,0,0>,2.7
		}
		texture { SkinTex }
		translate <0,0,7> // origin at base of neck
	}

#declare SDummy = //center at base of neck
	union {
		object { DHead rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { Torso rotate <0,0,0> translate <0,0,0> }
		object { LeftArm
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-8,-1> // hang it on the shoulder
		}
		object { RightArm
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,8,-1> // hang it on the shoulder
		}
		object { LowerTorso
			rotate <HipTude,0,0>
			rotate <0,0,TTwist>
			translate <0,0,-18> // hang it on the spine
		}
	}


//object { SDummy }

