
// Glenn's POV-Ray Scene File - Pattern Generator
// created 30-Aug-98
// last update 30-Aug-98
// copyright 1998 Glenn McCarter
//
// This file creates a pattern suitable for use as a
// bitmap for an image_map texture on an object.

#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.1;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  /* // Radiosity section: uncomment to enable radiosity
  // calculations; must also turn on radiosity in ini file.
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
  */ // end radiosity section
}

//===============================================
//             Variables
//===============================================


//===============================================
//             Cameras
//===============================================


#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  4*1.0>  // Where Z is up
  right     <4*1.0, 0.0,  0.0>
	orthographic
//    angle 60
//    direction z*50
  location <.01, .01, 3>
  look_at <0, 0, .1>
  rotate z*45
  }

camera {
    Special_Cam
  }

//===============================================
//             Textures
//===============================================

#declare XFiberTex =
	texture {
		pigment { color rgb<.92,.89,.64> }
		normal { bumps .9 scale <1,.15,1> }
		finish { ambient .05 metallic specular .5 roughness .08 }
	}


//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> } // quick sun
object {StdBulb60Watt translate <-10*Feet,1.2*Feet,5*Feet> } // over shoulder
#declare FillSpot =
  light_source {
    <4,-4,5>
    color rgb <.78, .75, .61>*.5
    spotlight
    point_at <0,0,0>
    radius 22    // degrees fully lit (*2)
    falloff 42   // degrees no lighting (*2)
    tightness 1
  }
object { FillSpot }



//===============================================
//             Environment
//===============================================

//background { color rgb <0.0, 0.0, 0.0> } // black
//object {GroundPlaneWhite translate z*-0}

//===============================================
//             Objects
//===============================================

//------------ Woven Carbon Fiber Fabric ---------------------

#declare TranSeed = seed(15730);
#macro CarbonFiberBundle(Dummy)
	superellipsoid {
		<.2,.6>
		texture { XFiberTex translate <rand(TranSeed)*20,rand(TranSeed)*20,rand(TranSeed)*20> }
		scale .17
	}
#end
#macro CFUnitSquare(Randomness) // use Randomness from 0 to 1, higher = more random sizes
	#local RS = seed(73709);
	union {
		object { CarbonFiberBundle(1) scale <1,rand(RS)*Randomness+(1-Randomness),rand(RS)*Randomness/3+(1-Randomness/3)> }
		object { CarbonFiberBundle(1) scale <1,rand(RS)*Randomness+(1-Randomness),rand(RS)*Randomness/3+(1-Randomness/3)> translate <.25,.25,0> }
		object { CarbonFiberBundle(1) scale <1,rand(RS)*Randomness+(1-Randomness),rand(RS)*Randomness/3+(1-Randomness/3)> rotate z*90 translate <.25,0,0> }
		object { CarbonFiberBundle(1) scale <1,rand(RS)*Randomness+(1-Randomness),rand(RS)*Randomness/3+(1-Randomness/3)> rotate z*90 translate <0,.25,0> }
	}
#end
#macro CFYGroup(Ysize)
	union {
		#local YCount = 0;
		#while ( YCount < Ysize*2 ) // *2 because the unit cell is only 1/2-inch
			object { CFUnitSquare(.3) translate <0.125,YCount*.5+.125,-0.1> }
			#local YCount = YCount + 1;
		#end
	}
#end
#macro CarbonFiberSurf(Xsize,Ysize)
	union {
		#local XCount = 0;
		#while ( XCount < Xsize*2 ) // *2 because the unit cell is only 1/2-inch
			object { CFYGroup(Ysize) translate <XCount*.5,0,0> }
			#local XCount = XCount + 1;
		#end
		box { // opaque bottom
			<0,0,-.4>,<Xsize,Ysize,0>
			texture { pigment { color rgb<0,0,0> } }
		}
		translate <0,0,-.16> // top at zero
	}
#end

object { CarbonFiberSurf(6,6) translate <-3,-3,0> }


