#include "colors.inc"
#include "shapes.inc"
#include "glass.inc"
#include "textures.inc"
#include "woods.inc"
#include "stones.inc"
#include "metals.inc"

#include "stele.inc"
#include "hydrotalcite.inc"

#include "pinkmarb.map"
#include "marbteal.map"
#include "teak.map"


 #declare PolyTyp01            =
  texture { pigment { color Gray90 }
       finish { specular 2 roughness .01 reflection .6 } }
 #declare PolyTyp02            =
  texture { pigment { rgb <0.0, 0.0, 1.0> }
       finish { specular 2 roughness .01 reflection .6 } }
 #declare PolyTyp03            =
  texture { pigment {color rgb <  1.000   0.000   0.000  > }
       finish { phong 1 phong_size 100 ambient .15 diffuse .7 } }
 #declare PolyTyp04            =
  texture { pigment {color Red }
       finish { phong 1 phong_size 100 ambient .15 diffuse .7 } }

 #declare SphereTyp01          =
  texture { pigment { rgb <1.0, 0.0, 0.0> }
       finish { specular 2 roughness .01 reflection .6 } }
 #declare SphereTyp02          =
  texture { pigment { rgb <0.0, 1.0, 0.0> }
       finish { specular 2 roughness .01 reflection .6 } }
 #declare SphereTyp03          =
  texture { pigment { rgb <1.0, 1.0, 1.0> }
       finish { specular 2 roughness .01 reflection .6 } }

//*************************************
// the camera section

camera { location <  80,  10,  0 > look_at  <   0,   0,  0 > }
//camera { location <  40,   -10,  0 > look_at  <   0,   -10,  0 > }
//camera { location <  50,   10,  0 > look_at  <   0,   10,  0 > }

//*************************************

// the light section
//light_source { < 600., 200., -400.> color rgb <1.,1.,1.>}
//light_source { <2, 4, -3> color rgb <1.,1.,1.>}
//light_source { 0*x color rgb <1,1,1> spotlight translate <300, 100, -40> point_at <0, 10, 0> radius 5 tightness 20 falloff 8 }
// An area light (creates soft shadows)
//light_source { 0*x color rgb 1.0 area_light <8, 0, 0> <0, 0, 8> 4, 4 adaptive 0 jitter translate <40, 80, -40> }
light_source { 0*x color rgb 1.0 area_light <8, 0, 0> <0, 0, 8> 4, 4 adaptive 0 jitter translate <600, 200, -400> }
light_source { 0*x color rgb 1.0 area_light <8, 0, 0> <0, 0, 8> 4, 4 adaptive 0 jitter translate <600, 200,  400> }

//*************************************

//the environment

// the wall and the floor
plane { x, -25.0 texture { pigment { granite color_map { M_PinkMarb } scale 2 } finish { specular 0.35 roughness 0.015 } } }
plane { y, -50.0 texture { T_Stone16 finish { specular 2 roughness .01 reflection .4 } } }
//plane { x, -25.0 texture { pigment { color White } } }
//plane { y, -50.0 texture { pigment { color Grey } } }

// the two piles
object {stele2 scale <2,2,2> translate < -10, -50, -50 >}
object {stele2 scale <2,2,2> translate < -10, -50,  50 >}

// the EXIT sign on the wall
box { <0, 0, 0> < 1, 1, 0>
  pigment {
    image_map { tga "exit.tga" } }
  finish { reflection .25 specular 0.3 }
  rotate -90*y
  scale <2.0,  10.0,  20.0> // <dX dY dZ>
  translate -7.5*z
  translate 40.0*y
  translate -24.5*x
}

//*************************************

object { crystal rotate 90*x translate 20*y}

//Messingschild
union { 
  text { ttf "Crystal.ttf" "Hydrotalcite" 0.2, 0 translate -3*x rotate 90*x }
  text { ttf "Crystal.ttf" "a.D. 1998" 0.2, 0 translate -2.2*x translate -1.1*y rotate 90*x }
  box { <-3.5, -0.4, -1.5> < 3.5,  -0.2,  1> }
  cylinder { -0.4*y, -0.2*y, 1 translate -3.5*x translate -0.25*z }
  cylinder { -0.4*y, -0.2*y, 1 translate  3.5*x translate -0.25*z }
  texture { T_Brass_5A }
	scale <2.7,1,2.7>
	rotate <-90,-90,0>
	translate <15.0,-10,0>
} //union

union {
union {// Teakholzsockel
  box { < -14.0,   0.0, -14.0> <  14.0,   1.0,  14.0> } //Sockel
  box { < -14.0,   1.0, -14.0> < -13.0,  30.0, -13.0> } //Strebe hinten links
  box { <  14.0,   1.0, -14.0> <  13.0,  30.0, -13.0> } //Strebe vorn links
  box { < -14.0,   1.0,  14.0> < -13.0,  30.0,  13.0> } //Strebe hinten rechts
  box { <  14.0,   1.0,  14.0> <  13.0,  30.0,  13.0> } //Strebe vorn rechts
  difference {
    box { < -14.0,  30.0, -14.0> <  14.0,  31.0,  14.0> } //Sockel
    box { < -13.0,  29.9, -13.0> <  13.0,  31.1,  13.0> } //Sockel
  } //end difference
	texture { pigment { P_WoodGrain3A color_map { M_Teak } scale 2 rotate x*45 } finish { reflection .25 specular 1 } }
} //union

union { //Vitrinenscheiben
  box { < -13.0,  30.4, -13.0> <  13.0,  30.6,  13.0> } //Scheibe oben
  box { < -13.0,   1.0, -13.4> <  13.0,  30.0, -13.6> } //Scheibe links
  box { < -13.0,   1.0,  13.4> <  13.0,  30.0,  13.6> } //Scheibe rechts
  box { <  13.4,   1.0, -13.0> <  13.6,  30.0,  13.0> } //Scheibe vorn  
  box { < -13.4,   1.0, -13.0> < -13.6,  30.0,  13.0> } //Scheibe hinten
  texture { T_Glass3 }
  //texture { T_Glass1 } // zum einrichten
} //union

translate -5*y
} //end union

//Granitsockel
box { <-14.5, -50, -14.5> < 14.5, -5, 14.5>
texture{ pigment { agate color_map { M_MarbTeal } scale 0.25 } finish { specular 0.35 roughness 0.015 } }
//texture { pigment { color Blue } }
}




// end of file
