#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "metals.inc"

 #declare PolyTyp01            =
  texture { pigment { color Gray90 }
       finish { specular 2 roughness .01 reflection .6 } }
 #declare PolyTyp02            =
  texture { pigment { rgb <0.0, 0.0, 1.0> }
       finish { specular 2 roughness .01 reflection .6 } }
 #declare PolyTyp03            =
  texture { pigment {color rgb <  1.000   0.000   0.000  > }
       finish { phong 1 phong_size 100 ambient .15 diffuse .7 } }
 #declare PolyTyp04            =
  texture { pigment {color Red }
       finish { phong 1 phong_size 100 ambient .15 diffuse .7 } }

 #declare SphereTyp01          =
  texture { pigment { rgb <1.0, 0.0, 0.0> }
       finish { specular 2 roughness .01 reflection .6 } }
 #declare SphereTyp02          =
  texture { pigment { rgb <0.0, 1.0, 0.0> }
       finish { specular 2 roughness .01 reflection .6 } }
 #declare SphereTyp03          =
  texture { pigment { rgb <1.0, 1.0, 1.0> }
       finish { specular 2 roughness .01 reflection .6 } }


#declare crystal =

union {
 // Octahedron   66  MG
 union {
  triangle { <    4.4081,   4.5810, 21.8117 > , <    4.4081,   1.5270, 21.8117 > , <    7.0529,   3.0540, 21.8117 > }
  triangle { <    4.4081,   4.5810, 21.8117 > , <    7.0529,   3.0540, 21.8117 > , <    6.1713,   4.5810, 23.8083 > }
  triangle { <    4.4081,   4.5810, 21.8117 > , <    6.1713,   4.5810, 23.8083 > , <    3.5265,   3.0540, 23.8083 > }
  triangle { <    4.4081,   4.5810, 21.8117 > , <    3.5265,   3.0540, 23.8083 > , <    4.4081,   1.5270, 21.8117 > }
  triangle { <    6.1713,   1.5270, 23.8083 > , <    4.4081,   1.5270, 21.8117 > , <    7.0529,   3.0540, 21.8117 > }
  triangle { <    6.1713,   1.5270, 23.8083 > , <    7.0529,   3.0540, 21.8117 > , <    6.1713,   4.5810, 23.8083 > }
  triangle { <    6.1713,   1.5270, 23.8083 > , <    6.1713,   4.5810, 23.8083 > , <    3.5265,   3.0540, 23.8083 > }
  triangle { <    6.1713,   1.5270, 23.8083 > , <    3.5265,   3.0540, 23.8083 > , <    4.4081,   1.5270, 21.8117 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   64  MG
 union {
  triangle { <    4.4081,   1.5270, 21.8117 > , <    4.4081,  -1.5270, 21.8117 > , <    7.0529,    .0000, 21.8117 > }
  triangle { <    4.4081,   1.5270, 21.8117 > , <    7.0529,    .0000, 21.8117 > , <    6.1713,   1.5270, 23.8083 > }
  triangle { <    4.4081,   1.5270, 21.8117 > , <    6.1713,   1.5270, 23.8083 > , <    3.5265,    .0000, 23.8083 > }
  triangle { <    4.4081,   1.5270, 21.8117 > , <    3.5265,    .0000, 23.8083 > , <    4.4081,  -1.5270, 21.8117 > }
  triangle { <    6.1713,  -1.5270, 23.8083 > , <    4.4081,  -1.5270, 21.8117 > , <    7.0529,    .0000, 21.8117 > }
  triangle { <    6.1713,  -1.5270, 23.8083 > , <    7.0529,    .0000, 21.8117 > , <    6.1713,   1.5270, 23.8083 > }
  triangle { <    6.1713,  -1.5270, 23.8083 > , <    6.1713,   1.5270, 23.8083 > , <    3.5265,    .0000, 23.8083 > }
  triangle { <    6.1713,  -1.5270, 23.8083 > , <    3.5265,    .0000, 23.8083 > , <    4.4081,  -1.5270, 21.8117 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   62  MG
 union {
  triangle { <    4.4081,  -1.5270, 21.8117 > , <    3.5265,  -3.0540, 23.8083 > , <    4.4081,  -4.5810, 21.8117 > }
  triangle { <    4.4081,  -1.5270, 21.8117 > , <    4.4081,  -4.5810, 21.8117 > , <    7.0529,  -3.0540, 21.8117 > }
  triangle { <    4.4081,  -1.5270, 21.8117 > , <    7.0529,  -3.0540, 21.8117 > , <    6.1713,  -1.5270, 23.8083 > }
  triangle { <    4.4081,  -1.5270, 21.8117 > , <    6.1713,  -1.5270, 23.8083 > , <    3.5265,  -3.0540, 23.8083 > }
  triangle { <    6.1713,  -4.5810, 23.8083 > , <    3.5265,  -3.0540, 23.8083 > , <    4.4081,  -4.5810, 21.8117 > }
  triangle { <    6.1713,  -4.5810, 23.8083 > , <    4.4081,  -4.5810, 21.8117 > , <    7.0529,  -3.0540, 21.8117 > }
  triangle { <    6.1713,  -4.5810, 23.8083 > , <    7.0529,  -3.0540, 21.8117 > , <    6.1713,  -1.5270, 23.8083 > }
  triangle { <    6.1713,  -4.5810, 23.8083 > , <    6.1713,  -1.5270, 23.8083 > , <    3.5265,  -3.0540, 23.8083 > }
    texture { PolyTyp01            }
 } // end union
 // Octahedron   56  MG
 union {
  triangle { <    4.4081,   4.5810, 21.8117 > , <    1.7632,   3.0540, 21.8117 > , <    1.7632,   6.1080, 21.8117 > }
  triangle { <    4.4081,   4.5810, 21.8117 > , <    1.7632,   6.1080, 21.8117 > , <    3.5265,   6.1080, 23.8083 > }
  triangle { <    4.4081,   4.5810, 21.8117 > , <    3.5265,   6.1080, 23.8083 > , <    3.5265,   3.0540, 23.8083 > }
  triangle { <    4.4081,   4.5810, 21.8117 > , <    3.5265,   3.0540, 23.8083 > , <    1.7632,   3.0540, 21.8117 > }
  triangle { <     .8816,   4.5810, 23.8083 > , <    1.7632,   3.0540, 21.8117 > , <    1.7632,   6.1080, 21.8117 > }
  triangle { <     .8816,   4.5810, 23.8083 > , <    1.7632,   6.1080, 21.8117 > , <    3.5265,   6.1080, 23.8083 > }
  triangle { <     .8816,   4.5810, 23.8083 > , <    3.5265,   6.1080, 23.8083 > , <    3.5265,   3.0540, 23.8083 > }
  triangle { <     .8816,   4.5810, 23.8083 > , <    3.5265,   3.0540, 23.8083 > , <    1.7632,   3.0540, 21.8117 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   54  MG
 union {
  triangle { <    3.5265,    .0000, 23.8083 > , <     .8816,   1.5270, 23.8083 > , <    1.7632,    .0000, 21.8117 > }
  triangle { <    3.5265,    .0000, 23.8083 > , <    1.7632,    .0000, 21.8117 > , <    4.4081,   1.5270, 21.8117 > }
  triangle { <    3.5265,    .0000, 23.8083 > , <    4.4081,   1.5270, 21.8117 > , <    3.5265,   3.0540, 23.8083 > }
  triangle { <    3.5265,    .0000, 23.8083 > , <    3.5265,   3.0540, 23.8083 > , <     .8816,   1.5270, 23.8083 > }
  triangle { <    1.7632,   3.0540, 21.8117 > , <     .8816,   1.5270, 23.8083 > , <    1.7632,    .0000, 21.8117 > }
  triangle { <    1.7632,   3.0540, 21.8117 > , <    1.7632,    .0000, 21.8117 > , <    4.4081,   1.5270, 21.8117 > }
  triangle { <    1.7632,   3.0540, 21.8117 > , <    4.4081,   1.5270, 21.8117 > , <    3.5265,   3.0540, 23.8083 > }
  triangle { <    1.7632,   3.0540, 21.8117 > , <    3.5265,   3.0540, 23.8083 > , <     .8816,   1.5270, 23.8083 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   46  MG
 union {
  triangle { <    -.8816,   7.6350, 21.8117 > , <   -1.7632,   6.1080, 23.8083 > , <    -.8816,   4.5810, 21.8117 > }
  triangle { <    -.8816,   7.6350, 21.8117 > , <    -.8816,   4.5810, 21.8117 > , <    1.7632,   6.1080, 21.8117 > }
  triangle { <    -.8816,   7.6350, 21.8117 > , <    1.7632,   6.1080, 21.8117 > , <     .8816,   7.6350, 23.8083 > }
  triangle { <    -.8816,   7.6350, 21.8117 > , <     .8816,   7.6350, 23.8083 > , <   -1.7632,   6.1080, 23.8083 > }
  triangle { <     .8816,   4.5810, 23.8083 > , <   -1.7632,   6.1080, 23.8083 > , <    -.8816,   4.5810, 21.8117 > }
  triangle { <     .8816,   4.5810, 23.8083 > , <    -.8816,   4.5810, 21.8117 > , <    1.7632,   6.1080, 21.8117 > }
  triangle { <     .8816,   4.5810, 23.8083 > , <    1.7632,   6.1080, 21.8117 > , <     .8816,   7.6350, 23.8083 > }
  triangle { <     .8816,   4.5810, 23.8083 > , <     .8816,   7.6350, 23.8083 > , <   -1.7632,   6.1080, 23.8083 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   60  MG
 union {
  triangle { <    4.4081,  -7.6350, 21.8117 > , <    7.0529,  -6.1080, 21.8117 > , <    4.4081,  -4.5810, 21.8117 > }
  triangle { <    4.4081,  -7.6350, 21.8117 > , <    4.4081,  -4.5810, 21.8117 > , <    3.5265,  -6.1080, 23.8083 > }
  triangle { <    4.4081,  -7.6350, 21.8117 > , <    3.5265,  -6.1080, 23.8083 > , <    6.1713,  -7.6350, 23.8083 > }
  triangle { <    4.4081,  -7.6350, 21.8117 > , <    6.1713,  -7.6350, 23.8083 > , <    7.0529,  -6.1080, 21.8117 > }
  triangle { <    6.1713,  -4.5810, 23.8083 > , <    7.0529,  -6.1080, 21.8117 > , <    4.4081,  -4.5810, 21.8117 > }
  triangle { <    6.1713,  -4.5810, 23.8083 > , <    4.4081,  -4.5810, 21.8117 > , <    3.5265,  -6.1080, 23.8083 > }
  triangle { <    6.1713,  -4.5810, 23.8083 > , <    3.5265,  -6.1080, 23.8083 > , <    6.1713,  -7.6350, 23.8083 > }
  triangle { <    6.1713,  -4.5810, 23.8083 > , <    6.1713,  -7.6350, 23.8083 > , <    7.0529,  -6.1080, 21.8117 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   33  MG
 union {
  triangle { <    -.8816,   1.5270, 21.8117 > , <   -3.5265,    .0000, 21.8117 > , <   -3.5265,   3.0540, 21.8117 > }
  triangle { <    -.8816,   1.5270, 21.8117 > , <   -3.5265,   3.0540, 21.8117 > , <   -1.7632,   3.0540, 23.8083 > }
  triangle { <    -.8816,   1.5270, 21.8117 > , <   -1.7632,   3.0540, 23.8083 > , <   -1.7632,    .0000, 23.8083 > }
  triangle { <    -.8816,   1.5270, 21.8117 > , <   -1.7632,    .0000, 23.8083 > , <   -3.5265,    .0000, 21.8117 > }
  triangle { <   -4.4081,   1.5270, 23.8083 > , <   -3.5265,    .0000, 21.8117 > , <   -3.5265,   3.0540, 21.8117 > }
  triangle { <   -4.4081,   1.5270, 23.8083 > , <   -3.5265,   3.0540, 21.8117 > , <   -1.7632,   3.0540, 23.8083 > }
  triangle { <   -4.4081,   1.5270, 23.8083 > , <   -1.7632,   3.0540, 23.8083 > , <   -1.7632,    .0000, 23.8083 > }
  triangle { <   -4.4081,   1.5270, 23.8083 > , <   -1.7632,    .0000, 23.8083 > , <   -3.5265,    .0000, 21.8117 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   52  MG
 union {
  triangle { <    1.7632,  -3.0540, 21.8117 > , <    4.4081,  -1.5270, 21.8117 > , <    1.7632,    .0000, 21.8117 > }
  triangle { <    1.7632,  -3.0540, 21.8117 > , <    1.7632,    .0000, 21.8117 > , <     .8816,  -1.5270, 23.8083 > }
  triangle { <    1.7632,  -3.0540, 21.8117 > , <     .8816,  -1.5270, 23.8083 > , <    3.5265,  -3.0540, 23.8083 > }
  triangle { <    1.7632,  -3.0540, 21.8117 > , <    3.5265,  -3.0540, 23.8083 > , <    4.4081,  -1.5270, 21.8117 > }
  triangle { <    3.5265,    .0000, 23.8083 > , <    4.4081,  -1.5270, 21.8117 > , <    1.7632,    .0000, 21.8117 > }
  triangle { <    3.5265,    .0000, 23.8083 > , <    1.7632,    .0000, 21.8117 > , <     .8816,  -1.5270, 23.8083 > }
  triangle { <    3.5265,    .0000, 23.8083 > , <     .8816,  -1.5270, 23.8083 > , <    3.5265,  -3.0540, 23.8083 > }
  triangle { <    3.5265,    .0000, 23.8083 > , <    3.5265,  -3.0540, 23.8083 > , <    4.4081,  -1.5270, 21.8117 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   35  MG
 union {
  triangle { <   -3.5265,   6.1080, 21.8117 > , <   -3.5265,   3.0540, 21.8117 > , <    -.8816,   4.5810, 21.8117 > }
  triangle { <   -3.5265,   6.1080, 21.8117 > , <    -.8816,   4.5810, 21.8117 > , <   -1.7632,   6.1080, 23.8083 > }
  triangle { <   -3.5265,   6.1080, 21.8117 > , <   -1.7632,   6.1080, 23.8083 > , <   -4.4081,   4.5810, 23.8083 > }
  triangle { <   -3.5265,   6.1080, 21.8117 > , <   -4.4081,   4.5810, 23.8083 > , <   -3.5265,   3.0540, 21.8117 > }
  triangle { <   -1.7632,   3.0540, 23.8083 > , <   -3.5265,   3.0540, 21.8117 > , <    -.8816,   4.5810, 21.8117 > }
  triangle { <   -1.7632,   3.0540, 23.8083 > , <    -.8816,   4.5810, 21.8117 > , <   -1.7632,   6.1080, 23.8083 > }
  triangle { <   -1.7632,   3.0540, 23.8083 > , <   -1.7632,   6.1080, 23.8083 > , <   -4.4081,   4.5810, 23.8083 > }
  triangle { <   -1.7632,   3.0540, 23.8083 > , <   -4.4081,   4.5810, 23.8083 > , <   -3.5265,   3.0540, 21.8117 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   50  MG
 union {
  triangle { <    1.7632,  -3.0540, 21.8117 > , <    1.7632,  -6.1080, 21.8117 > , <    4.4081,  -4.5810, 21.8117 > }
  triangle { <    1.7632,  -3.0540, 21.8117 > , <    4.4081,  -4.5810, 21.8117 > , <    3.5265,  -3.0540, 23.8083 > }
  triangle { <    1.7632,  -3.0540, 21.8117 > , <    3.5265,  -3.0540, 23.8083 > , <     .8816,  -4.5810, 23.8083 > }
  triangle { <    1.7632,  -3.0540, 21.8117 > , <     .8816,  -4.5810, 23.8083 > , <    1.7632,  -6.1080, 21.8117 > }
  triangle { <    3.5265,  -6.1080, 23.8083 > , <    1.7632,  -6.1080, 21.8117 > , <    4.4081,  -4.5810, 21.8117 > }
  triangle { <    3.5265,  -6.1080, 23.8083 > , <    4.4081,  -4.5810, 21.8117 > , <    3.5265,  -3.0540, 23.8083 > }
  triangle { <    3.5265,  -6.1080, 23.8083 > , <    3.5265,  -3.0540, 23.8083 > , <     .8816,  -4.5810, 23.8083 > }
  triangle { <    3.5265,  -6.1080, 23.8083 > , <     .8816,  -4.5810, 23.8083 > , <    1.7632,  -6.1080, 21.8117 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   37  MG
 union {
  triangle { <   -3.5265,   9.1620, 21.8117 > , <   -3.5265,   6.1080, 21.8117 > , <    -.8816,   7.6350, 21.8117 > }
  triangle { <   -3.5265,   9.1620, 21.8117 > , <    -.8816,   7.6350, 21.8117 > , <   -1.7632,   9.1620, 23.8083 > }
  triangle { <   -3.5265,   9.1620, 21.8117 > , <   -1.7632,   9.1620, 23.8083 > , <   -4.4081,   7.6350, 23.8083 > }
  triangle { <   -3.5265,   9.1620, 21.8117 > , <   -4.4081,   7.6350, 23.8083 > , <   -3.5265,   6.1080, 21.8117 > }
  triangle { <   -1.7632,   6.1080, 23.8083 > , <   -3.5265,   6.1080, 21.8117 > , <    -.8816,   7.6350, 21.8117 > }
  triangle { <   -1.7632,   6.1080, 23.8083 > , <    -.8816,   7.6350, 21.8117 > , <   -1.7632,   9.1620, 23.8083 > }
  triangle { <   -1.7632,   6.1080, 23.8083 > , <   -1.7632,   9.1620, 23.8083 > , <   -4.4081,   7.6350, 23.8083 > }
  triangle { <   -1.7632,   6.1080, 23.8083 > , <   -4.4081,   7.6350, 23.8083 > , <   -3.5265,   6.1080, 21.8117 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   44  MG
 union {
  triangle { <    -.8816,   4.5810, 21.8117 > , <    -.8816,   1.5270, 21.8117 > , <    1.7632,   3.0540, 21.8117 > }
  triangle { <    -.8816,   4.5810, 21.8117 > , <    1.7632,   3.0540, 21.8117 > , <     .8816,   4.5810, 23.8083 > }
  triangle { <    -.8816,   4.5810, 21.8117 > , <     .8816,   4.5810, 23.8083 > , <   -1.7632,   3.0540, 23.8083 > }
  triangle { <    -.8816,   4.5810, 21.8117 > , <   -1.7632,   3.0540, 23.8083 > , <    -.8816,   1.5270, 21.8117 > }
  triangle { <     .8816,   1.5270, 23.8083 > , <    -.8816,   1.5270, 21.8117 > , <    1.7632,   3.0540, 21.8117 > }
  triangle { <     .8816,   1.5270, 23.8083 > , <    1.7632,   3.0540, 21.8117 > , <     .8816,   4.5810, 23.8083 > }
  triangle { <     .8816,   1.5270, 23.8083 > , <     .8816,   4.5810, 23.8083 > , <   -1.7632,   3.0540, 23.8083 > }
  triangle { <     .8816,   1.5270, 23.8083 > , <   -1.7632,   3.0540, 23.8083 > , <    -.8816,   1.5270, 21.8117 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   41  MG
 union {
  triangle { <    1.7632,  -3.0540, 21.8117 > , <    -.8816,  -4.5810, 21.8117 > , <    -.8816,  -1.5270, 21.8117 > }
  triangle { <    1.7632,  -3.0540, 21.8117 > , <    -.8816,  -1.5270, 21.8117 > , <     .8816,  -1.5270, 23.8083 > }
  triangle { <    1.7632,  -3.0540, 21.8117 > , <     .8816,  -1.5270, 23.8083 > , <     .8816,  -4.5810, 23.8083 > }
  triangle { <    1.7632,  -3.0540, 21.8117 > , <     .8816,  -4.5810, 23.8083 > , <    -.8816,  -4.5810, 21.8117 > }
  triangle { <   -1.7632,  -3.0540, 23.8083 > , <    -.8816,  -4.5810, 21.8117 > , <    -.8816,  -1.5270, 21.8117 > }
  triangle { <   -1.7632,  -3.0540, 23.8083 > , <    -.8816,  -1.5270, 21.8117 > , <     .8816,  -1.5270, 23.8083 > }
  triangle { <   -1.7632,  -3.0540, 23.8083 > , <     .8816,  -1.5270, 23.8083 > , <     .8816,  -4.5810, 23.8083 > }
  triangle { <   -1.7632,  -3.0540, 23.8083 > , <     .8816,  -4.5810, 23.8083 > , <    -.8816,  -4.5810, 21.8117 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   42  MG
 union {
  triangle { <    -.8816,   1.5270, 21.8117 > , <    -.8816,  -1.5270, 21.8117 > , <    1.7632,    .0000, 21.8117 > }
  triangle { <    -.8816,   1.5270, 21.8117 > , <    1.7632,    .0000, 21.8117 > , <     .8816,   1.5270, 23.8083 > }
  triangle { <    -.8816,   1.5270, 21.8117 > , <     .8816,   1.5270, 23.8083 > , <   -1.7632,    .0000, 23.8083 > }
  triangle { <    -.8816,   1.5270, 21.8117 > , <   -1.7632,    .0000, 23.8083 > , <    -.8816,  -1.5270, 21.8117 > }
  triangle { <     .8816,  -1.5270, 23.8083 > , <    -.8816,  -1.5270, 21.8117 > , <    1.7632,    .0000, 21.8117 > }
  triangle { <     .8816,  -1.5270, 23.8083 > , <    1.7632,    .0000, 21.8117 > , <     .8816,   1.5270, 23.8083 > }
  triangle { <     .8816,  -1.5270, 23.8083 > , <     .8816,   1.5270, 23.8083 > , <   -1.7632,    .0000, 23.8083 > }
  triangle { <     .8816,  -1.5270, 23.8083 > , <   -1.7632,    .0000, 23.8083 > , <    -.8816,  -1.5270, 21.8117 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   31  MG
 union {
  triangle { <   -3.5265,    .0000, 21.8117 > , <    -.8816,  -1.5270, 21.8117 > , <   -3.5265,  -3.0540, 21.8117 > }
  triangle { <   -3.5265,    .0000, 21.8117 > , <   -3.5265,  -3.0540, 21.8117 > , <   -4.4081,  -1.5270, 23.8083 > }
  triangle { <   -3.5265,    .0000, 21.8117 > , <   -4.4081,  -1.5270, 23.8083 > , <   -1.7632,    .0000, 23.8083 > }
  triangle { <   -3.5265,    .0000, 21.8117 > , <   -1.7632,    .0000, 23.8083 > , <    -.8816,  -1.5270, 21.8117 > }
  triangle { <   -1.7632,  -3.0540, 23.8083 > , <    -.8816,  -1.5270, 21.8117 > , <   -3.5265,  -3.0540, 21.8117 > }
  triangle { <   -1.7632,  -3.0540, 23.8083 > , <   -3.5265,  -3.0540, 21.8117 > , <   -4.4081,  -1.5270, 23.8083 > }
  triangle { <   -1.7632,  -3.0540, 23.8083 > , <   -4.4081,  -1.5270, 23.8083 > , <   -1.7632,    .0000, 23.8083 > }
  triangle { <   -1.7632,  -3.0540, 23.8083 > , <   -1.7632,    .0000, 23.8083 > , <    -.8816,  -1.5270, 21.8117 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   84  MG
 union {
  triangle { <    4.4081,   4.5810, 16.2050 > , <    2.6448,   4.5810, 14.2084 > , <    5.2897,   3.0540, 14.2084 > }
  triangle { <    4.4081,   4.5810, 16.2050 > , <    5.2897,   3.0540, 14.2084 > , <    4.4081,   1.5270, 16.2050 > }
  triangle { <    4.4081,   4.5810, 16.2050 > , <    4.4081,   1.5270, 16.2050 > , <    1.7632,   3.0540, 16.2050 > }
  triangle { <    4.4081,   4.5810, 16.2050 > , <    1.7632,   3.0540, 16.2050 > , <    2.6448,   4.5810, 14.2084 > }
  triangle { <    2.6448,   1.5270, 14.2084 > , <    2.6448,   4.5810, 14.2084 > , <    5.2897,   3.0540, 14.2084 > }
  triangle { <    2.6448,   1.5270, 14.2084 > , <    5.2897,   3.0540, 14.2084 > , <    4.4081,   1.5270, 16.2050 > }
  triangle { <    2.6448,   1.5270, 14.2084 > , <    4.4081,   1.5270, 16.2050 > , <    1.7632,   3.0540, 16.2050 > }
  triangle { <    2.6448,   1.5270, 14.2084 > , <    1.7632,   3.0540, 16.2050 > , <    2.6448,   4.5810, 14.2084 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   83  MG
 union {
  triangle { <    2.6448,   1.5270, 14.2084 > , <    4.4081,   1.5270, 16.2050 > , <    1.7632,    .0000, 16.2050 > }
  triangle { <    2.6448,   1.5270, 14.2084 > , <    1.7632,    .0000, 16.2050 > , <    2.6448,  -1.5270, 14.2083 > }
  triangle { <    2.6448,   1.5270, 14.2084 > , <    2.6448,  -1.5270, 14.2083 > , <    5.2897,    .0000, 14.2084 > }
  triangle { <    2.6448,   1.5270, 14.2084 > , <    5.2897,    .0000, 14.2084 > , <    4.4081,   1.5270, 16.2050 > }
  triangle { <    4.4081,  -1.5270, 16.2050 > , <    4.4081,   1.5270, 16.2050 > , <    1.7632,    .0000, 16.2050 > }
  triangle { <    4.4081,  -1.5270, 16.2050 > , <    1.7632,    .0000, 16.2050 > , <    2.6448,  -1.5270, 14.2083 > }
  triangle { <    4.4081,  -1.5270, 16.2050 > , <    2.6448,  -1.5270, 14.2083 > , <    5.2897,    .0000, 14.2084 > }
  triangle { <    4.4081,  -1.5270, 16.2050 > , <    5.2897,    .0000, 14.2084 > , <    4.4081,   1.5270, 16.2050 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   79  MG
 union {
  triangle { <     .0000,   6.1080, 14.2084 > , <    1.7632,   6.1080, 16.2050 > , <    -.8816,   4.5810, 16.2050 > }
  triangle { <     .0000,   6.1080, 14.2084 > , <    -.8816,   4.5810, 16.2050 > , <     .0000,   3.0540, 14.2083 > }
  triangle { <     .0000,   6.1080, 14.2084 > , <     .0000,   3.0540, 14.2083 > , <    2.6448,   4.5810, 14.2084 > }
  triangle { <     .0000,   6.1080, 14.2084 > , <    2.6448,   4.5810, 14.2084 > , <    1.7632,   6.1080, 16.2050 > }
  triangle { <    1.7632,   3.0540, 16.2050 > , <    1.7632,   6.1080, 16.2050 > , <    -.8816,   4.5810, 16.2050 > }
  triangle { <    1.7632,   3.0540, 16.2050 > , <    -.8816,   4.5810, 16.2050 > , <     .0000,   3.0540, 14.2083 > }
  triangle { <    1.7632,   3.0540, 16.2050 > , <     .0000,   3.0540, 14.2083 > , <    2.6448,   4.5810, 14.2084 > }
  triangle { <    1.7632,   3.0540, 16.2050 > , <    2.6448,   4.5810, 14.2084 > , <    1.7632,   6.1080, 16.2050 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   82  MG
 union {
  triangle { <    5.2897,  -3.0540, 14.2084 > , <    4.4081,  -1.5270, 16.2050 > , <    2.6448,  -1.5270, 14.2083 > }
  triangle { <    5.2897,  -3.0540, 14.2084 > , <    2.6448,  -1.5270, 14.2083 > , <    2.6448,  -4.5810, 14.2083 > }
  triangle { <    5.2897,  -3.0540, 14.2084 > , <    2.6448,  -4.5810, 14.2083 > , <    4.4081,  -4.5810, 16.2050 > }
  triangle { <    5.2897,  -3.0540, 14.2084 > , <    4.4081,  -4.5810, 16.2050 > , <    4.4081,  -1.5270, 16.2050 > }
  triangle { <    1.7632,  -3.0540, 16.2050 > , <    4.4081,  -1.5270, 16.2050 > , <    2.6448,  -1.5270, 14.2083 > }
  triangle { <    1.7632,  -3.0540, 16.2050 > , <    2.6448,  -1.5270, 14.2083 > , <    2.6448,  -4.5810, 14.2083 > }
  triangle { <    1.7632,  -3.0540, 16.2050 > , <    2.6448,  -4.5810, 14.2083 > , <    4.4081,  -4.5810, 16.2050 > }
  triangle { <    1.7632,  -3.0540, 16.2050 > , <    4.4081,  -4.5810, 16.2050 > , <    4.4081,  -1.5270, 16.2050 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   81  MG
 union {
  triangle { <    2.6448,  -4.5810, 14.2083 > , <    4.4081,  -4.5810, 16.2050 > , <    5.2897,  -6.1080, 14.2083 > }
  triangle { <    2.6448,  -4.5810, 14.2083 > , <    5.2897,  -6.1080, 14.2083 > , <    2.6448,  -7.6350, 14.2083 > }
  triangle { <    2.6448,  -4.5810, 14.2083 > , <    2.6448,  -7.6350, 14.2083 > , <    1.7632,  -6.1080, 16.2050 > }
  triangle { <    2.6448,  -4.5810, 14.2083 > , <    1.7632,  -6.1080, 16.2050 > , <    4.4081,  -4.5810, 16.2050 > }
  triangle { <    4.4081,  -7.6350, 16.2050 > , <    4.4081,  -4.5810, 16.2050 > , <    5.2897,  -6.1080, 14.2083 > }
  triangle { <    4.4081,  -7.6350, 16.2050 > , <    5.2897,  -6.1080, 14.2083 > , <    2.6448,  -7.6350, 14.2083 > }
  triangle { <    4.4081,  -7.6350, 16.2050 > , <    2.6448,  -7.6350, 14.2083 > , <    1.7632,  -6.1080, 16.2050 > }
  triangle { <    4.4081,  -7.6350, 16.2050 > , <    1.7632,  -6.1080, 16.2050 > , <    4.4081,  -4.5810, 16.2050 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   78  MG
 union {
  triangle { <    1.7632,  -3.0540, 16.2050 > , <    1.7632,    .0000, 16.2050 > , <    2.6448,  -1.5270, 14.2083 > }
  triangle { <    1.7632,  -3.0540, 16.2050 > , <    2.6448,  -1.5270, 14.2083 > , <     .0000,  -3.0540, 14.2083 > }
  triangle { <    1.7632,  -3.0540, 16.2050 > , <     .0000,  -3.0540, 14.2083 > , <    -.8816,  -1.5270, 16.2050 > }
  triangle { <    1.7632,  -3.0540, 16.2050 > , <    -.8816,  -1.5270, 16.2050 > , <    1.7632,    .0000, 16.2050 > }
  triangle { <     .0000,    .0000, 14.2083 > , <    1.7632,    .0000, 16.2050 > , <    2.6448,  -1.5270, 14.2083 > }
  triangle { <     .0000,    .0000, 14.2083 > , <    2.6448,  -1.5270, 14.2083 > , <     .0000,  -3.0540, 14.2083 > }
  triangle { <     .0000,    .0000, 14.2083 > , <     .0000,  -3.0540, 14.2083 > , <    -.8816,  -1.5270, 16.2050 > }
  triangle { <     .0000,    .0000, 14.2083 > , <    -.8816,  -1.5270, 16.2050 > , <    1.7632,    .0000, 16.2050 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   75  MG
 union {
  triangle { <     .0000,   6.1080, 14.2084 > , <    -.8816,   7.6350, 16.2050 > , <   -2.6448,   7.6350, 14.2083 > }
  triangle { <     .0000,   6.1080, 14.2084 > , <   -2.6448,   7.6350, 14.2083 > , <   -2.6448,   4.5810, 14.2083 > }
  triangle { <     .0000,   6.1080, 14.2084 > , <   -2.6448,   4.5810, 14.2083 > , <    -.8816,   4.5810, 16.2050 > }
  triangle { <     .0000,   6.1080, 14.2084 > , <    -.8816,   4.5810, 16.2050 > , <    -.8816,   7.6350, 16.2050 > }
  triangle { <   -3.5265,   6.1080, 16.2050 > , <    -.8816,   7.6350, 16.2050 > , <   -2.6448,   7.6350, 14.2083 > }
  triangle { <   -3.5265,   6.1080, 16.2050 > , <   -2.6448,   7.6350, 14.2083 > , <   -2.6448,   4.5810, 14.2083 > }
  triangle { <   -3.5265,   6.1080, 16.2050 > , <   -2.6448,   4.5810, 14.2083 > , <    -.8816,   4.5810, 16.2050 > }
  triangle { <   -3.5265,   6.1080, 16.2050 > , <    -.8816,   4.5810, 16.2050 > , <    -.8816,   7.6350, 16.2050 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   74  MG
 union {
  triangle { <    -.8816,   1.5270, 16.2050 > , <    -.8816,   4.5810, 16.2050 > , <     .0000,   3.0540, 14.2083 > }
  triangle { <    -.8816,   1.5270, 16.2050 > , <     .0000,   3.0540, 14.2083 > , <   -2.6448,   1.5270, 14.2083 > }
  triangle { <    -.8816,   1.5270, 16.2050 > , <   -2.6448,   1.5270, 14.2083 > , <   -3.5265,   3.0540, 16.2050 > }
  triangle { <    -.8816,   1.5270, 16.2050 > , <   -3.5265,   3.0540, 16.2050 > , <    -.8816,   4.5810, 16.2050 > }
  triangle { <   -2.6448,   4.5810, 14.2083 > , <    -.8816,   4.5810, 16.2050 > , <     .0000,   3.0540, 14.2083 > }
  triangle { <   -2.6448,   4.5810, 14.2083 > , <     .0000,   3.0540, 14.2083 > , <   -2.6448,   1.5270, 14.2083 > }
  triangle { <   -2.6448,   4.5810, 14.2083 > , <   -2.6448,   1.5270, 14.2083 > , <   -3.5265,   3.0540, 16.2050 > }
  triangle { <   -2.6448,   4.5810, 14.2083 > , <   -3.5265,   3.0540, 16.2050 > , <    -.8816,   4.5810, 16.2050 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   10  MG
 union {
  triangle { <    2.6448,   1.5270, 14.2084 > , <    1.7632,   3.0540, 16.2050 > , <    1.7632,    .0000, 16.2050 > }
  triangle { <    2.6448,   1.5270, 14.2084 > , <    1.7632,    .0000, 16.2050 > , <     .0000,    .0000, 14.2083 > }
  triangle { <    2.6448,   1.5270, 14.2084 > , <     .0000,    .0000, 14.2083 > , <     .0000,   3.0540, 14.2083 > }
  triangle { <    2.6448,   1.5270, 14.2084 > , <     .0000,   3.0540, 14.2083 > , <    1.7632,   3.0540, 16.2050 > }
  triangle { <    -.8816,   1.5270, 16.2050 > , <    1.7632,   3.0540, 16.2050 > , <    1.7632,    .0000, 16.2050 > }
  triangle { <    -.8816,   1.5270, 16.2050 > , <    1.7632,    .0000, 16.2050 > , <     .0000,    .0000, 14.2083 > }
  triangle { <    -.8816,   1.5270, 16.2050 > , <     .0000,    .0000, 14.2083 > , <     .0000,   3.0540, 14.2083 > }
  triangle { <    -.8816,   1.5270, 16.2050 > , <     .0000,   3.0540, 14.2083 > , <    1.7632,   3.0540, 16.2050 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   77  MG
 union {
  triangle { <     .0000,  -3.0540, 14.2083 > , <     .0000,  -6.1080, 14.2083 > , <    2.6448,  -4.5810, 14.2083 > }
  triangle { <     .0000,  -3.0540, 14.2083 > , <    2.6448,  -4.5810, 14.2083 > , <    1.7632,  -3.0540, 16.2050 > }
  triangle { <     .0000,  -3.0540, 14.2083 > , <    1.7632,  -3.0540, 16.2050 > , <    -.8816,  -4.5810, 16.2050 > }
  triangle { <     .0000,  -3.0540, 14.2083 > , <    -.8816,  -4.5810, 16.2050 > , <     .0000,  -6.1080, 14.2083 > }
  triangle { <    1.7632,  -6.1080, 16.2050 > , <     .0000,  -6.1080, 14.2083 > , <    2.6448,  -4.5810, 14.2083 > }
  triangle { <    1.7632,  -6.1080, 16.2050 > , <    2.6448,  -4.5810, 14.2083 > , <    1.7632,  -3.0540, 16.2050 > }
  triangle { <    1.7632,  -6.1080, 16.2050 > , <    1.7632,  -3.0540, 16.2050 > , <    -.8816,  -4.5810, 16.2050 > }
  triangle { <    1.7632,  -6.1080, 16.2050 > , <    -.8816,  -4.5810, 16.2050 > , <     .0000,  -6.1080, 14.2083 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   73  MG
 union {
  triangle { <     .0000,    .0000, 14.2083 > , <    -.8816,   1.5270, 16.2050 > , <   -2.6448,   1.5270, 14.2083 > }
  triangle { <     .0000,    .0000, 14.2083 > , <   -2.6448,   1.5270, 14.2083 > , <   -2.6448,  -1.5270, 14.2083 > }
  triangle { <     .0000,    .0000, 14.2083 > , <   -2.6448,  -1.5270, 14.2083 > , <    -.8816,  -1.5270, 16.2050 > }
  triangle { <     .0000,    .0000, 14.2083 > , <    -.8816,  -1.5270, 16.2050 > , <    -.8816,   1.5270, 16.2050 > }
  triangle { <   -3.5265,    .0000, 16.2050 > , <    -.8816,   1.5270, 16.2050 > , <   -2.6448,   1.5270, 14.2083 > }
  triangle { <   -3.5265,    .0000, 16.2050 > , <   -2.6448,   1.5270, 14.2083 > , <   -2.6448,  -1.5270, 14.2083 > }
  triangle { <   -3.5265,    .0000, 16.2050 > , <   -2.6448,  -1.5270, 14.2083 > , <    -.8816,  -1.5270, 16.2050 > }
  triangle { <   -3.5265,    .0000, 16.2050 > , <    -.8816,  -1.5270, 16.2050 > , <    -.8816,   1.5270, 16.2050 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   72  MG
 union {
  triangle { <    -.8816,  -4.5810, 16.2050 > , <   -2.6448,  -4.5810, 14.2083 > , <   -3.5265,  -3.0540, 16.2050 > }
  triangle { <    -.8816,  -4.5810, 16.2050 > , <   -3.5265,  -3.0540, 16.2050 > , <    -.8816,  -1.5270, 16.2050 > }
  triangle { <    -.8816,  -4.5810, 16.2050 > , <    -.8816,  -1.5270, 16.2050 > , <     .0000,  -3.0540, 14.2083 > }
  triangle { <    -.8816,  -4.5810, 16.2050 > , <     .0000,  -3.0540, 14.2083 > , <   -2.6448,  -4.5810, 14.2083 > }
  triangle { <   -2.6448,  -1.5270, 14.2083 > , <   -2.6448,  -4.5810, 14.2083 > , <   -3.5265,  -3.0540, 16.2050 > }
  triangle { <   -2.6448,  -1.5270, 14.2083 > , <   -3.5265,  -3.0540, 16.2050 > , <    -.8816,  -1.5270, 16.2050 > }
  triangle { <   -2.6448,  -1.5270, 14.2083 > , <    -.8816,  -1.5270, 16.2050 > , <     .0000,  -3.0540, 14.2083 > }
  triangle { <   -2.6448,  -1.5270, 14.2083 > , <     .0000,  -3.0540, 14.2083 > , <   -2.6448,  -4.5810, 14.2083 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron  108  MG
 union {
  triangle { <    6.1713,   1.5270,  6.6050 > , <    5.2897,   3.0540,  8.6017 > , <    5.2897,    .0000,  8.6017 > }
  triangle { <    6.1713,   1.5270,  6.6050 > , <    5.2897,    .0000,  8.6017 > , <    3.5265,    .0000,  6.6050 > }
  triangle { <    6.1713,   1.5270,  6.6050 > , <    3.5265,    .0000,  6.6050 > , <    3.5265,   3.0540,  6.6050 > }
  triangle { <    6.1713,   1.5270,  6.6050 > , <    3.5265,   3.0540,  6.6050 > , <    5.2897,   3.0540,  8.6017 > }
  triangle { <    2.6448,   1.5270,  8.6017 > , <    5.2897,   3.0540,  8.6017 > , <    5.2897,    .0000,  8.6017 > }
  triangle { <    2.6448,   1.5270,  8.6017 > , <    5.2897,    .0000,  8.6017 > , <    3.5265,    .0000,  6.6050 > }
  triangle { <    2.6448,   1.5270,  8.6017 > , <    3.5265,    .0000,  6.6050 > , <    3.5265,   3.0540,  6.6050 > }
  triangle { <    2.6448,   1.5270,  8.6017 > , <    3.5265,   3.0540,  6.6050 > , <    5.2897,   3.0540,  8.6017 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron  107  MG
 union {
  triangle { <    6.1713,  -1.5270,  6.6050 > , <    3.5265,  -3.0540,  6.6050 > , <    5.2897,  -3.0540,  8.6017 > }
  triangle { <    6.1713,  -1.5270,  6.6050 > , <    5.2897,  -3.0540,  8.6017 > , <    5.2897,    .0000,  8.6017 > }
  triangle { <    6.1713,  -1.5270,  6.6050 > , <    5.2897,    .0000,  8.6017 > , <    3.5265,    .0000,  6.6050 > }
  triangle { <    6.1713,  -1.5270,  6.6050 > , <    3.5265,    .0000,  6.6050 > , <    3.5265,  -3.0540,  6.6050 > }
  triangle { <    2.6448,  -1.5270,  8.6017 > , <    3.5265,  -3.0540,  6.6050 > , <    5.2897,  -3.0540,  8.6017 > }
  triangle { <    2.6448,  -1.5270,  8.6017 > , <    5.2897,  -3.0540,  8.6017 > , <    5.2897,    .0000,  8.6017 > }
  triangle { <    2.6448,  -1.5270,  8.6017 > , <    5.2897,    .0000,  8.6017 > , <    3.5265,    .0000,  6.6050 > }
  triangle { <    2.6448,  -1.5270,  8.6017 > , <    3.5265,    .0000,  6.6050 > , <    3.5265,  -3.0540,  6.6050 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   11  MG
 union {
  triangle { <     .0000,    .0000,  8.6017 > , <    2.6448,   1.5270,  8.6017 > , <    2.6448,  -1.5270,  8.6017 > }
  triangle { <     .0000,    .0000,  8.6017 > , <    2.6448,  -1.5270,  8.6017 > , <     .8816,  -1.5270,  6.6050 > }
  triangle { <     .0000,    .0000,  8.6017 > , <     .8816,  -1.5270,  6.6050 > , <     .8816,   1.5270,  6.6050 > }
  triangle { <     .0000,    .0000,  8.6017 > , <     .8816,   1.5270,  6.6050 > , <    2.6448,   1.5270,  8.6017 > }
  triangle { <    3.5265,    .0000,  6.6050 > , <    2.6448,   1.5270,  8.6017 > , <    2.6448,  -1.5270,  8.6017 > }
  triangle { <    3.5265,    .0000,  6.6050 > , <    2.6448,  -1.5270,  8.6017 > , <     .8816,  -1.5270,  6.6050 > }
  triangle { <    3.5265,    .0000,  6.6050 > , <     .8816,  -1.5270,  6.6050 > , <     .8816,   1.5270,  6.6050 > }
  triangle { <    3.5265,    .0000,  6.6050 > , <     .8816,   1.5270,  6.6050 > , <    2.6448,   1.5270,  8.6017 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron  106  MG
 union {
  triangle { <    5.2897,  -6.1080,  8.6017 > , <    5.2897,  -3.0540,  8.6017 > , <    6.1713,  -4.5810,  6.6050 > }
  triangle { <    5.2897,  -6.1080,  8.6017 > , <    6.1713,  -4.5810,  6.6050 > , <    3.5265,  -6.1080,  6.6050 > }
  triangle { <    5.2897,  -6.1080,  8.6017 > , <    3.5265,  -6.1080,  6.6050 > , <    2.6448,  -4.5810,  8.6017 > }
  triangle { <    5.2897,  -6.1080,  8.6017 > , <    2.6448,  -4.5810,  8.6017 > , <    5.2897,  -3.0540,  8.6017 > }
  triangle { <    3.5265,  -3.0540,  6.6050 > , <    5.2897,  -3.0540,  8.6017 > , <    6.1713,  -4.5810,  6.6050 > }
  triangle { <    3.5265,  -3.0540,  6.6050 > , <    6.1713,  -4.5810,  6.6050 > , <    3.5265,  -6.1080,  6.6050 > }
  triangle { <    3.5265,  -3.0540,  6.6050 > , <    3.5265,  -6.1080,  6.6050 > , <    2.6448,  -4.5810,  8.6017 > }
  triangle { <    3.5265,  -3.0540,  6.6050 > , <    2.6448,  -4.5810,  8.6017 > , <    5.2897,  -3.0540,  8.6017 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron  103  MG
 union {
  triangle { <     .0000,   3.0540,  8.6017 > , <    2.6448,   4.5810,  8.6017 > , <     .8816,   4.5810,  6.6050 > }
  triangle { <     .0000,   3.0540,  8.6017 > , <     .8816,   4.5810,  6.6050 > , <     .8816,   1.5270,  6.6050 > }
  triangle { <     .0000,   3.0540,  8.6017 > , <     .8816,   1.5270,  6.6050 > , <    2.6448,   1.5270,  8.6017 > }
  triangle { <     .0000,   3.0540,  8.6017 > , <    2.6448,   1.5270,  8.6017 > , <    2.6448,   4.5810,  8.6017 > }
  triangle { <    3.5265,   3.0540,  6.6050 > , <    2.6448,   4.5810,  8.6017 > , <     .8816,   4.5810,  6.6050 > }
  triangle { <    3.5265,   3.0540,  6.6050 > , <     .8816,   4.5810,  6.6050 > , <     .8816,   1.5270,  6.6050 > }
  triangle { <    3.5265,   3.0540,  6.6050 > , <     .8816,   1.5270,  6.6050 > , <    2.6448,   1.5270,  8.6017 > }
  triangle { <    3.5265,   3.0540,  6.6050 > , <    2.6448,   1.5270,  8.6017 > , <    2.6448,   4.5810,  8.6017 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron  102  MG
 union {
  triangle { <    2.6448,  -4.5810,  8.6017 > , <    2.6448,  -1.5270,  8.6017 > , <     .0000,  -3.0540,  8.6017 > }
  triangle { <    2.6448,  -4.5810,  8.6017 > , <     .0000,  -3.0540,  8.6017 > , <     .8816,  -4.5810,  6.6050 > }
  triangle { <    2.6448,  -4.5810,  8.6017 > , <     .8816,  -4.5810,  6.6050 > , <    3.5265,  -3.0540,  6.6050 > }
  triangle { <    2.6448,  -4.5810,  8.6017 > , <    3.5265,  -3.0540,  6.6050 > , <    2.6448,  -1.5270,  8.6017 > }
  triangle { <     .8816,  -1.5270,  6.6050 > , <    2.6448,  -1.5270,  8.6017 > , <     .0000,  -3.0540,  8.6017 > }
  triangle { <     .8816,  -1.5270,  6.6050 > , <     .0000,  -3.0540,  8.6017 > , <     .8816,  -4.5810,  6.6050 > }
  triangle { <     .8816,  -1.5270,  6.6050 > , <     .8816,  -4.5810,  6.6050 > , <    3.5265,  -3.0540,  6.6050 > }
  triangle { <     .8816,  -1.5270,  6.6050 > , <    3.5265,  -3.0540,  6.6050 > , <    2.6448,  -1.5270,  8.6017 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   99  MG
 union {
  triangle { <   -2.6448,   4.5810,  8.6017 > , <   -1.7632,   3.0540,  6.6050 > , <     .0000,   3.0540,  8.6017 > }
  triangle { <   -2.6448,   4.5810,  8.6017 > , <     .0000,   3.0540,  8.6017 > , <     .0000,   6.1080,  8.6017 > }
  triangle { <   -2.6448,   4.5810,  8.6017 > , <     .0000,   6.1080,  8.6017 > , <   -1.7632,   6.1080,  6.6050 > }
  triangle { <   -2.6448,   4.5810,  8.6017 > , <   -1.7632,   6.1080,  6.6050 > , <   -1.7632,   3.0540,  6.6050 > }
  triangle { <     .8816,   4.5810,  6.6050 > , <   -1.7632,   3.0540,  6.6050 > , <     .0000,   3.0540,  8.6017 > }
  triangle { <     .8816,   4.5810,  6.6050 > , <     .0000,   3.0540,  8.6017 > , <     .0000,   6.1080,  8.6017 > }
  triangle { <     .8816,   4.5810,  6.6050 > , <     .0000,   6.1080,  8.6017 > , <   -1.7632,   6.1080,  6.6050 > }
  triangle { <     .8816,   4.5810,  6.6050 > , <   -1.7632,   6.1080,  6.6050 > , <   -1.7632,   3.0540,  6.6050 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   98  MG
 union {
  triangle { <     .0000,    .0000,  8.6017 > , <     .0000,   3.0540,  8.6017 > , <   -2.6448,   1.5270,  8.6017 > }
  triangle { <     .0000,    .0000,  8.6017 > , <   -2.6448,   1.5270,  8.6017 > , <   -1.7632,    .0000,  6.6050 > }
  triangle { <     .0000,    .0000,  8.6017 > , <   -1.7632,    .0000,  6.6050 > , <     .8816,   1.5270,  6.6050 > }
  triangle { <     .0000,    .0000,  8.6017 > , <     .8816,   1.5270,  6.6050 > , <     .0000,   3.0540,  8.6017 > }
  triangle { <   -1.7632,   3.0540,  6.6050 > , <     .0000,   3.0540,  8.6017 > , <   -2.6448,   1.5270,  8.6017 > }
  triangle { <   -1.7632,   3.0540,  6.6050 > , <   -2.6448,   1.5270,  8.6017 > , <   -1.7632,    .0000,  6.6050 > }
  triangle { <   -1.7632,   3.0540,  6.6050 > , <   -1.7632,    .0000,  6.6050 > , <     .8816,   1.5270,  6.6050 > }
  triangle { <   -1.7632,   3.0540,  6.6050 > , <     .8816,   1.5270,  6.6050 > , <     .0000,   3.0540,  8.6017 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   94  MG
 union {
  triangle { <   -2.6448,   4.5810,  8.6017 > , <   -5.2897,   6.1080,  8.6017 > , <   -2.6448,   7.6350,  8.6017 > }
  triangle { <   -2.6448,   4.5810,  8.6017 > , <   -2.6448,   7.6350,  8.6017 > , <   -1.7632,   6.1080,  6.6050 > }
  triangle { <   -2.6448,   4.5810,  8.6017 > , <   -1.7632,   6.1080,  6.6050 > , <   -4.4081,   4.5810,  6.6050 > }
  triangle { <   -2.6448,   4.5810,  8.6017 > , <   -4.4081,   4.5810,  6.6050 > , <   -5.2897,   6.1080,  8.6017 > }
  triangle { <   -4.4081,   7.6350,  6.6050 > , <   -5.2897,   6.1080,  8.6017 > , <   -2.6448,   7.6350,  8.6017 > }
  triangle { <   -4.4081,   7.6350,  6.6050 > , <   -2.6448,   7.6350,  8.6017 > , <   -1.7632,   6.1080,  6.6050 > }
  triangle { <   -4.4081,   7.6350,  6.6050 > , <   -1.7632,   6.1080,  6.6050 > , <   -4.4081,   4.5810,  6.6050 > }
  triangle { <   -4.4081,   7.6350,  6.6050 > , <   -4.4081,   4.5810,  6.6050 > , <   -5.2897,   6.1080,  8.6017 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   97  MG
 union {
  triangle { <   -1.7632,    .0000,  6.6050 > , <   -1.7632,  -3.0540,  6.6050 > , <     .8816,  -1.5270,  6.6050 > }
  triangle { <   -1.7632,    .0000,  6.6050 > , <     .8816,  -1.5270,  6.6050 > , <     .0000,    .0000,  8.6017 > }
  triangle { <   -1.7632,    .0000,  6.6050 > , <     .0000,    .0000,  8.6017 > , <   -2.6448,  -1.5270,  8.6016 > }
  triangle { <   -1.7632,    .0000,  6.6050 > , <   -2.6448,  -1.5270,  8.6016 > , <   -1.7632,  -3.0540,  6.6050 > }
  triangle { <     .0000,  -3.0540,  8.6017 > , <   -1.7632,  -3.0540,  6.6050 > , <     .8816,  -1.5270,  6.6050 > }
  triangle { <     .0000,  -3.0540,  8.6017 > , <     .8816,  -1.5270,  6.6050 > , <     .0000,    .0000,  8.6017 > }
  triangle { <     .0000,  -3.0540,  8.6017 > , <     .0000,    .0000,  8.6017 > , <   -2.6448,  -1.5270,  8.6016 > }
  triangle { <     .0000,  -3.0540,  8.6017 > , <   -2.6448,  -1.5270,  8.6016 > , <   -1.7632,  -3.0540,  6.6050 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   93  MG
 union {
  triangle { <   -4.4081,   4.5810,  6.6050 > , <   -4.4081,   1.5270,  6.6050 > , <   -1.7632,   3.0540,  6.6050 > }
  triangle { <   -4.4081,   4.5810,  6.6050 > , <   -1.7632,   3.0540,  6.6050 > , <   -2.6448,   4.5810,  8.6017 > }
  triangle { <   -4.4081,   4.5810,  6.6050 > , <   -2.6448,   4.5810,  8.6017 > , <   -5.2897,   3.0540,  8.6016 > }
  triangle { <   -4.4081,   4.5810,  6.6050 > , <   -5.2897,   3.0540,  8.6016 > , <   -4.4081,   1.5270,  6.6050 > }
  triangle { <   -2.6448,   1.5270,  8.6017 > , <   -4.4081,   1.5270,  6.6050 > , <   -1.7632,   3.0540,  6.6050 > }
  triangle { <   -2.6448,   1.5270,  8.6017 > , <   -1.7632,   3.0540,  6.6050 > , <   -2.6448,   4.5810,  8.6017 > }
  triangle { <   -2.6448,   1.5270,  8.6017 > , <   -2.6448,   4.5810,  8.6017 > , <   -5.2897,   3.0540,  8.6016 > }
  triangle { <   -2.6448,   1.5270,  8.6017 > , <   -5.2897,   3.0540,  8.6016 > , <   -4.4081,   1.5270,  6.6050 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   92  MG
 union {
  triangle { <   -1.7632,    .0000,  6.6050 > , <   -2.6448,   1.5270,  8.6017 > , <   -2.6448,  -1.5270,  8.6016 > }
  triangle { <   -1.7632,    .0000,  6.6050 > , <   -2.6448,  -1.5270,  8.6016 > , <   -4.4081,  -1.5270,  6.6050 > }
  triangle { <   -1.7632,    .0000,  6.6050 > , <   -4.4081,  -1.5270,  6.6050 > , <   -4.4081,   1.5270,  6.6050 > }
  triangle { <   -1.7632,    .0000,  6.6050 > , <   -4.4081,   1.5270,  6.6050 > , <   -2.6448,   1.5270,  8.6017 > }
  triangle { <   -5.2897,    .0000,  8.6016 > , <   -2.6448,   1.5270,  8.6017 > , <   -2.6448,  -1.5270,  8.6016 > }
  triangle { <   -5.2897,    .0000,  8.6016 > , <   -2.6448,  -1.5270,  8.6016 > , <   -4.4081,  -1.5270,  6.6050 > }
  triangle { <   -5.2897,    .0000,  8.6016 > , <   -4.4081,  -1.5270,  6.6050 > , <   -4.4081,   1.5270,  6.6050 > }
  triangle { <   -5.2897,    .0000,  8.6016 > , <   -4.4081,   1.5270,  6.6050 > , <   -2.6448,   1.5270,  8.6017 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   61  MG
 union {
  triangle { <    4.4081,  -1.5270,  -.9983 > , <    3.5265,  -3.0540,   .9983 > , <    4.4081,  -4.5810,  -.9983 > }
  triangle { <    4.4081,  -1.5270,  -.9983 > , <    4.4081,  -4.5810,  -.9983 > , <    7.0529,  -3.0540,  -.9983 > }
  triangle { <    4.4081,  -1.5270,  -.9983 > , <    7.0529,  -3.0540,  -.9983 > , <    6.1713,  -1.5270,   .9983 > }
  triangle { <    4.4081,  -1.5270,  -.9983 > , <    6.1713,  -1.5270,   .9983 > , <    3.5265,  -3.0540,   .9983 > }
  triangle { <    6.1713,  -4.5810,   .9983 > , <    3.5265,  -3.0540,   .9983 > , <    4.4081,  -4.5810,  -.9983 > }
  triangle { <    6.1713,  -4.5810,   .9983 > , <    4.4081,  -4.5810,  -.9983 > , <    7.0529,  -3.0540,  -.9983 > }
  triangle { <    6.1713,  -4.5810,   .9983 > , <    7.0529,  -3.0540,  -.9983 > , <    6.1713,  -1.5270,   .9983 > }
  triangle { <    6.1713,  -4.5810,   .9983 > , <    6.1713,  -1.5270,   .9983 > , <    3.5265,  -3.0540,   .9983 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   63  MG
 union {
  triangle { <    4.4081,   1.5270,  -.9983 > , <    4.4081,  -1.5270,  -.9983 > , <    7.0529,    .0000,  -.9983 > }
  triangle { <    4.4081,   1.5270,  -.9983 > , <    7.0529,    .0000,  -.9983 > , <    6.1713,   1.5270,   .9983 > }
  triangle { <    4.4081,   1.5270,  -.9983 > , <    6.1713,   1.5270,   .9983 > , <    3.5265,    .0000,   .9983 > }
  triangle { <    4.4081,   1.5270,  -.9983 > , <    3.5265,    .0000,   .9983 > , <    4.4081,  -1.5270,  -.9983 > }
  triangle { <    6.1713,  -1.5270,   .9983 > , <    4.4081,  -1.5270,  -.9983 > , <    7.0529,    .0000,  -.9983 > }
  triangle { <    6.1713,  -1.5270,   .9983 > , <    7.0529,    .0000,  -.9983 > , <    6.1713,   1.5270,   .9983 > }
  triangle { <    6.1713,  -1.5270,   .9983 > , <    6.1713,   1.5270,   .9983 > , <    3.5265,    .0000,   .9983 > }
  triangle { <    6.1713,  -1.5270,   .9983 > , <    3.5265,    .0000,   .9983 > , <    4.4081,  -1.5270,  -.9983 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   55  MG
 union {
  triangle { <    4.4081,   4.5810,  -.9983 > , <    1.7632,   3.0540,  -.9983 > , <    1.7632,   6.1080,  -.9983 > }
  triangle { <    4.4081,   4.5810,  -.9983 > , <    1.7632,   6.1080,  -.9983 > , <    3.5265,   6.1080,   .9983 > }
  triangle { <    4.4081,   4.5810,  -.9983 > , <    3.5265,   6.1080,   .9983 > , <    3.5265,   3.0540,   .9983 > }
  triangle { <    4.4081,   4.5810,  -.9983 > , <    3.5265,   3.0540,   .9983 > , <    1.7632,   3.0540,  -.9983 > }
  triangle { <     .8816,   4.5810,   .9983 > , <    1.7632,   3.0540,  -.9983 > , <    1.7632,   6.1080,  -.9983 > }
  triangle { <     .8816,   4.5810,   .9983 > , <    1.7632,   6.1080,  -.9983 > , <    3.5265,   6.1080,   .9983 > }
  triangle { <     .8816,   4.5810,   .9983 > , <    3.5265,   6.1080,   .9983 > , <    3.5265,   3.0540,   .9983 > }
  triangle { <     .8816,   4.5810,   .9983 > , <    3.5265,   3.0540,   .9983 > , <    1.7632,   3.0540,  -.9983 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   65  MG
 union {
  triangle { <    4.4081,   4.5810,  -.9983 > , <    4.4081,   1.5270,  -.9983 > , <    7.0529,   3.0540,  -.9983 > }
  triangle { <    4.4081,   4.5810,  -.9983 > , <    7.0529,   3.0540,  -.9983 > , <    6.1713,   4.5810,   .9983 > }
  triangle { <    4.4081,   4.5810,  -.9983 > , <    6.1713,   4.5810,   .9983 > , <    3.5265,   3.0540,   .9983 > }
  triangle { <    4.4081,   4.5810,  -.9983 > , <    3.5265,   3.0540,   .9983 > , <    4.4081,   1.5270,  -.9983 > }
  triangle { <    6.1713,   1.5270,   .9983 > , <    4.4081,   1.5270,  -.9983 > , <    7.0529,   3.0540,  -.9983 > }
  triangle { <    6.1713,   1.5270,   .9983 > , <    7.0529,   3.0540,  -.9983 > , <    6.1713,   4.5810,   .9983 > }
  triangle { <    6.1713,   1.5270,   .9983 > , <    6.1713,   4.5810,   .9983 > , <    3.5265,   3.0540,   .9983 > }
  triangle { <    6.1713,   1.5270,   .9983 > , <    3.5265,   3.0540,   .9983 > , <    4.4081,   1.5270,  -.9983 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   53  MG
 union {
  triangle { <    3.5265,    .0000,   .9983 > , <    1.7632,    .0000,  -.9983 > , <     .8816,   1.5270,   .9983 > }
  triangle { <    3.5265,    .0000,   .9983 > , <     .8816,   1.5270,   .9983 > , <    3.5265,   3.0540,   .9983 > }
  triangle { <    3.5265,    .0000,   .9983 > , <    3.5265,   3.0540,   .9983 > , <    4.4081,   1.5270,  -.9983 > }
  triangle { <    3.5265,    .0000,   .9983 > , <    4.4081,   1.5270,  -.9983 > , <    1.7632,    .0000,  -.9983 > }
  triangle { <    1.7632,   3.0540,  -.9983 > , <    1.7632,    .0000,  -.9983 > , <     .8816,   1.5270,   .9983 > }
  triangle { <    1.7632,   3.0540,  -.9983 > , <     .8816,   1.5270,   .9983 > , <    3.5265,   3.0540,   .9983 > }
  triangle { <    1.7632,   3.0540,  -.9983 > , <    3.5265,   3.0540,   .9983 > , <    4.4081,   1.5270,  -.9983 > }
  triangle { <    1.7632,   3.0540,  -.9983 > , <    4.4081,   1.5270,  -.9983 > , <    1.7632,    .0000,  -.9983 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   45  MG
 union {
  triangle { <    -.8816,   7.6350,  -.9983 > , <   -1.7632,   6.1080,   .9983 > , <    -.8816,   4.5810,  -.9983 > }
  triangle { <    -.8816,   7.6350,  -.9983 > , <    -.8816,   4.5810,  -.9983 > , <    1.7632,   6.1080,  -.9983 > }
  triangle { <    -.8816,   7.6350,  -.9983 > , <    1.7632,   6.1080,  -.9983 > , <     .8816,   7.6350,   .9983 > }
  triangle { <    -.8816,   7.6350,  -.9983 > , <     .8816,   7.6350,   .9983 > , <   -1.7632,   6.1080,   .9983 > }
  triangle { <     .8816,   4.5810,   .9983 > , <   -1.7632,   6.1080,   .9983 > , <    -.8816,   4.5810,  -.9983 > }
  triangle { <     .8816,   4.5810,   .9983 > , <    -.8816,   4.5810,  -.9983 > , <    1.7632,   6.1080,  -.9983 > }
  triangle { <     .8816,   4.5810,   .9983 > , <    1.7632,   6.1080,  -.9983 > , <     .8816,   7.6350,   .9983 > }
  triangle { <     .8816,   4.5810,   .9983 > , <     .8816,   7.6350,   .9983 > , <   -1.7632,   6.1080,   .9983 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   49  MG
 union {
  triangle { <    1.7632,  -3.0540,  -.9983 > , <    1.7632,  -6.1080,  -.9983 > , <    4.4081,  -4.5810,  -.9983 > }
  triangle { <    1.7632,  -3.0540,  -.9983 > , <    4.4081,  -4.5810,  -.9983 > , <    3.5265,  -3.0540,   .9983 > }
  triangle { <    1.7632,  -3.0540,  -.9983 > , <    3.5265,  -3.0540,   .9983 > , <     .8816,  -4.5810,   .9983 > }
  triangle { <    1.7632,  -3.0540,  -.9983 > , <     .8816,  -4.5810,   .9983 > , <    1.7632,  -6.1080,  -.9983 > }
  triangle { <    3.5265,  -6.1080,   .9983 > , <    1.7632,  -6.1080,  -.9983 > , <    4.4081,  -4.5810,  -.9983 > }
  triangle { <    3.5265,  -6.1080,   .9983 > , <    4.4081,  -4.5810,  -.9983 > , <    3.5265,  -3.0540,   .9983 > }
  triangle { <    3.5265,  -6.1080,   .9983 > , <    3.5265,  -3.0540,   .9983 > , <     .8816,  -4.5810,   .9983 > }
  triangle { <    3.5265,  -6.1080,   .9983 > , <     .8816,  -4.5810,   .9983 > , <    1.7632,  -6.1080,  -.9983 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   51  MG
 union {
  triangle { <    1.7632,    .0000,  -.9983 > , <    4.4081,  -1.5270,  -.9983 > , <    1.7632,  -3.0540,  -.9983 > }
  triangle { <    1.7632,    .0000,  -.9983 > , <    1.7632,  -3.0540,  -.9983 > , <     .8816,  -1.5270,   .9983 > }
  triangle { <    1.7632,    .0000,  -.9983 > , <     .8816,  -1.5270,   .9983 > , <    3.5265,    .0000,   .9983 > }
  triangle { <    1.7632,    .0000,  -.9983 > , <    3.5265,    .0000,   .9983 > , <    4.4081,  -1.5270,  -.9983 > }
  triangle { <    3.5265,  -3.0540,   .9983 > , <    4.4081,  -1.5270,  -.9983 > , <    1.7632,  -3.0540,  -.9983 > }
  triangle { <    3.5265,  -3.0540,   .9983 > , <    1.7632,  -3.0540,  -.9983 > , <     .8816,  -1.5270,   .9983 > }
  triangle { <    3.5265,  -3.0540,   .9983 > , <     .8816,  -1.5270,   .9983 > , <    3.5265,    .0000,   .9983 > }
  triangle { <    3.5265,  -3.0540,   .9983 > , <    3.5265,    .0000,   .9983 > , <    4.4081,  -1.5270,  -.9983 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   43  MG
 union {
  triangle { <    -.8816,   4.5810,  -.9983 > , <    -.8816,   1.5270,  -.9983 > , <    1.7632,   3.0540,  -.9983 > }
  triangle { <    -.8816,   4.5810,  -.9983 > , <    1.7632,   3.0540,  -.9983 > , <     .8816,   4.5810,   .9983 > }
  triangle { <    -.8816,   4.5810,  -.9983 > , <     .8816,   4.5810,   .9983 > , <   -1.7632,   3.0540,   .9983 > }
  triangle { <    -.8816,   4.5810,  -.9983 > , <   -1.7632,   3.0540,   .9983 > , <    -.8816,   1.5270,  -.9983 > }
  triangle { <     .8816,   1.5270,   .9983 > , <    -.8816,   1.5270,  -.9983 > , <    1.7632,   3.0540,  -.9983 > }
  triangle { <     .8816,   1.5270,   .9983 > , <    1.7632,   3.0540,  -.9983 > , <     .8816,   4.5810,   .9983 > }
  triangle { <     .8816,   1.5270,   .9983 > , <     .8816,   4.5810,   .9983 > , <   -1.7632,   3.0540,   .9983 > }
  triangle { <     .8816,   1.5270,   .9983 > , <   -1.7632,   3.0540,   .9983 > , <    -.8816,   1.5270,  -.9983 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   36  MG
 union {
  triangle { <   -3.5265,   9.1620,  -.9983 > , <   -3.5265,   6.1080,  -.9983 > , <    -.8816,   7.6350,  -.9983 > }
  triangle { <   -3.5265,   9.1620,  -.9983 > , <    -.8816,   7.6350,  -.9983 > , <   -1.7632,   9.1620,   .9983 > }
  triangle { <   -3.5265,   9.1620,  -.9983 > , <   -1.7632,   9.1620,   .9983 > , <   -4.4081,   7.6350,   .9983 > }
  triangle { <   -3.5265,   9.1620,  -.9983 > , <   -4.4081,   7.6350,   .9983 > , <   -3.5265,   6.1080,  -.9983 > }
  triangle { <   -1.7632,   6.1080,   .9983 > , <   -3.5265,   6.1080,  -.9983 > , <    -.8816,   7.6350,  -.9983 > }
  triangle { <   -1.7632,   6.1080,   .9983 > , <    -.8816,   7.6350,  -.9983 > , <   -1.7632,   9.1620,   .9983 > }
  triangle { <   -1.7632,   6.1080,   .9983 > , <   -1.7632,   9.1620,   .9983 > , <   -4.4081,   7.6350,   .9983 > }
  triangle { <   -1.7632,   6.1080,   .9983 > , <   -4.4081,   7.6350,   .9983 > , <   -3.5265,   6.1080,  -.9983 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   59  MG
 union {
  triangle { <    4.4081,  -7.6350,  -.9983 > , <    7.0529,  -6.1080,  -.9983 > , <    4.4081,  -4.5810,  -.9983 > }
  triangle { <    4.4081,  -7.6350,  -.9983 > , <    4.4081,  -4.5810,  -.9983 > , <    3.5265,  -6.1080,   .9983 > }
  triangle { <    4.4081,  -7.6350,  -.9983 > , <    3.5265,  -6.1080,   .9983 > , <    6.1713,  -7.6350,   .9983 > }
  triangle { <    4.4081,  -7.6350,  -.9983 > , <    6.1713,  -7.6350,   .9983 > , <    7.0529,  -6.1080,  -.9983 > }
  triangle { <    6.1713,  -4.5810,   .9983 > , <    7.0529,  -6.1080,  -.9983 > , <    4.4081,  -4.5810,  -.9983 > }
  triangle { <    6.1713,  -4.5810,   .9983 > , <    4.4081,  -4.5810,  -.9983 > , <    3.5265,  -6.1080,   .9983 > }
  triangle { <    6.1713,  -4.5810,   .9983 > , <    3.5265,  -6.1080,   .9983 > , <    6.1713,  -7.6350,   .9983 > }
  triangle { <    6.1713,  -4.5810,   .9983 > , <    6.1713,  -7.6350,   .9983 > , <    7.0529,  -6.1080,  -.9983 > }
    texture { PolyTyp02            }
 } //end union
 // Octahedron   34  MG
 union {
  triangle { <   -3.5265,   6.1080,  -.9983 > , <   -3.5265,   3.0540,  -.9983 > , <    -.8816,   4.5810,  -.9983 > }
  triangle { <   -3.5265,   6.1080,  -.9983 > , <    -.8816,   4.5810,  -.9983 > , <   -1.7632,   6.1080,   .9983 > }
  triangle { <   -3.5265,   6.1080,  -.9983 > , <   -1.7632,   6.1080,   .9983 > , <   -4.4081,   4.5810,   .9983 > }
  triangle { <   -3.5265,   6.1080,  -.9983 > , <   -4.4081,   4.5810,   .9983 > , <   -3.5265,   3.0540,  -.9983 > }
  triangle { <   -1.7632,   3.0540,   .9983 > , <   -3.5265,   3.0540,  -.9983 > , <    -.8816,   4.5810,  -.9983 > }
  triangle { <   -1.7632,   3.0540,   .9983 > , <    -.8816,   4.5810,  -.9983 > , <   -1.7632,   6.1080,   .9983 > }
  triangle { <   -1.7632,   3.0540,   .9983 > , <   -1.7632,   6.1080,   .9983 > , <   -4.4081,   4.5810,   .9983 > }
  triangle { <   -1.7632,   3.0540,   .9983 > , <   -4.4081,   4.5810,   .9983 > , <   -3.5265,   3.0540,  -.9983 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron    9  MG
 union {
  triangle { <    -.8816,   1.5270,  -.9983 > , <    -.8816,  -1.5270,  -.9983 > , <    1.7632,    .0000,  -.9983 > }
  triangle { <    -.8816,   1.5270,  -.9983 > , <    1.7632,    .0000,  -.9983 > , <     .8816,   1.5270,   .9983 > }
  triangle { <    -.8816,   1.5270,  -.9983 > , <     .8816,   1.5270,   .9983 > , <   -1.7632,    .0000,   .9983 > }
  triangle { <    -.8816,   1.5270,  -.9983 > , <   -1.7632,    .0000,   .9983 > , <    -.8816,  -1.5270,  -.9983 > }
  triangle { <     .8816,  -1.5270,   .9983 > , <    -.8816,  -1.5270,  -.9983 > , <    1.7632,    .0000,  -.9983 > }
  triangle { <     .8816,  -1.5270,   .9983 > , <    1.7632,    .0000,  -.9983 > , <     .8816,   1.5270,   .9983 > }
  triangle { <     .8816,  -1.5270,   .9983 > , <     .8816,   1.5270,   .9983 > , <   -1.7632,    .0000,   .9983 > }
  triangle { <     .8816,  -1.5270,   .9983 > , <   -1.7632,    .0000,   .9983 > , <    -.8816,  -1.5270,  -.9983 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   32  MG
 union {
  triangle { <    -.8816,   1.5270,  -.9983 > , <   -3.5265,    .0000,  -.9983 > , <   -3.5265,   3.0540,  -.9983 > }
  triangle { <    -.8816,   1.5270,  -.9983 > , <   -3.5265,   3.0540,  -.9983 > , <   -1.7632,   3.0540,   .9983 > }
  triangle { <    -.8816,   1.5270,  -.9983 > , <   -1.7632,   3.0540,   .9983 > , <   -1.7632,    .0000,   .9983 > }
  triangle { <    -.8816,   1.5270,  -.9983 > , <   -1.7632,    .0000,   .9983 > , <   -3.5265,    .0000,  -.9983 > }
  triangle { <   -4.4081,   1.5270,   .9983 > , <   -3.5265,    .0000,  -.9983 > , <   -3.5265,   3.0540,  -.9983 > }
  triangle { <   -4.4081,   1.5270,   .9983 > , <   -3.5265,   3.0540,  -.9983 > , <   -1.7632,   3.0540,   .9983 > }
  triangle { <   -4.4081,   1.5270,   .9983 > , <   -1.7632,   3.0540,   .9983 > , <   -1.7632,    .0000,   .9983 > }
  triangle { <   -4.4081,   1.5270,   .9983 > , <   -1.7632,    .0000,   .9983 > , <   -3.5265,    .0000,  -.9983 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   40  MG
 union {
  triangle { <    1.7632,  -3.0540,  -.9983 > , <    -.8816,  -4.5810,  -.9983 > , <    -.8816,  -1.5270,  -.9983 > }
  triangle { <    1.7632,  -3.0540,  -.9983 > , <    -.8816,  -1.5270,  -.9983 > , <     .8816,  -1.5270,   .9983 > }
  triangle { <    1.7632,  -3.0540,  -.9983 > , <     .8816,  -1.5270,   .9983 > , <     .8816,  -4.5810,   .9983 > }
  triangle { <    1.7632,  -3.0540,  -.9983 > , <     .8816,  -4.5810,   .9983 > , <    -.8816,  -4.5810,  -.9983 > }
  triangle { <   -1.7632,  -3.0540,   .9983 > , <    -.8816,  -4.5810,  -.9983 > , <    -.8816,  -1.5270,  -.9983 > }
  triangle { <   -1.7632,  -3.0540,   .9983 > , <    -.8816,  -1.5270,  -.9983 > , <     .8816,  -1.5270,   .9983 > }
  triangle { <   -1.7632,  -3.0540,   .9983 > , <     .8816,  -1.5270,   .9983 > , <     .8816,  -4.5810,   .9983 > }
  triangle { <   -1.7632,  -3.0540,   .9983 > , <     .8816,  -4.5810,   .9983 > , <    -.8816,  -4.5810,  -.9983 > }
    texture { PolyTyp01            }
 } //end union
 // Octahedron   30  MG
 union {
  triangle { <   -3.5265,    .0000,  -.9983 > , <    -.8816,  -1.5270,  -.9983 > , <   -3.5265,  -3.0540,  -.9983 > }
  triangle { <   -3.5265,    .0000,  -.9983 > , <   -3.5265,  -3.0540,  -.9983 > , <   -4.4081,  -1.5270,   .9983 > }
  triangle { <   -3.5265,    .0000,  -.9983 > , <   -4.4081,  -1.5270,   .9983 > , <   -1.7632,    .0000,   .9983 > }
  triangle { <   -3.5265,    .0000,  -.9983 > , <   -1.7632,    .0000,   .9983 > , <    -.8816,  -1.5270,  -.9983 > }
  triangle { <   -1.7632,  -3.0540,   .9983 > , <    -.8816,  -1.5270,  -.9983 > , <   -3.5265,  -3.0540,  -.9983 > }
  triangle { <   -1.7632,  -3.0540,   .9983 > , <   -3.5265,  -3.0540,  -.9983 > , <   -4.4081,  -1.5270,   .9983 > }
  triangle { <   -1.7632,  -3.0540,   .9983 > , <   -4.4081,  -1.5270,   .9983 > , <   -1.7632,    .0000,   .9983 > }
  triangle { <   -1.7632,  -3.0540,   .9983 > , <   -1.7632,    .0000,   .9983 > , <    -.8816,  -1.5270,  -.9983 > }
    texture { PolyTyp02            }
 } //end union


// top interlayer

//Cl-
sphere { <  3.2, -4.3, 3.8>, 1.81 texture { SphereTyp02 } }
sphere { <  0.8,  0.0, 3.8>, 1.81 texture { SphereTyp02 } }
sphere { < -4.2,  0.0, 3.8>, 1.81 texture { SphereTyp02 } }
sphere { < -1.6,  4.2, 3.8>, 1.81 texture { SphereTyp02 } }

//H2O
sphere { < -0.4, -2.3, 3.8>, 0.38 texture { SphereTyp03 } }
sphere { <  0.8, -3.0, 3.8>, 1.35 texture { SphereTyp01 } }
sphere { <  2.0, -2.3, 3.8>, 0.38 texture { SphereTyp03 } }

sphere { < -1.8, 0.1, 3.8>, 0.38 texture { SphereTyp03 } }
sphere { < -1.8, 1.5, 3.8>, 1.35 texture { SphereTyp01 } }
sphere { < -3.0, 2.2, 3.8>, 0.38 texture { SphereTyp03 } }

sphere { < 3.2, 0.1, 3.8>, 0.38 texture { SphereTyp03 } }
sphere { < 3.2, 1.5, 3.8>, 1.35 texture { SphereTyp01 } }
sphere { < 2.0, 2.2, 3.8>, 0.38 texture { SphereTyp03 } }

sphere { < -5.4, 6.7, 3.8>, 0.38 texture { SphereTyp03 } }
sphere { < -4.2, 6.0, 3.8>, 1.35 texture { SphereTyp01 } }
sphere { < -3.0, 6.7, 3.8>, 0.38 texture { SphereTyp03 } }

//middle interlayer

//Cl-
sphere { <  1.6, -2.0, 11.4>, 1.81 texture { SphereTyp02 } }
sphere { < -3.4, -2.0, 11.4>, 1.81 texture { SphereTyp02 } }
sphere { < -0.8,  2.4, 11.4>, 1.81 texture { SphereTyp02 } }
sphere { < -3.2,  6.6, 11.4>, 1.81 texture { SphereTyp02 } }

//H2O
sphere { < 1.6, -6.4, 11.4>, 0.38 texture { SphereTyp03 } }
sphere { < 1.6, -5.0, 11.4>, 1.35 texture { SphereTyp01 } }
sphere { < 0.4, -4.3, 11.4>, 0.38 texture { SphereTyp03 } }

sphere { < -0.8, -2.0, 11.4>, 0.38 texture { SphereTyp03 } }
sphere { < -0.8, -0.6, 11.4>, 1.35 texture { SphereTyp01 } }
sphere { <  0.4,  0.1, 11.4>, 0.38 texture { SphereTyp03 } }

sphere { < 1.8, 2.4, 11.4>, 0.38 texture { SphereTyp03 } }
sphere { < 1.8, 3.8, 11.4>, 1.35 texture { SphereTyp01 } }
sphere { < 3.0, 4.5, 11.4>, 0.38 texture { SphereTyp03 } }

sphere { < -3.6, 2.4, 11.4>, 0.38 texture { SphereTyp03 } }
sphere { < -3.6, 3.8, 11.4>, 1.35 texture { SphereTyp01 } }
sphere { < -4.8, 4.5, 11.4>, 0.38 texture { SphereTyp03 } }

//bottom interlayer

//Cl-
sphere { <0.8, -1.5, 19>, 1.81 texture { SphereTyp02 } }
sphere { <3.4, -6, 19>, 1.81 texture { SphereTyp02 } }
sphere { <3.4, 3, 19>, 1.81 texture { SphereTyp02 } }
sphere { <-1.5, 3, 19>, 1.81 texture { SphereTyp02 } }
sphere { <-4, -1.5, 19>, 1.81 texture { SphereTyp02 } }
sphere { <-4, 7.5, 19>, 1.81 texture { SphereTyp02 } }

//H2O
sphere { <0.8, 2.9, 19>, 0.38 texture { SphereTyp03 } }
sphere { <0.8, 1.5, 19>, 1.35 texture { SphereTyp01 } }
sphere { <2, 0.8, 19>, 0.38 texture { SphereTyp03 } }

sphere { <3.4, -1.6, 19>, 0.38 texture { SphereTyp03 } }
sphere { <3.4, -3, 19>, 1.35 texture { SphereTyp01 } }
sphere { <2.2, -2.3, 19>, 0.38 texture { SphereTyp03 } }

sphere { <-1.6, -1.6, 19>, 0.38 texture { SphereTyp03 } }
sphere { <-1.6, -3, 19>, 1.35 texture { SphereTyp01 } }
sphere { <-2.8, -2.3, 19>, 0.38 texture { SphereTyp03 } }

sphere { <-4.2, 2.9, 19>, 0.38 texture { SphereTyp03 } }
sphere { <-4.2, 1.5, 19>, 1.35 texture { SphereTyp01 } }
sphere { <-3, 0.8, 19>, 0.38 texture { SphereTyp03 } }

sphere { <-1.6, 7.4, 19>, 0.38 texture { SphereTyp03 } }
sphere { <-1.6, 6, 19>, 1.35 texture { SphereTyp01 } }
sphere { <-2.8, 5.3, 19>, 0.38 texture { SphereTyp03 } }


//unit cell lattice
cylinder { < 4.8, 0.0, -1>,< 4.8, 0.0, 22.8>, 0.1 open texture { PolyTyp03 }}
cylinder { < 4.8, 3.0, -1>,< 4.8, 3.0, 22.8>, 0.1 open texture { PolyTyp03 }}
cylinder { < 2.4, 1.5, -1>,< 2.4, 1.5, 22.8>, 0.1 open texture { PolyTyp03 }}
cylinder { < 2.4, 4.5, -1>,< 2.4, 4.5, 22.8>, 0.1 open texture { PolyTyp03 }}

//crystallographic directions
union {
  cylinder { <0, 12, 15.2>,<0, 12, 22.8>, 0.2 }
  cone { <0, 12, 15.2> 0.5, <0, 12, 13.7>, 0 }
  cylinder { <0, 12, 22.8>,<0, 15, 22.8>, 0.2 }
  cone { <0, 15, 22.8> 0.5, <0, 16.5, 22.8>, 0 }
  cylinder { <0, 12, 22.8>,<2.8, 10.5, 22.8>, 0.2 }
  cone { <2.8, 10.5, 22.8> 0.5, <4.2, 9.8, 22.8>, 0 }
  pigment { BrightGold }
  finish { specular 2 roughness .01 reflection .6 }
  translate 3*x
  translate -4*y
} //union
} //End union



// end of file
