
// "Elementary"

// files and picture by/(c) Darren Izzard 1998

// Main POV-Ray file
// (for POV-Ray 3.1 beta 4)

#version 3.1;

#include "colors.inc"

//nb. to include the ENGRAVED_TEXT object (the array elements text hung from
//the wall at the back), you need to have the Arial Narrow TrueType font
//(filename "an______.ttf")  in the "/windows/fonts" directory. If you are
//planning on rendering this file, including that object, on another system
//(such as Linux or an Amiga), or if you don't have Arial Narrow, alter the
//following #declare to point to a TrueType font of your own. However, it
//may not fit in the frame provided.

#declare ENGRAVED_TEXT_FONT="\windows\fonts\an______.ttf"

// numerical options in the scene

#declare WALLHEIGHT=8.5;   //the height of the walls behind the table
#declare PROTON_RADIUS=0.8;      //only applies if ATOM=1 - gives radius of all subatomic
                                //particles, relative to the whole atom(=6).
#declare FIRE_SEED_NUMBER=48485648;          //seed for random numbers used by fire over walls
                                             //the number originates from the font sizes of
                                             //the four lines of text in the periodic table
                                             //imagemaps (48,48,56,48 points respectively).
#declare TABLE_SEED_NUMBER=145218;           //seed for random numbers used by the periodic
                                             //table object - 145 and 218 were consecutive
                                             //*FX call numbers described on page 238 of my
                                             //old Acorn Electron user guide

//boolean options for the scene - to turn these off, comment out the lines

//#declare USE_DIRTY_HEATER=1;       //I think this doesn't look too good - adds spots of
                                   //rust/corrosion to the reflective metal in the heater
//#declare STEAM_EMISSION=1;         //remove to use more accurate scattering{} for the beaker
                                   //steam - it's better-looking but VERY slow
//#declare TEXT_BACK_WALL=1;         //positions the engraved text on the back wall - otherwise
                                   //it goes on the left-hand side, behind the heater
#declare USE_TABLE_IMAGEMAPS=1;    //takes a little longer, but gives each element in the
                                   //periodic table an imagemap (actually chosen at random
                                   //from the stacked-block imagemaps.

//the main objects in the scene - comment out a line to remove the object

#declare LIGHTNING_LAYER=1;        //the lightning background
#declare ELECTRIC_FIRE=1;          //the electric fire
#declare WALL_ORNAMENTATION=1;     //wallpaper, plus the little red columns at the top
#declare WALL_FIRE=1;              //the flames on top of the wall - only if WALL_ORNAMENTATION
                                   //is also on
#declare WALL_WINDOW=1;            //the windows in the wall
#declare WATER_BEAKER=1;           //the beaker of boiling water+steam
#declare ATOM=1;                   //the carbon atom
#declare GEOMETRIC_ELEMENTS=1;     //the split-up cube
#declare PERIODIC_BLOCKS=1;        //the five stacked blocks from the periodic table
#declare ENGRAVED_TEXT=1;          //engraved text hung on the wall
#declare PERIODIC_TABLE=1;         //periodic table hung on the wall

//the elements - i.e. the weather
sky_sphere {
           pigment {    //reddish clouds
                   bozo
                   color_map {
                     [0 color (Red+White)/3]
                     [0.25 color (Blue+Orange)/2]
                     [0.5 color Gray20]
                     [1 color Black]
                     }
                   scale 0.05
                   turbulence 0.8
                   }
           #ifdef (LIGHTNING_LAYER)
           pigment {    //lightning
                   agate
                   color_map {
                             [0.98 color Clear]
                             [1 color White]
                             }
                   agate_turb 0.75
                   scale 0.4
                   }
           #end
           }



//electric fire (-3.75,-2.5,-2.5)-(3.75,2.5,2.5)
#declare ElectricFire=object {
       union {
             difference {   //wooden/painted metal case
                        union {
                              box {<-3.75,-2.5,-0.2>,<-3,2.5,2.5>}
                              union {    //switch on the side
                                    difference {
                                               box {<-3.75,1,2.25>,<-3.85,2,1.75>
                                                   texture { pigment { color White } }
                                                   }
                                               box {<-3.8,1.1,2.20>,<-4,1.9,1.80>
                                                   texture { pigment { color Blue/3 } }
                                                   }
                                               bounded_by { box {<-3.75,1,2.25>,<-3.85,2,1.75>}}
                                               }
                                    box {<-3.75,1.1,2.20>,<-4,1.5,1.80>
                                        texture { pigment { color Blue/3 } }
                                        }
                                    translate z*-1
                                    translate y*-2
                                    }
                              box {<3,-2.5,-0.2>,<3.75,2.5,2.5>}
                              box {<-3,-2.4,-0.3>,<3,2.4,2.5>
                                  texture {
                                          pigment { color Brown }
                                          normal { crackle scale 0.1 }
                                          finish { specular 0.1 metallic }
                                          }
                                  }
                              }
                        cylinder {<-3,0,0>,<3,0,0>,2}
                        bounded_by { box{<-4,-2.5,-0.2>,<3.5,2.5,2.5>}}
                        texture {
                                pigment {
                                        wood
                                        color_map {
                                                  [0 color (Red+Brown)/2]
                                                  [0.5 color Brown]
                                                  [1 color (Orange+Red+Brown)/3]
                                                  }
                                        turbulence 0.5
                                        }
                                finish { specular 0.2 }
                                }
                        }
             union {    //safety grille bars at the front
                   #declare Xpos=-2.5;
                   #while (Xpos<=2.5)
                          object {
                                 difference {
                                     torus { 2,0.05 sturm }
                                     box {<-2.5,-0.5,0>,<2.5,0.5,2.5>}
                                     bounded_by { box {<-2.5,-0.5,0>,<2.5,0.5,-2.5>}}
                                     texture {
                                             pigment { color White }
                                             finish { specular 0.75 metallic }
                                             }
                                     }
                                 rotate z*90
                                 scale <1,1,0.5>
                                 translate x*Xpos
                                 }
                          #declare Xpos=Xpos+1;
                   #end
                   }
             union {
                   difference { //metal reflective inner surface
                        cylinder {<-3,0,0>,<3,0,0>,2}
                        cylinder {<-3.1,0,-0.2>,<3.1,0,-0.2>,2}
                        bounded_by { box {<-3,-2,-2>,<3,2,2>} }
                        }
                   union {  //gold side plates
                         box {<-3,-2,-0.2>,<-2.8,2,2>}
                         box {<3,-2,-0.2>,<2.8,2,2>}
                         texture {
                                 pigment { color (Brown+Yellow)/2 }
                                 normal { crackle scale 0.1 }
                                 finish { specular 0.5 metallic }
                                 }
                         }
                   texture {    //a dirty[?] metallic finish
#ifdef (USE_DIRTY_HEATER)
                           bumps
                           texture_map {
                                       [0.98 pigment { color White } finish { reflection 0.7 }]
                                       [0.99 pigment { color Gray10 }]
                                       }
                           scale 0.1
#else
                           pigment { color White } finish { reflection 0.7 }
#end
                           }
                   }
             union {    //the heating elements!
                   #declare HeatingEl=light_source {
                         <-2,0,0> color (Red+Orange)/3
                         area_light x,y,5,1
                         adaptive 1
                         looks_like {
                            cylinder {<-3,0,0>,<3,0,0>,0.1 translate x*2}
                            texture {
                               pigment { gradient x
                                     color_map {
                                               [0 color Red]
                                               [1 color Yellow]
                                               }
                                     scallop_wave
                                     scale 0.05
                                     }
                               normal {
                                  gradient x
                                  scallop_wave
                                  scale 0.05
                                  }
                               finish {
                                  ambient 0.5
                                  }
                               }
                            }
                         }
                   object {HeatingEl translate z*0.75 translate y*1}
                   object {HeatingEl translate z*1}
                   object {HeatingEl translate z*0.75 translate -y*1}
                   }
             }
       }

//walls
#declare WallBlockTexture=texture {
                    pigment {
                            color (White+Yellow+Brown)/5
                            }
                    normal {
                           bumps
                           scale 0.05
                           }
                    finish {
                           specular 0.25
                           }
                    }

union {
      box {<-20,-20,-30>,<-21,WALLHEIGHT,21>
#ifdef (WALL_ORNAMENTATION)
          pigment {
                  image_map {
                            png "wallpaper.png"
                            interpolate 2
                            }
                  rotate -y*90
                  scale 3
                  }
#else
          pigment { color (Blue/2) }
#end
          }
#ifdef (WALL_WINDOW)
      union {
        difference {
#end
      box {<-21,-20,20>,<30,WALLHEIGHT,21>
#ifdef (WALL_ORNAMENTATION)
          pigment {
                  image_map {
                            png "wallpaper.png"
                            interpolate 2
                            }
                  scale 3
                  }
#else
          pigment { color (Blue/2) }
#end
          }
#ifdef (WALL_WINDOW)
      union {
            box {<-12,1,19>,<-8,6,22> pigment { color Black }}
            box {<1,1,19>,<5,6,22> pigment { color Black }}
            }
      bounded_by {box{<-21,-20,20>,<30,WALLHEIGHT,21>}}
      }   //difference
     //frame
     //-- win1
     box {<-12,1,19.6>,<-8,1.4,21.4>}
     box {<-12,6,19.6>,<-8,5.6,21.4>}
     box {<-12,1,19.6>,<-11.6,6,21.4>}
     box {<-8,1,19.6>,<-8.4,6,21.4>}
     //-- win2
     box {<1,1,19.6>,<5,1.4,21.4>}
     box {<1,6,19.6>,<5,5.6,21.4>}
     box {<1,1,19.6>,<1.4,6,21.4>}
     box {<5,1,19.6>,<4.6,6,21.4>}
     //top frame
     //-- win1
     difference {
                box {<-8,6,19.8>,<-12,3,21.2>}
                box {<-8.6,5.4,19.5>,<-11.4,3.2,21.5>}
                bounded_by{box{<-8,6,19.8>,<-12,3,21.2>}}
                }
     //-- win2
     difference {
                box {<1,6,19.8>,<5,3,21.2>}
                box {<1.6,5.4,19.5>,<4.4,3.2,21.5>}
                bounded_by{box{<1,6,19.8>,<5,3,21.2>}}
                }
     //glass
     //-- win1
     box {<-12,1,20>,<-8,6,21>
         texture {
                 pigment { color rgbft <0.8,1,0.8,0.9,0> }
                 }
         }
     //-- win2
     box {<1,1,20>,<5,6,21>
         texture {
                 pigment { color rgbft <0.8,1,0.8,0,0.9> }
                 }
         }
     texture {WallBlockTexture}
     }    //union
#end
      union {   //the blocks on top of the walls
            box {<-19,WALLHEIGHT-0.25,-30>,<-22,WALLHEIGHT+0.25,22>}
            box {<-22,WALLHEIGHT-0.25,19>,<30,WALLHEIGHT+0.25,22>}
#ifdef (WALL_ORNAMENTATION)
            //and the blocks on top of those...
            box {<-19,WALLHEIGHT+0.75,-30>,<-22,WALLHEIGHT+1,22>}
            box {<-22,WALLHEIGHT+0.75,19>,<30,WALLHEIGHT+1,22>}
  #ifdef (WALL_FIRE)
            union {
              #declare FireUnit=object {
                       cone {<0,0,0>,1,<0,3,0>,0
                                hollow on
                                texture { pigment { color Clear } }
                                interior {
                                         media {
                                               emission color (Yellow+Orange)/2
                                               samples 1,1
                                               density {
                                                       spherical
                                                       color_map {
                                                                 [0 color Black]
                                                                 [0.25 color Red]
                                                                 [0.5 color Orange]
                                                                 [0.75 color Yellow]
                                                                 [1 color White]
                                                                 }
                                                       turbulence 0.8
                                                       }
                                               }
                                         }
                                scale <0.5,1.5,0.5>
                                }
                       }
              #declare FireSeed=seed(FIRE_SEED_NUMBER);
              #declare Pos=0.5;
              #while (Pos<=50)
                   object { FireUnit translate <-20.5,WALLHEIGHT+1,22-Pos> }
                   object { FireUnit translate <-22+Pos,WALLHEIGHT+1,20.5> }
                   #declare Pos=Pos+0.25+(0.5*rand(FireSeed));
              #end
              }
  #end
#end
            texture{WallBlockTexture}
            }
#ifdef (WALL_ORNAMENTATION)
      union {   //the small columns between the two blocks
            #declare Pos=0.5;
            #while (Pos<=50)
                   cylinder {<-20.5,WALLHEIGHT+0.25,22-Pos>,<-20.5,WALLHEIGHT+0.75,22-Pos>,0.2}
                   cylinder {<-22+Pos,WALLHEIGHT+0.25,20.5>,<-22+Pos,WALLHEIGHT+0.75,20.5>,0.2}
                   #declare Pos=Pos+1;
            #end
            texture {
                    pigment { color (Red+Orange+White)/6 }
                    finish { metallic reflection 0.5 }
                    }
            }
#end
      }

#ifdef (PERIODIC_TABLE)
object {
       union {
             #declare FileNameArray=array[5] {
                      "elmap-105.png","elmap-14.png","elmap-79.png","elmap-8.png","elmap-92.png"
                      }
             #declare TableSeed=seed(TABLE_SEED_NUMBER);
             box {<-0.5,-0.5,0>,<18.3,11.3,-0.2>
                 texture {
                         pigment {
                                 wood
                                 colour_map {
                                            [0 color (Green+Brown*3)/4]
                                            [0.5 color Brown]
                                            [1 color (Green+Brown*2)/3]
                                            }
                                 turbulence 0.85
                                 }
                         }
                 }
             #declare XPos=0;
             #while (XPos<18)
                    #declare YPos=0;
                    #while (YPos<11)
                           //this horrendous conditional just formats out a nice
                           //periodic table, based on the one I found in my
                           //encyclopaedia - minus the five stacked blocks at
                           //the front of the picture!
                           #if (
                               ((YPos=0)&(XPos<15)&(XPos!=3)) |
                               ((YPos=2)&(XPos<15)) |
                               ((YPos=4)&(XPos<11)&(XPos!=2)&(XPos!=4)) |
                               ((YPos=5)&(XPos!=2)&(XPos!=10)) |
                               ((YPos>5)&(YPos<8)) |
                               ((YPos=8)&((XPos<2)|(XPos>11))&(XPos!=13)) |
                               ((YPos=9)&((XPos<2)|(XPos>11))&(XPos!=15)) |
                               ((YPos=10)&((XPos=0)|(XPos=17)))
                               )
                             object {
                                  box {<0,0,0>,<1,1,-1>}
                                  texture {
                                          pigment {
                                              #ifdef (USE_TABLE_IMAGEMAPS)
                                                  image_map {
                                                            png FileNameArray[rand(TableSeed)*4.999]
                                                            interpolate 2
                                                            }
                                              #else
                                                  color White
                                              #end
                                              }
                                          finish { reflection 0.2 }
                                          }
                                  scale 0.8
                                  translate <XPos,YPos,0>
                                  }
                           #end
                           #declare YPos=YPos+1;
                    #end
                    #declare XPos=XPos+1;
             #end
             }
       scale 0.3
       translate <-6,3,20>
       }
#end

#ifdef (ENGRAVED_TEXT)
object {
       union {
             union { //frame
                   box {<0,-0.425,-0.2>,<-0.125,1.125,0.2>}
                   box {<12.25,-0.425,-0.2>,<12.375,1.125,0.2>}
                   box {<-0.125,-0.425,-0.2>,<12.375,-0.3,0.2>}
                   box {<-0.125,1,-0.2>,<12.375,1.125,0.2>}
                   texture {
                           pigment { wood
                                   color_map {
                                             [0 color Yellow/4]
                                             [1 color Brown]
                                             }
                                   scale 0.25
                                   turbulence 0.75
                                   }
                           }
                   }
             difference {
                  #declare TextBox=box {<0,-0.3,0>,<12.25,1,0.2>}
                  object {TextBox}
                  text {
                       ttf ENGRAVED_TEXT_FONT
                       "a[5]  b(7)  c[1][2]  d(1,e(5),f(g(2)))"
                       0.1,0
                       texture {
                               pigment { color Blue/2 }
                               finish { specular 0.1 metallic }
                               }
                       }
                  bounded_by {object {TextBox}}
                  texture {
                          pigment { color (Yellow+Blue*2)/3 }
                          finish { specular 0.3 metallic }
                          }
                  }
           }
  #ifdef (TEXT_BACK_WALL)
       scale <1.5,1,2>
       translate <-12.5,WALLHEIGHT-1.8,19.6>
  #else
       scale <1.5,1,2>
       rotate y*-90
       translate <-19.6,WALLHEIGHT-1.8,2>
  #end
       }
#end

#ifdef (WATER_BEAKER)
#declare WaterBeaker=object {
         union {
               lathe {
                     linear_spline
                     11
                     <0,0>,<2.5,0>,<3,0.5>,<3,6>,<3.5,6.5>,
                     <3,6.5>,<2.5,6>,<2.5,1>,<2,0.5>,<0,0.5>,
                     <0,0>
                     sturm
                     texture {
                             pigment {
                                     image_map {
                                               png "beakermap.png"
                                               transmit 0,0.8     //bg colour is transparent
                                               map_type 2         //cylindrical
                                               interpolate 2
                                               }
                                     scale <1,6.5,1>    //match shape
                                     //color rgbft <0.9,0.9,1,0.6,0>
                                     }
                             finish {
                                    specular 0.4
                                    }
                             }
                     interior {
                              ior 1.5   //glass
                              }
                     }
               lathe {
                     linear_spline
                     6
                     <0,0.5>,<2,0.5>,<2.5,1>,<2.5,4.5>,<0,4.5>,<0,0.5>
                     sturm
                     texture {
                             pigment {
                                     color rgbft <0.7,0.8,0.9,0,0.9>
                                     }
                             }
                     interior {
                              ior 1.333  //water
                              }
                     }
                 cylinder {
                        <0,0,0>,<0,1,0>,1
                        hollow on
                        pigment { color rgbf 1 }
                        interior {
                                 media {
                                       #ifdef (STEAM_EMISSION)
                                       emission color 0.25
                                       #else
                                       scattering { 3, //Mie hazy: more accurate but MUCH slower
                                                    color 1
                                                    }
                                       #end
                                       samples 1,1
                                       density {
                                               spherical
                                               turbulence 0.8
                                               }
                                       }
                                 }
                        scale <3,8,3>
                        translate y*6
                        }


//This was the old 3.02 halo{} version of the steam.
//It will not work AT ALL in POV 3.1 - use the media{} version
//above instead.
//               cylinder {
//                      <0,0,0>,<0,1,0>,1
//                      hollow
//                      pigment { color Clear }
//                      finish { ambient 0 }
//                      halo {
//                           attenuating
//                           cubic
//                           spherical_mapping
//                           colour_map {
//                                      [0 rgbt <0.5,0.5,0.5,1>]
//                                      [1 rgbt <0.5,0.5,0.5,0>]
//                                      }
//                           samples 25
//                           turbulence 0.8
//                           }
//                      scale <3,8,3>
//                      translate y*6
//                      }
               }
         }
#end

#ifdef (ATOM)
#declare CarbonAtom=object {    //sphere of approx. radius 6.5
         union {
               #declare NucleusHalf=object {
                   union {
                     sphere {<1,0,0>,PROTON_RADIUS}
                     sphere {<0,1,0>,PROTON_RADIUS}
                     sphere {<0,0,1>,PROTON_RADIUS}
                     sphere {<-1,0,0>,PROTON_RADIUS}
                     sphere {<0,-1,0>,PROTON_RADIUS}
                     sphere {<0,0,-1>,PROTON_RADIUS}
                     }
                   }
               object { NucleusHalf
                      texture {
                              pigment { color Blue }
                              finish { phong 0.25 phong_size 30 }
                              }
                      }
               object { NucleusHalf
                      rotate z*45
                      texture {
                              pigment { color Magenta }
                              finish { phong 0.25 phong_size 30 }
                              }
                      }
               #declare ElectronOrbit=union {
                        torus {
                              6,0.1 sturm
                              pigment { color rgbt <0.7,0.7,0.7,0.7> }
                              }
                        object {
                           sphere { <6,0,0>,PROTON_RADIUS
                                 texture {
                                         pigment { color SkyBlue }
                                         finish { phong 0.25 phong_size 30 }
                                         }
                               }
                           }
                        }
               object { ElectronOrbit rotate <0,20,50>}
               object { ElectronOrbit rotate <60,80,110> }
               object { ElectronOrbit rotate <120,140,170> }
               object { ElectronOrbit rotate <180,200,230> }
               object { ElectronOrbit rotate <240,260,290> }
               object { ElectronOrbit rotate <300,320,350> }
               }
         }
#end

#ifdef (GEOMETRIC_ELEMENTS)
#declare SplitCube=object {
         object {         //was union{}
               union {  //initial cube
                     #declare CubeInternal=box { <0,0,0>,<1,1,1> //internal
                           texture {
                                   pigment { colour rgbt <0.4,0.75,1,0.6> }
                                   }
                           }
                     #declare CubeEdges=union {    //edges
                           cylinder {<0,0,0>,<1,0,0>,0.05}
                           cylinder {<0,0,0>,<0,1,0>,0.05}
                           cylinder {<0,0,0>,<0,0,1>,0.05}
                           cylinder {<1,1,1>,<0,1,1>,0.05}
                           cylinder {<1,1,1>,<1,0,1>,0.05}
                           cylinder {<1,1,1>,<1,1,0>,0.05}
                           cylinder {<1,0,0>,<1,1,0>,0.05}
                           cylinder {<1,0,0>,<1,0,1>,0.05}
                           cylinder {<0,1,0>,<1,1,0>,0.05}
                           cylinder {<0,1,0>,<0,1,1>,0.05}
                           cylinder {<0,0,1>,<1,0,1>,0.05}
                           cylinder {<0,0,1>,<0,1,1>,0.05}
                           texture {
                                   pigment { colour Orange }
                                   finish { specular 0.1 metallic }
                                   }
                           }
                     #declare CubePoints=union {    //points
                           sphere {<0,0,0>,0.07}
                           sphere {<1,0,0>,0.07}
                           sphere {<0,1,0>,0.07}
                           sphere {<1,1,0>,0.07}
                           sphere {<0,0,1>,0.07}
                           sphere {<1,0,1>,0.07}
                           sphere {<0,1,1>,0.07}
                           sphere {<1,1,1>,0.07}
                           texture {
                                   pigment { colour <1,0.8,0.8,0.5> }
                                   finish { specular 0.25 metallic }
                                   }
                           }
                     object {CubeInternal}
                     object {CubePoints scale 1.4 translate -0.2}
                     object {CubeEdges scale 1.2 translate -0.1 }
                     }
               }
         }
#end

#ifdef (PERIODIC_BLOCKS)

#declare PBlockTexture=texture {
         pigment { color (White*2+Yellow)/3 }
         finish { reflection 0.2 }
         }

#macro PBlock(MapFileName)
       union {
             box {<0,0,0>,<1,1,-0.2>
                 texture {
                         pigment { color (White*2+Yellow)/3 }
                         finish { reflection 0.2 }
                         }
                 }
             box {<0,0,-0.19>,<1,1,-0.3>
                 texture {
                         pigment {
                                 image_map {
                                           png MapFileName
                                           interpolate 2
                                           }
                                 }
                         finish { reflection 0.2 }
                         }
                 }
             }
#end

#declare PeriodicBlocks=object {
         union {
               object { PBlock("elmap-8.png") rotate y*5 }                       //Oxygen
               object { PBlock("elmap-92.png") rotate -y*30 translate x }        //Uranium
               object { PBlock("elmap-105.png") rotate -y*20 translate -x+z/2 }  //Unnilpentium
               object { PBlock("elmap-79.png") rotate x*90 translate x/4+y-z/2 } //Gold
               object { PBlock("elmap-14.png") rotate -y*30 translate -x+y+z/2}  //Silicon
               }
         }
#end

//table and its objects
union {
      object {
             box { <-10,-1,-10>,<10,0,10> }
             texture {
                     pigment {
                             wood
                             color_map {
                               [0 color Brown/2]
                               [0.5 color (Red+Brown)/3]
                               [1 color (Brown*2+Orange)/5]
                               }
                               turbulence 0.35
                             }
                     }
             }
      #ifdef (ELECTRIC_FIRE)
      object {
             ElectricFire
             rotate x*20
             rotate y*-75   //was -50
             translate y*2.5
             scale 0.9          //we do want to scale the translation
             translate <-3.75,0,0>
             }
      #end
      #ifdef (WATER_BEAKER)
      object {
             WaterBeaker
             rotate y*-90   //rotate label into view
             scale 0.4
             translate <1.8,0,1>
             }
      #end
      #ifdef (ATOM)
      object {
             CarbonAtom
             rotate y*75
             translate y*6.5
             scale 0.2 //scale translation
             translate <5.1,0,-2>
             }
      #end
      #ifdef (GEOMETRIC_ELEMENTS)
      object {
             SplitCube
             rotate y*25
             translate <-1,0.3,-6>
             }
      #end
      #ifdef (PERIODIC_BLOCKS)
      object {
             PeriodicBlocks
             rotate -y*30
             scale 1
             translate <2.75,0,-5>
             }
      #end
      }

light_source {              //main light
             <4,6,-4>,color White
             }

light_source {              //low-positioned orange light, really for the atom
             <7,0.5,-8>,color (Orange*2+White)/7
             }


light_source {              //low-positioned blue light, for the back of the fire
             <-5,0.5,-5>,color (White+Blue*3)/4
             }

camera {
       location <5,3.5,-10>
       look_at <0,1,1>
       }
