// Persistence of Vision Ray Tracer Scene Description File
// File: Eaufort.pov
// Vers: 3.1b
// Desc:
// Date: 31/07/98
// Auth: (c)Rameaux Martial*** Martial.Rameaux@wanadoo.fr

#version 3.1;
global_settings { assumed_gamma 2.0 }
#include "colors.inc"
#include "textures.inc"
#include "consts.inc"
#declare Rad_Quality = 5;
#include "rad_def.inc"

global_settings { assumed_gamma 2.2
                  max_trace_level 8
                  max_intersections 128
                   }




#include "Bouteil.inc"
/***********************/

camera
{
  location  <0.0 , 2.0 ,-15.0>
  look_at   <0.0 , 0.0 , 0.0>
  angle 60
}


//MEDIA ETC...
#declare D2=	density {	 spherical // cylindrical // boxed	
								ramp_wave
                                     turbulence  <2.4,0.9,0.5>
                                      octaves 9
                                      lambda 0.3
                                      omega 0.1
                                      color_map {
										[0.0 color rgbt <0., 0., 0,1>]
         								[0.1 color rgbt <1, 0.0, 0,1>]
										[0.3 color rgbt <0, 0.0, 0,1>]
                                       	[0.4 color rgbt <0, 0.0, 0,1>]
										[0.5 color rgbt <0, 0.0, 0,1>]
                                       	[0.6 color rgbt <0, 0.0, 0,1>]
                                        [0.7 color rgbt <0, 0.0, 0,1>]
          								[0.9 color rgbt <1, 1.0, 0,1>]
										[1.0 color rgbt <0, 0.0, 0,1>]
									  }
                                    frequency 3
                                    scale 0.9
									}


#declare M2=media {

                    emission 0.55
                     intervals 20
     				 samples 1, 20
      			 	confidence 0.9999
      			  	variance 1/1000
				  density { D2}
				     }


//LUMIERE
light_source
{
  0*x color rgb 1
  translate <-100, 100, -200>
}
light_source
{
  0*x color rgb 1
  shadowless
  translate <100, 100, 200>

  }


// FLAMMES
#declare Flamme =
box { <-20,-20,0>,<20,20,1>
// sphere { 0,1
        	pigment { color rgbt <1,1,1,1> }
                   finish { ambient 0 diffuse 0 }
                   interior { //ior 1
        		media {M2 scale 1.95 }
			}
		scale <8,8,2>
        translate y*0.5

  }

  #declare Flamme2=
  box { <-20,-20,0>,<20,20,1>
  //sphere { 0,1
            pigment { color rgbt <1,1,1,1> }
              finish { ambient 0 diffuse 0 }
            interior {   media { M2 scale 1.5 } }
               scale <5,10,2>
        translate <-1,0,5>
  }

object { Flamme  hollow }
object { Flamme2 hollow }

//Blobs
#declare Arc =1;
#while (Arc<180)
#declare Sd1 = seed (Arc);
#declare Trouble= Sd1*(1.0*rand(Sd1) );
blob
{
  threshold 0.50
  sphere { <0,0,0>,Trouble,0.55  }
  sphere { <1,-1,0>,1.5,0.55  rotate z*3 }
  texture
{
    pigment { White filter 1.0 }
    finish
    {
      ambient 0.0
      diffuse 0.0
      reflection 0.25
      irid { 0.25 thickness 0.5 turbulence 0.5 } // amount 0.35
      specular 1.0
      roughness 0.001
      }
  }
interior
{
 ior 1.33
  caustics 1.0
      fade_distance 5.0
      fade_power 1.0
      }

  translate <-5,0,-1> rotate z*-Arc
}
#declare Arc= Arc + 20+Trouble;
#end


//BOUTEILLE
object { BOUTEILLE scale 0.5 rotate <-50,-20,30> translate <-4,-5,3>}


// TERRE 
sphere { 0,1
        pigment { 
            image_map { 
            gif "terre.gif" 
              map_type 1
                interpolate 2
                  once
                      }
                    rotate y*-90
                            }
                        finish { ambient 0.4 diffuse 0.4 }
                         
translate <5,0,0>
}
               
