// Persistence Of Vision raytracer version 3.0 sample file.
// Simple heightfield example

#version 3.0
global_settings { assumed_gamma 2.2 }
 global_settings { adc_bailout 0.0039 }
//explosion
#declare Explo_Location=<12,25,12>
#declare Explo_Size=15
#include "explosion.inc"
//
#include "colors.inc"
#include "spray.inc"
#include"skies.inc"


camera {
    location <0, 35, -77.00 >
    right x*1.333
    up y
    direction z
    look_at <0,14, 15>
}

//chlore cloud

sphere { 0, 1
  hollow
  texture {
    pigment { colour Clear }
    halo {
    cubic
      max_value 3
      spherical_mapping
      glowing
      colour_map {
        [0 color rgbt <0.2, 0.4, 0, 1> ]
        [1 color rgbt <0.1, .8, 0.1, 0> ]
      }
      turbulence 1.6
      samples 50
      aa_level 4
      aa_threshold 0.2
    }
  }scale<46,30,20>translate<-20,-5,-20>
}


// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 400, -200>
}

light_source { <0, 10000, -1000> White }

//terrain
height_field {                   // upper-right of image at <0.5, 0.0, 0.5>
    gif "c:\pov\land\pilou.ghf"               // lower-left of image at <0.0, 0.0, 0.0>
    pigment {
        image_map { gif "c:\pov\land\mars.gif"}
    rotate x*90                  // rotate the image to the x/z plane
    }
    translate <-0.5, 0, -0.5>    // center the whole shebang
    scale<100,17,100>
// allow atmosphere inside shape

}

// create a sphere shape
sphere
{
  <0, 1, 0> // center of sphere <X Y Z>
  10000      // radius of sphere

hollow texture{T_Cloud1 scale 1000
}
}
// create a sphere shape
sphere
{
  <0, 1, 0> // center of sphere <X Y Z>
  11000       // radius of sphere

hollow texture{pigment{

gradient y // specify color_map direction(s)
color_map {    [0 color rgb <0, 0, 0.8> ]
        [1 color rgb <0.8, .4, 0.15,> ]}

}scale 5000 translate<0,1300,0>}}

//lava spray
// SPRAY OPTIONS
   #declare use_blob = true
   #declare components_only = true
   #declare spray_loop = true
   #declare spray_turb = .3
   #declare spin_turb = 4
   #declare angle_turb = 2
   #declare particle_count = 600
   #declare particle_life = 2
   #declare particle_dist = .2
   #declare particle_size = 10
   #declare particle_stretch = 6
   #declare particle_sep= 0.8
   #declare evaporate = 0
   #declare nozzle_angle = 30

// CREATE SPRAY BLOB OBJECT
   blob {threshold .5
      #declare spray_location = <12, 12, 12>
      #declare spray_direction = <8, 35, 12>
      #declare spray_strength = 20

      #declare spray_color_map = color_map {[0 rgb <1, .4, .1>]}


      #include "Spray.inc"

         }


//water on heightfield
box
{
  <-45, 4, -46>  // one corner position <X1 Y1 Z1>
  < 42,  7,  28>  // other corner position <X2 Y2 Z2>
   texture {
       pigment {color rgb<0.0,0.23,0.61>}
       normal {bumps 0.3 scale .8}
       finish {phong 0.2 reflection .5 ambient 0.1 diffuse 0.2 ior 1.33}
     }
}


