//**** Instructions ****//
/*
Description: Will create a 3d explosion for use in any scene.

Usage: Declare a Explo_Location to place the explosion, and use
Explo_Size to scale as needed (basic explosion is contained in a
10 unit sphere.).  For animations place your explosion and set the
Explo_Clock as needed (Default is POV-Ray's internal clock.).

Options:
Explo_Clock
Sets the length of time since the explosion's creation (0).
Default is POV-Ray's internal clock.
(explosion is over at (1))

Explo_Bright
The brightness of the explosion.
Default is "1".

Explo_Detail
Adds a bit of detail and substance to the explosion.
Default is "on".

Explo_Discolor
Discolors the explosion a bit.
Default is "off".

SparksA
Adds a electic looking discharge at the center of the explosion.
Default is "on".

SparksB
Adds sparks flying away from the explosion.
Default is "on".

Explo_Size
The size of the explosion.
Default is "1".

Explo_Rotate
The amount by which the explosion is rotated.
Default is "4545*.15+4534".

Explo_Location
Location of the explosion.
No default.

Contacting the Author:
E-mail me at daysix@teleport.com with comments or suggestions.

*/

//**** Start Up Values ****//
 global_settings {max_trace_level 20 }
 #declare Explosion = true
 #ifndef (Explo_Bright)  #declare Explo_Bright = 1 #end
 #ifndef (Explo_Clock)  #declare Explo_Clock = clock #end
 #ifndef (Explo_Detail)  #declare Explo_Detail = on #end
 #ifndef (Explo_Discolor)  #declare Explo_Discolor = off #end
 #ifndef (SparksA)  #declare SparksA = on #end
 #ifndef (SparksB)  #declare SparksB = on #end
 #ifndef (Explo_Size)  #declare Explo_Size = 1 #end
 #ifndef (Explo_Rotate)  #declare Explo_Rotate = 4545*.35+45304 #end
 #ifndef (Explo_Location)
  #warning "You need to specify a location (Explo_Location) for the explosion.\n"
  #declare Explosion = false
 #end

//**** Build the Explosion ****//
     #declare ExplodeA =
      union {
      disc {<0,0,0>, x, 1.5
         pigment {onion color_map {
            [0 rgbt <2 - (Explo_Clock * .5), 1.5 - (Explo_Clock * 1),1 - (Explo_Clock * 1), 1*Explo_Clock-.1>]
            [.25 rgbt <1 - (Explo_Clock * .5), 0, 0, 1>]}
            turbulence .05*Explo_Clock
            scale 3
            warp {turbulence Explo_Clock * .5+.25 octaves 3 lambda 1*Explo_Clock+2 omega 1}
            }
            finish {ambient 2*Explo_Bright diffuse 0}
         no_shadow hollow
         scale 1 + (Explo_Clock * 3)+.25
         scale 1
         }
      disc {<0,0,0>, z, 1.5
         pigment {onion color_map {
            [0 rgbt <2 - (Explo_Clock * .5), 1.5 - (Explo_Clock * 1),0, 1*Explo_Clock-.1>]
            [.25 rgbt <1 - (Explo_Clock * .5), 0, 0, 1>]}
            turbulence .05*Explo_Clock
            scale 3
            warp {turbulence Explo_Clock * .5+.25 octaves 3 lambda 1*Explo_Clock+2 omega 1}
            }
            finish {ambient 2*Explo_Bright diffuse 0}
         no_shadow hollow
         scale 1 + (Explo_Clock * 3)+.25
         scale 1
         }
      disc {<0,0,0>, y, 1.5
         pigment {onion color_map {
            [0 rgbt <2 - (Explo_Clock * .5), 1.5 - (Explo_Clock * 1),1 - (Explo_Clock * 1), 1*Explo_Clock-.1>]
            [.25 rgbt <1 - (Explo_Clock * .5), 0, 0, 1>]}
            turbulence .05*Explo_Clock
            scale 3
            warp {turbulence Explo_Clock * .5+.25 octaves 3 lambda 1*Explo_Clock+2 omega 1}
            rotate 20
            }
            finish {ambient 2*Explo_Bright diffuse 0}
         no_shadow hollow
         scale 1 + (Explo_Clock * 3)+.25
         scale 1
         }

}
     #declare ExplodeB =
      disc {<0,0,0>, x, 1.5
         pigment {onion color_map {
            [0 rgbt <2 - (Explo_Clock * .5), 1.5 - (Explo_Clock * 1), 1, 1*Explo_Clock-.1>]
            [.25 rgbt <1 - (Explo_Clock * .5), .5, .5, 1>]}
            // turbulence .05*Explo_Clock
            scale 3
            warp {turbulence Explo_Clock * .5+.25 octaves 3 lambda 1*Explo_Clock+2 omega 1}
            }
            finish {ambient 1*Explo_Bright diffuse 0}
         no_shadow hollow
         scale 1 + (Explo_Clock * 3)+.25
         scale 1
         }

//**** Explosion ****//
#if (Explosion = true)
union  {
object {
ExplodeA
scale .75
}
      /*
      union {
      disc {<0,0,0>, x, 1.5
         pigment {onion color_map {
            [0 rgbt <1 , 1 - (Explo_Clock * 1),1, 1*Explo_Clock-.1>]
            [.25 rgbt <1*clock, 1- (Explo_Clock * 1), 1- (Explo_Clock * 1), 1>]}
            //turbulence .05*Explo_Clock
            scale 3
            //warp {turbulence Explo_Clock * .5+.25 octaves 3 lambda 1*Explo_Clock+2 omega 1}
            }
            finish {ambient (2*Explo_Bright)-1.5*Explo_Clock diffuse 0}
         no_shadow hollow
         scale 1 + (Explo_Clock * 3)+.25
         scale 1
         }
      disc {<0,0,0>, z, 1.5
         pigment {onion color_map {
            [0 rgbt <1 , 1 - (Explo_Clock * 1),1, 1*Explo_Clock-.1>]
            [.25 rgbt <1*clock, 1- (Explo_Clock * 1), 1- (Explo_Clock * 1), 1>]}
            //turbulence .05*Explo_Clock
            scale 3
            //warp {turbulence Explo_Clock * .5+.25 octaves 3 lambda 1*Explo_Clock+2 omega 1}
            }
            finish {ambient (2*Explo_Bright)-1.5*Explo_Clock diffuse 0}
         no_shadow hollow
         scale 1 + (Explo_Clock * 3)+.25
         scale 1
         }
      disc {<0,0,0>, y, 1.5
         pigment {onion color_map {
            [0 rgbt <1 , 1 - (Explo_Clock * 1),1, 1*Explo_Clock-.1>]
            [.25 rgbt <1*clock, 1- (Explo_Clock * 1), 1- (Explo_Clock * 1), 1>]}
            //turbulence .05*Explo_Clock
            scale 3
            //warp {turbulence Explo_Clock * .5+.25 octaves 3 lambda 1*Explo_Clock+2 omega 1}
            }
            finish {ambient (2*Explo_Bright)-1.5*Explo_Clock diffuse 0}
         no_shadow hollow
         scale 1 + (Explo_Clock * 3)+.25
         scale 1
         }
       translate 0
       scale 2
       rotate 56*Explo_Clock
       }
       */
#if (Explo_Detail = on)
object {
ExplodeA
rotate 45645
scale .75
}
object {
ExplodeA
rotate 657645
scale 1
}

#end

#if (Explo_Discolor = on)
object {
ExplodeB
scale .75
rotate <0,0,69076>
}
#end

#if (SparksA = on)
object
      {
         sphere { < 0, 0, 0 >, 1  no_shadow hollow}
texture
         {
         pigment {
marble
color_map {
    [0.00 0.10 color rgbt <1,1,1.5,1*Explo_Clock>
               color rgbt <0,.15,1,.35*Explo_Clock+.65> ]
    [0.10 0.2 color  rgbt <0,.15,1,.35*Explo_Clock+.65>
               color  rgbt <0,.15,1,.35*Explo_Clock+.65> ]
    [0.20 0.30 color  rgbt <0,.15,1,.35*Explo_Clock+.65>
               color  rgbt <0,0,.15,.15*Explo_Clock+.85>  ]
    [0.30 0.4 color rgbt <0,0,.15,.15*Explo_Clock+.85>
               color rgbt <0,0,.15,.15*Explo_Clock+.85> ]
    [0.4 0.65 color rgbt <0,0,.15,.15*Explo_Clock+.85>
               color rgbt <0,0,.075,1>]
    [0.65 1.00 color rgbt <0,0,.075,1>
               color rgbt <0,0,.075,1>]
}
scale 2
translate <0,0,-10*Explo_Clock>
turbulence 1
}
finish {
ambient 1*Explo_Bright
diffuse 0
}

         }

 scale 1
 translate <0,0,0>
scale 1.25
}
#end

#if (SparksB = on)
#declare spark_count = 75
   #declare min_distance = 0
   #declare max_distance = 10*clock+.75
   #declare star_size = .1
      #declare star_object = disc {<0, 0, 0>,x,.5 no_shadow hollow
         pigment {onion color_map {[0 rgbt <1,1,0,.5*Explo_Clock>] [1 rgbt <1,0,0,1>]} scallop_wave}
         finish {ambient 1*Explo_Bright diffuse 0} scale <1,1,10> }

   #declare _SF_distdif = max_distance - min_distance
   #declare _SF_rand = seed(0)

   //**** Sparks ****//
   union {
   #declare _SF_count = 0 #while (_SF_count < spark_count)
     object {
     star_object
       scale star_size
       translate z * (min_distance + rand(_SF_rand) * _SF_distdif)
       rotate (<rand(_SF_rand),rand(_SF_rand),rand(_SF_rand)>-.5)*360
       }
   #declare _SF_count = _SF_count + 1
   #end
   }


#end
object
      {
         sphere { < 0, 0, 0 >, 1  no_shadow hollow}
texture
         {
         pigment {bozo color_map {
            [0 rgbt <2 - (Explo_Clock * .5), 1.5 - (Explo_Clock * 1), 0, 1*Explo_Clock-.1>]
            [.25 rgbt <1 - (Explo_Clock * .5), 0, 0, 1>]}
            turbulence 2
            scale 1
            //warp {turbulence Explo_Clock * .5+.25 octaves 3 lambda 1*Explo_Clock+2 omega 1}
translate <-5*Explo_Clock,-5*Explo_Clock,-5*Explo_Clock>
rotate Explo_Clock*20
            }
            finish {ambient 1*Explo_Bright diffuse 0}
         }

 scale 1
 translate <0,0,0>
scale 1 + (Explo_Clock * 3)+.15-2.5
}
object
      {
         sphere { < 0, 0, 0 >, 1  no_shadow hollow}
texture
         {
         pigment {bozo color_map {
            [0 rgbt <2 - (Explo_Clock * .5), 1.5 - (Explo_Clock * 1), 0, 1*Explo_Clock-.1+.25>]
            [.25 rgbt <1 - (Explo_Clock * .5), 0, 0, 1>]}
            turbulence 2
            scale 1
            //warp {turbulence Explo_Clock * .5+.25 octaves 3 lambda 1*Explo_Clock+2 omega 1}
translate <-5*Explo_Clock,-5*Explo_Clock,-5*Explo_Clock>
rotate Explo_Clock*20
            }
            finish {ambient 1*Explo_Bright diffuse 0}
         }

 scale 1
 translate <0,0,0>
scale 1 + (Explo_Clock * 3)+.2-2.5
}
object
      {
         sphere { < 0, 0, 0 >, 1  no_shadow hollow}
texture
         {
         pigment {bozo color_map {
            [0 rgbt <2 - (Explo_Clock * .5), 1.5 - (Explo_Clock * 1), 0, 1*Explo_Clock+.5>]
            [.25 rgbt <1 - (Explo_Clock * .5), 0, 0, 1>]}
            turbulence 2
            scale 1
            //warp {turbulence Explo_Clock * .5+.25 octaves 3 lambda 1*Explo_Clock+2 omega 1}
translate <-5*Explo_Clock,-5*Explo_Clock,-5*Explo_Clock>
rotate Explo_Clock*20
            }
            finish {ambient 1*Explo_Bright diffuse 0}
         }

 scale 1
 translate <0,0,0>
scale 1 + (Explo_Clock * 3)+.25-2.5
}
rotate Explo_Rotate
scale Explo_Size
translate Explo_Location
}
#end
