// Persistence of Vision Ray Tracer Scene Description File
// File: platogriek.pov
// Vers: 3
// Desc: Griekse kolom
// Date: 25 augustus 1998
// Auth: Erick

#include "colors.inc"
#include "textures.inc"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "STONES.INC"
#include "Dorisch.inc"
#include "Griek.inc"
#include "moleculen.inc"
global_settings { ambient_light color rgb <.9,.6,.8> }
global_settings { assumed_gamma 2.2 }
global_settings { max_trace_level 40}

camera {
	location <2, 3, -7>
	up <0, 1, 0>
    look_at <10,10,200>
	angle 80
}

#declare R1 = seed(1543)
#declare R2 = seed(6743)

#declare steraantal=0
#while (steraantal < 6000)
#declare xs=(rand(R1)-.5)*2200 
#declare zs=rand(R2)*1100
#declare ys=sqrt(abs(1210000-xs*xs-zs*zs))
              object {sphere {<xs,ys,zs>,rand(R2)
              pigment {color rgb <rand(R1),rand(R2),rand(R1)>}}}
              object {sphere {<xs,-zs,ys>,rand(R2)
              pigment {color rgb <rand(R1),rand(R2),rand(R1)>}}}

#declare steraantal=steraantal+1
#end

#declare wereld= 
sphere {<0,0,0>,5000
hollow texture {pigment {Clear}}}

object {wereld}

light_source
{
  0*x 
  color rgb 1
  area_light
  <4, 0, 0> <0, 0, 4> 
  4, 4
  adaptive 1
  translate <20, 20, -100>
}

light_source {<150, 100, -100> color LightGray}
light_source {<0, 200, -1000> color LightGray}


#declare kolomdubbelrij=
union{
#declare teller = 0
#while (teller < 3)
object
      {column_doric
      translate <teller*2.4,0,0>}
object
      {column_doric
      translate <teller*2.4,0,3.6>}
#declare teller=teller+1
#end
box {<-.24,2.4,-.24>,<5.04,2.6,3.84>
    texture{T_Column2}}}

object {kolomdubbelrij
       rotate y*-30}


object {Griek
texture {T_Grnt19
scale 10}
scale 3
rotate x*-105
rotate y*35
rotate z*15
translate <2,2.25,2>}

#declare vuurtextuur=
texture {pigment {Clear}
halo
{linear
      max_value 2.0
      spherical_mapping
      emitting
      turbulence 2
  frequency 1
  max_value 1.0
  colour_map
  {
    [ 0 color rgbf <1, .3, .3, 0.2> ]
    [ 0.1 color rgbf <1, 1, 0, 0.6> ]
    [ 0.15 color rgbf <.8, 1, .2, 0.5> ]
    [ 0.2 color rgbf <1,.5, 0, .7> ]
    [ 0.9 color rgbf <1, 1, 0, 0.6> ]
    [ 1 color rgbf <.3, .2, .3, 0.9> ]
  }
  samples 20
  aa_level 1
  aa_threshold 0.3
  jitter 0.8
}}

object { Tetrahedron
hollow texture {vuurtextuur}
scale 5
rotate y*-70
rotate x*20
no_shadow
translate <25,18,75>}

#declare wolktextuur=
texture {pigment {Clear}
halo
{linear
      max_value 2.0
      cylindrical_mapping
      turbulence 2
  frequency 2
  max_value 2.0
  colour_map
  {
        [0.0, 0.1   color rgbt <1,1,1,.3>
                    color red 0.55 green 0.60 blue 0.65]
        [0.1, 0.5   color red 0.55 green 0.60 blue 0.65
                    color rgb <0.184, 0.184, 0.309> ]
        [0.5, 1.001 color rgbt <0.184, 0.184, 0.309,0>
                    color rgbt <0.1, 0.1, 0.2,.8>]
  }
  samples 50
  aa_level 3
  aa_threshold 0.3
  jitter 0.8
}}

object { Octahedron
   hollow texture {
    wolktextuur
    }
    scale 5
    rotate x*-10
    rotate y*25
   no_shadow
   translate <-5,25,45>}

object { Icosahedron
   texture{
   pigment {color rgb <0.39, 0.41, 0.6>}
   finish {
    ambient 0.40
    brilliance 4
    diffuse 0.4
    metallic
    specular 0.70
    roughness 1/60
    reflection 0.6
}}
  normal{waves 3
  turbulence .3
  frequency 10
   scale 3}
   bounded_by {sphere{<0, 0, 0>, 3}}
   scale 8
   translate <-40,25,70>
   no_shadow
}

box {<0,0,0><1,1,1>
   texture {
    pigment {
        granite
        color_map {
            [0.0 color DarkBrown ]
            [0.6 color DarkBrown ]
            [0.8 color DarkWood ]
            [0.95 color ForestGreen]
            [1.0 color ForestGreen ]
        }
        scale .5
    }
    normal  { bumps 5 scale 20}
}
texture {
    pigment {
        wrinkles
        turbulence 0.3
        scale 4
        color_map {
            [0.0 rgbf< 0.50, 0.25, 0.10, 0.85>]
            [1.0 rgbf< 0.65, 0.40, 0.00, 0.65>]
        }
    }
    normal  { bumps 2 scale 12}}
    scale 15
    rotate y*-30
    rotate x*10
   translate <50,40,90>
   no_shadow}
   
   
   
   object {buckminsterfullereen
   scale .3
   translate <-7,3,12>
   no_shadow}
   
   object {methaan
   scale .7 
   translate <-4, 5, 4>
    no_shadow}
   
   object {cubane
   scale .5
   translate <10,3.5, 12>
    no_shadow}
   
   object {sf6
   scale .8
   translate <7,11,12>
    no_shadow}
   
