/* Persistence Of Vision raytracer beta version 3.1 file.
File by A. BUCK
EMAIL ABUCHM7158.AOL.COM
*/

#version 3.1;

#macro rotation (Arry,Row)

#local Alpha=radians(Arry[Row][3]);

#local X=Arry[Row][0];
#local Y=Arry[Row][1];
#local Z=Arry[Row][2];

#local KX=X/sqrt(X*X+Y*Y+Z*Z);
#local KY=Y/sqrt(X*X+Y*Y+Z*Z);
#local KZ=Z/sqrt(X*X+Y*Y+Z*Z);

matrix <

(1-cos(Alpha))*KX*KX+cos(Alpha),
(1-cos(Alpha))*KX*KY+KZ*sin(Alpha),
(1-cos(Alpha))*KX*KZ-KY*sin(Alpha),

(1-cos(Alpha))*KX*KY-KZ*sin(Alpha),
(1-cos(Alpha))*KY*KY+cos(Alpha),
(1-cos(Alpha))*KY*KZ+KX*sin(Alpha),

(1-cos(Alpha))*KX*KZ+KY*sin(Alpha),
(1-cos(Alpha))*KY*KZ-KX*sin(Alpha),
(1-cos(Alpha))*KZ*KZ+cos(Alpha),

0, 0, 0 >

#end

#macro miny1 (Arry1,Vertex)

#local Count2=0;
#local Number=0;
#while (Count2 < dimension_size(Arry1,1))
#local Count1=0;
#while (Count1 < dimension_size(Vertex,1))
#declare Number=min(Number,
vaxis_rotate(
<Vertex[Count1][0],Vertex[Count1][1],Vertex[Count1][2]>,
<Arry1[Count2][0],Arry1[Count2][1],Arry1[Count2][2]>,
Arry1[Count2][3]).y);
#declare Count1=Count1+1;
#end
#declare Count2=Count2+1;
#end
abs(Number)
#end

#macro miny2 (Arry1,Arry2,Vertex)

#local Number=0;
#local Count2=0;
#while (Count2 < dimension_size(Arry1,1))
#local Count1=0;
#while (Count1 < dimension_size(Vertex,1))
#declare Number=min(Number,
vaxis_rotate(
vaxis_rotate(
<Vertex[Count1][0],Vertex[Count1][1],Vertex[Count1][2]>,
<Arry1[Count2][0],Arry1[Count2][1],Arry1[Count2][2]>,
Arry1[Count2][3]),
<Arry2[Count2][0],Arry2[Count2][1],Arry2[Count2][2]>,
Arry2[Count2][3]).y);
#declare Count1=Count1+1;
#end
#declare Count2=Count2+1;
#end
abs(Number)
#end

#macro miny3 (Arry1,Arry2,Arry3,Vertex)

#local Number=0;
#local Count2=0;
#while (Count2 < dimension_size(Arry1,1))
#local Count1=0;
#while (Count1 < dimension_size(Vertex,1))
#declare Number=min(Number,
vaxis_rotate(
vaxis_rotate(
vaxis_rotate(
<Vertex[Count1][0],Vertex[Count1][1],Vertex[Count1][2]>,
<Arry1[Count2][0],Arry1[Count2][1],Arry1[Count2][2]>,
Arry1[Count2][3]),
<Arry2[Count2][0],Arry2[Count2][1],Arry2[Count2][2]>,
Arry2[Count2][3]),
<Arry3[Count2][0],Arry3[Count2][1],Arry3[Count2][2]>,
Arry3[Count2][3]).y);
#declare Count1=Count1+1;
#end
#declare Count2=Count2+1;
#end
abs(Number)
#end

#macro miny4 (Arry1,Arry2,Arry3,Arry4,Vertex)

#local Number=0;
#local Count2=0;
#while (Count2 < dimension_size(Arry1,1))
#local Count1=0;
#while (Count1 < dimension_size(Vertex,1))
#declare Number=min(Number,
vaxis_rotate(
vaxis_rotate(
vaxis_rotate(
vaxis_rotate(
<Vertex[Count1][0],Vertex[Count1][1],Vertex[Count1][2]>,
<Arry1[Count2][0],Arry1[Count2][1],Arry1[Count2][2]>,
Arry1[Count2][3]),
<Arry2[Count2][0],Arry2[Count2][1],Arry2[Count2][2]>,
Arry2[Count2][3]),
<Arry3[Count2][0],Arry3[Count2][1],Arry3[Count2][2]>,
Arry3[Count2][3]),
<Arry4[Count2][0],Arry4[Count2][1],Arry4[Count2][2]>,
Arry4[Count2][3]).y);
#declare Count1=Count1+1;
#end
#declare Count2=Count2+1;
#end
abs(Number)
#end

global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "couleurs.inc"
#include "stones.inc"
#include "polyreg.inc"
#include "woods.inc"
#include "glass.inc"
#include "skies.inc"

#declare C1 = .06;
#declare C2 = .8*C1;
#declare C3 = 1.1*C1;
#declare C4 = .9*C1;
#declare Angle = degrees(asin(sqrt(2/3)));
#declare Angle1 = degrees(atan2((sqrt(5)-1)/2, 1));

#declare cube1 =
difference { box { -C1, C1 }
             box { <-C3, -C2, -C2>, <C3, C2, C2> }
             box { <-C2, -C3, -C2>, <C2, C3, C2> }
             box { <-C2, -C2, -C3>, <C2, C2, C3> }
             pigment { Or }
             finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic }
           }

#declare cube2 =
difference { box { -C1, C1 }
             box { <-C3, -C4, -C4>, <C3, C4, C4> }
             box { <-C4, -C3, -C4>, <C4, C3, C4> }
             box { <-C4, -C4, -C3>, <C4, C4, C3> }
             pigment { Or }
             finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic }
           }

#declare mat3 = array[3][4]
{
{0,0,1,45},
{0,1,0,45},
{1,0,0,45}
}

#declare mat3a = array[3][4]
{
{1,0,0,degrees(asin(sqrt(2/3)))},
{1,0,0,degrees(asin(sqrt(2/3)))},
{1,0,0,degrees(asin(sqrt(2/3)))}
}

#declare mat3b = array[3][4]
{
{0,1,0,0},
{0,1,0,120},
{0,1,0,240}
}

#declare mat4a = array[4][4]
{
{1,1,1,180},
{1,1,-1,180},
{1,-1,-1,180},
{1,-1,1,180}
}

#declare mat4b = array[4][4]
{
{1,0,0,45},
{1,0,0,45},
{1,0,0,45},
{1,0,0,45}
}

#declare mat5a = array[5][4]
{
{1,0,0,degrees(atan2((sqrt(5)-1)/2, 1))},
{1,0,0,degrees(atan2((sqrt(5)-1)/2, 1))},
{1,0,0,degrees(atan2((sqrt(5)-1)/2, 1))},
{1,0,0,degrees(atan2((sqrt(5)-1)/2, 1))},
{1,0,0,degrees(atan2((sqrt(5)-1)/2, 1))}
}

#declare mat5b = array[5][4]
{
{0,1,0,0},
{0,1,0,72},
{0,1,0,144},
{0,1,0,216},
{0,1,0,288}
}

#declare mat6a = array[6][4]
{
{1,1,0,90},
{1,-1,0,90},
{1,0,1,90},
{1,0,-1,90},
{0,1,1,90},
{0,1,-1,90}
}

#declare mat6b = array[6][4]
{
{1,0,0,45},
{1,0,0,45},
{1,0,0,45},
{1,0,0,45},
{1,0,0,45},
{1,0,0,45}
}

#declare mat8 = array[8][4]
{
{1,1,1,90},
{1,1,-1,90},
{1,-1,-1,90},
{1,-1,1,90},
{1,1,1,-90},
{1,1,-1,-90},
{1,-1,-1,-90},
{1,-1,1,-90}
}

#declare mat12 = array[12][4]
{
{0,1,1,45},
{1,0,1,45},
{0,-1,1,45},
{-1,0,1,45},
{1,1,0,45},
{1,-1,0,45},
{0,1,1,-45},
{1,0,1,-45},
{0,-1,1,-45},
{-1,0,1,-45},
{1,1,0,-45},
{1,-1,0,-45}
}


#declare mat12a = array[12][4]
{
{1,1,1,180},
{1,1,1,180},
{1,1,1,180},
{1,-1,1,180},
{1,-1,1,180},
{1,-1,1,180},
{-1,-1,1,180},
{-1,-1,1,180},
{-1,-1,1,180},
{-1,1,1,180},
{-1,1,1,180},
{-1,1,1,180},
}

#declare mat12b = array[12][4]
{
{1,-1,1,180},
{-1,-1,1,180},
{-1,1,1,180},
{1,1,1,180},
{-1,-1,1,180},
{-1,1,1,180},
{1,1,1,180},
{1,-1,1,180},
{-1,1,1,180},
{1,1,1,180},
{1,-1,1,180},
{-1,-1,1,180},
}

#declare mat12c = array[12][4]
{
{0,0,1,45},
{0,0,1,45},
{0,0,1,45},
{0,0,1,45},
{0,0,1,45},
{0,0,1,45},
{0,0,1,45},
{0,0,1,45},
{0,0,1,45},
{0,0,1,45},
{0,0,1,45},
{0,0,1,45}
}

#declare mat12d = array[12][4]
{
{1,0,0,degrees(asin(1/sqrt(3)))},
{1,0,0,degrees(asin(1/sqrt(3)))},
{1,0,0,degrees(asin(1/sqrt(3)))},
{1,0,0,degrees(asin(1/sqrt(3)))},
{1,0,0,degrees(asin(1/sqrt(3)))},
{1,0,0,degrees(asin(1/sqrt(3)))},
{1,0,0,degrees(asin(1/sqrt(3)))},
{1,0,0,degrees(asin(1/sqrt(3)))},
{1,0,0,degrees(asin(1/sqrt(3)))},
{1,0,0,degrees(asin(1/sqrt(3)))},
{1,0,0,degrees(asin(1/sqrt(3)))},
{1,0,0,degrees(asin(1/sqrt(3)))}
}

#declare couleur12 = array[12]
{Jaune,Rouge,Bleu,Vert,Violet,Noir,Blanc,Azur,Brun,Corail,Kaki,Magenta,}

/*
camera {
   location  <-.7, .4, 0>
   up        <0,  .54,  0>
   right     <.72,  0,  0>
   look_at   <0, C1, 0>}
background { Bleu_Ciel }
*/
camera {
   location  <-3, .5, -.3>
   up        <0,  .54,  0>
   right     <.72,  0,  0>
   look_at   <0, 2.8*C1, 0>}

// sky_sphere { S_Cloud2 }

light_source { <-3, 1.2, -.15> rgb <.9, .9, .9> }
light_source { <-1, 1.2, .4> rgb <.8, .8, .8> }
light_source { <-2, .04, .7> rgb <.9, .9, .9> }
light_source { <-3, 8, 10> rgb <2, 2, 2> }



// L'encadrement de fentre
difference {
union {
box { <-2, -2, .62> <2, 2, 1.05> pigment { Vieil_Or } }
box { <-.5, -.08, .6> <.5, 1.35, .63> pigment { Orchidee_Moyen2 } }
}
union {
box { <-.41, .02, .55> <.41, 1.25, 1.10> pigment { Orchidee_Moyen2 } }
box { <-.45, .025, .8> <.45, 1.25, .9> pigment { Gris } }
}
finish { reflection 0.1 diffuse .52 phong .75 phong_size 15 }
}

// Le mur latral
box { <1.2, -2, -4> <1.6, 2, 1.05> pigment { Vieil_Or } }


// La tablette de fentre
box { <-.52, .005, .58> <.52, .025, .9>
texture { T_Wood7 scale 5 rotate 90*y }  }

#declare fenetre =
union {
// la vitre
box { <-.4, .05, .82> <.40, .63, .83> texture {T_Glass4} }
// Montant verticaux du cadre
// gauche
difference {
box { <-.45, .02, .8> <-.39, .66, .845> }
cylinder { < -.39, .01, .8 >, < -.39, .67, .8 >, .005 }
}
// droit
difference {
box { <.39, .02, .8> <.45, .66, .845> }
cylinder { < .39, .01, .8 >, < .39, .67, .8 >, .005 }
}
// Partie basse du cadre
difference {
box { <-.45, .02, .8> <.45, .06, .845> }
cylinder { < -.46, .06, .8 >, < .46, .06, .8 >, .005 }
}
// Partie haute du cadre
difference {
box { <-.45, .62, .8> <.45, .66, .845> }
cylinder { < -.46, .62, .8 >, < .46, .62, .8 >, .005 }
}
// Sparateur vertical de gauche
difference {
box { <-.21, .02, .8> <-.19, .66, .845> }
cylinder { < -.21, .01, .8 >, < -.21, .67, .8 >, .005 }
cylinder { < -.19, .01, .8 >, < -.19, .67, .8 >, .005 }
}
// Sparateur vertical du milieu
difference {
box { <-.01, .02, .8> <.01, .66, .845> }
cylinder { < -.01, .01, .8 >, < -.01, .67, .8 >, .005 }
cylinder { < .01, .01, .8 >, < .01, .67, .8 >, .005 }
}
// Sparateur vertical de droite
difference {
box { <.19, .02, .8> <.21, .66, .845> }
cylinder { < .19, .01, .8 >, < .19, .67, .8 >, .005 }
cylinder { < .21, .01, .8 >, < .21, .67, .8 >, .005 }
}
// sparateur horizontal
difference {
box { <-.45, .33, .8> <.45, .35, .845> }
cylinder { < -.46, .33, .8 >, < .46, .33, .8 >, .005 }
cylinder { < -.46, .35, .8 >, < .46, .35, .8 >, .005 }
}
pigment { Blanc }
finish { reflection 0 diffuse .52 phong .75 phong_size 15 }
}

// Service fixe
object { fenetre translate <0, .59, .055> }
// Service coulissant
object { fenetre translate <0, .2, 0> }

// La mer
plane { y, -8.5 pigment { Bleu }
finish { reflection 0.1 diffuse .52 phong .75 phong_size 15 } }

// Le sol

polygon {
5,
<-2, 2.5>, <2, 2.5>, <2, -2.5>, <-2, -2.5>, <-2, 2.5>
rotate <-90, 0, 0>
translate <0, -1, -1.5>
texture {
pigment {checker color Blue color Red scale .05}
finish {reflection 0}
} }

// Le plafond
polygon {
5,
<-2, 2.5>, <2, 2.5>, <2, -2.5>, <-2, -2.5>, <-2, 2.5>
rotate <-90, 0, 0>
translate <0, 1.6, -1.5>
pigment { Blanc }
finish { reflection 0 diffuse .52 phong .75 phong_size 15 }
}


// Les colonnes
union {
cylinder { < .4425, -1, .5425 >, < .4425, 1, .5425 >, .0125 }
cylinder { < 1.0925, -1, .5425 >, < 1.0925, 1, .5425 >, .0125 }
cylinder { < .4425, -1, -1.0125 >, < .4425, 1, -1.0125 >, .0125 }
cylinder { < 1.0925, -1, -1.0125 >, < 1.0925, 1, -1.0125 >, .0125 }
pigment { Noir }
finish { reflection 0 diffuse .52 phong .75 phong_size 15 }
}

// La tablette
#declare planche =
union {
box { <.43, -.025, .53> <1.13, 0, -1>
texture { T_Wood12
//rotate 90*y
finish { reflection 0.05 } scale .075 }
finish { reflection 0.10 } }
cylinder { < .41, -.065, .5175>, < 1.15, -.065, .5175>, .0125 pigment { Noir }
finish { reflection 0 diffuse .52 phong .75 phong_size 15 } }
cylinder { < .41, -.065, -1.0375 >, < 1.15, -.065, -1.0375 >, .0125 pigment { Noir }
finish { reflection 0 diffuse .52 phong .75 phong_size 15 } }
cylinder { < .4675, -.04, .57 >, < .4675, -.04, -1.07 >, .0125 pigment { Noir }
finish { reflection 0 diffuse .52 phong .75 phong_size 15 } }
cylinder { < 1.1175, -.04, .57 >, < 1.1175, -.04, -1.07 >, .0125 pigment { Noir }
finish { reflection 0 diffuse .52 phong .75 phong_size 15 } }
sphere { <1.105, -.0525, .53>, .03 pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
sphere { <.455, -.0525, .53>, .03 pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
sphere { <1.105, -.0525, -1.025>, .03 pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
sphere { <.455, -.0525, -1.025>, .03 pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
}

planche
object { planche translate <0, -.8, 0> }
object { planche translate <0, -.4, 0> }
object { planche translate <0, .4, 0> }
object { planche translate <0, .8, 0> }



// Compound of three cubes and sphere
union {
#declare Count=0;
#while (Count < dimension_size(mat3,1))
object { cube1 rotation (mat3, Count) }
#declare Count=Count+1;
#end
sphere { <0, 0, 0>, sqrt(2)*C2
pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
rotate <0, 15, 0>
translate <.7, miny1(mat3,vcube)*C1, .4>
}

// Compound of three cubes and sphere
union {
#declare Count=0;
#while (Count < dimension_size(mat3a,1))
object { cube1 rotation (mat3a, Count) rotation (mat3b, Count) }
#declare Count=Count+1;
#end
sphere { <0, 0, 0>, sqrt(2)*C2
pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
rotate <0, -15, 0>
translate <.7, miny1(mat3a,vcube)*C1, 0>
}

// Compound of four cubes and sphere
union {
#declare Count=0;
#while (Count < dimension_size(mat4a,1))
object { cube1 rotation (mat4a, Count) rotation (mat4b, Count) }
#declare Count=Count+1;
#end
sphere { <0, 0, 0>, sqrt(2)*C2
pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
rotate <0, 8, 0>
translate <.7, miny2(mat4a,mat4b,vcube)*C1, -.4>
}

// Compound of five cubes and sphere
union {
#declare Count=0;
#while (Count < dimension_size(mat5a,1))
object { cube1 rotation (mat5a, Count) rotation (mat5b, Count) }
#declare Count=Count+1;
#end
sphere { <0, 0, 0>, sqrt(2)*C2
pigment { Argent }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic } }
rotate <0, 30, 0>
translate <.7, miny1(mat5a,vcube)*C1, -.8>
}

// Compound of five dodecahedra
union {
#declare Count=0;
#while (Count < dimension_size(mat5a,1))
object { Dodecaedre1 rotation (mat5a, Count) rotation (mat5b, Count)
pigment { couleur12[Count] } }
#declare Count=Count+1;
#end
scale C1
rotate <0, 30, 0>
translate <.7, .4+miny1(mat5a,vdodec1)*C1, -.8>
}

// Compound of three octahedra
union {
#declare Count=0;
#while (Count < dimension_size(mat3a,1))
object { Octaedre rotation (mat3a, Count) rotation (mat3b, Count)
pigment { couleur12[Count] } }
#declare Count=Count+1;
#end
scale 1.5*C1
rotate <0, 30, 0>
translate <.7, .4+miny1(mat3a,vocta)*1.5*C1, -.4>
}

// Compound of four tetrahedra
union {
#declare Count=0;
#while (Count < dimension_size(mat4a,1))
object { Tetraedre1 rotation (mat4a, Count) rotation (mat4b, Count)
pigment { couleur12[Count] } }
#declare Count=Count+1;
#end
scale C1
rotate <0, 30, 0>
translate <.7, .4+miny2(mat4a,mat4b,vtetra1)*C1, .4>
}

// Compound of four octahedra
union {
#declare Count=0;
#while (Count < dimension_size(mat4a,1))
object { Octaedre rotation (mat4a, Count)
pigment { couleur12[Count] } }
#declare Count=Count+1;
#end
scale 1.5*C1
rotate <0, 30, 0>
translate <.7, .8+miny1(mat4a,vocta)*1.5*C1, .4>
}

// Compound of five octahedra
union {
#declare Count=0;
#while (Count < dimension_size(mat5a,1))
object { Octaedre rotation (mat5a, Count) rotation (mat5b, Count)
pigment { couleur12[Count+1] } }
#declare Count=Count+1;
#end
scale 1.5*C1
rotate <0, 24, 0>
translate <.7, .4+miny1(mat5a,vocta)*1.5*C1, 0>
}

// Compound of five tetrahedra
union {
#declare Count=0;
#while (Count < dimension_size(mat5a,1))
object { Tetraedre1 rotation (mat5a, Count) rotation (mat5b, Count)
pigment { couleur12[Count+1] } }
#declare Count=Count+1;
#end
scale C1
rotate <0, 24, 0>
translate <.7, .8+miny1(mat5a,vtetra1)*C1, 0>
}

// Compound of six tetrahedra
union {
#declare Count=0;
#while (Count < dimension_size(mat6a,1))
object { Tetraedre1 rotation (mat6a, Count) rotation (mat6b, Count)
pigment { couleur12[Count+1] } }
#declare Count=Count+1;
#end
scale C1
rotate <0, 24, 0>
translate <.7, .8+miny2(mat6a,mat6b,vtetra1)*C1, -.4>
}

// Compound of six cubes
union {
#declare Count=0;
#while (Count < dimension_size(mat6a,1))
object { cube1 rotation (mat6a, Count) rotation (mat6b, Count) }
#declare Count=Count+1;
#end
rotate <0, 15, 0>
translate <.7, .8+miny2(mat6a,mat6b,vcube)*C1, -.8>
}


// Stella Octangula or octaedron elevatum : compound of two tetrahedra
union {
object { Tetraedre1
       pigment { Or }
       finish { reflection 0.2 diffuse .52 phong .75 phong_size 15 metallic }
       }
object { Tetraedre2
       pigment { Argent }
       finish { reflection 0.2 diffuse .52 phong .75 phong_size 15 metallic }
       }
       scale C1
       translate <.7, -.4+C1, .4>
      }


// Compound of octaedron and cube
union {
       object { Octaedre scale 2*C1
       pigment { Or }
       finish { reflection 0.2 diffuse .52 phong .75 phong_size 15 metallic }
       }
       box { <-1, -1, -1>, <1, 1, 1> scale C1
       pigment { Cuivre }
       finish { reflection 0.2 diffuse .52 phong .75 phong_size 15 metallic }
       }
       rotate <45, 0, 0>
       translate <.7, -.4+2*C1/sqrt(2), -.4>
      }

// Compound of dodecaedron and icosaedron
union {
       object { Icosaedre1 scale C1*(sqrt(5)+1)/2
       pigment { Argent }
       finish { reflection 0.2 diffuse .52 phong .75 phong_size 15 metallic }
       }
       object { Dodecaedre1 scale C1
       pigment { Cuivre }
       finish { reflection 0.2 diffuse .52 phong .75 phong_size 15 metallic }
       }
       translate <.7, -.4+C1*(sqrt(5)+1)/2, -.8>
      }

// Compound of two dodecaedra
union {
      object { Dodecaedre1 scale C1 pigment { Or }
      finish { reflection 0.2 diffuse .52 phong .75 phong_size 15 metallic }
      }
      object { Dodecaedre2 scale C1 pigment { Argent }
      finish { reflection 0.2 diffuse .52 phong .75 phong_size 15 metallic }
      }
       translate <.7, -.4+C1*(sqrt(5)+1)/2, 0>
}

// Compound of twelve cubes
union {
#declare Count=0;
#while (Count < dimension_size(mat12,1))
object { cube2 rotation (mat12, Count) rotation (mat12c, Count) rotation (mat12d, Count) }
#declare Count=Count+1;
#end
translate <.7, -.8+miny3(mat12,mat12c,mat12d,vcube)*C1, -.4>
}

// Compound of twelve cubes
union {
#declare Count=0;
#while (Count < dimension_size(mat12a,1))
object { cube2 rotation (mat12a, Count) rotation (mat12b, Count) rotation (mat12c, Count) rotation (mat12d, Count) }
#declare Count=Count+1;
#end
translate <.7, -.8+miny4(mat12a,mat12b,mat12c,mat12d,vcube)*C1, -.8>
}

// Compound of twelve tetrahedra
union {
#declare Count=0;
#while (Count < dimension_size(mat12,1))
object { Tetraedre1 rotation (mat12, Count) rotation (mat12c, Count) rotation (mat12d, Count) }
#declare Count=Count+1;
#end
pigment { Or }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic }
scale C1
translate <.7, -.8+miny3(mat12,mat12c,mat12d,vtetra1)*C1, .4>
}

// Compound of twelve tetrahedra
union {
#declare Count=0;
#while (Count < dimension_size(mat12a,1))
object { Tetraedre2 rotation (mat12a, Count) rotation (mat12b, Count) rotation (mat12c, Count) rotation (mat12d, Count) }
#declare Count=Count+1;
#end
pigment { Or }
finish { reflection 0.3 diffuse .52 phong .75 phong_size 15 metallic }
scale C1
translate <.7, -.8+miny4(mat12a,mat12b,mat12c,mat12d,vtetra2)*C1, 0>
}
