//  Persistance of Vision Raytracer V3.0
//  World definition file.

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.2,0.300,0.400> }

camera {  //  Camera StdCam
  location  <-13.123, -22.244, 13.843>
  direction <0.0,     0.0,  1.8317>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, 0.000, -0.900>
}



//
// *******  L I G H T S *******
//


light_source {   // Light1
  <0.000, -20.000, 20.000>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light1
  <-20.000, -10.000, 10.000>
  color rgb <1.000, 1.000, 1.000>
}

//
// ********  TEXTURES  *******
//

#include "glfreaks.inc"


//
// ********  REFERENCED OBJECTS  *******
//
#declare MonCube=object { superellipsoid { // SuperQ001
    <0.2, 0.2>
  }
  }

//Programme
#declare R1 = seed(1)
#declare maxI=33 //nombre IMpaire please 33
#declare GrandCote=5
#declare Cote=GrandCote/maxI
#declare Trou=0.5
#declare Verre=1

#declare Face1=union{  // Face k=0
  #declare i=0
  #declare j=0
  #declare k=0
  #while (i<maxI)
  #while (j<=i)
   #if (rand(R1)<Trou)
    object {
      MonCube
      scale Cote
      translate <-GrandCote+Cote+2*i*Cote,-GrandCote+Cote+2*j*Cote,-GrandCote+Cote+2*k*Cote>
      #if (rand(R1)<Verre)
          texture {
              WrinkleGray
              pigment {color red rand(R1) green rand(R1) blue rand(R1) }
          }
      #else
           texture {Glass_1}
      #end
    }
   #end
   #declare j=j+1
  #end
    #declare j=0
    cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <Cote/5, Cote/5, (GrandCote+Cote)*2>
    translate <-GrandCote+Cote+2*i*Cote,-GrandCote+Cote+2*j*Cote,-GrandCote-Cote>
    texture {
    Glass_1
    }
    }
    #declare i =i+1
  #end
  }

#declare Face2=union{   // Face k=maxI-1
  #declare i=0
  #declare k=maxI-1
  #while (i<maxI)
    #declare j=i
    #while (j<maxI)
     #if (rand(R1)<Trou)
      object {
      MonCube
      scale Cote
      translate <-GrandCote+Cote+2*i*Cote,-GrandCote+Cote+2*j*Cote,-GrandCote+Cote+2*k*Cote>
      #if (rand(R1)<Verre)
          texture {
              WrinkleGray
              pigment {color red rand(R1) green rand(R1) blue rand(R1) }
          }
      #else
           texture {Glass_1}
      #end
      }
    #end
    #declare j=j+1
   #end
    #declare j=0
    cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <Cote/5, Cote/5, (GrandCote+Cote)*2>
    translate <-GrandCote+Cote+2*i*Cote,GrandCote-Cote,-GrandCote-Cote>
    texture {
    Glass_1
    }
    }
    #declare i =i+1
  #end
  }

#declare Face3=union{   // Face j=maxI-1
  #declare i=0
  #declare j=0
  #declare k=maxI-1
  #while (i<maxI)
   #while (j<maxI)
    #if (rand(R1)<Trou)
    object {
      MonCube
      scale Cote
      translate <-GrandCote+Cote+2*i*Cote,-GrandCote+Cote+2*k*Cote,-GrandCote+Cote+2*j*Cote>
      #if (rand(R1)<Verre)
          texture {
              WrinkleGray
              pigment {color red rand(R1) green rand(R1) blue rand(R1) }
          }
      #else
           texture {Glass_1}
      #end
    }
   #end
   #declare j=j+1
  #end
    #declare j=0
    cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <Cote/5, Cote/5, (GrandCote+Cote)*2>
    rotate -90.0*y
    translate <GrandCote+Cote,-GrandCote+Cote+2*i*Cote,-GrandCote+Cote>
    texture {
    Glass_1
  }
  }
    #declare i =i+1
  #end
  }


  #declare Face4=union{   // Face j=0
  #declare i=0
  #declare j=0
  #declare k=0
  #while (i<maxI)
  #while (j<=i)
   #if (rand(R1)<Trou)
    object {
      MonCube
      scale Cote
      translate <-GrandCote+Cote+2*i*Cote,-GrandCote+Cote+2*k*Cote,-GrandCote+Cote+2*j*Cote>
      #if (rand(R1)<Verre)
          texture {
              WrinkleGray
              pigment {color red rand(R1) green rand(R1) blue rand(R1) }
          }
      #else
           texture {Glass_1}
      #end
    }
   #end
   #declare j=j+1
  #end
    #declare j=0
    cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <Cote/5, Cote/5, (GrandCote+Cote)*2>
    rotate -90.0*y
    translate <GrandCote+Cote,-GrandCote+Cote+2*i*Cote,+GrandCote-Cote>
    texture {
    Glass_1
  }
  }
    #declare i =i+1
  #end
  }


#declare Face5=union{   // Face i=maxI-1
  #declare i=0
  #declare j=0
  #declare k=maxI-1
  #while (i<maxI)
  #while (j<maxI)
   #if (rand(R1)<Trou)
    object {
      MonCube
      scale Cote
      translate <-GrandCote+Cote+2*k*Cote,-GrandCote+Cote++2*j*Cote,-GrandCote+Cote+2*i*Cote>
      #if (rand(R1)<Verre)
          texture {
              WrinkleGray
              pigment {color red rand(R1) green rand(R1) blue rand(R1) }
          }
      #else
           texture {Glass_1}
      #end
    }
   #end
   #declare j=j+1
  #end
    #declare j=0
    cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <Cote/5, Cote/5, (GrandCote+Cote)*2>
    rotate -90.0*x
    translate <-GrandCote+Cote+2*k*Cote,-GrandCote-Cote,-GrandCote+Cote+2*i*Cote>
    texture {
    Glass_1
  }
  }
    #declare i =i+1
  #end
}

#declare Face6=union{   // Face i=0
  #declare i=0
  #declare k=0
  #while (i<maxI)
  #declare j=maxI-i
  #while (j<maxI)
   #if (rand(R1)<Trou)
    object {
      MonCube
      scale Cote
      translate <-GrandCote+Cote+2*k*Cote,-GrandCote+Cote++2*j*Cote,-GrandCote+Cote++2*i*Cote>
      #if (rand(R1)<Verre)
          texture {
              WrinkleGray
              pigment {color red rand(R1) green rand(R1) blue rand(R1) }
          }
      #else
           texture {Glass_1}
      #end
    }
   #end
   #declare j=j+1
  #end
    #declare j=0
    cylinder {
    <0,0,1>, <0,0,0>, 1
    scale <Cote/5, Cote/5, (GrandCote+Cote)*2>
    rotate -90.0*x
    translate <-GrandCote+Cote+2*k*Cote,-GrandCote-Cote,-GrandCote+Cote+2*i*Cote>
    texture {
    Glass_1
  }
  }
    #declare i =i+1
  #end

}




//
// ********  OBJECTS  *******
//


union { // CSG001
  object {Face1}
  object {Face2}
  object {Face3}
  object {Face4}
  object {Face5}
  object {Face6}

}

#declare Polished_Chrome =
   texture
   {
      pigment
      {
         color rgb <1.0, 1.0, 1.0>
      }
      finish
      {
         ambient 0.1
         diffuse 0.7
         brilliance 6.0
         phong 0.4
         phong_size 20.0
         reflection 1
      }
   }


#declare Rayon=3
#declare GrandCote=GrandCote/2

sphere {
  <0,0,0>,1
  texture {
    Polished_Chrome
  }
  scale Rayon
}

