// The Mercury Machine

union {

union {
difference {
sphere {
	0, 2
}
box {
	<2, 0, 2>, <-2, -2, -2>
}
}
difference {
sphere {
	0, 2
}
box {
	<2, 2, 2>, <-2, 0, -2>
}
scale <1, 0.8, 1>
translate <0, 0.0001, 0>
}
translate <0, 6, 0>
texture {
	ReflectiveText
}
}

cylinder {
	<0, 5, 0>, <0, 3.5, 0>, 0.5
	texture { ReflectiveText }
}
cylinder {
	<0, 5, -0.65>, <0, 3.5, -0.65>, 0.15
	texture { CopperText }
}
cylinder {
	<0, 5, -0.65>, <0, 3.5, -0.65>, 0.15
	texture { CopperText }
	rotate y*120
}
cylinder {
	<0, 5, -0.65>, <0, 3.5, -0.65>, 0.15
	texture { CopperText }
	rotate y*240
}

union {
sphere {
	0, 1.5
	scale <1, 0.2, 1>
	translate <0, 3.5, 0>
}
cylinder {
	<0, 3.5, 0>, <0, 2.5, 0>, 1.5
}
difference {
cylinder {
	<0, 2.5, 0>, <0, 2, 0>, 2
}
torus {
	2, 0.5
	translate <0, 2.5, 0>
}
}
cylinder {
	<0, 2, 0>, <0, 1.5, 0>, 2
}
difference {
sphere {
	0, 2
}
box {
	<3, 3, 3>, <-3, 0, -3>
}
box {
	<3, -1.5, 3>, <-3, -3, -3>
}
translate <0, 1, 0>
}
texture { BodyText }
}

cylinder {
	<0, 1.5, 0>, <0, 1, 0>, 2
	texture { Stripedpig rotate z*30 }
	texture { StripedOverlay }
}

#declare hydralics = union {
union {
cylinder {
	<0.25, 3.4, -2.5>, <-0.25, 3.4, -2.5>, 0.1
}
intersection {
torus {
	0.25, 0.1
}
box {
	<-1, -1, -1>, <0, 1, 0>
}
translate <-0.25, 3.4, -2.25>
}
intersection {
torus {
	0.25, 0.1
}
box {
	<0, -1, -1>, <1, 1, 0>
}
translate <0.25, 3.4, -2.25>
}
cylinder {
	<-0.5, 3.4, 0>, <-0.5, 3.4, -2.25>, 0.1
}
cylinder {
	<0.5, 3.4, 0>, <0.5, 3.4, -2.25>, 0.1
}
texture { BodyText }
}

union {
difference {
cylinder {
	<0.25, 3.4, -2.5>, <-0.25, 3.4, -2.5>, 0.25
}
cylinder {
	<0.26, 3.4, -2.5>, <-0.26, 3.4, -2.5>, 0.1
}
}
torus {
	0.175, 0.075
	rotate z*90
	scale <0.2, 1, 1>
	translate <-0.25, 3.4, -2.5>
}
torus {
	0.175, 0.075
	rotate z*90
	scale <0.2, 1, 1>
	translate <0.25, 3.4, -2.5>
}
texture { YellowText }
}

cylinder {
	<0, 3.4, -2.5>, <0, 1, -2.5>, 0.2
	texture { ReflectiveIrid }
}

union {
cylinder {
	<0, 2, -2.5>, <0, -1, -2.5>, 0.5
}
torus {
	0.35, 0.15
	scale <1, 0.2, 1>
	translate <0, 2, -2.5>
}
cylinder {
	<0.5, -1, -2.5>, <-0.5, -1, -2.5>, 0.5
}
texture { YellowText scale 4 translate y*-1 }
}

}

object { hydralics rotate y*60 }
object { hydralics rotate y*180 }
object { hydralics rotate y*300 }

torus {
	2.5, 0.15
	translate <0, -1, 0>
	texture { ReflectiveIrid }
}

#declare onespout = union {
difference {
cylinder {
	<0, 3, 0>, <0, 1, 0>, 0.1
}
cylinder {
	<0, 4, 0>, <0, 0, 0>, 0.09
}
box {
	<1, 1, 1>, <-1, 0, -1>
	rotate x*45
	translate y*2.9
}
}

torus {
	0.1, 0.05
	translate y*2.5
}

difference {
cylinder {
	<0, 2.5, 0>, <0, 1, 0>, 0.15
}
cylinder {
	<0, 2.4, 0>, <0, 2.36, 0>, 0.2
}
cylinder {
	<0, 2.32, 0>, <0, 2.28, 0>, 0.2
}

cylinder {
	<0, 2.24, 0>, <0, 2.2, 0>, 0.2
}
}

texture { ReflectiveText }

}

#declare number = 0;
#while (number < 15)
object { onespout rotate x*110 rotate y*24*number translate y*6 }
#declare number = number + 1;
#end

#declare number = 0;
#while (number < 20)
object { onespout rotate x*90 rotate y*18*number translate y*6 }
#declare number = number + 1;
#end

#declare number = 0;
#while (number < 15)
object { onespout rotate x*70 rotate y*24*number translate y*6 }
#declare number = number + 1;
#end

#declare number = 0;
#while (number < 15)
object { onespout rotate x*50 rotate y*24*number+<0, 12, 0> translate y*6 }
#declare number = number + 1;
#end

#declare number = 0;
#while (number < 10)
object { onespout rotate x*30 rotate y*36*number translate y*6 }
#declare number = number + 1;
#end

#declare number = 0;
#while (number < 5)
object { onespout rotate x*30 rotate y*72*number translate y*6 }
#declare number = number + 1;
#end

// a green light

union {
sphere {
	<0, 3, -1.5>, 0.1
	texture { GreenLightText }
}
sphere {
	0, 0.5
	pigment { color rgbt 1 }
	interior {
	media {
	emission <0.25, 0.5, 0.25>
	}
	}
	hollow
	scale <1, 1, 0.5>
	translate <0, 3, -1.5>
}
rotate y*-30
}

// The Mercury

#declare mercuryspittle = union {
blob {
	threshold 0.6
	sphere { <0, 6, 0>, 0.3, 1 }
	sphere { <0, 5.6, 0>, 0.3, 1 }

	sphere { <0, 4, 0>, 0.1, 1 }
	sphere { <0, 3.9, 0>, 0.1, 1 }
	sphere { <0, 3.8, 0>, 0.075, 1 }
	sphere { <0, 3.7, 0>, 0.05, 1 }
	sphere { <0, 3.6, 0>, 0.1, 1 }
	sphere { <0, 3.5, 0>, 0.075, 1 }
	texture { BrightMerc }
}
cylinder {
	<0, 6, 0>, <0, 2.5, 0>, 0.1
	pigment {
		gradient y
		color_map {
			[ 0 rgbt <1, 1, 1, 1> ]
			[ 0.5 rgbt <0.5, 0.5, 0.5, 1> ]
			[ 1 rgbt <0.5, 0.5, 0.5, 0.7> ]
		}
		scale 4
		translate y*2
	}
	finish {
		ambient 1
		diffuse 0
	}
	interior {
		ior 1
	}
}

}

union {

#declare number = 0;
#while (number < 15)
object { mercuryspittle translate <0, rand(seed(number)), 0> rotate x*110 rotate y*24*number translate y*6 }
#declare number = number + 1;
#end

#declare number = 0;
#while (number < 20)
object { mercuryspittle translate <0, rand(seed(number)), 0> rotate x*90 rotate y*18*number translate y*6 }
#declare number = number + 1;
#end

#declare number = 0;
#while (number < 15)
object { mercuryspittle translate <0, rand(seed(number)), 0> rotate x*70 rotate y*24*number translate y*6 }
#declare number = number + 1;
#end

#declare number = 0;
#while (number < 15)
object { mercuryspittle translate <0, rand(seed(number)), 0> rotate x*50 rotate y*24*number+<0, 12, 0> translate y*6 }
#declare number = number + 1;
#end

#declare number = 0;
#while (number < 10)
object { mercuryspittle translate <0, rand(seed(number)), 0> rotate x*30 rotate y*36*number translate y*6 }
#declare number = number + 1;
#end
/*
#declare number = 0;
#while (number < 5)
object { mercuryspittle translate <0, rand(seed(number)), 0> rotate x*30 rotate y*72*number translate y*6 }
#declare number = number + 1;
#end
*/
no_shadow
}

}
