#include "colors.inc"
#include "woods.inc"
#include "textures.inc"
#include "sea.inc"
#include "metalpath.inc"
#include "rocks.inc"
#include "machine.inc"
#include "canister.inc"

global_settings {
	max_trace_level 10
}

camera {
	location <0, 4.5, -20>
	look_at <0, 5, 0>
}

light_source {
	<0, 4.5, -20>
	color rgb 0.5
	media_interaction off
}

light_source {
	<0, 10, -5>
	color rgb <0.6, 0.8, 1>*1.5
	spotlight
	point_at <0, 2, 0>
	radius 45
	tightness 10
	falloff 45
}

light_source {
	<0, 10, -5>
	color rgb <0.6, 1, 0.8>*1.5
	rotate y*120
	spotlight
	point_at <0, 2, 0>
	radius 45
	tightness 10
	falloff 45
}

light_source {
	<0, 10, -5>
	color rgb <1, 0.8, 0.6>*1.5
	rotate y*240
	spotlight
	point_at <0, 2, 0>
	radius 45
	tightness 10
	falloff 45
}

light_source {
	<10, 10, 10>
	color rgb <1, 0.5, 0.5>*0.75
	fade_distance 5
	fade_power 2
}

light_source {
	<-10, 10, 10>
	color rgb <0.5, 0.25, 0.25>
	fade_distance 5
	fade_power 2
}

#declare ibeam = difference {
box {
	<0.5, 14, 50>, <-0.5, 13, -50>
}
box {
	<0.45, 13.45, 55>, <-0.45, 12, -55>
}
#declare number = -45;
#while (number < 50)
cylinder {
	<1, 13.4, number>, <-1, 13.4, number>, 0.1
}
cylinder {
	<1, 13.4, number+0.5>, <-1, 13.4, number+0.5>, 0.1
}
#declare number = number + 5;
#end
texture { ibeamTexture }
}

object { ibeam }
object { ibeam translate x*10 }

object { ibeam translate x*-10 }



union {
difference {
box {
	<10, 14, 40>, <-10, 4, 18>
}
box {
	<9.8, 13.8, 39.8>, <-9.8, 4.2, 10>
}
texture { WhiteText }
}
difference {
box {
	<-9, 13, 40>, <-10, 4, 25>
}
box {
	<-8, 12.5, 35>, <-10, 8.5, 30>
}
box {
	<-8, 12.5, 38>, <-10, 10.5, 36>
}
box {
	<-8, 12.5, 29>, <-10, 10.5, 27>
}
texture { WhiteText }
}
union {
intersection {
sphere {
	0, 0.5
	scale <1, 6, 7.5>
}
box {
	<1, 2, 2.5>, <-1, -2, -2.5>
}

texture {
	pigment {
		image_map {
			tga "greenmach.tga"
			map_type 0
			interpolate 2
		}
		translate <-0.5, -0.5, -0.5>
		rotate y*-90
		scale <1, 4, 5>
	}
	finish {
		ambient 0.8
		diffuse 0.2
		specular 0.5
		roughness 0.01
	}
}
}
sphere {
	0, 3
	pigment { color rgbt 1 }
	interior {
	media {
		emission <0.03, 0.06, 0.03>
	}
	}
	hollow
}
translate <-9.5, 10.5, 32.5>
}

union {
intersection {
sphere {
	0, 0.5
	scale <1, 3, 3>
}
box {
	<1, 0.8, 1>, <-1, -0.8, -1>
}
texture { FuzzyScreen }
}
sphere {
	0, 1.5
	pigment { color rgbt 1 }
	interior {
	media {
		emission 0.1
	}
	}
	hollow
}
translate <-9.5, 11.5, 37>
}

union {
intersection {
sphere {
	0, 0.5
	scale <1, 3, 3>
}
box {
	<1, 0.8, 1>, <-1, -0.8, -1>
}
texture { FuzzyScreen }
}
sphere {
	0, 1.5
	pigment { color rgbt 1 }
	interior {
	media {
		emission 0.1
	}
	}
	hollow
}
translate <-9.5, 11.5, 28>
}

union {
difference {
box {
	<5, 12, 18>, <-5, 8, 17.5>
}
box {
	<4.8, 11.8, 19>, <-4.8, 8.2, 17>
}
}
box {
	<2, 12, 18>, <1.8, 8, 17.5>
}
box {
	<-1.8, 12, 18>, <-2, 8, 17.5>
}
texture { ibeamTexture }
}

box {
	<5, 12, 17.8>, <-5, 8, 17.7>
	texture { glassyText }
	interior { ior 1.45 }
}

light_source {
	<0, 10, 30>
	color rgb 0.5
	fade_distance 20
	fade_power 2
}
rotate y*45
}

#declare Board = union {
box {
	<7.4, 14.5, 0.9>, <-7.4, 14, 0.1>
}
box {
	<7.5, 14.4, 0.9>, <-7.5, 14.1, 0.1>
}
box {
	<7.4, 14.4, 1>, <-7.4, 14.1, 0>
}

cylinder {
	<7.4, 14.4, 0.9>, <-7.4, 14.4, 0.9>, 0.1
}
cylinder {
	<7.4, 14.4, 0.1>, <-7.4, 14.4, 0.1>, 0.1
}
cylinder {
	<7.4, 14.4, 0.9>, <7.4, 14.4, 0.1>, 0.1
}
cylinder {
	<-7.4, 14.4, 0.9>, <-7.4, 14.4, 0.1>, 0.1
}

cylinder {
	<7.4, -14.4, 0.9>, <-7.4, -14.4, 0.9>, 0.1
}
cylinder {
	<7.4, -14.4, 0.1>, <-7.4, -14.4, 0.1>, 0.1
}
cylinder {
	<7.4, -14.4, 0.9>, <7.4, -14.4, 0.1>, 0.1
}
cylinder {
	<-7.4, -14.4, 0.9>, <-7.4, -14.4, 0.1>, 0.1
}

cylinder {
	<7.4, 14.4, 0.9>, <7.4, 14.1, 0.9>, 0.1
}
cylinder {
	<-7.4, 14.4, 0.9>, <-7.4, 14.1, 0.9>, 0.1
}
cylinder {
	<7.4, 14.4, 0.1>, <7.4, 14.1, 0.1>, 0.1
}
cylinder {
	<-7.4, 14.4, 0.1>, <-7.4, 14.1, 0.1>, 0.1
}

sphere {
	<7.4, 14.4, 0.9>, 0.1
}
sphere {
	<-7.4, 14.4, 0.9>, 0.1
}
sphere {
	<7.4, 14.1, 0.9>, 0.1
}
sphere {
	<-7.4, 14.1, 0.9>, 0.1
}

sphere {
	<7.4, 14.4, 0.1>, 0.1
}
sphere {
	<-7.4, 14.4, 0.1>, 0.1
}
sphere {
	<7.4, 14.1, 0.1>, 0.1
}
sphere {
	<-7.4, 14.1, 0.1>, 0.1
}
texture { T_Wood13 rotate y*90 }
}

object { Board rotate y*10 translate <5, 0, 10> }

object { Board rotate y*-10 translate <-5, 0, 3> }
object { Board rotate y*-10 translate <-5, 0, 4> }
object { Board rotate y*-10 translate <-5, 0, 5> }

object { Board rotate y*-30 translate <4, 0, 0> }
object { Board rotate y*-30 translate <4, 0, -1> }

// Some pipes on the ceiling

union {
cylinder {
	<-7, 12.5, 5>, <-20, 12.5, 5>, 0.5
}
intersection {
torus {
	0.5, 0.5
}
box {
	<2, 2, 2>, <0, -2, 0>
}
translate <-7, 12.5, 4.5>
}
cylinder {
	<-6.5, 12.5, 4.5>, <-6.5, 12.5, -10>, 0.5
}
texture { PipeTexture }
}

union {
cylinder {
	<-5.5, 11.5, 3>, <-20, 11.5, 3>, 0.2
}
intersection {
torus {
	0.2, 0.2
}
box {
	<2, 2, 2>, <0, -2, 0>
}
rotate x*90
translate <-5.5, 11.7, 3>
}
cylinder {
	<-5.3, 11.7, 3>, <-5.3, 12.3, 3>, 0.2
}
intersection {
torus {
	0.2, 0.2
}
box {
	<0, 2, 2>, <-2, -2, 0>
}
rotate x*-90
translate <-5.1, 12.3, 3>
}
cylinder {
	<3, 12.5, 3>, <-5.1, 12.5, 3>, 0.2
}
intersection {
torus {
	0.2, 0.2
}
box {
	<2, 2, 2>, <0, -2, 0>
}
translate <3, 12.5, 2.8>
}
cylinder {
	<3.2, 12.5, 2.8>, <3.2, 12.8, -10>, 0.2
}

// copper #2

cylinder {
	<-5.5, 11.5, 2.5>, <-20, 11.5, 2.5>, 0.2
}
intersection {
torus {
	0.2, 0.2
}
box {
	<2, 2, 2>, <0, -2, 0>
}
rotate x*90
translate <-5.5, 11.7, 2.5>
}
cylinder {
	<-5.3, 11.7, 2.5>, <-5.3, 12.3, 2.5>, 0.2
}
intersection {
torus {
	0.2, 0.2
}
box {
	<0, 2, 2>, <-2, -2, 0>
}
rotate x*-90
translate <-5.1, 12.3, 2.5>
}
cylinder {
	<2.5, 12.5, 2.5>, <-5.1, 12.5, 2.5>, 0.2
}
intersection {
torus {
	0.2, 0.2
}
box {
	<2, 2, 2>, <0, -2, 0>
}
translate <2.5, 12.5, 2.3>
}
cylinder {
	<2.7, 12.5, 2.3>, <2.7, 12.8, -10>, 0.2
}

translate z*-3

texture { CopperText }

}
